/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import java.util.ArrayList;
import java.util.List;
import javafx.event.Event;
import javafx.geometry.NodeOrientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseEvent;

public class TabPaneBehavior
extends BehaviorBase<TabPane> {
    private static final String HOME = "Home";
    private static final String END = "End";
    private static final String CTRL_PAGE_UP = "Ctrl_Page_Up";
    private static final String CTRL_PAGE_DOWN = "Ctrl_Page_Down";
    private static final String CTRL_TAB = "Ctrl_Tab";
    private static final String CTRL_SHIFT_TAB = "Ctrl_Shift_Tab";
    protected static final List<KeyBinding> TAB_PANE_BINDINGS = new ArrayList<KeyBinding>();

    @Override
    protected void callAction(String string) {
        boolean bl;
        boolean bl2 = bl = ((TabPane)this.getControl()).getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT;
        if ("TraverseLeft".equals(string) && !bl || "TraverseRight".equals(string) && bl || "TraverseUp".equals(string)) {
            if (((TabPane)this.getControl()).isFocused()) {
                this.selectPreviousTab();
            }
        } else if ("TraverseRight".equals(string) && !bl || "TraverseLeft".equals(string) && bl || "TraverseDown".equals(string)) {
            if (((TabPane)this.getControl()).isFocused()) {
                this.selectNextTab();
            }
        } else if (CTRL_TAB.equals(string) || CTRL_PAGE_DOWN.equals(string)) {
            TabPane tabPane = (TabPane)this.getControl();
            if (tabPane.getSelectionModel().getSelectedIndex() == tabPane.getTabs().size() - 1) {
                tabPane.getSelectionModel().selectFirst();
            } else {
                this.selectNextTab();
            }
            tabPane.requestFocus();
        } else if (CTRL_SHIFT_TAB.equals(string) || CTRL_PAGE_UP.equals(string)) {
            TabPane tabPane = (TabPane)this.getControl();
            if (tabPane.getSelectionModel().getSelectedIndex() == 0) {
                tabPane.getSelectionModel().selectLast();
            } else {
                this.selectPreviousTab();
            }
            tabPane.requestFocus();
        } else if (HOME.equals(string)) {
            if (((TabPane)this.getControl()).isFocused()) {
                ((TabPane)this.getControl()).getSelectionModel().selectFirst();
            }
        } else if (END.equals(string)) {
            if (((TabPane)this.getControl()).isFocused()) {
                ((TabPane)this.getControl()).getSelectionModel().selectLast();
            }
        } else {
            super.callAction(string);
        }
    }

    public static boolean isChildFocused(Node node, List<Node> list) {
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) == node) {
                bl = true;
                break;
            }
            if (!(list.get(i) instanceof Parent) || !TabPaneBehavior.isChildFocused(node, ((Parent)list.get(i)).getChildrenUnmodifiable())) continue;
            return true;
        }
        return bl;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        TabPane tabPane = (TabPane)this.getControl();
        tabPane.requestFocus();
    }

    public TabPaneBehavior(TabPane tabPane) {
        super(tabPane, TAB_PANE_BINDINGS);
    }

    public void selectTab(Tab tab) {
        ((TabPane)this.getControl()).getSelectionModel().select(tab);
    }

    public boolean canCloseTab(Tab tab) {
        Event event = new Event(tab, tab, Tab.TAB_CLOSE_REQUEST_EVENT);
        Event.fireEvent(tab, event);
        return !event.isConsumed();
    }

    public void closeTab(Tab tab) {
        TabPane tabPane = (TabPane)this.getControl();
        int n = tabPane.getTabs().indexOf(tab);
        if (n != -1) {
            tabPane.getTabs().remove(n);
        }
        if (tab.getOnClosed() != null) {
            Event.fireEvent(tab, new Event(Tab.CLOSED_EVENT));
        }
    }

    public void selectNextTab() {
        int n;
        SingleSelectionModel<Tab> singleSelectionModel = ((TabPane)this.getControl()).getSelectionModel();
        for (int i = n = singleSelectionModel.getSelectedIndex(); i < ((TabPane)this.getControl()).getTabs().size(); ++i) {
            singleSelectionModel.selectNext();
            if (((Tab)singleSelectionModel.getSelectedItem()).isDisable()) continue;
            return;
        }
        singleSelectionModel.select(n);
    }

    public void selectPreviousTab() {
        int n;
        SingleSelectionModel<Tab> singleSelectionModel = ((TabPane)this.getControl()).getSelectionModel();
        for (int i = n = singleSelectionModel.getSelectedIndex(); i > 0; --i) {
            singleSelectionModel.selectPrevious();
            if (((Tab)singleSelectionModel.getSelectedItem()).isDisable()) continue;
            return;
        }
        singleSelectionModel.select(n);
    }

    static {
        TAB_PANE_BINDINGS.add(new KeyBinding(KeyCode.UP, "TraverseUp"));
        TAB_PANE_BINDINGS.add(new KeyBinding(KeyCode.DOWN, "TraverseDown"));
        TAB_PANE_BINDINGS.add(new KeyBinding(KeyCode.LEFT, "TraverseLeft"));
        TAB_PANE_BINDINGS.add(new KeyBinding(KeyCode.RIGHT, "TraverseRight"));
        TAB_PANE_BINDINGS.add(new KeyBinding(KeyCode.HOME, HOME));
        TAB_PANE_BINDINGS.add(new KeyBinding(KeyCode.END, END));
        TAB_PANE_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, CTRL_PAGE_UP).ctrl());
        TAB_PANE_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, CTRL_PAGE_DOWN).ctrl());
        TAB_PANE_BINDINGS.add(new KeyBinding(KeyCode.TAB, CTRL_TAB).ctrl());
        TAB_PANE_BINDINGS.add(new KeyBinding(KeyCode.TAB, CTRL_SHIFT_TAB).shift().ctrl());
    }
}

