/*
 * Decompiled with CFR 0.152.
 */
package rtr.utilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import java.util.Random;
import java.util.SplittableRandom;
import java.util.concurrent.ForkJoinPool;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.newdawn.slick.Color;
import rtr.console.Console;
import rtr.system.RTRThreadPool;
import rtr.utilities.OrderedPair;

public class Utilities {
    public static Random random = new Random();
    public static SplittableRandom fastRandom = new SplittableRandom();
    private static long startTime;
    private static long endTime;
    private static boolean sendingProfile;
    private static boolean sendingProfileFailed;
    private static int sendingProfileAttempts;

    public static void startTimer() {
        startTime = System.currentTimeMillis();
    }

    public static boolean endTimer(String message, int cullBelow) {
        endTime = System.currentTimeMillis();
        if (endTime - startTime > (long)cullBelow) {
            Console.out(String.valueOf(message) + (endTime - startTime), true);
            return true;
        }
        return false;
    }

    public static void endTimer(String message) {
        Utilities.endTimer(message, 0);
    }

    public static void endTimer() {
        Utilities.endTimer("Time: ", 0);
    }

    public static void startTimerNano() {
        startTime = System.nanoTime();
    }

    public static boolean endTimerNano(String message, int cullBelow) {
        endTime = System.nanoTime();
        if (endTime - startTime > (long)cullBelow) {
            Console.out(String.valueOf(message) + (endTime - startTime), true);
            return true;
        }
        return false;
    }

    public static void endTimerNano(String message) {
        Utilities.endTimerNano(message, 0);
    }

    public static void endTimerNano() {
        Utilities.endTimerNano("Time: ", 0);
    }

    public static int randomInt(int i) {
        if (i < 1) {
            System.out.println("Random " + i + " is too low, set to 1.");
            i = 1;
        }
        return fastRandom.nextInt(i);
    }

    public static int randomInt(int x, int y) {
        int difference;
        if (x >= y) {
            System.out.println("Random values flipped! Fixing..");
            int x1 = y;
            int y1 = x;
            x = x1;
            y = y1;
        }
        if ((difference = Math.abs(x - y)) < 1) {
            System.out.println("Random " + difference + " is too low, set to 1.");
            difference = 1;
        }
        int randomInt = fastRandom.nextInt(difference + 1);
        int adjustedResult = randomInt + x;
        return adjustedResult;
    }

    public static float randomFloat() {
        return random.nextFloat();
    }

    public static boolean isOutOfBounds(int length, int width, int x, int y) {
        return x < 0 || y < 0 || x >= length || y >= width;
    }

    public static boolean coordinatesWithin(int x, int y, int x2, int y2, int distance) {
        return Math.abs(x - x2) <= distance && Math.abs(y - y2) <= distance;
    }

    public static ArrayList<OrderedPair> getAllCoordinatesWithin(int centerX, int centerY, int distance) {
        ArrayList<OrderedPair> list = new ArrayList<OrderedPair>();
        int x = distance;
        int y = distance;
        int endX = distance + 1;
        int endY = distance + 1;
        int x2 = 0;
        while (x2 < endX) {
            int y2 = 0;
            while (y2 < endY) {
                int dx = x - x2;
                int dy = y - y2;
                int hValue = (int)Math.sqrt(dx * dx + dy * dy);
                if (hValue < distance) {
                    int shiftX = centerX - distance;
                    int shiftY = centerY - distance;
                    OrderedPair o = null;
                    OrderedPair o2 = null;
                    OrderedPair o3 = null;
                    OrderedPair o4 = null;
                    o = OrderedPair.getOrderedPair(shiftX + x2, shiftY + y2);
                    if (x2 != endX - 1) {
                        o2 = OrderedPair.getOrderedPair(shiftX + x2 * -1 + distance * 2, shiftY + y2);
                    }
                    if (y2 != endY - 1) {
                        o3 = OrderedPair.getOrderedPair(shiftX + x2, shiftY + y2 * -1 + distance * 2);
                    }
                    if (x2 != endX - 1 && y2 != endY - 1) {
                        o4 = OrderedPair.getOrderedPair(shiftX + x2 * -1 + distance * 2, shiftY + y2 * -1 + distance * 2);
                    }
                    if (o != null) {
                        list.add(o);
                    }
                    if (o2 != null) {
                        list.add(o2);
                    }
                    if (o3 != null) {
                        list.add(o3);
                    }
                    if (o4 != null) {
                        list.add(o4);
                    }
                }
                ++y2;
            }
            ++x2;
        }
        return list;
    }

    public static byte[][] createRangeMap(int d) {
        byte[][] out = new byte[d * 2][d * 2];
        int x = d;
        int y = d;
        int endX = out.length / 2 + 1;
        int endY = out[0].length / 2 + 1;
        int x2 = 0;
        while (x2 < endX) {
            int y2 = 0;
            while (y2 < endY) {
                int dx = x - x2;
                int dy = y - y2;
                int hValue = (int)Math.sqrt(dx * dx + dy * dy);
                if (hValue < d) {
                    out[x2][y2] = 1;
                    if (x2 != endX - 1) {
                        out[x2 * -1 + d * 2][y2] = 1;
                    }
                    if (y2 != endY - 1) {
                        out[x2][y2 * -1 + d * 2] = 1;
                    }
                    if (x2 != endX - 1 && y2 != endY - 1) {
                        out[x2 * -1 + d * 2][y2 * -1 + d * 2] = 1;
                    }
                }
                ++y2;
            }
            ++x2;
        }
        return out;
    }

    public static String wrapString(String input, int wrapAt) {
        StringBuilder sb = new StringBuilder(input);
        StringBuilder output = new StringBuilder("");
        int lastSpace = 0;
        int lineW = 0;
        int i = 0;
        while (i < sb.length()) {
            ++lineW;
            if (sb.charAt(i) == ' ') {
                lastSpace = i;
            }
            if (sb.charAt(i) == '$') {
                lineW -= 5;
            }
            output.append(sb.charAt(i));
            if (sb.charAt(i) == '~') {
                lineW = 0;
            } else if (lineW >= wrapAt) {
                output.replace(lastSpace, lastSpace + 1, "~");
                lineW = i - lastSpace;
            }
            ++i;
        }
        return output.toString();
    }

    public static boolean colorMatchCheck(ArrayList<Color> validColors, Color color) {
        for (Color c : validColors) {
            if (!c.equals(color)) continue;
            return true;
        }
        return false;
    }

    public static float calculateAngle(float x1, float y1, float x2, float y2) {
        float xDiff = x2 - x1;
        float yDiff = y2 - y1;
        return (float)Math.atan2(yDiff, xDiff);
    }

    public static float calculateProjectileAngle(float x1, float y1, float x2, float y2, float missileSpeed, float targetAngle, float targetVelocity) {
        return Utilities.calculateProjectileAngle(x1, y1, x2, y2, missileSpeed, 0.0f, targetAngle, targetVelocity);
    }

    public static float calculateProjectileAngle(float x1, float y1, float x2, float y2, float missileSpeed, float missileFriction, float targetAngle, float targetVelocity) {
        double cos = Math.cos(targetAngle) * (double)targetVelocity;
        double sin = Math.sin(targetAngle) * (double)targetVelocity;
        double dx = x2 - x1;
        double dy = y2 - y1;
        double hValue = Math.sqrt(dx * dx + dy * dy) / (double)missileSpeed;
        int x = 1;
        while ((double)x < hValue) {
            hValue += (double)missileFriction;
            ++x;
        }
        x2 = (float)((double)x2 + cos * hValue);
        y2 = (float)((double)y2 + sin * hValue);
        double hValue2 = 0.0;
        double hValueDiff = 2.0;
        while (hValueDiff > 0.1) {
            double dx2 = x2 - x1;
            double dy2 = y2 - y1;
            hValue2 = Math.sqrt(dx2 * dx2 + dy2 * dy2) / (double)missileSpeed;
            hValueDiff = Math.abs(hValue2 - hValue);
            int x3 = 1;
            while ((double)x3 < hValueDiff) {
                hValueDiff += (double)missileFriction;
                ++x3;
            }
            if (hValue > hValue2) {
                x2 = (float)((double)x2 - cos * hValueDiff);
                y2 = (float)((double)y2 - sin * hValueDiff);
            } else {
                x2 = (float)((double)x2 + cos * hValueDiff);
                y2 = (float)((double)y2 + sin * hValueDiff);
            }
            hValue = hValue2;
        }
        double xDiff = x2 - x1;
        double yDiff = y2 - y1;
        return (float)Math.atan2(yDiff, xDiff);
    }

    public static boolean isSendingProfile() {
        return sendingProfile;
    }

    public static boolean isSendingProfileFailed() {
        return sendingProfileFailed;
    }

    public static int getSendingProfileAttempts() {
        return sendingProfileAttempts;
    }

    public static void sendProfile(int number, String name, String category, String comments, String username) throws IOException {
        ForkJoinPool thread = RTRThreadPool.getThreadPool(8);
        thread.submit(() -> {
            String timeStamp;
            block44: {
                Object fos;
                block42: {
                    sendingProfile = true;
                    sendingProfileFailed = false;
                    sendingProfileAttempts = 0;
                    System.out.println("Packaging profile " + number);
                    try {
                        FileUtils.copyDirectory((File)new File("profiles/profile" + number + "/"), (File)new File("profiles/profileOut/profile0/"));
                        FileUtils.copyDirectory((File)new File("logs/"), (File)new File("profiles/profileOut/logs/"));
                    }
                    catch (Exception e1) {
                        sendingProfile = false;
                        sendingProfileFailed = true;
                        e1.printStackTrace();
                    }
                    Properties report = new Properties();
                    report.setProperty("Number", "" + number);
                    report.setProperty("Name", name);
                    report.setProperty("Category", category);
                    report.setProperty("Comments", comments);
                    report.setProperty("Username", username);
                    try {
                        FileOutputStream out = new FileOutputStream("profiles/profileOut/report.txt");
                        report.store(out, "Report");
                        out.close();
                    }
                    catch (IOException ioe) {
                        System.out.println("Failed to save report file!");
                    }
                    timeStamp = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(new Date());
                    try {
                        Throwable throwable = null;
                        Object var8_12 = null;
                        try {
                            fos = new FileOutputStream(Paths.get("profiles/" + name + "_" + category + "_" + timeStamp + ".zip", new String[0]).toFile());
                            try {
                                try (final ZipOutputStream zos = new ZipOutputStream((OutputStream)fos);){
                                    final Path folderOut = Paths.get("profiles/profileOut/", new String[0]);
                                    Files.walkFileTree(folderOut, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                                        @Override
                                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                            zos.putNextEntry(new ZipEntry(folderOut.relativize(file).toString()));
                                            Files.copy(file, zos);
                                            zos.closeEntry();
                                            return FileVisitResult.CONTINUE;
                                        }

                                        @Override
                                        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                                            zos.putNextEntry(new ZipEntry(String.valueOf(folderOut.relativize(dir).toString()) + "/"));
                                            zos.closeEntry();
                                            return FileVisitResult.CONTINUE;
                                        }
                                    });
                                }
                                if (fos == null) break block42;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (fos == null) throw throwable;
                                ((FileOutputStream)fos).close();
                                throw throwable;
                            }
                            ((FileOutputStream)fos).close();
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                                throw throwable;
                            }
                            if (throwable == throwable3) throw throwable;
                            throwable.addSuppressed(throwable3);
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        sendingProfile = false;
                        sendingProfileFailed = true;
                        return;
                    }
                }
                System.out.println("Uploading profile " + number);
                FTPClient client = new FTPClient();
                String fileName = String.valueOf(name) + "_" + category + "_" + timeStamp + ".zip";
                try {
                    try {
                        fos = null;
                        Object var10_19 = null;
                        try (FileInputStream fis = new FileInputStream(Paths.get("profiles/" + fileName, new String[0]).toFile());){
                            client.connect("ftp.rayvolution.net");
                            client.login("rtrpublic@risetoruins.com", "rtr123");
                            client.setFileType(2);
                            boolean didStore = false;
                            while (!didStore) {
                                if (sendingProfileAttempts > 2) {
                                    sendingProfileFailed = true;
                                    break;
                                }
                                System.out.println("Upload Attempt: " + (sendingProfileAttempts + 1));
                                didStore = client.storeFile(fileName, (InputStream)fis);
                                ++sendingProfileAttempts;
                            }
                            client.logout();
                        }
                        catch (Throwable throwable) {
                            if (fos == null) {
                                fos = throwable;
                                throw fos;
                            }
                            if (fos == throwable) throw fos;
                            ((Throwable)fos).addSuppressed(throwable);
                            throw fos;
                        }
                    }
                    catch (IOException e) {
                        sendingProfile = false;
                        sendingProfileFailed = true;
                        e.printStackTrace();
                        try {
                            sendingProfile = false;
                            client.disconnect();
                        }
                        catch (IOException e2) {
                            sendingProfile = false;
                            e2.printStackTrace();
                        }
                        break block44;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        sendingProfile = false;
                        client.disconnect();
                        throw throwable;
                    }
                    catch (IOException e) {
                        sendingProfile = false;
                        e.printStackTrace();
                    }
                    throw throwable;
                }
                try {
                    sendingProfile = false;
                    client.disconnect();
                }
                catch (IOException e) {
                    sendingProfile = false;
                    e.printStackTrace();
                }
            }
            if (sendingProfileFailed) {
                System.out.println("Upload of profile " + number + " failed.");
            } else {
                System.out.println("Upload of profile " + number + " completed.");
            }
            try {
                FileUtils.deleteDirectory((File)new File("profiles/profileOut/"));
                Files.delete(Paths.get("profiles/" + name + "_" + category + "_" + timeStamp + ".zip", new String[0]));
            }
            catch (Exception e) {
                sendingProfile = false;
                e.printStackTrace();
            }
            sendingProfile = false;
        });
    }

    public static boolean isStreamLive() {
        try {
            URL url = new URL("http://risetoruins.com/streamCheck.php");
            URLConnection conn = url.openConnection();
            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String inputLine = br.readLine();
            br.close();
            return inputLine.equals("ONLINE");
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

