/*
 * Decompiled with CFR 0.152.
 */
package rtr.utilities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import rtr.utilities.Utilities;

public class OrderedPair {
    private static OrderedPair[][] orderedPairMap;
    private int x;
    private int y;

    static {
        OrderedPair.initOrderedPairs();
    }

    public OrderedPair(int x, int y) {
        this.x = x;
        this.y = y;
    }

    private static void initOrderedPairs() {
        orderedPairMap = new OrderedPair[256][256];
        int x = 0;
        while (x < 256) {
            int y = 0;
            while (y < 256) {
                OrderedPair.orderedPairMap[x][y] = new OrderedPair(x, y);
                ++y;
            }
            ++x;
        }
    }

    public static OrderedPair getOrderedPair(int x, int y) {
        if (!Utilities.isOutOfBounds(256, 256, x, y)) {
            return orderedPairMap[x][y];
        }
        return null;
    }

    public static ArrayList<OrderedPair> sortPairsDistance(final int tileX, final int tileY, ArrayList<OrderedPair> list) {
        Collections.sort(list, new Comparator<OrderedPair>(){

            @Override
            public int compare(OrderedPair m1, OrderedPair m2) {
                int dx1 = m1.getX() - tileX;
                int dy1 = m1.getY() - tileY;
                int hValue1 = dx1 * dx1 + dy1 * dy1;
                int dx2 = m2.getX() - tileX;
                int dy2 = m2.getY() - tileY;
                int hValue2 = dx2 * dx2 + dy2 * dy2;
                if (m1 == m2) {
                    return hValue2;
                }
                return hValue1 - hValue2;
            }
        });
        return list;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }
}

