/*
 * Decompiled with CFR 0.152.
 */
package rtr.utilities;

import java.io.File;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;

public class ImageScrubber {
    public static void scrubMapSheets() {
        ImageScrubber.scrub(new File("src/res/maps/base").listFiles());
        ImageScrubber.scrub(new File("src/res/maps/collision").listFiles());
        ImageScrubber.scrub(new File("src/res/maps/data").listFiles());
        ImageScrubber.scrub(new File("src/res/maps/depth").listFiles());
        ImageScrubber.scrub(new File("src/res/maps/particle").listFiles());
        ImageScrubber.scrub(new File("src/res/maps/shadow").listFiles());
    }

    private static void scrub(File[] base) {
        File[] fileArray = base;
        int n = base.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isFile()) {
                if (f.getName().contains("terrainMaster")) {
                    System.out.println("Found illegal image: " + f.getName());
                    f.delete();
                    f.deleteOnExit();
                } else if (ImageScrubber.isBlankImage(f)) {
                    System.out.println("Found blank image: " + f.getName());
                    f.delete();
                    f.deleteOnExit();
                }
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isBlankImage(File f) {
        try {
            Image i = new Image(f.getAbsolutePath());
            int width = i.getWidth();
            int height = i.getHeight();
            int w = 0;
            block2: while (true) {
                if (w >= width) {
                    return true;
                }
                int h = 0;
                while (true) {
                    if (h >= height) {
                        ++w;
                        continue block2;
                    }
                    if (i.getColor(w, h).getAlpha() > 0) {
                        return false;
                    }
                    ++h;
                }
                break;
            }
        }
        catch (SlickException e) {
            return true;
        }
    }
}

