/*
 * Decompiled with CFR 0.152.
 */
package rtr.utilities;

public class FastMath {
    private static final float RAD = (float)Math.PI / 180;
    private static final int SIN_BITS = 12;
    private static final int SIN_MASK = 4095;
    private static final int SIN_COUNT = 4096;
    private static final float radFull = (float)Math.PI * 2;
    private static final float degFull = 360.0f;
    private static final float radToIndex = 651.8986f;
    private static final float degToIndex = 11.377778f;
    private static final float[] sin = new float[4096];
    private static final float[] cos = new float[4096];

    static {
        int i = 0;
        while (i < 4096) {
            FastMath.sin[i] = (float)Math.sin(((float)i + 0.5f) / 4096.0f * ((float)Math.PI * 2));
            FastMath.cos[i] = (float)Math.cos(((float)i + 0.5f) / 4096.0f * ((float)Math.PI * 2));
            ++i;
        }
    }

    public static final float sin(float rad) {
        return sin[(int)(rad * 651.8986f) & 0xFFF];
    }

    public static final float cos(float rad) {
        return cos[(int)(rad * 651.8986f) & 0xFFF];
    }

    public static final float sinDeg(float deg) {
        return sin[(int)(deg * 11.377778f) & 0xFFF];
    }

    public static final float cosDeg(float deg) {
        return cos[(int)(deg * 11.377778f) & 0xFFF];
    }

    public static final float sinDegStrict(float deg) {
        return (float)Math.sin(deg * ((float)Math.PI / 180));
    }

    public static final float cosDegStrict(float deg) {
        return (float)Math.cos(deg * ((float)Math.PI / 180));
    }
}

