/*
 * Decompiled with CFR 0.152.
 */
package rtr.system;

import java.util.ArrayList;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.newdawn.slick.AppGameContainer;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.GameState;
import org.newdawn.slick.state.StateBasedGame;
import rtr.SettingsParser;
import rtr.states.MainMenuState;
import rtr.states.PlayState;
import rtr.states.SplashState;
import rtr.states.StateBase;
import rtr.system.ScaleControl;

public class Game
extends StateBasedGame {
    private static AppGameContainer appgc;
    private static final String ICONS = "res/icon.png";
    private static final String GAME_VERSION = "InDev 1";
    private static final String SETTINGS_VERSION = "0";
    private static final String GAME_NAME = "Half Baked Rogue InDev 1";
    private static final int GAME_LOOP_UPDATE_MAXIMUM = 20;
    private static final int LOADING_LOOP_UPDATE_MAXIMUM = 2000;
    private static SplashState splashState;
    private static int splashStateID;
    private static MainMenuState mainMenuState;
    private static int mainMenuStateID;
    private static PlayState playState;
    private static int playStateID;
    private static StateBase currentState;
    private static int activeProfile;
    private static ArrayList<String> validGameVersions;

    static {
        splashStateID = 0;
        mainMenuStateID = 1;
        playStateID = 3;
        activeProfile = -1;
    }

    public Game(String gamename) {
        super(gamename);
        validGameVersions = new ArrayList();
        validGameVersions.add(GAME_VERSION);
        splashState = new SplashState(splashStateID);
        this.addState((GameState)splashState);
        mainMenuState = new MainMenuState(mainMenuStateID);
        this.addState((GameState)mainMenuState);
        playState = new PlayState(playStateID);
        this.addState((GameState)playState);
    }

    public void initStatesList(GameContainer gc) throws SlickException {
        this.enterState(splashStateID);
        gc.setShowFPS(false);
        Display.setResizable((boolean)true);
    }

    public static void launchGame() throws LWJGLException, SlickException {
        SettingsParser.loadBaseSettings();
        ScaleControl.initDisplay();
        try {
            System.out.println(GAME_NAME);
            System.out.println("Operating System: " + System.getProperty("os.name"));
            System.out.println("GPU Drivers: " + Display.getAdapter());
            System.out.println("GPU Driver Version: " + Display.getVersion());
            System.out.println("Maximum JVM Memory: " + Runtime.getRuntime().maxMemory() / 0x100000L + "MB");
            if (SettingsParser.getFullScreen()) {
                System.out.println("Display Mode: Full Screen");
            } else {
                System.out.println("Display Mode: Windowed");
            }
            System.out.println();
            if (SettingsParser.getFullScreen()) {
                appgc = new AppGameContainer((org.newdawn.slick.Game)new Game(GAME_NAME), true);
                Mouse.setGrabbed((boolean)true);
            } else {
                int width = Display.getDesktopDisplayMode().getWidth() - 100;
                int height = Display.getDesktopDisplayMode().getHeight() - 200;
                if (width < ScaleControl.getMinWidth()) {
                    width = ScaleControl.getMinWidth();
                }
                if (height < ScaleControl.getMinHeight()) {
                    height = ScaleControl.getMinHeight();
                }
                appgc = new AppGameContainer((org.newdawn.slick.Game)new Game(GAME_NAME), width, height);
            }
            appgc.setIcon(ICONS);
            appgc.setVSync(SettingsParser.getVSync());
            appgc.setTargetFrameRate(60);
            appgc.setClearEachFrame(false);
            appgc.setAlwaysRender(true);
            appgc.setMultiSample(0);
            appgc.setMaximumLogicUpdateInterval(20);
            appgc.start();
        }
        catch (SlickException e) {
            e.printStackTrace();
        }
    }

    public static void setModeLoad() {
        appgc.setMaximumLogicUpdateInterval(2000);
    }

    public static void setModeGame() {
        appgc.setMaximumLogicUpdateInterval(20);
    }

    public static String getVersion() {
        return GAME_VERSION;
    }

    public static String getSettingsVersion() {
        return SETTINGS_VERSION;
    }

    public static int getActiveProfile() {
        return activeProfile;
    }

    public static void setActiveProfile(int aP) {
        activeProfile = aP;
    }

    public static void setCS(StateBase s) {
        currentState = s;
    }

    public static StateBase getCS() {
        return currentState;
    }

    public static int getCSID() {
        return currentState.getID();
    }

    public static SplashState getSplashState() {
        return splashState;
    }

    public static MainMenuState getMainMenuState() {
        return mainMenuState;
    }

    public static PlayState getPlayState() {
        return playState;
    }

    public static ArrayList<String> getValidGameVersions() {
        return validGameVersions;
    }

    public static boolean isValidGameVersion(String s) {
        for (String v : validGameVersions) {
            if (!v.equals(s)) continue;
            return true;
        }
        return false;
    }

    public static enum GameMode {
        SPLASH,
        PLAY,
        MAIN_MENU;

    }
}

