/*
 * Decompiled with CFR 0.152.
 */
package rtr.states;

import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.newdawn.slick.AppGameContainer;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.Input;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.imageout.ImageOut;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;
import rtr.ImageLoader;
import rtr.SettingsParser;
import rtr.ShadowModule;
import rtr.TransitionModule;
import rtr.TurnControlModule;
import rtr.console.Console;
import rtr.font.FontModule;
import rtr.item.ItemModule;
import rtr.lighting.LightingModule;
import rtr.map.CollisionModule;
import rtr.map.MapModule;
import rtr.map.MiniMapModule;
import rtr.mobs.MobModule;
import rtr.object.ObjectModule;
import rtr.particles.ParticleModule;
import rtr.particles.projectiles.ProjectileModule;
import rtr.system.Game;
import rtr.system.ScaleControl;
import rtr.utilities.Utilities;

public class StateBase
extends BasicGameState {
    protected Game.GameMode gameMode;
    protected static FontModule font = new FontModule();
    protected static MapModule map = new MapModule();
    protected static MiniMapModule miniMap = new MiniMapModule();
    protected static ShadowModule shadow = new ShadowModule();
    protected static MobModule mob = new MobModule();
    protected static ItemModule item = new ItemModule();
    protected static ObjectModule object = new ObjectModule();
    protected static LightingModule lighting = new LightingModule();
    protected static CollisionModule collision = new CollisionModule();
    protected static ParticleModule particle = new ParticleModule();
    protected static ProjectileModule projectile = new ProjectileModule();
    protected static TurnControlModule turnControl = new TurnControlModule();
    protected static TransitionModule transition = new TransitionModule();
    protected boolean loadFont;
    protected boolean loadMap;
    protected boolean loadMiniMap;
    protected boolean loadShadow;
    protected boolean loadMob;
    protected boolean loadItem;
    protected boolean loadObject;
    protected boolean loadLighting;
    protected boolean loadCollision;
    protected boolean loadParticle;
    protected boolean loadProjectile;
    protected boolean loadTurnControl;
    protected boolean loadTransition;
    protected boolean loadingRequired;
    protected boolean modulesLoaded;
    protected boolean initLoad;
    protected String currentLoad = "";
    protected long startTime;
    protected long endTime;
    protected long startTimeTotal;
    protected long endTimeTotal;
    protected Image loadingLogo;
    protected Image loadingPillar;
    protected int stateID;
    protected GameContainer gc;
    protected StateBasedGame sbg;
    protected Graphics g;
    protected Input input;
    protected boolean takeScreenShot;
    protected Runtime runtime = Runtime.getRuntime();
    protected ArrayList<String> randomLoadingMessages = new ArrayList();
    protected String randomLoadingMessage;
    protected boolean hideGUI;
    protected boolean debug;

    public static FontModule getFontModule() {
        return font;
    }

    public static MapModule getMapModule() {
        return map;
    }

    public static MiniMapModule getMiniMapModule() {
        return miniMap;
    }

    public static ShadowModule getShadowModule() {
        return shadow;
    }

    public static MobModule getMobModule() {
        return mob;
    }

    public static ItemModule getItemModule() {
        return item;
    }

    public static ObjectModule getObjectModule() {
        return object;
    }

    public static LightingModule getLightingModule() {
        return lighting;
    }

    public static CollisionModule getCollisionModule() {
        return collision;
    }

    public static ParticleModule getParticleModule() {
        return particle;
    }

    public static ProjectileModule getProjectileModule() {
        return projectile;
    }

    public static TurnControlModule getTurnControlModule() {
        return turnControl;
    }

    public static TransitionModule getTransitionModule() {
        return transition;
    }

    public StateBase(int s) {
        this.stateID = s;
    }

    public void init(GameContainer gc, StateBasedGame sbg) throws SlickException {
        this.gc = gc;
        this.sbg = sbg;
        this.g = gc.getGraphics();
        this.input = gc.getInput();
        this.input.enableKeyRepeat();
        this.initLoad = true;
        try {
            String line;
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("res/loadingMessages.txt");
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                this.randomLoadingMessages.add(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.loadingLogo = ImageLoader.getImage("res/logo.png");
        this.loadingPillar = ImageLoader.getImage("res/pillar.png");
    }

    private void resetModules() throws SlickException {
        System.out.println("Resetting " + (Object)((Object)this.gameMode));
        if (this.loadFont) {
            font.resetModule();
        }
        if (this.loadMap) {
            map.resetModule();
        }
        if (this.loadMiniMap) {
            miniMap.resetModule();
        }
        if (this.loadShadow) {
            shadow.resetModule();
        }
        if (this.loadMob) {
            mob.resetModule();
        }
        if (this.loadItem) {
            item.resetModule();
        }
        if (this.loadObject) {
            object.resetModule();
        }
        if (this.loadLighting) {
            lighting.resetModule();
        }
        if (this.loadCollision) {
            collision.resetModule();
        }
        if (this.loadParticle) {
            particle.resetModule();
        }
        if (this.loadProjectile) {
            projectile.resetModule();
        }
        if (this.loadTurnControl) {
            turnControl.resetModule();
        }
        if (this.loadTransition) {
            transition.resetModule();
        }
    }

    public void render(GameContainer container, StateBasedGame game, Graphics g) throws SlickException {
        g.clear();
        g.setColor(Color.black);
        g.fillRect(-16.0f, -16.0f, Display.getWidth() + 32, Display.getHeight() + 32);
        if (Display.wasResized()) {
            this.setGUI();
        }
    }

    protected void renderLoadScreen() {
        this.g.scale(ScaleControl.getScale(), ScaleControl.getScale());
        if (font.isInitialized()) {
            String message = Utilities.wrapString(this.randomLoadingMessage, 38);
            font.drawString(ScaleControl.getWidth() / 2, ScaleControl.getHeight() / 2 - 40, "$GRE1LOADING", 3, true);
            font.drawString(ScaleControl.getWidth() / 2, ScaleControl.getHeight() / 2 - 10, this.currentLoad.toUpperCase(), 3, true);
            font.drawString(ScaleControl.getWidth() / 2, ScaleControl.getHeight() / 2 + 50, "$YEL1" + message, 2, true);
        }
        this.loadingLogo.drawCentered(ScaleControl.getWidth() / 2, ScaleControl.getHeight() / 2 - 110);
        this.loadingPillar.draw(-96.0f, 0.0f);
        this.loadingPillar.draw(ScaleControl.getWidth() - this.loadingPillar.getWidth() + 96, 0.0f);
    }

    protected void renderDebug(float x, float y) {
        this.g.setColor(new Color(0, 0, 0, 200));
        this.g.fillRect(x - 5.0f, y + 5.0f, 220.0f, 250.0f);
        font.drawString(x, y + 15.0f, "$GRE1FPS: " + this.gc.getFPS(), 1);
        font.drawString(x, y + 25.0f, "$BLU0Map: " + map.getMapX() + " " + map.getMapY(), 1);
        font.drawString(x, y + 85.0f, "$CYA1Used Memory: " + (this.runtime.totalMemory() - this.runtime.freeMemory()) / 0x100000L, 1);
        font.drawString(x, y + 95.0f, "$CYA1Free Memory: " + this.runtime.freeMemory() / 0x100000L, 1);
        font.drawString(x, y + 105.0f, "$CYA1Total Memory: " + this.runtime.totalMemory() / 0x100000L, 1);
        font.drawString(x, y + 115.0f, "$CYA1Maximum Memory: " + this.runtime.maxMemory() / 0x100000L, 1);
        font.drawString(x, y + 125.0f, "$YEL1Resolution: " + Display.getWidth() + "x" + Display.getHeight(), 1);
        font.drawString(x, y + 135.0f, "$YEL1Viewport: " + ScaleControl.getWidth() + "x" + ScaleControl.getHeight(), 1);
        font.drawString(x, y + 145.0f, "$YEL1Scale: " + ScaleControl.getScale(), 1);
    }

    public void update(GameContainer container, StateBasedGame game, int delta) throws SlickException {
        if (this.loadingRequired) {
            this.loadState();
            return;
        }
        this.controlsKeyboard();
    }

    protected void controlsKeyboard() throws SlickException {
    }

    public void enter(GameContainer gc, StateBasedGame sbg) throws SlickException {
        Game.setCS(this);
        this.loadingRequired = true;
        this.modulesLoaded = false;
        this.initLoad = true;
        this.currentLoad = "";
        this.endTimeTotal = 0L;
        this.startTimeTotal = 0L;
    }

    public void leave(GameContainer gc, StateBasedGame sbg) throws SlickException {
        this.resetModules();
    }

    protected void screenShotListener() throws SlickException {
        if (this.takeScreenShot) {
            boolean findNextScreenShot = true;
            int screenShotNumber = 1;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Date date = new Date();
            File screenShotFolder = new File("screenShots/");
            if (!screenShotFolder.exists()) {
                screenShotFolder.mkdirs();
            }
            File screenShotFile = new File("screenShots/InDev-" + dateFormat.format(date) + "-" + screenShotNumber + ".png");
            Image screenShot = new Image(this.gc.getWidth(), this.gc.getHeight());
            this.g.copyArea(screenShot, 0, 0);
            while (findNextScreenShot) {
                if (!screenShotFile.exists() || screenShotFile.isDirectory()) {
                    ImageOut.write((Image)screenShot, (String)screenShotFile.toString(), (boolean)false);
                    findNextScreenShot = false;
                    continue;
                }
                screenShotFile = new File("screenShots/InDev-" + dateFormat.format(date) + "-" + ++screenShotNumber + ".png");
            }
            screenShotFolder = null;
            screenShotFile = null;
            screenShot.destroy();
            this.takeScreenShot = false;
            System.gc();
        }
    }

    protected void setGUI() throws SlickException {
        if (Display.wasResized()) {
            ((AppGameContainer)this.gc).setDisplayMode(Display.getWidth(), Display.getHeight(), false);
        }
        ScaleControl.setDisplay();
    }

    protected void toggleFullScreen() throws SlickException {
        if (SettingsParser.getFullScreen()) {
            Console.out("Switching to Windowed mode.", false);
            int width = Display.getDesktopDisplayMode().getWidth() - 100;
            int height = Display.getDesktopDisplayMode().getHeight() - 200;
            if (width < ScaleControl.getMinWidth()) {
                width = ScaleControl.getMinWidth();
            }
            if (height < ScaleControl.getMinHeight()) {
                height = ScaleControl.getMinHeight();
            }
            ((AppGameContainer)this.gc).setDisplayMode(width, height, false, true);
            SettingsParser.setFullScreen(false);
            Mouse.setGrabbed((boolean)false);
        } else {
            Console.out("Switching to Fullscreen mode.", false);
            Toolkit t = Toolkit.getDefaultToolkit();
            ((AppGameContainer)this.gc).setDisplayMode(t.getScreenSize().width, t.getScreenSize().height, true, true);
            SettingsParser.setFullScreen(true);
            Mouse.setGrabbed((boolean)true);
        }
    }

    protected void loadState() throws SlickException {
        if (this.modulesLoaded) {
            return;
        }
        if (this.initLoad) {
            this.startTimeTotal = System.currentTimeMillis();
            Game.setModeLoad();
            Console.out("Loading Game", true);
            this.randomLoadingMessage = this.randomLoadingMessages.get(Utilities.randomInt(this.randomLoadingMessages.size()));
            this.initLoad = false;
        }
        if (this.loadFont && !font.isInitialized()) {
            if (!this.currentLoad.equals("Font Module")) {
                this.currentLoad = "Font Module";
                return;
            }
            this.startTime = System.currentTimeMillis();
            font.initModule(this);
            this.endTime = System.currentTimeMillis();
            Console.out("Font Module: " + (this.endTime - this.startTime), true);
            return;
        }
        if (this.loadTurnControl && !turnControl.isInitialized()) {
            if (!this.currentLoad.equals("Turn Control Module")) {
                this.currentLoad = "Turn Control Module";
                return;
            }
            this.startTime = System.currentTimeMillis();
            turnControl.initModule(this);
            this.endTime = System.currentTimeMillis();
            Console.out("Turn Control Module: " + (this.endTime - this.startTime), true);
            return;
        }
        if (this.loadItem && !item.isInitialized()) {
            if (!this.currentLoad.equals("Item Module")) {
                this.currentLoad = "Item Module";
                return;
            }
            this.startTime = System.currentTimeMillis();
            item.initModule(this);
            this.endTime = System.currentTimeMillis();
            Console.out("Item Module: " + (this.endTime - this.startTime), true);
            return;
        }
        if (this.loadObject && !object.isInitialized()) {
            if (!this.currentLoad.equals("Object Module")) {
                this.currentLoad = "Object Module";
                return;
            }
            this.startTime = System.currentTimeMillis();
            object.initModule(this);
            this.endTime = System.currentTimeMillis();
            Console.out("Object Module: " + (this.endTime - this.startTime), true);
            return;
        }
        if (this.loadMap && !map.isInitialized()) {
            if (!this.currentLoad.equals("Map Module")) {
                this.currentLoad = "Map Module";
                return;
            }
            this.startTime = System.currentTimeMillis();
            map.initModule(this);
            this.endTime = System.currentTimeMillis();
            Console.out("Map Module: " + (this.endTime - this.startTime), true);
            return;
        }
        if (this.loadMiniMap && !miniMap.isInitialized()) {
            if (!this.currentLoad.equals("Mini Map Module")) {
                this.currentLoad = "Mini Map Module";
                return;
            }
            this.startTime = System.currentTimeMillis();
            miniMap.initModule(this);
            this.endTime = System.currentTimeMillis();
            Console.out("Mini Map Module: " + (this.endTime - this.startTime), true);
            return;
        }
        if (this.loadShadow && !shadow.isInitialized()) {
            if (!this.currentLoad.equals("Shadow Module")) {
                this.currentLoad = "Shadow Module";
                return;
            }
            this.startTime = System.currentTimeMillis();
            shadow.initModule(this);
            this.endTime = System.currentTimeMillis();
            Console.out("Shadow Module: " + (this.endTime - this.startTime), true);
            return;
        }
        if (this.loadLighting && !lighting.isInitialized()) {
            if (!this.currentLoad.equals("Lighting Module")) {
                this.currentLoad = "Lighting Module";
                return;
            }
            this.startTime = System.currentTimeMillis();
            lighting.initModule(this);
            this.endTime = System.currentTimeMillis();
            Console.out("Lighting Module: " + (this.endTime - this.startTime), true);
            return;
        }
        if (this.loadCollision && !collision.isInitialized()) {
            if (!this.currentLoad.equals("Collision Module")) {
                this.currentLoad = "Collision Module";
                return;
            }
            this.startTime = System.currentTimeMillis();
            collision.initModule(this);
            this.endTime = System.currentTimeMillis();
            Console.out("Collision Module: " + (this.endTime - this.startTime), true);
            return;
        }
        if (this.loadParticle && !particle.isInitialized()) {
            if (!this.currentLoad.equals("Particle Module")) {
                this.currentLoad = "Particle Module";
                return;
            }
            this.startTime = System.currentTimeMillis();
            particle.initModule(this);
            this.endTime = System.currentTimeMillis();
            Console.out("Particle Module: " + (this.endTime - this.startTime), true);
            return;
        }
        if (this.loadProjectile && !projectile.isInitialized()) {
            if (!this.currentLoad.equals("Projectile Module")) {
                this.currentLoad = "Projectile Module";
                return;
            }
            this.startTime = System.currentTimeMillis();
            projectile.initModule(this);
            this.endTime = System.currentTimeMillis();
            Console.out("Projectile Module: " + (this.endTime - this.startTime), true);
            return;
        }
        if (this.loadMob && !mob.isInitialized()) {
            if (!this.currentLoad.equals("Mob Module")) {
                this.currentLoad = "Mob Module";
                return;
            }
            this.startTime = System.currentTimeMillis();
            mob.initModule(this);
            this.endTime = System.currentTimeMillis();
            Console.out("Mob Module: " + (this.endTime - this.startTime), true);
            return;
        }
        if (this.loadTransition && !transition.isInitialized()) {
            if (!this.currentLoad.equals("Transition Module")) {
                this.currentLoad = "Transition Module";
                return;
            }
            this.startTime = System.currentTimeMillis();
            transition.initModule(this, this.gc, this.sbg, this.input);
            this.endTime = System.currentTimeMillis();
            Console.out("Transition Module: " + (this.endTime - this.startTime), true);
            return;
        }
        this.modulesLoaded = true;
        Game.setModeGame();
    }

    protected void mapWriter() throws SlickException {
        boolean findNextScreenShot = true;
        int screenShotNumber = 1;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date date = new Date();
        File screenShotFolder = new File("screenShots/");
        if (!screenShotFolder.exists()) {
            screenShotFolder.mkdirs();
        }
        File fullMapFile = new File("screenShots/fullScreenshot-" + dateFormat.format(date) + "-" + screenShotNumber + ".png");
        while (findNextScreenShot) {
            if (!fullMapFile.exists() && !fullMapFile.isDirectory()) {
                Image screenShot = new Image(map.getMapFullWidth(), map.getMapFullHeight());
                Graphics g = screenShot.getGraphics();
                map.renderMapWriter(g);
                ImageOut.write((Image)screenShot, (String)fullMapFile.toString(), (boolean)false);
                findNextScreenShot = false;
                continue;
            }
            fullMapFile = new File("screenShots/fullScreenshot-" + dateFormat.format(date) + "-" + ++screenShotNumber + ".png");
        }
        screenShotFolder = null;
        fullMapFile = null;
        this.takeScreenShot = false;
        System.gc();
    }

    public int getID() {
        return this.stateID;
    }

    public Game.GameMode getGameMode() {
        return this.gameMode;
    }

    public void setGameMode(Game.GameMode gM) {
        this.gameMode = gM;
    }
}

