/*
 * Decompiled with CFR 0.152.
 */
package rtr.states;

import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Cursor;
import org.lwjgl.input.Mouse;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.StateBasedGame;
import rtr.ImageLoader;
import rtr.states.StateBase;
import rtr.system.Game;
import rtr.system.ScaleControl;
import rtr.utilities.Utilities;

public class SplashState
extends StateBase {
    private Image splash;
    private float splashDriftX = -15.0f;
    private int splashCountdown = 5;
    private int[] randomSize = new int[500];
    private float[] driftX = new float[500];
    private float[] driftY = new float[500];
    private float[] rectX = new float[500];
    private float[] rectY = new float[500];
    private Color[] color = new Color[500];
    private Image rectangleFBO;

    public SplashState(int s) {
        super(s);
        this.gameMode = Game.GameMode.SPLASH;
    }

    @Override
    public void enter(GameContainer gc, StateBasedGame sbg) throws SlickException {
        Game.setCS(this);
        try {
            Cursor emptyCursor = new Cursor(1, 1, 0, 0, 1, BufferUtils.createIntBuffer((int)1), null);
            Mouse.setNativeCursor((Cursor)emptyCursor);
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
        ScaleControl.setDisplay();
        this.splash = ImageLoader.getImage("res/splash.png");
        this.rectangleFBO = new Image(ScaleControl.getWidth() + 32, ScaleControl.getHeight() + 32);
        int x = 0;
        while (x < this.randomSize.length) {
            this.color[x] = new Color(150 + Utilities.randomInt(100), 255, 255, 100 + Utilities.randomInt(50));
            this.randomSize[x] = 8 + Utilities.randomInt(16);
            this.rectX[x] = Utilities.randomInt(-1023, 1023);
            this.rectY[x] = Utilities.randomInt(-63, 63);
            this.driftX[x] = Utilities.randomFloat();
            this.driftY[x] = (Utilities.randomFloat() - Utilities.randomFloat()) / 8.0f;
            ++x;
        }
        this.loadFont = true;
        font.initModule(this);
        this.loadTransition = true;
        transition.initModule(this, gc, sbg, this.input);
        this.loadMap = true;
        map.initModule(this);
        transition.enter();
    }

    @Override
    public void setGUI() throws SlickException {
        super.setGUI();
        this.updateFBO();
    }

    public void updateFBO() throws SlickException {
        this.rectangleFBO = new Image(ScaleControl.getWidth() + 32, ScaleControl.getHeight() + 32);
    }

    @Override
    public void render(GameContainer gc, StateBasedGame sbg, Graphics g) throws SlickException {
        super.render(gc, sbg, g);
        g.scale(ScaleControl.getScale(), ScaleControl.getScale());
        g.setColor(new Color(0, 0, 0, 200));
        g.fillRect(0.0f, 0.0f, ScaleControl.getWidth() + 2, ScaleControl.getHeight() + 2);
        Graphics FBO = this.rectangleFBO.getGraphics();
        FBO.clear();
        int x = 0;
        while (x < this.randomSize.length) {
            FBO.setColor(this.color[x]);
            FBO.fillRoundRect((float)(ScaleControl.getWidth() / 2) + this.rectX[x], (float)(ScaleControl.getHeight() / 2) + this.rectY[x], this.randomSize[x], this.randomSize[x], 4);
            ++x;
        }
        FBO.flush();
        this.rectangleFBO.draw(0.0f, 0.0f);
        this.splash.drawCentered((float)(ScaleControl.getWidth() / 2) + this.splashDriftX, ScaleControl.getHeight() / 2);
        g.resetTransform();
        g.scale(ScaleControl.getScale(), ScaleControl.getScale());
        transition.render(g);
    }

    @Override
    public void update(GameContainer gc, StateBasedGame sbg, int delta) throws SlickException {
        super.update(gc, sbg, delta);
        if (this.loadingRequired) {
            return;
        }
        --this.splashCountdown;
        this.splashDriftX += 0.05f;
        int x = 0;
        while (x < this.randomSize.length) {
            int n = x;
            this.rectX[n] = this.rectX[n] + this.driftX[x];
            int n2 = x;
            this.rectY[n2] = this.rectY[n2] + this.driftY[x];
            ++x;
        }
        if (this.splashCountdown <= 0) {
            transition.startTransition(Game.getPlayState());
        }
    }
}

