/*
 * Decompiled with CFR 0.152.
 */
package rtr.states;

import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.StateBasedGame;
import rtr.SettingsParser;
import rtr.TurnControlModule;
import rtr.console.Console;
import rtr.gui.PlayStateGUI;
import rtr.item.ItemBase;
import rtr.mobs.MobBase;
import rtr.states.StateBase;
import rtr.system.Game;
import rtr.system.ScaleControl;
import rtr.utilities.Utilities;

public class PlayState
extends StateBase {
    private PlayStateGUI gui;

    public PlayState(int s) {
        super(s);
        this.gameMode = Game.GameMode.PLAY;
        this.loadFont = true;
        this.loadMap = true;
        this.loadMiniMap = true;
        this.loadShadow = true;
        this.loadMob = true;
        this.loadItem = true;
        this.loadObject = true;
        this.loadLighting = true;
        this.loadCollision = true;
        this.loadParticle = true;
        this.loadProjectile = true;
        this.loadTurnControl = true;
        this.loadTransition = true;
    }

    @Override
    protected void loadState() throws SlickException {
        super.loadState();
        if (this.modulesLoaded) {
            this.loadingRequired = false;
            this.gui = new PlayStateGUI();
            this.setGUI();
            transition.enter();
            this.endTimeTotal = System.currentTimeMillis();
            Console.out("TOTAL TIME: " + (this.endTimeTotal - this.startTimeTotal), true);
            this.currentLoad = "Starting...";
        }
    }

    @Override
    public void leave(GameContainer gc, StateBasedGame sbg) throws SlickException {
        super.leave(gc, sbg);
    }

    @Override
    public void render(GameContainer gc, StateBasedGame sbg, Graphics g) throws SlickException {
        super.render(gc, sbg, g);
        if (this.loadingRequired) {
            this.renderLoadScreen();
            return;
        }
        g.scale(ScaleControl.getScale(), ScaleControl.getScale());
        boolean profiling = false;
        int profilingCap = 2;
        if (profiling) {
            Utilities.startTimer();
        }
        map.renderBottom();
        if (profiling) {
            Utilities.endTimer("Map Bottom: ", profilingCap);
            Utilities.startTimer();
        }
        shadow.renderBottom();
        if (profiling) {
            Utilities.endTimer("Shadow Bottom: ", profilingCap);
            Utilities.startTimer();
        }
        map.renderTop();
        if (profiling) {
            Utilities.endTimer("Map Top: ", profilingCap);
            Utilities.startTimer();
        }
        shadow.renderTop();
        if (profiling) {
            Utilities.endTimer("Shadow Top: ", profilingCap);
            Utilities.startTimer();
        }
        item.render();
        if (profiling) {
            Utilities.endTimer("Item: ", profilingCap);
            Utilities.startTimer();
        }
        object.render();
        if (profiling) {
            Utilities.endTimer("Object: ", profilingCap);
            Utilities.startTimer();
        }
        particle.renderBottom();
        if (profiling) {
            Utilities.endTimer("Particle Top: ", profilingCap);
            Utilities.startTimer();
        }
        mob.render(g);
        if (profiling) {
            Utilities.endTimer("Mob: ", profilingCap);
            Utilities.startTimer();
        }
        particle.renderTop();
        if (profiling) {
            Utilities.endTimer("Particle Top: ", profilingCap);
            Utilities.startTimer();
        }
        projectile.render();
        if (profiling) {
            Utilities.endTimer("Projectile: ", profilingCap);
            Utilities.startTimer();
        }
        lighting.render(g);
        if (profiling) {
            Utilities.endTimer("Lighting: ", profilingCap);
            Utilities.startTimer();
        }
        turnControl.render();
        if (profiling) {
            Utilities.endTimer("Turn Control: ", profilingCap);
            Utilities.startTimer();
        }
        if (profiling) {
            Utilities.endTimer("Mob: ", profilingCap);
        }
        g.resetTransform();
        g.scale(ScaleControl.getScale(), ScaleControl.getScale());
        this.renderGUI();
        this.screenShotListener();
        transition.render(g);
    }

    private void renderGUI() throws SlickException {
        this.gui.render(this.g);
        Console.renderBanner(this.g);
        particle.renderGUI();
        if (this.debug) {
            this.renderDebug(65.0f, 30.0f);
        }
    }

    @Override
    public void update(GameContainer gc, StateBasedGame sbg, int delta) throws SlickException {
        super.update(gc, sbg, delta);
        if (this.loadingRequired) {
            return;
        }
        Console.update();
        boolean profiling = false;
        int profilingCap = 0;
        if (profiling) {
            Utilities.startTimer();
        }
        map.update();
        if (profiling) {
            Utilities.endTimer("Map: ", profilingCap);
            Utilities.startTimer();
        }
        miniMap.update();
        if (profiling) {
            Utilities.endTimer("Mini Map: ", profilingCap);
            Utilities.startTimer();
        }
        item.update();
        if (profiling) {
            Utilities.endTimer("Item: ", profilingCap);
            Utilities.startTimer();
        }
        object.update();
        if (profiling) {
            Utilities.endTimer("Object: ", profilingCap);
            Utilities.startTimer();
        }
        mob.update();
        if (profiling) {
            Utilities.endTimer("Mob: ", profilingCap);
            Utilities.startTimer();
        }
        lighting.update();
        if (profiling) {
            Utilities.endTimer("Lighting: ", profilingCap);
            Utilities.startTimer();
        }
        particle.update();
        if (profiling) {
            Utilities.endTimer("Particle: ", profilingCap);
            Utilities.startTimer();
        }
        projectile.update();
        if (profiling) {
            Utilities.endTimer("Projectile: ", profilingCap);
            Utilities.startTimer();
        }
        turnControl.update();
        if (profiling) {
            Utilities.endTimer("Turn Control: ", profilingCap);
        }
    }

    @Override
    protected void controlsKeyboard() throws SlickException {
        if (transition.getControlLockout()) {
            this.input.clearKeyPressedRecord();
            return;
        }
        if (this.input.isKeyPressed(59)) {
            map.generateMap();
        }
        if (this.input.isKeyPressed(60)) {
            if (this.input.isKeyDown(42)) {
                this.mapWriter();
            } else {
                this.takeScreenShot = true;
            }
        }
        if (this.input.isKeyPressed(SettingsParser.getKeyFullScreen())) {
            this.toggleFullScreen();
            this.setGUI();
            this.input.clearKeyPressedRecord();
            return;
        }
        if (this.input.isKeyDown(15)) {
            this.gui.openMiniMap();
        } else {
            this.gui.closeMiniMap();
        }
        if (turnControl.getCurrentTurnState() == TurnControlModule.TurnState.IDLE && mob.getHero().getCommandState() != MobBase.MobCommand.DEAD) {
            if (this.gui.isInventoryOpen()) {
                if (this.input.isKeyPressed(23) || this.input.isKeyPressed(1)) {
                    this.gui.toggleInventory();
                } else if (this.input.isKeyPressed(18)) {
                    if (this.gui.isUsingContainer()) {
                        if (this.gui.getContainerSlotHighlightedItem() != null) {
                            mob.getHero().takeFromContainer(this.gui.getContainer(), this.gui.getContainerSlotHighlightedItem());
                        }
                    } else if (this.gui.getContainer() != null) {
                        if (this.gui.getInventorySlotHighlightedItem() != null) {
                            mob.getHero().placeInContainer(this.gui.getContainer(), this.gui.getInventorySlotHighlightedItem());
                        }
                    } else if (this.attemptHeroUseAction(this.gui.getInventorySlotHighlightedItem())) {
                        turnControl.executeTurn();
                    }
                } else if (this.input.isKeyPressed(44)) {
                    this.gui.toggleUsingContainer();
                } else if (this.input.isKeyPressed(16)) {
                    if (!this.gui.isUsingContainer() && this.attemptHeroDropAction(this.gui.getInventorySlotHighlightedItem())) {
                        turnControl.executeTurn();
                    }
                } else if (this.input.isKeyPressed(SettingsParser.getKeyUp()) || this.input.isKeyPressed(17) || this.input.isControllerUp(6)) {
                    if (this.gui.isUsingContainer()) {
                        this.gui.setContainerSlotHighlightedUp();
                    } else {
                        this.gui.setInventorySlotHighlightedUp();
                    }
                } else if (this.input.isKeyPressed(SettingsParser.getKeyDown()) || this.input.isKeyPressed(31) || this.input.isControllerDown(6)) {
                    if (this.gui.isUsingContainer()) {
                        this.gui.setContainerSlotHighlightedDown();
                    } else {
                        this.gui.setInventorySlotHighlightedDown();
                    }
                } else if (this.input.isKeyPressed(SettingsParser.getKeyLeft()) || this.input.isKeyPressed(30) || this.input.isControllerLeft(6)) {
                    if (this.gui.isUsingContainer()) {
                        this.gui.setContainerSlotHighlightedLeft();
                    } else {
                        this.gui.setInventorySlotHighlightedLeft();
                    }
                } else if (this.input.isKeyPressed(SettingsParser.getKeyRight()) || this.input.isKeyPressed(32) || this.input.isControllerRight(6)) {
                    if (this.gui.isUsingContainer()) {
                        this.gui.setContainerSlotHighlightedRight();
                    } else {
                        this.gui.setInventorySlotHighlightedRight();
                    }
                } else if (this.input.isKeyPressed(57)) {
                    if (this.gui.isUsingContainer()) {
                        this.gui.selectContainerItem();
                    } else {
                        this.gui.selectInventoryItem();
                    }
                }
            } else if (this.input.isKeyPressed(23)) {
                this.gui.toggleInventory();
            } else if (this.input.isKeyPressed(18)) {
                if (this.attemptHeroPickupAction()) {
                    turnControl.executeTurn();
                }
            } else if (this.input.isKeyDown(SettingsParser.getKeyUp()) || this.input.isKeyDown(17) || this.input.isControllerUp(6)) {
                if (this.attemptHeroMovementAction(MobBase.MobDirection.NORTH) || this.attemptHeroOpenContainerAction(MobBase.MobDirection.NORTH)) {
                    turnControl.executeTurn();
                }
            } else if (this.input.isKeyDown(SettingsParser.getKeyDown()) || this.input.isKeyDown(31) || this.input.isControllerDown(6)) {
                if (this.attemptHeroMovementAction(MobBase.MobDirection.SOUTH) || this.attemptHeroOpenContainerAction(MobBase.MobDirection.SOUTH)) {
                    turnControl.executeTurn();
                }
            } else if (this.input.isKeyDown(SettingsParser.getKeyLeft()) || this.input.isKeyDown(30) || this.input.isControllerLeft(6)) {
                if (this.attemptHeroMovementAction(MobBase.MobDirection.WEST) || this.attemptHeroOpenContainerAction(MobBase.MobDirection.WEST)) {
                    turnControl.executeTurn();
                }
            } else if ((this.input.isKeyDown(SettingsParser.getKeyRight()) || this.input.isKeyDown(32) || this.input.isControllerRight(6)) && (this.attemptHeroMovementAction(MobBase.MobDirection.EAST) || this.attemptHeroOpenContainerAction(MobBase.MobDirection.EAST))) {
                turnControl.executeTurn();
            }
        }
        this.input.clearKeyPressedRecord();
        if (this.input.isKeyPressed(SettingsParser.getKeyDebug())) {
            boolean bl = this.debug = !this.debug;
        }
        if (this.input.isKeyPressed(SettingsParser.getKeyHideGUI())) {
            this.hideGUI = !this.hideGUI;
        }
    }

    private boolean attemptHeroUseAction(ItemBase i) {
        MobBase hero = mob.getHero();
        return hero.commandEat(i);
    }

    private boolean attemptHeroDropAction(ItemBase i) {
        MobBase hero = mob.getHero();
        return hero.commandDrop(i);
    }

    private boolean attemptHeroPickupAction() {
        MobBase hero = mob.getHero();
        return hero.commandPickup(item.getItem(hero.getTileX(), hero.getTileY()));
    }

    private boolean attemptHeroOpenContainerAction(MobBase.MobDirection d) {
        MobBase hero = mob.getHero();
        return hero.commandOpenContainer(d);
    }

    private boolean attemptHeroMovementAction(MobBase.MobDirection d) {
        MobBase hero = mob.getHero();
        return hero.commandOpenDoor(d) || hero.commandAttack(d) || hero.commandMove(d);
    }

    public PlayStateGUI getGUI() {
        return this.gui;
    }
}

