/*
 * Decompiled with CFR 0.152.
 */
package rtr.states;

import org.lwjgl.input.Keyboard;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.StateBasedGame;
import rtr.SettingsParser;
import rtr.console.Console;
import rtr.states.StateBase;
import rtr.system.Game;
import rtr.system.ScaleControl;
import rtr.utilities.Utilities;

public class MainMenuState
extends StateBase {
    private float floatVelX = Utilities.randomFloat() - Utilities.randomFloat();
    private float floatVelY = Utilities.randomFloat() - Utilities.randomFloat();
    private String keyName;
    private boolean keyChange;

    public MainMenuState(int s) {
        super(s);
        this.gameMode = Game.GameMode.MAIN_MENU;
        this.loadFont = true;
        this.loadMap = true;
        this.loadItem = true;
        this.loadTransition = true;
    }

    @Override
    protected void loadState() throws SlickException {
        super.loadState();
        if (this.modulesLoaded) {
            int randomX = Utilities.randomInt(-127, 127);
            int randomY = Utilities.randomInt(-127, 127);
            map.setMapPosition(map.getMapFullWidth() / 2 * -1 + randomX, map.getMapFullHeight() / 2 * -1 + randomY);
            this.debug = false;
            this.loadingRequired = false;
            this.setGUI();
            transition.enter();
            this.endTimeTotal = System.currentTimeMillis();
            Console.out("TOTAL TIME: " + (this.endTimeTotal - this.startTimeTotal), true);
            this.currentLoad = "Starting...";
        }
    }

    @Override
    public void render(GameContainer gc, StateBasedGame sbg, Graphics g) throws SlickException {
        super.render(gc, sbg, g);
        if (this.loadingRequired) {
            this.renderLoadScreen();
            return;
        }
        g.scale(ScaleControl.getScale(), ScaleControl.getScale());
        g.resetTransform();
        g.scale(ScaleControl.getScale(), ScaleControl.getScale());
        this.loadingPillar.draw(-96.0f, 0.0f);
        this.loadingPillar.draw(ScaleControl.getWidth() - this.loadingPillar.getWidth() + 96, 0.0f);
        if (this.debug) {
            this.renderDebug(65.0f, 0.0f);
        }
        this.screenShotListener();
        transition.render(g);
    }

    @Override
    public void update(GameContainer gc, StateBasedGame sbg, int delta) throws SlickException {
        super.update(gc, sbg, delta);
        if (this.loadingRequired) {
            return;
        }
        map.update();
        boolean noX = false;
        boolean noY = false;
        if (map.getMapX() * -1.0f < (float)map.getMapWidth()) {
            this.floatVelX -= 0.01f;
            noX = true;
        } else if (map.getMapX() * -1.0f > (float)(map.getMapFullWidth() - ScaleControl.getHeight() - ScaleControl.getWidth() / 2)) {
            this.floatVelX += 0.01f;
            noX = true;
        } else if (map.getMapY() * -1.0f < (float)map.getMapHeight()) {
            this.floatVelY -= 0.01f;
            noY = true;
        } else if (map.getMapY() * -1.0f > (float)(map.getMapFullHeight() - ScaleControl.getHeight() - ScaleControl.getHeight() / 2)) {
            this.floatVelY += 0.01f;
            noY = true;
        }
        if (!noX) {
            this.floatVelX = this.floatVelX < 0.0f ? (this.floatVelX -= 0.01f) : (this.floatVelX += 0.01f);
        }
        if (!noY) {
            this.floatVelY = this.floatVelY < 0.0f ? (this.floatVelY -= 0.01f) : (this.floatVelY += 0.01f);
        }
        if (this.floatVelX < -3.0f) {
            this.floatVelX = -3.0f;
        }
        if (this.floatVelX > 3.0f) {
            this.floatVelX = 3.0f;
        }
        if (this.floatVelY < -3.0f) {
            this.floatVelY = -3.0f;
        }
        if (this.floatVelY > 3.0f) {
            this.floatVelY = 3.0f;
        }
    }

    @Override
    protected void controlsKeyboard() throws SlickException {
        if (transition.getControlLockout()) {
            return;
        }
        if (this.input.isKeyPressed(SettingsParser.getKeyFullScreen())) {
            this.toggleFullScreen();
            this.setGUI();
            this.input.clearKeyPressedRecord();
            return;
        }
        if (this.input.isKeyPressed(SettingsParser.getKeyScreenShot())) {
            this.takeScreenShot = true;
        }
        if (this.input.isKeyPressed(SettingsParser.getKeyDebug())) {
            boolean bl = this.debug = !this.debug;
        }
        if (this.keyChange) {
            this.input.pause();
            this.input.clearKeyPressedRecord();
            if (Keyboard.getEventKeyState()) {
                this.keyChange = false;
                this.input.resume();
            }
            return;
        }
    }
}

