/*
 * Decompiled with CFR 0.152.
 */
package rtr.particles.projectiles;

import org.newdawn.slick.SlickException;
import rtr.map.CollisionModule;
import rtr.particles.ParticleModule;
import rtr.particles.projectiles.ProjectileBase;
import rtr.utilities.FastMath;
import rtr.utilities.Utilities;

public class ProjectileSmallBlast
extends ProjectileBase {
    float angle;
    boolean stopped;
    ParticleModule.ParticleSet particleSet;

    public ProjectileSmallBlast(int x, int y, ParticleModule.ParticleSet s) {
        super(x, y);
        this.decay = Utilities.randomInt(10) + 5;
        this.velX = Utilities.randomFloat() / 50.0f + 2.0f;
        this.velY = Utilities.randomFloat() / 50.0f + 2.0f;
        this.angle = (float)Math.toRadians((double)Utilities.randomInt(3600) / 10.0);
        this.particleSet = s;
    }

    @Override
    public void update() throws SlickException {
        ++this.decayTick;
        if (this.decayTick > this.decay) {
            this.projectile.remove(this);
        }
        if (!this.stopped) {
            this.projectileX += FastMath.cos(this.angle) * this.velX;
            this.projectileY += FastMath.sin(this.angle) * this.velY;
            if (this.collision.checkParticleCollision((int)this.projectileX, (int)this.projectileY, CollisionModule.CollisionHeight.MEDIUM) != this.collision.getCollisionNone()) {
                this.stopped = true;
            }
        }
        int i = 0;
        while (i < 2) {
            this.particles.newParticle(this.projectileX + (float)Utilities.randomInt(2) - 1.0f, this.projectileY + (float)Utilities.randomInt(2) - 1.0f, ParticleModule.ParticleType.FIRE, this.particleSet);
            ++i;
        }
        if (Utilities.randomInt(8) == 0) {
            this.particles.newParticle(this.projectileX + (float)Utilities.randomInt(2) - 1.0f, this.projectileY + (float)Utilities.randomInt(2) - 1.0f, ParticleModule.ParticleType.DUST, ParticleModule.ParticleSet.BLACK);
            this.particles.newParticle(this.projectileX + (float)Utilities.randomInt(2) - 1.0f, this.projectileY + (float)Utilities.randomInt(2) - 1.0f, ParticleModule.ParticleType.DUST, this.particleSet);
        }
    }
}

