/*
 * Decompiled with CFR 0.152.
 */
package rtr.particles.projectiles;

import org.newdawn.slick.SlickException;
import rtr.map.CollisionModule;
import rtr.particles.ParticleModule;
import rtr.particles.projectiles.ProjectileBase;
import rtr.utilities.FastMath;
import rtr.utilities.Utilities;

public class ProjectileMagicTrail
extends ProjectileBase {
    float angle;
    boolean stopped;
    ParticleModule.ParticleSet particleSet;

    public ProjectileMagicTrail(int x, int y, ParticleModule.ParticleSet s) {
        super(x, y);
        this.decay = Utilities.randomInt(500) + 5;
        this.velX = Utilities.randomFloat() / 50.0f + 0.5f;
        this.velY = Utilities.randomFloat() / 50.0f + 0.5f;
        this.angle = (float)Math.toRadians((double)Utilities.randomInt(3600) / 10.0);
        this.particleSet = s;
    }

    @Override
    public void update() throws SlickException {
        ++this.decayTick;
        if (this.decayTick > this.decay) {
            this.projectile.remove(this);
        }
        if (!this.stopped) {
            this.projectileX += FastMath.cos(this.angle) * this.velX;
            this.projectileY += FastMath.sin(this.angle) * this.velY;
            if (this.collision.checkParticleCollision((int)this.projectileX, (int)this.projectileY, CollisionModule.CollisionHeight.MEDIUM) != this.collision.getCollisionNone()) {
                this.stopped = true;
            }
        }
        this.particles.newParticle(this.projectileX + (float)Utilities.randomInt(2) - 1.0f, this.projectileY + (float)Utilities.randomInt(2) - 1.0f, ParticleModule.ParticleType.FIRE, this.particleSet);
        if (Utilities.randomInt(10) == 0) {
            this.particles.newParticle(this.projectileX + (float)Utilities.randomInt(2) - 1.0f, this.projectileY + (float)Utilities.randomInt(2) - 1.0f, ParticleModule.ParticleType.SMOKE, this.particleSet);
            this.particles.newParticle(this.projectileX + (float)Utilities.randomInt(2) - 1.0f, this.projectileY + (float)Utilities.randomInt(2) - 1.0f, ParticleModule.ParticleType.SPARKLE, this.particleSet);
        }
    }
}

