/*
 * Decompiled with CFR 0.152.
 */
package rtr.particles.projectiles;

import org.newdawn.slick.SlickException;
import rtr.map.CollisionModule;
import rtr.particles.ParticleModule;
import rtr.particles.projectiles.ProjectileBase;
import rtr.utilities.Utilities;

public class ProjectileExpandingRing
extends ProjectileBase {
    float angle;
    int startX;
    int startY;
    int radius;
    int currentRadius;
    int speed;
    ParticleModule.ParticleSet particleSet;

    public ProjectileExpandingRing(int x, int y, int r, int s, ParticleModule.ParticleSet pS) {
        super(x, y);
        this.startX = x;
        this.startY = y;
        this.angle = (float)Math.toRadians((double)Utilities.randomInt(3600) / 10.0);
        this.particleSet = pS;
        this.radius = r;
        this.speed = s;
    }

    @Override
    public void update() throws SlickException {
        int particleAmount = 360;
        particleAmount = this.currentRadius < 360 ? this.currentRadius : (particleAmount += this.currentRadius);
        particleAmount /= 2;
        int x = 0;
        while (x < particleAmount) {
            this.angle += (float)x;
            this.projectileX = (float)(Math.cos(this.angle) * (double)this.currentRadius + (double)this.startX);
            this.projectileY = (float)(Math.sin(this.angle) * (double)this.currentRadius + (double)this.startY);
            if (this.collision.checkParticleCollision((int)this.projectileX, (int)this.projectileY, CollisionModule.CollisionHeight.MEDIUM) == this.collision.getCollisionNone()) {
                this.particles.newParticle(this.projectileX + (float)Utilities.randomInt(-1, 1), this.projectileY + (float)Utilities.randomInt(-1, 1), ParticleModule.ParticleType.FIRE, this.particleSet);
                if (Utilities.randomInt(25) == 0) {
                    this.particles.newParticle(this.projectileX + (float)Utilities.randomInt(-1, 1), this.projectileY + (float)Utilities.randomInt(-1, 1), ParticleModule.ParticleType.SMOKE, this.particleSet);
                }
            }
            ++x;
        }
        this.currentRadius += this.speed;
        if (this.currentRadius >= this.radius) {
            this.projectile.remove(this);
        }
    }
}

