/*
 * Decompiled with CFR 0.152.
 */
package rtr.particles.projectiles;

import org.newdawn.slick.SlickException;
import rtr.particles.ParticleModule;
import rtr.particles.projectiles.ProjectileBase;
import rtr.utilities.FastMath;
import rtr.utilities.Utilities;

public class ProjectileExpandingEnergyRing
extends ProjectileBase {
    float angle;
    int startX;
    int startY;
    float radius;
    ParticleModule.ParticleSet particleSet;

    public ProjectileExpandingEnergyRing(int x, int y, ParticleModule.ParticleSet s) {
        super(x, y);
        this.startX = x;
        this.startY = y;
        this.decay = Utilities.randomInt(200) + 50;
        this.angle = (float)Math.toRadians((double)Utilities.randomInt(3600) / 10.0);
        this.particleSet = s;
        this.radius = 0.1f;
    }

    @Override
    public void update() throws SlickException {
        ++this.decayTick;
        if (this.decayTick > this.decay) {
            this.projectile.remove(this);
        }
        this.angle = (float)((double)this.angle + 0.02);
        this.radius += 0.2f;
        this.projectileX = FastMath.cos(this.angle) * this.radius + (float)this.startX;
        this.projectileY = FastMath.sin(this.angle) * this.radius + (float)this.startY;
        this.particles.newParticle(this.projectileX + (float)Utilities.randomInt(2) - 1.0f, this.projectileY + (float)Utilities.randomInt(2) - 1.0f, ParticleModule.ParticleType.FIRE, this.particleSet);
        if (Utilities.randomInt(10) == 0) {
            this.particles.newParticle(this.projectileX + (float)Utilities.randomInt(2) - 1.0f, this.projectileY + (float)Utilities.randomInt(2) - 1.0f, ParticleModule.ParticleType.SPARKLE, this.particleSet);
        }
    }
}

