/*
 * Decompiled with CFR 0.152.
 */
package rtr.particles.projectiles;

import org.newdawn.slick.SlickException;
import rtr.particles.ParticleModule;
import rtr.particles.projectiles.ProjectileBase;
import rtr.utilities.FastMath;
import rtr.utilities.Utilities;

public class ProjectileEnergyNova
extends ProjectileBase {
    float angle;
    ParticleModule.ParticleSet particleSet;

    public ProjectileEnergyNova(int x, int y, ParticleModule.ParticleSet s) {
        super(x, y);
        this.decay = Utilities.randomInt(200) + 200;
        this.velX = Utilities.randomFloat() / 5.0f + 0.4f;
        this.velY = Utilities.randomFloat() / 5.0f + 0.4f;
        this.angle = (float)Math.toRadians((double)Utilities.randomInt(3600) / 10.0);
        this.particleSet = s;
    }

    @Override
    public void update() throws SlickException {
        ++this.decayTick;
        if (this.decayTick > this.decay) {
            this.projectile.remove(this);
        }
        this.angle = (float)((double)this.angle + 0.01);
        this.projectileX += FastMath.cos(this.angle) * this.velX;
        this.projectileY += FastMath.sin(this.angle) * this.velY;
        this.particles.newParticle(this.projectileX, this.projectileY, ParticleModule.ParticleType.FIRE, ParticleModule.ParticleSet.FIRE_BLUE);
        this.particles.newParticle(this.projectileX + (float)Utilities.randomInt(-1, 1), this.projectileY + (float)Utilities.randomInt(-1, 1), ParticleModule.ParticleType.FIRE, this.particleSet);
        if (Utilities.randomInt(40) == 0) {
            this.particles.newParticle(this.projectileX + (float)Utilities.randomInt(-1, 1), this.projectileY + (float)Utilities.randomInt(-1, 1), ParticleModule.ParticleType.SPARKLE, this.particleSet);
        }
    }
}

