/*
 * Decompiled with CFR 0.152.
 */
package rtr.particles.projectiles;

import org.newdawn.slick.SlickException;
import rtr.particles.ParticleModule;
import rtr.particles.projectiles.ProjectileBase;
import rtr.utilities.Utilities;

public class ProjectileEnergyBeam
extends ProjectileBase {
    protected float targetX;
    protected float targetY;
    protected float angle;

    public ProjectileEnergyBeam(int x, int y, int x2, int y2) {
        super(x, y);
        this.decay = 2000;
        this.targetX = x2;
        this.targetY = y2;
        this.velX = 1.0f;
        this.velY = 1.0f;
        this.angle = Utilities.calculateAngle(x, y, this.targetX, this.targetY);
    }

    @Override
    public void update() throws SlickException {
        ++this.decayTick;
        if (this.decayTick > this.decay) {
            this.projectile.remove(this);
        }
        boolean arrived = false;
        while (!arrived) {
            this.projectileX = (float)((double)this.projectileX + Math.cos(this.angle) * (double)this.velX);
            this.projectileY = (float)((double)this.projectileY + Math.sin(this.angle) * (double)this.velY);
            this.particles.newParticle(this.projectileX + (float)Utilities.randomInt(2) - 1.0f, this.projectileY + (float)Utilities.randomInt(2) - 1.0f, ParticleModule.ParticleType.FIRE, ParticleModule.ParticleSet.FIRE_BLUE);
            this.particles.newParticle(this.projectileX + (float)Utilities.randomInt(2) - 1.0f, this.projectileY + (float)Utilities.randomInt(2) - 1.0f, ParticleModule.ParticleType.SPARKLE, ParticleModule.ParticleSet.MAGIC_BLUE);
            if (Utilities.randomInt(10) == 0) {
                this.particles.newParticle(this.projectileX + (float)Utilities.randomInt(2) - 1.0f, this.projectileY + (float)Utilities.randomInt(2) - 1.0f, ParticleModule.ParticleType.SMOKE, ParticleModule.ParticleSet.MAGIC_BLUE);
            }
            if (!((float)((int)this.projectileX) >= this.targetX - 1.0f) || !((float)((int)this.projectileX) <= this.targetX + 1.0f) || !((float)((int)this.projectileY) >= this.targetY - 1.0f) || !((float)((int)this.projectileY) <= this.targetY + 1.0f)) continue;
            arrived = true;
        }
        this.projectile.remove(this);
    }
}

