/*
 * Decompiled with CFR 0.152.
 */
package rtr.particles.projectiles;

import org.newdawn.slick.SlickException;
import rtr.map.CollisionModule;
import rtr.particles.ParticleModule;
import rtr.particles.projectiles.ProjectileBase;
import rtr.utilities.FastMath;
import rtr.utilities.Utilities;

public class ProjectileDestruction
extends ProjectileBase {
    float angle;
    boolean direction;
    boolean onFire;

    public ProjectileDestruction(int x, int y) {
        super(x, y);
        this.decay = Utilities.randomInt(500) + 500;
        this.velY = this.velX = Utilities.randomFloat() * 6.0f;
        this.angle = (float)Math.toRadians((double)Utilities.randomInt(3600) / 10.0);
        if (Utilities.randomInt(2) == 0) {
            this.direction = true;
        }
        if (Utilities.randomInt(3) == 0) {
            this.onFire = true;
        }
    }

    @Override
    public void update() throws SlickException {
        ++this.decayTick;
        if (this.decayTick > this.decay) {
            this.projectile.remove(this);
        }
        if (this.velX > 0.0f) {
            this.angle = this.direction ? (this.angle += Utilities.randomFloat() / 50.0f) : (this.angle -= Utilities.randomFloat() / 50.0f);
            this.projectileX += FastMath.cos(this.angle) * this.velX;
            this.projectileY += FastMath.sin(this.angle) * this.velY;
            if (this.collision.checkParticleCollision((int)this.projectileX, (int)this.projectileY, CollisionModule.CollisionHeight.MEDIUM) != this.collision.getCollisionNone()) {
                this.velX -= 2.0f;
                this.velY -= 2.0f;
            } else {
                this.velX -= 0.2f;
                this.velY -= 0.2f;
            }
            int i = 0;
            while (i < 2) {
                this.particles.newParticle(this.projectileX + (float)Utilities.randomInt(-2, 2), this.projectileY + (float)Utilities.randomInt(-2, 2), ParticleModule.ParticleType.SMOKE, ParticleModule.ParticleSet.GRAY);
                this.particles.newParticle(this.projectileX + (float)Utilities.randomInt(-2, 2), this.projectileY + (float)Utilities.randomInt(-2, 2), Utilities.randomInt(360), ParticleModule.ParticleType.DUST, ParticleModule.ParticleSet.BLACK);
                ++i;
            }
        }
        if (this.velX <= 0.0f) {
            this.velX = 0.0f;
        }
        if (this.onFire) {
            this.particles.newParticle(this.projectileX, this.projectileY, ParticleModule.ParticleType.FIRE, ParticleModule.ParticleSet.FIRE_RED);
            if (Utilities.randomInt(2) == 0) {
                this.particles.newParticle(this.projectileX + (float)Utilities.randomInt(-2, 2), this.projectileY + (float)Utilities.randomInt(-2, 2), ParticleModule.ParticleType.FIRE, ParticleModule.ParticleSet.FIRE_RED);
            }
        }
    }
}

