/*
 * Decompiled with CFR 0.152.
 */
package rtr.particles;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ForkJoinPool;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;
import rtr.ModuleBase;
import rtr.SettingsParser;
import rtr.particles.Particle;
import rtr.particles.ParticleEmitter;
import rtr.particles.templates.ParticleTemplateBase;
import rtr.particles.templates.ParticleTemplateBlood;
import rtr.particles.templates.ParticleTemplateBloodPool;
import rtr.particles.templates.ParticleTemplateCrumb;
import rtr.particles.templates.ParticleTemplateDust;
import rtr.particles.templates.ParticleTemplateFall;
import rtr.particles.templates.ParticleTemplateFallFast;
import rtr.particles.templates.ParticleTemplateFire;
import rtr.particles.templates.ParticleTemplateFlash;
import rtr.particles.templates.ParticleTemplateFlashFast;
import rtr.particles.templates.ParticleTemplateMagicFloat;
import rtr.particles.templates.ParticleTemplateMagicFloatSlow;
import rtr.particles.templates.ParticleTemplateRain;
import rtr.particles.templates.ParticleTemplateSmoke;
import rtr.particles.templates.ParticleTemplateSnow;
import rtr.particles.templates.ParticleTemplateSparkle;
import rtr.particles.templates.ParticleTemplateSpeck;
import rtr.particles.templates.ParticleTemplateWater;
import rtr.particles.templates.ParticleTemplateWaterPool;
import rtr.particles.templates.ParticleTemplateWaterPoolFast;
import rtr.particles.templates.ParticleTemplateWindDust;
import rtr.states.StateBase;
import rtr.system.Game;
import rtr.system.RTRThreadPool;
import rtr.utilities.Utilities;

public class ParticleModule
extends ModuleBase {
    private ArrayList<ParticleEmitter>[][] particleEmittersMap;
    private HashMap<Integer, byte[][]> emitterMasks;
    private int tileGlobalX;
    private int tileGlobalY;
    private Deque<Particle> particleStorage = new ArrayDeque<Particle>(70000);
    private HashSet<Particle> particleArrayTop = new HashSet();
    private HashSet<Particle> particleArrayBottom = new HashSet();
    private HashSet<Particle> particleArrayGUI = new HashSet();
    private List<Particle> particleArrayOut = Collections.synchronizedList(new ArrayList());
    private HashSet<Particle> particleArrayTopAdd = new HashSet();
    private HashSet<Particle> particleArrayBottomAdd = new HashSet();
    private HashSet<Particle> particleArrayGUIAdd = new HashSet();
    private HashSet<Particle> particleArrayTopRemove = new HashSet();
    private HashSet<Particle> particleArrayBottomRemove = new HashSet();
    private HashSet<Particle> particleArrayGUIRemove = new HashSet();
    private BitSet particleLiquidMap;
    private BitSet particleFootPrintMap;
    private Color[][] particleColors;

    @Override
    public void initModule(StateBase cS) throws SlickException {
        super.initModule(cS);
        if (this.particleColors == null) {
            SpriteSheet particleSheet = new SpriteSheet("res/particles.png", 1, 1);
            particleSheet.setFilter(9728);
            this.particleColors = new Color[particleSheet.getHorizontalCount()][particleSheet.getVerticalCount()];
            int x = 0;
            while (x < particleSheet.getHorizontalCount()) {
                int y = 0;
                while (y < particleSheet.getVerticalCount()) {
                    this.particleColors[x][y] = particleSheet.getSprite(x, y).getColor(0, 0);
                    ++y;
                }
                ++x;
            }
            particleSheet.flushPixelData();
        }
        this.particleEmittersMap = new ArrayList[this.map.getMapWidth()][this.map.getMapHeight()];
        this.particleLiquidMap = new BitSet(this.map.getMapFullWidth() * this.map.getMapFullHeight());
        this.particleFootPrintMap = new BitSet(this.map.getMapFullWidth() * this.map.getMapFullHeight());
        this.particleLiquidMap = new BitSet(this.map.getMapFullWidth() * this.map.getMapFullHeight());
        this.particleFootPrintMap = new BitSet(this.map.getMapFullWidth() * this.map.getMapFullHeight());
        if (this.emitterMasks == null) {
            this.emitterMasks = this.map.getMapTileLoader().getParticleTiles();
        }
        this.initLoad();
    }

    @Override
    public void resetModule() throws SlickException {
        super.resetModule();
        this.tileGlobalX = 0;
        this.tileGlobalY = 0;
        this.particleArrayTop.clear();
        this.particleArrayBottom.clear();
        this.particleArrayTopAdd.clear();
        this.particleArrayBottomAdd.clear();
        this.particleArrayGUI.clear();
        this.particleArrayGUIAdd.clear();
    }

    @Override
    protected void loadPlay() throws SlickException {
        this.buildFullEmitterMap();
        this.newPlay();
    }

    @Override
    protected void newPlay() throws SlickException {
        this.buildFullEmitterMap();
    }

    public Properties getPlayProperties() {
        Properties properties = new Properties();
        properties.setProperty("version", Game.getVersion());
        int particleID = 0;
        for (Particle p : this.particleArrayTop) {
            if (!p.canSave()) continue;
            properties.putAll((Map<?, ?>)p.getPlayProperties(particleID));
            ++particleID;
        }
        for (Particle p : this.particleArrayBottom) {
            if (!p.canSave()) continue;
            properties.putAll((Map<?, ?>)p.getPlayProperties(particleID));
            ++particleID;
        }
        properties.setProperty("particleCount", Integer.toString(particleID));
        return properties;
    }

    public void renderBottom() {
        this.particleArrayOut.clear();
        ForkJoinPool activePool = null;
        activePool = RTRThreadPool.getThreadPool(1);
        activePool.submit(() -> this.particleArrayBottom.parallelStream().forEach(p -> {
            if (p.canRender()) {
                this.particleArrayOut.add((Particle)p);
            }
        }));
        while (activePool != null && !activePool.isQuiescent()) {
        }
        Graphics g = new Graphics();
        g.glBeginQuads();
        for (Particle p : this.particleArrayOut) {
            p.render(g);
        }
        g.glEnd();
    }

    public void renderTop() {
        this.particleArrayOut.clear();
        ForkJoinPool activePool = null;
        activePool = this.particleArrayTop.size() > 20000 ? RTRThreadPool.getThreadPool(8) : RTRThreadPool.getThreadPool(4);
        activePool.submit(() -> this.particleArrayTop.parallelStream().forEach(p -> {
            if (p.canRender()) {
                this.particleArrayOut.add((Particle)p);
            }
        }));
        while (activePool != null && !activePool.isQuiescent()) {
        }
        Graphics g = new Graphics();
        g.glBeginQuads();
        for (Particle p : this.particleArrayOut) {
            p.render(g);
        }
        g.glEnd();
    }

    public void renderGUI() throws SlickException {
        Graphics g = new Graphics();
        g.glBeginQuads();
        Object[] ArrayGUILoop = this.particleArrayGUI.toArray();
        int i = 0;
        while (i < ArrayGUILoop.length) {
            Particle p = (Particle)ArrayGUILoop[i];
            p.renderGUI(g);
            ++i;
        }
        g.glEnd();
    }

    public void renderWorldMap(float mapX, float mapY) throws SlickException {
        Graphics g = new Graphics();
        g.glBeginQuads();
        Object[] ArrayBottomLoop = this.particleArrayBottom.toArray();
        int i = 0;
        while (i < ArrayBottomLoop.length) {
            Particle p = (Particle)ArrayBottomLoop[i];
            p.renderWorldMap(g, mapX, mapY);
            ++i;
        }
        Object[] ArrayTopLoop = this.particleArrayTop.toArray();
        int i2 = 0;
        while (i2 < ArrayTopLoop.length) {
            Particle p = (Particle)ArrayTopLoop[i2];
            p.renderWorldMap(g, mapX, mapY);
            ++i2;
        }
        g.glEnd();
    }

    public void renderSplash() throws SlickException {
        Graphics g = new Graphics();
        g.glBeginQuads();
        Object[] ArrayGUILoop = this.particleArrayGUI.toArray();
        int i = 0;
        while (i < ArrayGUILoop.length) {
            Particle p = (Particle)ArrayGUILoop[i];
            p.renderGUI(g);
            ++i;
        }
        g.glEnd();
    }

    public void update() throws SlickException {
        if (SettingsParser.getDebug()) {
            ParticleType[] particleTypeArray = ParticleType.values();
            int n = particleTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ParticleType r = particleTypeArray[n2];
                r.getTemplate().load();
                ++n2;
            }
        }
        this.particleArrayTop.removeAll(this.particleArrayBottomAdd);
        this.particleArrayTop.addAll(this.particleArrayTopAdd);
        this.particleArrayBottom.removeAll(this.particleArrayTopAdd);
        this.particleArrayBottom.addAll(this.particleArrayBottomAdd);
        this.particleArrayGUI.addAll(this.particleArrayGUIAdd);
        this.particleArrayTopAdd.clear();
        this.particleArrayBottomAdd.clear();
        this.particleArrayGUIAdd.clear();
        ForkJoinPool activePoolTop = null;
        ForkJoinPool activePoolBot = null;
        ForkJoinPool activePoolGUI = null;
        activePoolTop = this.particleArrayTop.size() > 20000 ? RTRThreadPool.getThreadPool(8) : RTRThreadPool.getThreadPool(4);
        activePoolTop.submit(() -> this.particleArrayTop.parallelStream().forEach(p -> {
            p.update();
            if (p.getDuration() <= 0) {
                this.particleArrayTopRemove.add((Particle)p);
            } else if (!p.isTop()) {
                this.particleArrayBottomAdd.add((Particle)p);
            }
        }));
        activePoolBot = this.particleArrayBottom.size() > 20000 ? RTRThreadPool.getThreadPool(8) : RTRThreadPool.getThreadPool(4);
        activePoolBot.submit(() -> this.particleArrayBottom.parallelStream().forEach(p -> {
            p.update();
            if (p.getDuration() <= 0) {
                this.particleArrayBottomRemove.add((Particle)p);
            } else if (p.isTop()) {
                this.particleArrayTopAdd.add((Particle)p);
            }
        }));
        activePoolGUI = this.particleArrayGUI.size() > 20000 ? RTRThreadPool.getThreadPool(8) : RTRThreadPool.getThreadPool(4);
        activePoolGUI.submit(() -> this.particleArrayGUI.parallelStream().forEach(p -> {
            p.update();
            if (p.getDuration() <= 0) {
                this.particleArrayGUIRemove.add((Particle)p);
            }
        }));
        while (activePoolTop != null && !activePoolTop.isQuiescent() || activePoolBot != null && !activePoolBot.isQuiescent() || activePoolGUI != null && !activePoolGUI.isQuiescent()) {
        }
        int startX = this.map.getMapRenderTileTopLeftX() - 2;
        int startY = this.map.getMapRenderTileTopLeftY() - 2;
        int endX = this.map.getMapRenderTileBottomRightX() + 2;
        int endY = this.map.getMapRenderTileBottomRightY() + 2;
        int x = startX;
        while (x < endX) {
            int y = startY;
            while (y < endY) {
                ArrayList<ParticleEmitter> emitOut;
                if (x >= 0 && x <= this.map.getMapWidth() - 1 && y >= 0 && y <= this.map.getMapHeight() - 1 && (emitOut = this.particleEmittersMap[x][y]) != null) {
                    for (ParticleEmitter e : emitOut) {
                        e.emit();
                    }
                }
                ++y;
            }
            ++x;
        }
        this.particleArrayTop.removeAll(this.particleArrayTopRemove);
        this.particleStorage.addAll(this.particleArrayTopRemove);
        this.particleArrayTopRemove.clear();
        this.particleArrayBottom.removeAll(this.particleArrayBottomRemove);
        this.particleStorage.addAll(this.particleArrayBottomRemove);
        this.particleArrayBottomRemove.clear();
        this.particleArrayGUI.removeAll(this.particleArrayGUIRemove);
        this.particleStorage.addAll(this.particleArrayGUIRemove);
        this.particleArrayGUIRemove.clear();
    }

    private void buildFullEmitterMap() throws SlickException {
        int[] tileID = new int[this.map.getMapLayers()];
        int x = 0;
        while (x < this.map.getMapWidth()) {
            int y = 0;
            while (y < this.map.getMapHeight()) {
                int l = 0;
                while (l < tileID.length) {
                    tileID[l] = this.map.getTileId(x, y, l);
                    if (tileID[l] != 0) {
                        this.builder(x, y, l, tileID[l]);
                    }
                    ++l;
                }
                ++y;
            }
            ++x;
        }
    }

    private void builder(int tX, int tY, int tL, int tileID) throws SlickException {
        int y;
        if (!this.map.getMapTileLoader().isTileParticles(tileID)) {
            return;
        }
        this.tileGlobalX = tX * this.map.getTileWidth();
        this.tileGlobalY = tY * this.map.getTileHeight();
        byte[][] emitterTile = this.emitterMasks.get(tileID);
        boolean isFull = true;
        byte start = emitterTile[0][0];
        int x = 0;
        while (x < emitterTile.length) {
            y = 0;
            while (y < emitterTile[x].length) {
                if (emitterTile[x][y] != start) {
                    isFull = false;
                }
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < this.map.getTileWidth()) {
            y = 0;
            while (y < this.map.getTileHeight()) {
                int pixelX = this.tileGlobalX + x;
                int pixelY = this.tileGlobalY + y;
                if (emitterTile[x][y] != 0) {
                    if (this.particleEmittersMap[tX][tY] == null) {
                        this.particleEmittersMap[tX][tY] = new ArrayList();
                    }
                    ParticleEmitter emitter = this.createNewEmitter(emitterTile[x][y], pixelX, pixelY, isFull);
                    this.particleEmittersMap[tX][tY].add(emitter);
                    if (isFull) {
                        return;
                    }
                }
                ++y;
            }
            ++x;
        }
    }

    private ParticleEmitter createNewEmitter(byte emitterNumber, int pixelX, int pixelY, boolean isFull) {
        switch (emitterNumber) {
            case 1: {
                return new ParticleEmitter(pixelX, pixelY, 400, ParticleType.FIRE, ParticleSet.FIRE_RED, isFull);
            }
            case 2: {
                return new ParticleEmitter(pixelX, pixelY, 200, ParticleType.FIRE, ParticleSet.FIRE_RED, isFull);
            }
            case 3: {
                return new ParticleEmitter(pixelX, pixelY, 60, ParticleType.FIRE, ParticleSet.FIRE_RED, isFull);
            }
            case 4: {
                return new ParticleEmitter(pixelX, pixelY, 20, ParticleType.FIRE, ParticleSet.FIRE_RED, isFull);
            }
            case 5: {
                return new ParticleEmitter(pixelX, pixelY, 400, ParticleType.FIRE, ParticleSet.FIRE_YELLOW, isFull);
            }
            case 6: {
                return new ParticleEmitter(pixelX, pixelY, 200, ParticleType.FIRE, ParticleSet.FIRE_YELLOW, isFull);
            }
            case 7: {
                return new ParticleEmitter(pixelX, pixelY, 60, ParticleType.FIRE, ParticleSet.FIRE_YELLOW, isFull);
            }
            case 8: {
                return new ParticleEmitter(pixelX, pixelY, 20, ParticleType.FIRE, ParticleSet.FIRE_YELLOW, isFull);
            }
            case 9: {
                return new ParticleEmitter(pixelX, pixelY, 400, ParticleType.FIRE, ParticleSet.FIRE_GREEN, isFull);
            }
            case 10: {
                return new ParticleEmitter(pixelX, pixelY, 200, ParticleType.FIRE, ParticleSet.FIRE_GREEN, isFull);
            }
            case 11: {
                return new ParticleEmitter(pixelX, pixelY, 60, ParticleType.FIRE, ParticleSet.FIRE_GREEN, isFull);
            }
            case 12: {
                return new ParticleEmitter(pixelX, pixelY, 20, ParticleType.FIRE, ParticleSet.FIRE_GREEN, isFull);
            }
            case 13: {
                return new ParticleEmitter(pixelX, pixelY, 400, ParticleType.FIRE, ParticleSet.FIRE_BLUE, isFull);
            }
            case 14: {
                return new ParticleEmitter(pixelX, pixelY, 200, ParticleType.FIRE, ParticleSet.FIRE_BLUE, isFull);
            }
            case 15: {
                return new ParticleEmitter(pixelX, pixelY, 60, ParticleType.FIRE, ParticleSet.FIRE_BLUE, isFull);
            }
            case 16: {
                return new ParticleEmitter(pixelX, pixelY, 20, ParticleType.FIRE, ParticleSet.FIRE_BLUE, isFull);
            }
            case 17: {
                return new ParticleEmitter(pixelX, pixelY, 350, ParticleType.SMOKE, ParticleSet.GRAY, isFull);
            }
            case 18: {
                return new ParticleEmitter(pixelX, pixelY, 110, ParticleType.SMOKE, ParticleSet.GRAY, isFull);
            }
            case 19: {
                return new ParticleEmitter(pixelX, pixelY, 40, ParticleType.SMOKE, ParticleSet.GRAY, isFull);
            }
            case 20: {
                return new ParticleEmitter(pixelX, pixelY, 12000, ParticleType.SPARKLE, ParticleSet.MAGIC_RED, isFull);
            }
            case 21: {
                return new ParticleEmitter(pixelX, pixelY, 6000, ParticleType.SPARKLE, ParticleSet.MAGIC_RED, isFull);
            }
            case 22: {
                return new ParticleEmitter(pixelX, pixelY, 3000, ParticleType.SPARKLE, ParticleSet.MAGIC_RED, isFull);
            }
            case 23: {
                return new ParticleEmitter(pixelX, pixelY, 1500, ParticleType.SPARKLE, ParticleSet.MAGIC_RED, isFull);
            }
            case 24: {
                return new ParticleEmitter(pixelX, pixelY, 12000, ParticleType.SPARKLE, ParticleSet.MAGIC_GREEN, isFull);
            }
            case 25: {
                return new ParticleEmitter(pixelX, pixelY, 6000, ParticleType.SPARKLE, ParticleSet.MAGIC_GREEN, isFull);
            }
            case 26: {
                return new ParticleEmitter(pixelX, pixelY, 3000, ParticleType.SPARKLE, ParticleSet.MAGIC_GREEN, isFull);
            }
            case 27: {
                return new ParticleEmitter(pixelX, pixelY, 1500, ParticleType.SPARKLE, ParticleSet.MAGIC_GREEN, isFull);
            }
            case 28: {
                return new ParticleEmitter(pixelX, pixelY, 12000, ParticleType.SPARKLE, ParticleSet.MAGIC_BLUE, isFull);
            }
            case 29: {
                return new ParticleEmitter(pixelX, pixelY, 6000, ParticleType.SPARKLE, ParticleSet.MAGIC_BLUE, isFull);
            }
            case 30: {
                return new ParticleEmitter(pixelX, pixelY, 3000, ParticleType.SPARKLE, ParticleSet.MAGIC_BLUE, isFull);
            }
            case 31: {
                return new ParticleEmitter(pixelX, pixelY, 1500, ParticleType.SPARKLE, ParticleSet.MAGIC_BLUE, isFull);
            }
            case 32: {
                return new ParticleEmitter(pixelX, pixelY, 1000, ParticleType.MAGIC_FLOAT, ParticleSet.MAGIC_RED, isFull);
            }
            case 33: {
                return new ParticleEmitter(pixelX, pixelY, 500, ParticleType.MAGIC_FLOAT, ParticleSet.MAGIC_RED, isFull);
            }
            case 34: {
                return new ParticleEmitter(pixelX, pixelY, 100, ParticleType.MAGIC_FLOAT, ParticleSet.MAGIC_RED, isFull);
            }
            case 35: {
                return new ParticleEmitter(pixelX, pixelY, 1000, ParticleType.MAGIC_FLOAT, ParticleSet.MAGIC_YELLOW, isFull);
            }
            case 36: {
                return new ParticleEmitter(pixelX, pixelY, 500, ParticleType.MAGIC_FLOAT, ParticleSet.MAGIC_YELLOW, isFull);
            }
            case 37: {
                return new ParticleEmitter(pixelX, pixelY, 100, ParticleType.MAGIC_FLOAT, ParticleSet.MAGIC_YELLOW, isFull);
            }
            case 38: {
                return new ParticleEmitter(pixelX, pixelY, 1000, ParticleType.MAGIC_FLOAT, ParticleSet.MAGIC_GREEN, isFull);
            }
            case 39: {
                return new ParticleEmitter(pixelX, pixelY, 500, ParticleType.MAGIC_FLOAT, ParticleSet.MAGIC_GREEN, isFull);
            }
            case 40: {
                return new ParticleEmitter(pixelX, pixelY, 100, ParticleType.MAGIC_FLOAT, ParticleSet.MAGIC_GREEN, isFull);
            }
            case 41: {
                return new ParticleEmitter(pixelX, pixelY, 1000, ParticleType.MAGIC_FLOAT, ParticleSet.MAGIC_BLUE, isFull);
            }
            case 42: {
                return new ParticleEmitter(pixelX, pixelY, 500, ParticleType.MAGIC_FLOAT, ParticleSet.MAGIC_BLUE, isFull);
            }
            case 43: {
                return new ParticleEmitter(pixelX, pixelY, 100, ParticleType.MAGIC_FLOAT, ParticleSet.MAGIC_BLUE, isFull);
            }
            case 44: {
                return new ParticleEmitter(pixelX, pixelY, 12000, ParticleType.SPARKLE, ParticleSet.MAGIC_PURPLE, isFull);
            }
            case 45: {
                return new ParticleEmitter(pixelX, pixelY, 6000, ParticleType.SPARKLE, ParticleSet.MAGIC_PURPLE, isFull);
            }
            case 46: {
                return new ParticleEmitter(pixelX, pixelY, 3000, ParticleType.SPARKLE, ParticleSet.MAGIC_PURPLE, isFull);
            }
            case 47: {
                return new ParticleEmitter(pixelX, pixelY, 1500, ParticleType.SPARKLE, ParticleSet.MAGIC_PURPLE, isFull);
            }
            case 48: {
                return new ParticleEmitter(pixelX, pixelY, 400, ParticleType.FIRE, ParticleSet.FIRE_PURPLE, isFull);
            }
            case 49: {
                return new ParticleEmitter(pixelX, pixelY, 200, ParticleType.FIRE, ParticleSet.FIRE_PURPLE, isFull);
            }
            case 50: {
                return new ParticleEmitter(pixelX, pixelY, 60, ParticleType.FIRE, ParticleSet.FIRE_PURPLE, isFull);
            }
            case 51: {
                return new ParticleEmitter(pixelX, pixelY, 20, ParticleType.FIRE, ParticleSet.FIRE_PURPLE, isFull);
            }
            case 52: {
                return new ParticleEmitter(pixelX, pixelY, 1000, ParticleType.MAGIC_FLOAT, ParticleSet.MAGIC_PURPLE, isFull);
            }
            case 53: {
                return new ParticleEmitter(pixelX, pixelY, 500, ParticleType.MAGIC_FLOAT, ParticleSet.MAGIC_PURPLE, isFull);
            }
            case 54: {
                return new ParticleEmitter(pixelX, pixelY, 100, ParticleType.MAGIC_FLOAT, ParticleSet.MAGIC_PURPLE, isFull);
            }
        }
        return null;
    }

    public void updateParticleMap(int x, int y) throws SlickException {
        if (this.particleEmittersMap[x][y] != null) {
            this.particleEmittersMap[x][y].clear();
        }
        int[] tileID = new int[this.map.getMapLayers()];
        int l = 0;
        while (l < tileID.length) {
            tileID[l] = this.map.getTileId(x, y, l);
            if (tileID[l] != 0) {
                this.builder(x, y, l, tileID[l]);
            }
            ++l;
        }
    }

    public void newParticle(String[] propertiesString) {
        Particle p = new Particle(propertiesString);
        if (p.isTop()) {
            this.particleArrayTop.add(p);
        } else {
            this.particleArrayBottom.add(p);
        }
    }

    public void newParticle(float x, float y, ParticleType t, ParticleSet s) {
        this.newParticle(x, y, -1.0f, t, s, false);
    }

    public void newParticle(float x, float y, float a, ParticleType t, ParticleSet s) {
        this.newParticle(x, y, a, t, s, false);
    }

    public void newParticle(float x, float y, ParticleType t, ParticleSet s, boolean guiParticle) {
        this.newParticle(x, y, -1.0f, t, s, guiParticle);
    }

    public void newParticle(float x, float y, float a, ParticleType t, ParticleSet s, boolean guiParticle) {
        if (SettingsParser.getParticleAmount() == SettingsParser.ParticleAmount.REDUCED && Utilities.randomInt(2) == 0) {
            return;
        }
        if (SettingsParser.getParticleAmount() == SettingsParser.ParticleAmount.MINIMAL && Utilities.randomInt(3) == 0) {
            return;
        }
        if (SettingsParser.getParticleAmount() == SettingsParser.ParticleAmount.MINIMAL && (t == ParticleType.BLOOD || t == ParticleType.BLOOD_POOL || t == ParticleType.CRUMB || t == ParticleType.DUST || t == ParticleType.SPARKLE || t == ParticleType.SPECK || t == ParticleType.WATER || t == ParticleType.WATER_POOL || t == ParticleType.WATER_POOL_FAST || t == ParticleType.WIND_DUST)) {
            return;
        }
        Particle p = this.particleStorage.size() > 0 ? this.particleStorage.removeFirst() : new Particle();
        if (p != null) {
            p.configure(x, y, t.getTemplate(), s, a);
            if (guiParticle) {
                this.particleArrayGUI.add(p);
            } else if (p.isTop()) {
                this.particleArrayTop.add(p);
            } else {
                this.particleArrayBottom.add(p);
            }
        }
    }

    public boolean checkLiquidMap(int x, int y) {
        return this.particleLiquidMap.get(x + y * this.map.getMapFullWidth());
    }

    public void addLiquidMap(int x, int y) {
        this.particleLiquidMap.set(x + y * this.map.getMapFullWidth(), true);
    }

    public void removeLiquidMap(int x, int y) {
        this.particleLiquidMap.set(x + y * this.map.getMapFullWidth(), false);
    }

    public boolean checkFootPrintMap(int x, int y) {
        return this.particleFootPrintMap.get(x + y * this.map.getMapFullWidth());
    }

    public void addFootPrintMap(int x, int y) {
        this.particleFootPrintMap.set(x + y * this.map.getMapFullWidth(), true);
    }

    public void removeFootPrintMap(int x, int y) {
        this.particleFootPrintMap.set(x + y * this.map.getMapFullWidth(), false);
    }

    public int getParticleCount() {
        return this.particleArrayTop.size() + this.particleArrayBottom.size() + this.particleArrayGUI.size();
    }

    public Color getParticleColor(ParticleSet set) {
        Color randomColor = this.particleColors[Utilities.randomInt(this.particleColors.length)][set.getID()];
        return new Color(randomColor.r, randomColor.g, randomColor.b);
    }

    public static enum ParticleSet {
        BLOOD_RED(0),
        BLOOD_GREEN(1),
        WATER(2),
        FIRE_RED(8),
        FIRE_GREEN(9),
        FIRE_BLUE(10),
        FIRE_PURPLE(11),
        FIRE_YELLOW(12),
        MAGIC_RED(3),
        MAGIC_GREEN(4),
        MAGIC_BLUE(5),
        MAGIC_PURPLE(6),
        MAGIC_YELLOW(7),
        LIGHT_GRAY(13),
        GRAY(14),
        DARK_GRAY(15),
        BLACK(16),
        BROWN(17);

        private final int particleID;

        private ParticleSet(int particleID) {
            this.particleID = particleID;
        }

        public int getID() {
            return this.particleID;
        }
    }

    public static enum ParticleType {
        BLOOD(new ParticleTemplateBlood()),
        BLOOD_POOL(new ParticleTemplateBloodPool()),
        WATER(new ParticleTemplateWater()),
        WATER_POOL(new ParticleTemplateWaterPool()),
        WATER_POOL_FAST(new ParticleTemplateWaterPoolFast()),
        RAIN(new ParticleTemplateRain()),
        SPARKLE(new ParticleTemplateSparkle()),
        FIRE(new ParticleTemplateFire()),
        FLASH(new ParticleTemplateFlash()),
        FLASH_FAST(new ParticleTemplateFlashFast()),
        MAGIC_FLOAT(new ParticleTemplateMagicFloat()),
        MAGIC_FLOAT_SLOW(new ParticleTemplateMagicFloatSlow()),
        FALL(new ParticleTemplateFall()),
        FALL_FAST(new ParticleTemplateFallFast()),
        SMOKE(new ParticleTemplateSmoke()),
        SPECK(new ParticleTemplateSpeck()),
        DUST(new ParticleTemplateDust()),
        CRUMB(new ParticleTemplateCrumb()),
        SNOW(new ParticleTemplateSnow()),
        WIND_DUST(new ParticleTemplateWindDust());

        private final ParticleTemplateBase template;

        private ParticleType(ParticleTemplateBase template) {
            this.template = template;
        }

        public ParticleTemplateBase getTemplate() {
            return this.template;
        }
    }
}

