/*
 * Decompiled with CFR 0.152.
 */
package rtr.particles;

import rtr.map.MapModule;
import rtr.particles.ParticleModule;
import rtr.states.StateBase;
import rtr.utilities.Utilities;

public class ParticleEmitter {
    private MapModule map = StateBase.getMapModule();
    private ParticleModule particles = StateBase.getParticleModule();
    private int emitterX;
    private int emitterY;
    private int rate;
    private ParticleModule.ParticleType type;
    private ParticleModule.ParticleSet set;
    private boolean wholeTile;

    public ParticleEmitter(int x, int y, int r, ParticleModule.ParticleType t, ParticleModule.ParticleSet s, boolean wT) {
        this.emitterX = x;
        this.emitterY = y;
        this.rate = r;
        this.type = t;
        this.set = s;
        this.wholeTile = wT;
    }

    public void emit() {
        int modifiedRate = this.rate;
        if (this.wholeTile) {
            if (modifiedRate / (this.map.getTileWidth() * this.map.getTileHeight()) == 0 || Utilities.randomInt(modifiedRate / (this.map.getTileWidth() * this.map.getTileHeight())) == 0) {
                this.particles.newParticle(this.emitterX + Utilities.randomInt(this.map.getTileWidth()), this.emitterY + Utilities.randomInt(this.map.getTileHeight()), this.type, this.set);
            }
        } else if (Utilities.randomInt(modifiedRate) == 0) {
            this.particles.newParticle(this.emitterX, this.emitterY, this.type, this.set);
        }
    }

    public int getX() {
        return this.emitterX;
    }

    public int getY() {
        return this.emitterY;
    }
}

