/*
 * Decompiled with CFR 0.152.
 */
package rtr.particles;

import java.util.Properties;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import rtr.SettingsParser;
import rtr.map.CollisionModule;
import rtr.map.MapModule;
import rtr.particles.ParticleModule;
import rtr.particles.templates.ParticleTemplateBase;
import rtr.states.StateBase;
import rtr.system.ScaleControl;
import rtr.utilities.FastMath;
import rtr.utilities.Utilities;

public class Particle {
    protected MapModule map = StateBase.getMapModule();
    protected CollisionModule collision = StateBase.getCollisionModule();
    protected ParticleModule particle = StateBase.getParticleModule();
    private float particleX;
    private float particleY;
    private boolean canSave;
    private boolean top;
    private float angle;
    private float velocity;
    private float friction;
    private int flowResistance;
    private Color color;
    private float alphaMax;
    private int fadeOutPoint;
    private int fadeInPoint;
    private int duration;
    private float velocityX;
    private float velocityY;
    private float alpha;
    private float fadeOutPerTick;
    private float fadeInPerTick;
    private boolean behaviorFloatAway;
    private boolean behaviorDestroyOnCollision;
    private boolean behaviorToss;
    private boolean behaviorLiquid;
    private boolean behaviorOrbit;
    private boolean behaviorShake;
    private boolean behaviorLiquidInactive;
    private boolean behaviorLiquidOnMap;

    public Particle() {
    }

    public Particle(String[] newParticleString) {
    }

    public void configure(float x, float y, ParticleTemplateBase p, ParticleModule.ParticleSet s, float a) {
        this.particleX = x;
        this.particleY = y;
        this.canSave = p.canSave();
        this.top = p.isTop();
        this.angle = a != -1.0f ? a : (float)p.getAngle();
        if (p.getAngleVarience() != 0) {
            this.angle += (float)Utilities.randomInt(p.getAngleVarience() * -1, p.getAngleVarience());
        }
        this.angle = (float)Math.toRadians(this.angle);
        this.velocity = p.getVelocity();
        if (p.getVelocityVarience() != 0.0f) {
            this.velocity += (p.getVelocityVarience() - p.getVelocityVarience() * -1.0f) * Utilities.randomFloat() + p.getVelocityVarience() * -1.0f;
        }
        this.friction = p.getFriction();
        if (p.getFrictionVarience() != 0.0f) {
            this.friction += (p.getFrictionVarience() - p.getFrictionVarience() * -1.0f) * Utilities.randomFloat() + p.getFrictionVarience() * -1.0f;
        }
        this.flowResistance = p.getFlowResistance();
        if (p.getFlowResistanceVarience() != 0) {
            this.flowResistance = (int)((float)this.flowResistance + ((float)(p.getFlowResistanceVarience() - p.getFlowResistanceVarience() * -1) * Utilities.randomFloat() + (float)(p.getFlowResistanceVarience() * -1)));
        }
        this.color = this.particle.getParticleColor(s);
        this.alphaMax = p.getAlpha();
        if (p.getVelocityVarience() != 0.0f) {
            this.alphaMax += (p.getAlphaVarience() - p.getAlphaVarience() * -1.0f) * Utilities.randomFloat() + p.getAlphaVarience() * -1.0f;
        }
        this.fadeOutPoint = p.getFadeOutPoint();
        if (p.getFadeOutPointVarience() != 0) {
            this.fadeOutPoint += Utilities.randomInt(p.getFadeOutPointVarience() * -1, p.getFadeOutPointVarience());
        }
        this.fadeInPoint = p.getFadeInPoint();
        if (p.getFadeInPointVarience() != 0) {
            this.fadeInPoint += Utilities.randomInt(p.getFadeInPointVarience() * -1, p.getFadeInPointVarience());
        }
        this.duration = p.getDuration();
        if (p.getDurationVarience() != 0) {
            this.duration += Utilities.randomInt(p.getDurationVarience() * -1, p.getDurationVarience());
        }
        this.behaviorFloatAway = p.canBehaviorFloatAway();
        this.behaviorDestroyOnCollision = p.canBehaviorDestroyOnCollision();
        this.behaviorToss = p.canBehaviorToss();
        this.behaviorLiquid = p.canBehaviorLiquid();
        this.behaviorOrbit = p.canBehaviorOrbit();
        this.behaviorShake = p.canBehaviorShake();
        this.color.a = this.alpha = 0.0f;
        this.fadeOutPerTick = 1.0f / (float)this.fadeOutPoint;
        this.fadeInPerTick = 1.0f / (float)this.fadeInPoint;
        this.velocityX = FastMath.cos(this.angle) * this.velocity;
        this.velocityY = FastMath.sin(this.angle) * this.velocity;
        this.behaviorLiquidInactive = false;
    }

    public boolean canRender() {
        return this.particleX + this.map.getMapX() > -2.0f && this.particleX + this.map.getMapX() < (float)(ScaleControl.getWidth() + 2) && this.particleY + this.map.getMapY() > -2.0f && this.particleY + this.map.getMapY() < (float)(ScaleControl.getHeight() + 2);
    }

    public void render(Graphics g) {
        float mapX = this.map.getMapX();
        float mapY = this.map.getMapY();
        if (this.canRender()) {
            if (SettingsParser.getSmoothParticles()) {
                g.setColor(this.color);
                g.fillRectEmbedded(mapX + this.particleX, mapY + this.particleY, 1.0f, 1.0f);
            } else {
                g.setColor(this.color);
                g.fillRectEmbedded(mapX + (float)((int)this.particleX), mapY + (float)((int)this.particleY), 1.0f, 1.0f);
            }
        }
    }

    public void renderGUI(Graphics g) {
        if (SettingsParser.getSmoothParticles()) {
            g.setColor(this.color);
            g.fillRectEmbedded(this.particleX, this.particleY, 1.0f, 1.0f);
        } else {
            g.setColor(this.color);
            g.fillRectEmbedded((int)this.particleX, (int)this.particleY, 1.0f, 1.0f);
        }
    }

    public void renderWorldMap(Graphics g, float mapX, float mapY) {
        int displayWidth = ScaleControl.getWidth();
        int displayHeight = ScaleControl.getHeight();
        if (SettingsParser.getSmoothParticles()) {
            if (this.particleX + mapX > -2.0f && this.particleX + mapX < (float)(displayWidth + 2) && this.particleY + mapY > -2.0f && this.particleY + mapY < (float)(displayHeight + 2)) {
                g.setColor(this.color);
                g.fillRectEmbedded(mapX + this.particleX, mapY + this.particleY, 1.0f, 1.0f);
            }
        } else if (this.particleX + mapX > -2.0f && this.particleX + mapX < (float)(displayWidth + 2) && this.particleY + mapY > -2.0f && this.particleY + mapY < (float)(displayHeight + 2)) {
            g.setColor(this.color);
            g.fillRectEmbedded(mapX + (float)((int)this.particleX), mapY + (float)((int)this.particleY), 1.0f, 1.0f);
        }
    }

    public void update() {
        if (this.duration < this.fadeOutPoint && this.alpha > 0.0f) {
            this.alpha -= this.fadeOutPerTick;
            if (this.alpha < 0.0f) {
                this.alpha = 0.0f;
            }
            this.color.a = this.alpha;
        } else if (this.duration > this.fadeOutPoint && this.alpha < this.alphaMax) {
            this.alpha += this.fadeInPerTick;
            if (this.alpha > this.alphaMax) {
                this.alpha = this.alphaMax;
            }
            this.color.a = this.alpha;
        }
        if (this.behaviorFloatAway) {
            this.behaviorFloatAway();
        }
        if (this.behaviorDestroyOnCollision) {
            this.behaviorDestroyOnCollision();
        }
        if (this.behaviorToss) {
            this.behaviorToss();
        }
        if (this.behaviorLiquid) {
            this.behaviorLiquid();
        }
        if (this.behaviorOrbit) {
            this.behaviorOrbit();
        }
        if (this.behaviorShake) {
            this.behaviorShake();
        }
        --this.duration;
    }

    private void behaviorFloatAway() {
        this.particleX += this.velocityX;
        this.particleY += this.velocityY;
    }

    private void behaviorDestroyOnCollision() {
        if (this.collision.checkParticleCollision((int)this.particleX, (int)this.particleY, CollisionModule.CollisionHeight.MEDIUM) != this.collision.getCollisionNone() && this.duration > this.fadeOutPoint) {
            this.duration = this.fadeOutPoint;
        }
    }

    private void behaviorToss() {
        this.particleX += this.velocityX;
        this.particleY += this.velocityY;
        if (this.velocity > 0.0f) {
            this.velocity = this.collision.checkParticleCollision((int)this.particleX, (int)this.particleY, CollisionModule.CollisionHeight.MEDIUM) != this.collision.getCollisionNone() ? (this.velocity -= this.friction * 4.0f) : (this.velocity -= this.friction);
        }
        if (this.velocity <= 0.0f) {
            this.particleX = (int)this.particleX;
            this.particleY = (int)this.particleY;
            this.velocity = 0.0f;
            this.behaviorToss = false;
            this.top = false;
        }
        this.velocityX = (float)(Math.cos(this.angle) * (double)this.velocity);
        this.velocityY = (float)(Math.sin(this.angle) * (double)this.velocity);
    }

    private void behaviorLiquid() {
        if (this.velocity <= 0.0f) {
            if (!this.behaviorLiquidInactive) {
                this.adjustParticleBounds();
                if (Utilities.randomInt(this.flowResistance) == 0) {
                    byte collisionCheck = this.collision.checkParticleCollision((int)this.particleX, (int)this.particleY, CollisionModule.CollisionHeight.ANY);
                    if (collisionCheck == this.collision.getCollisionNorthLow() || collisionCheck == this.collision.getCollisionNorthMedium() || collisionCheck == this.collision.getCollisionNorthHigh()) {
                        this.particleY -= 1.0f;
                    } else if (collisionCheck == this.collision.getCollisionEastLow() || collisionCheck == this.collision.getCollisionEastMedium() || collisionCheck == this.collision.getCollisionEastHigh()) {
                        this.particleX += 1.0f;
                    } else if (collisionCheck == this.collision.getCollisionSouthLow() || collisionCheck == this.collision.getCollisionSouthMedium() || collisionCheck == this.collision.getCollisionSouthHigh()) {
                        this.particleY += 1.0f;
                    } else if (collisionCheck == this.collision.getCollisionWestLow() || collisionCheck == this.collision.getCollisionWestMedium() || collisionCheck == this.collision.getCollisionWestHigh()) {
                        this.particleX -= 1.0f;
                    } else {
                        byte collisionType = this.collision.checkParticleCollision((int)this.particleX, (int)this.particleY, CollisionModule.CollisionHeight.ANY);
                        while (this.particle.checkLiquidMap((int)this.particleX, (int)this.particleY) && (collisionType == this.collision.getCollisionNone() || collisionType == this.collision.getCollisionAllLow() || collisionType == this.collision.getCollisionAllMedium() || collisionType == this.collision.getCollisionAllHigh())) {
                            int random = Utilities.randomInt(4);
                            switch (random) {
                                case 0: {
                                    this.particleX += 1.0f;
                                    break;
                                }
                                case 1: {
                                    this.particleX -= 1.0f;
                                    break;
                                }
                                case 2: {
                                    this.particleY += 1.0f;
                                    break;
                                }
                                case 3: {
                                    this.particleY -= 1.0f;
                                }
                            }
                            collisionType = this.collision.checkParticleCollision((int)this.particleX, (int)this.particleY, CollisionModule.CollisionHeight.ANY);
                            this.adjustParticleBounds();
                        }
                        if (!this.particle.checkLiquidMap((int)this.particleX, (int)this.particleY)) {
                            this.particle.addLiquidMap((int)this.particleX, (int)this.particleY);
                            this.behaviorLiquidOnMap = true;
                            this.behaviorLiquidInactive = true;
                        }
                    }
                    if (Utilities.randomInt(100 - this.flowResistance) == 0) {
                        this.behaviorLiquidInactive = true;
                    }
                }
            }
            if (this.behaviorLiquidOnMap && (this.duration == 500 || this.duration < this.fadeOutPoint + 10)) {
                this.color = this.color.darker(0.2f);
                this.particle.removeLiquidMap((int)this.particleX, (int)this.particleY);
                this.behaviorLiquidOnMap = false;
            }
        }
    }

    private void behaviorOrbit() {
        this.particleX += this.velocityX;
        this.particleY += this.velocityY;
        this.angle += this.velocity / 10.0f;
        this.velocityX = FastMath.cos(this.angle) * this.velocity;
        this.velocityY = FastMath.sin(this.angle) * this.velocity;
    }

    private void behaviorShake() {
        if (Utilities.randomInt(2) == 0) {
            this.particleX = Utilities.randomInt(2) == 0 ? (this.particleX += this.velocityY) : (this.particleX -= this.velocityY);
        } else {
            this.particleY = Utilities.randomInt(2) == 0 ? (this.particleY += this.velocityX) : (this.particleY -= this.velocityX);
        }
    }

    public boolean canSave() {
        return this.canSave;
    }

    public boolean isTop() {
        return this.top;
    }

    public int getDuration() {
        return this.duration;
    }

    private void adjustParticleBounds() {
        while (Utilities.isOutOfBounds(this.map.getMapFullWidth() - 1, this.map.getMapFullHeight() - 1, (int)this.particleX, (int)this.particleY)) {
            if ((int)this.particleX >= this.map.getMapFullWidth() - 1) {
                this.particleX -= 1.0f;
                continue;
            }
            if ((int)this.particleX < 0) {
                this.particleX += 1.0f;
                continue;
            }
            if ((int)this.particleY >= this.map.getMapFullHeight() - 1) {
                this.particleY -= 1.0f;
                continue;
            }
            if ((int)this.particleY >= 0) continue;
            this.particleY += 1.0f;
        }
    }

    public Properties getPlayProperties(int ID) {
        Properties properties = new Properties();
        return properties;
    }

    public float getParticleX() {
        return this.particleX;
    }

    public float getParticleY() {
        return this.particleY;
    }
}

