/*
 * Decompiled with CFR 0.152.
 */
package rtr.object;

import java.util.ArrayList;
import java.util.HashMap;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;
import rtr.ImageLoader;
import rtr.ModuleBase;
import rtr.object.ObjectBase;
import rtr.object.ObjectChest;
import rtr.object.ObjectDeco;
import rtr.object.ObjectDoorNS;
import rtr.object.ObjectDoorWE;
import rtr.states.StateBase;
import rtr.utilities.Utilities;

public class ObjectModule
extends ModuleBase {
    private Image objectSheet;
    private HashMap<ObjectType, ArrayList<Image>> objectSprites;
    private ObjectBase[][] objects;
    private ArrayList<ObjectBase> objectsList;

    @Override
    public void initModule(StateBase cS) throws SlickException {
        super.initModule(cS);
        if (this.objects == null) {
            this.objects = new ObjectBase[this.map.getMapWidth()][this.map.getMapHeight()];
            this.objectsList = new ArrayList();
        }
        if (this.objectSheet == null) {
            this.objectSheet = ImageLoader.getImage("res/objectSheet.png");
        }
        if (this.objectSprites == null) {
            this.objectSprites = new HashMap();
            int row = 0;
            ObjectType[] objectTypeArray = ObjectType.values();
            int n = objectTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ObjectType t = objectTypeArray[n2];
                this.objectSprites.put(t, new ArrayList());
                SpriteSheet sheetOut = new SpriteSheet(this.objectSheet.getSubImage(0, row, this.map.getTileWidth() * 8, t.getHeight()), this.map.getTileWidth(), t.getHeight());
                System.out.println(String.valueOf(sheetOut.getHorizontalCount()) + " " + sheetOut.getVerticalCount());
                int i = 0;
                while (i < 8) {
                    this.objectSprites.get((Object)t).add(sheetOut.getSprite(i, 0));
                    ++i;
                }
                row += t.getHeight();
                ++n2;
            }
        }
    }

    @Override
    public void resetModule() throws SlickException {
        super.resetModule();
        this.objects = new ObjectBase[this.map.getMapWidth()][this.map.getMapHeight()];
        this.objectsList.clear();
    }

    public void render() {
        this.objectSheet.startUse();
        int startX = this.map.getMapRenderTileTopLeftX() - 1;
        int startY = this.map.getMapRenderTileTopLeftY() - 1;
        int endX = this.map.getMapRenderTileBottomRightX() + 1;
        int endY = this.map.getMapRenderTileBottomRightY() + 1;
        int x = startX;
        while (x < endX) {
            int y = startY;
            while (y < endY) {
                if (x >= 0 && x <= this.objects.length - 1 && y >= 0 && y <= this.objects[x].length - 1 && this.objects[x][y] != null) {
                    this.objects[x][y].render();
                }
                ++y;
            }
            ++x;
        }
        this.objectSheet.endUse();
    }

    public void update() throws SlickException {
        int startX = this.map.getMapRenderTileTopLeftX() - 1;
        int startY = this.map.getMapRenderTileTopLeftY() - 1;
        int endX = this.map.getMapRenderTileBottomRightX() + 1;
        int endY = this.map.getMapRenderTileBottomRightY() + 1;
        int x = startX;
        while (x < endX) {
            int y = startY;
            while (y < endY) {
                if (x >= 0 && x <= this.objects.length - 1 && y >= 0 && y <= this.objects[x].length - 1 && this.objects[x][y] != null) {
                    this.objects[x][y].update();
                }
                ++y;
            }
            ++x;
        }
    }

    public void addObject(int x, int y, ObjectType t) {
        if (t == ObjectType.DOOR_NS) {
            this.objects[x][y] = new ObjectDoorNS(x, y);
        } else if (t == ObjectType.DOOR_WE) {
            this.objects[x][y] = new ObjectDoorWE(x, y);
        } else if (t == ObjectType.CHEST) {
            this.objects[x][y] = new ObjectChest(x, y);
        } else if (t == ObjectType.DECO) {
            this.objects[x][y] = new ObjectDeco(x, y);
        }
        this.objectsList.add(this.objects[x][y]);
    }

    public void removeObject(int x, int y) {
        this.objectsList.remove(this.objects[x][y]);
        this.objects[x][y] = null;
    }

    public ObjectBase getObject(int x, int y) {
        return this.objects[x][y];
    }

    public Image getSprite(ObjectType t) {
        return this.objectSprites.get((Object)t).get(Utilities.randomInt(8));
    }

    public ArrayList<ObjectBase> getObjects() {
        return this.objectsList;
    }

    public void eraseMap() {
        this.objects = new ObjectBase[this.map.getMapWidth()][this.map.getMapHeight()];
        this.objectsList = new ArrayList();
    }

    public static enum ObjectType {
        DOOR_NS(32),
        DOOR_NS_OPEN(32),
        DOOR_WE(32),
        DOOR_WE_OPEN(32),
        CHEST(16),
        DECO(16),
        DOOR_RED(16),
        DOOR_GREEN(16),
        DOOR_BLUE(16);

        private final int height;

        private ObjectType(int height) {
            this.height = height;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

