/*
 * Decompiled with CFR 0.152.
 */
package rtr.object;

import org.newdawn.slick.Color;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import rtr.item.ItemBase;
import rtr.map.MapModule;
import rtr.object.ObjectModule;
import rtr.states.StateBase;

public class ObjectBase {
    protected ObjectModule object = StateBase.getObjectModule();
    protected MapModule map = StateBase.getMapModule();
    protected Image sprite;
    protected Color objectColor;
    protected ObjectModule.ObjectType objectType;
    protected int tileX;
    protected int tileY;
    protected int renderOffsetX;
    protected int renderOffsetY;
    protected boolean blocksMovement;
    protected boolean canBePushed;
    protected boolean canBeGrabbed;
    protected boolean canBeWalkedOn;
    protected boolean isDoor;
    protected boolean isContainer;
    protected ItemBase[] inventory;

    public ObjectBase(int x, int y) {
        this.tileX = x;
        this.tileY = y;
    }

    public void render() {
        float drawX = this.map.getMapX() + (float)(this.tileX * this.map.getTileWidth());
        float drawY = this.map.getMapY() + (float)(this.tileY * this.map.getTileHeight());
        int objectHeight = this.sprite.getHeight();
        if (objectHeight > this.map.getTileHeight()) {
            drawY -= (float)(objectHeight - this.map.getTileHeight());
        }
        this.sprite.drawEmbedded(drawX + (float)this.renderOffsetX, drawY + (float)this.renderOffsetY, drawX + (float)this.renderOffsetX + (float)this.sprite.getWidth(), drawY + (float)this.renderOffsetY + (float)this.sprite.getHeight(), 0.0f, 0.0f, this.sprite.getWidth(), this.sprite.getHeight(), this.objectColor);
    }

    public void update() throws SlickException {
    }

    public void pushed() {
    }

    public void grabbed() {
    }

    public void walkedOn() {
    }

    public void open() {
    }

    public boolean blocksMovement() {
        return this.blocksMovement;
    }

    public boolean canBePushed() {
        return this.canBePushed;
    }

    public boolean canBeGrabbed() {
        return this.canBeGrabbed;
    }

    public boolean canBeWalkedOn() {
        return this.canBeWalkedOn;
    }

    public boolean isDoor() {
        return this.isDoor;
    }

    public boolean isContainer() {
        return this.isContainer;
    }

    public ObjectModule.ObjectType getType() {
        return this.objectType;
    }

    public int getTileX() {
        return this.tileX;
    }

    public int getTileY() {
        return this.tileY;
    }

    public ItemBase[] getInventory() {
        return this.inventory;
    }

    public void swapItemsInInventory(int itemSlotOne, int itemSlotTwo) {
        ItemBase itemTwo;
        ItemBase itemOne = this.inventory[itemSlotOne];
        this.inventory[itemSlotOne] = itemTwo = this.inventory[itemSlotTwo];
        this.inventory[itemSlotTwo] = itemOne;
    }

    public void removeItemInInventory(ItemBase removeItem) {
        int i = 0;
        while (i < this.inventory.length) {
            if (this.inventory[i] == removeItem) {
                this.inventory[i] = null;
                break;
            }
            ++i;
        }
    }
}

