/*
 * Decompiled with CFR 0.152.
 */
package rtr.mobs.spritesheet;

import java.util.ArrayList;
import java.util.HashMap;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.imageout.ImageOut;
import rtr.ImageLoader;
import rtr.map.MapModule;
import rtr.mobs.MobBase;
import rtr.mobs.spritesheet.MobSprite;
import rtr.mobs.spritesheet.templates.MobSpriteTemplateBase;
import rtr.mobs.spritesheet.templates.MobSpriteTemplateVillager;
import rtr.mobs.spritesheet.templates.MobSpriteTemplateZombie;
import rtr.states.StateBase;

public class MobSpriteLoader {
    private MapModule map = StateBase.getMapModule();
    private Image mobBaseSpriteSheet;
    private static final int ANIMATION_COUNT = 61;
    private static final int ANIMATION_FRAMES = 8;
    private HashMap<MobBase.MobType, HashMap<MobBase.MobGender, HashMap<MobSprite.MobAnimationFrames, ArrayList<Image[]>>>> spriteSheets = new HashMap();
    private HashMap<MobBase.MobType, HashMap<MobBase.MobGender, MobSpriteTemplateBase>> spriteTemplates = new HashMap();

    public MobSpriteLoader() throws SlickException {
        if (this.mobBaseSpriteSheet == null) {
            this.mobBaseSpriteSheet = ImageLoader.getImage("res/mobs/mobs.png");
        }
        this.spriteTemplates.put(MobBase.MobType.HERO, new HashMap());
        this.spriteTemplates.get((Object)MobBase.MobType.HERO).put(MobBase.MobGender.NONE, new MobSpriteTemplateVillager());
        this.spriteTemplates.get((Object)MobBase.MobType.HERO).put(MobBase.MobGender.MALE, new MobSpriteTemplateVillager());
        this.spriteTemplates.get((Object)MobBase.MobType.HERO).put(MobBase.MobGender.FEMALE, new MobSpriteTemplateVillager());
        this.spriteTemplates.put(MobBase.MobType.ZOMBIE, new HashMap());
        this.spriteTemplates.get((Object)MobBase.MobType.ZOMBIE).put(MobBase.MobGender.NONE, new MobSpriteTemplateZombie());
        this.spriteTemplates.get((Object)MobBase.MobType.ZOMBIE).put(MobBase.MobGender.MALE, new MobSpriteTemplateZombie());
        this.spriteTemplates.get((Object)MobBase.MobType.ZOMBIE).put(MobBase.MobGender.FEMALE, new MobSpriteTemplateZombie());
        this.loadMob(MobBase.MobType.HERO, MobBase.MobGender.NONE, 0);
        this.loadMob(MobBase.MobType.HERO, MobBase.MobGender.MALE, 0);
        this.loadMob(MobBase.MobType.HERO, MobBase.MobGender.FEMALE, 5);
        this.loadMob(MobBase.MobType.ZOMBIE, MobBase.MobGender.NONE, 15);
        this.loadMob(MobBase.MobType.ZOMBIE, MobBase.MobGender.MALE, 15);
        this.loadMob(MobBase.MobType.ZOMBIE, MobBase.MobGender.FEMALE, 21);
    }

    private void buildSpriteSheet() throws SlickException {
        Image mobBase = ImageLoader.getImage("res/mobs/baseMobsSheet.png");
        SpriteSheet sheet = new SpriteSheet(mobBase, 8 * this.map.getTileWidth(), 61 * this.map.getTileHeight());
        int layerCount = 0;
        int x = 0;
        while (x < sheet.getHorizontalCount()) {
            Image out = sheet.getSprite(x, 0);
            int l = 0;
            while (l < this.map.getTileWidth()) {
                Color check = out.getColor(l, 0);
                if (!(check.a > 0.0f)) break;
                ++layerCount;
                ++l;
            }
            ++x;
        }
        int shiftX = 8 * this.map.getTileWidth();
        int shiftY = 60 * this.map.getTileHeight();
        Image unparsedSheet = new Image(shiftX * layerCount, shiftY);
        int drawLayer = 0;
        Graphics g = unparsedSheet.getGraphics();
        int s = 0;
        while (s < sheet.getHorizontalCount()) {
            System.out.println(drawLayer);
            Image currentSheet = sheet.getSprite(s, 0);
            int l = 0;
            while (l < this.map.getTileWidth()) {
                Color layerCheckColor = currentSheet.getColor(l, 0);
                if (layerCheckColor.a == 0.0f) break;
                Color dontColorCheck = currentSheet.getColor(l, 15);
                boolean dontColor = false;
                if (dontColorCheck.a > 0.0f) {
                    dontColor = true;
                }
                int colorLayer = 0;
                while (layerCheckColor.a > 0.0f) {
                    int w = 0;
                    while (w < currentSheet.getWidth()) {
                        int h = this.map.getTileHeight();
                        while (h < currentSheet.getHeight()) {
                            Color currentSheetColor = currentSheet.getColor(w, h);
                            if (currentSheetColor.equals(layerCheckColor)) {
                                if (!dontColor) {
                                    if (currentSheetColor.r >= currentSheetColor.b && currentSheetColor.r >= currentSheetColor.g) {
                                        currentSheetColor.b = currentSheetColor.r;
                                        currentSheetColor.g = currentSheetColor.r;
                                    } else if (currentSheetColor.g >= currentSheetColor.r && currentSheetColor.g >= currentSheetColor.b) {
                                        currentSheetColor.r = currentSheetColor.g;
                                        currentSheetColor.b = currentSheetColor.g;
                                    } else if (currentSheetColor.b >= currentSheetColor.r && currentSheetColor.b >= currentSheetColor.g) {
                                        currentSheetColor.r = currentSheetColor.b;
                                        currentSheetColor.g = currentSheetColor.b;
                                    }
                                }
                                g.setColor(currentSheetColor);
                                g.fillRect(w + drawLayer * shiftX, h - this.map.getTileHeight(), 1.0f, 1.0f);
                            }
                            ++h;
                        }
                        ++w;
                    }
                    layerCheckColor = currentSheet.getColor(l, ++colorLayer);
                }
                ++drawLayer;
                ++l;
            }
            ++s;
        }
        ImageOut.write((Image)unparsedSheet, (String)"src/res/mobs/mobs.png", (boolean)true);
        g.flush();
        this.mobBaseSpriteSheet = new Image("src/res/mobs/mobs.png");
        this.mobBaseSpriteSheet.setFilter(9728);
    }

    private void loadMob(MobBase.MobType type, MobBase.MobGender gender, int posX) {
        int layers = this.spriteTemplates.get((Object)type).get((Object)gender).getLayers();
        posX = posX * this.map.getTileWidth() * 8;
        int posY = 0;
        SpriteSheet sheet = new SpriteSheet(this.mobBaseSpriteSheet.getSubImage(posX, posY, layers * (8 * this.map.getTileWidth()), 61 * this.map.getTileHeight()), this.map.getTileWidth(), this.map.getTileHeight());
        HashMap processedOut = new HashMap();
        MobSprite.MobAnimationFrames[] mobAnimationFramesArray = MobSprite.MobAnimationFrames.values();
        int n = mobAnimationFramesArray.length;
        int n2 = 0;
        while (n2 < n) {
            MobSprite.MobAnimationFrames mA = mobAnimationFramesArray[n2];
            int row = mA.getID();
            processedOut.put(mA, new ArrayList());
            int l = 0;
            while (l < layers) {
                int offSet = l * 8;
                Image[] animationImages = new Image[]{sheet.getSprite(offSet + 0, row), sheet.getSprite(offSet + 1, row), sheet.getSprite(offSet + 2, row), sheet.getSprite(offSet + 3, row), sheet.getSprite(offSet + 4, row), sheet.getSprite(offSet + 5, row), sheet.getSprite(offSet + 6, row), sheet.getSprite(offSet + 7, row)};
                ((ArrayList)processedOut.get((Object)mA)).add(animationImages);
                ++l;
            }
            ++n2;
        }
        if (this.spriteSheets.get((Object)type) == null) {
            this.spriteSheets.put(type, new HashMap());
        }
        this.spriteSheets.get((Object)type).put(gender, processedOut);
    }

    public Image getBaseSpriteSheet() throws SlickException {
        return this.mobBaseSpriteSheet;
    }

    public MobSprite createNewMobSprite(MobBase.MobType type, MobBase.MobGender gender) throws SlickException {
        if (this.spriteSheets.get((Object)type).get((Object)gender) != null) {
            return new MobSprite(this.spriteSheets.get((Object)type).get((Object)gender), this.spriteTemplates.get((Object)type).get((Object)gender));
        }
        return new MobSprite(this.spriteSheets.get((Object)type).get((Object)MobBase.MobGender.NONE), this.spriteTemplates.get((Object)type).get((Object)MobBase.MobGender.NONE));
    }
}

