/*
 * Decompiled with CFR 0.152.
 */
package rtr.mobs.spritesheet;

import java.util.ArrayList;
import java.util.HashMap;
import org.newdawn.slick.Animation;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import rtr.map.MapModule;
import rtr.mobs.spritesheet.templates.MobSpriteTemplateBase;
import rtr.states.StateBase;
import rtr.utilities.Utilities;

public class MobSprite {
    private MapModule map = StateBase.getMapModule();
    private Animation[] animation;
    private int sheetHeight = MobAnimationFrames.values().length;
    private Animation[][] animationMap = new Animation[this.sheetHeight][];
    private HashMap<MobAnimationFrames, Integer> animationRandom = new HashMap();
    private int layers;
    private boolean randomFrames;
    private boolean playingAnimation;
    private int randomFramesChance = 1000;
    Color[] colorOut;

    public MobSprite(HashMap<MobAnimationFrames, ArrayList<Image[]>> sheet, MobSpriteTemplateBase t) throws SlickException {
        this.layers = t.getLayers();
        this.colorOut = new Color[this.layers];
        int l = 0;
        while (l < this.layers) {
            this.colorOut[l] = new Color(0, 0, 0);
            ++l;
        }
        int x = 0;
        while (x < this.sheetHeight) {
            this.animationMap[x] = new Animation[this.layers];
            ++x;
        }
        MobAnimationFrames[] mobAnimationFramesArray = MobAnimationFrames.values();
        int n = mobAnimationFramesArray.length;
        int n2 = 0;
        while (n2 < n) {
            MobAnimationFrames mA = mobAnimationFramesArray[n2];
            int row = mA.getID();
            MobSpriteTemplateBase.MobAnimationConfig c = mA.getConfig();
            int l2 = 0;
            while (l2 < this.layers) {
                this.animationMap[row][l2] = new Animation(sheet.get((Object)mA).get(l2), t.getAnimationDurations().get((Object)c), true);
                this.animationMap[row][l2].setAutoUpdate(false);
                if (t.getAnimationFlags().get((Object)c).contains((Object)MobSpriteTemplateBase.MobAnimationFlags.NO_LOOPING)) {
                    this.animationMap[row][l2].setLooping(false);
                }
                if (t.getAnimationFlags().get((Object)c).contains((Object)MobSpriteTemplateBase.MobAnimationFlags.MANUAL_FRAMES)) {
                    this.animationMap[row][l2].stop();
                }
                if (t.getAnimationFlags().get((Object)c).contains((Object)MobSpriteTemplateBase.MobAnimationFlags.RANDOM_FRAMES)) {
                    this.animationMap[row][l2].stop();
                    this.animationRandom.put(mA, 1000);
                }
                ++l2;
            }
            ++n2;
        }
        this.setPosition(MobAnimationFrames.FACE_NORTH);
    }

    public void render(float spriteX, float spriteY, int depth, Color[] colorLayers, float alpha, boolean isCold, boolean isHot, boolean isPoisoned, boolean isBlighted, boolean drawEmbedded) throws SlickException {
        int l = 0;
        while (l < this.layers) {
            this.colorOut[l].r = colorLayers[l].r;
            this.colorOut[l].g = colorLayers[l].g;
            this.colorOut[l].b = colorLayers[l].b;
            this.colorOut[l].a = alpha;
            if (isCold) {
                this.colorOut[l].b = (float)((double)this.colorOut[l].b + 0.5);
                this.colorOut[l].g = (float)((double)this.colorOut[l].g + 0.5);
            }
            if (isHot) {
                this.colorOut[l].r = (float)((double)this.colorOut[l].r + 0.5);
            }
            if (isPoisoned) {
                this.colorOut[l].g = (float)((double)this.colorOut[l].g + 0.5);
            }
            if (isBlighted) {
                this.colorOut[l] = this.colorOut[l].darker(0.7f);
            }
            if (drawEmbedded) {
                if (depth > 0) {
                    this.animation[l].drawEmbedded(spriteX, spriteY + (float)depth, this.map.getTileWidth(), this.map.getTileHeight() - depth + 1, new Color(255, 255, 255, 100));
                }
                this.animation[l].drawEmbedded(spriteX, spriteY + (float)depth, this.map.getTileWidth(), this.map.getTileHeight() - depth, this.colorOut[l]);
            } else {
                if (depth > 0) {
                    this.animation[l].draw(spriteX, spriteY, this.map.getTileWidth(), this.map.getTileHeight() - depth + 1, new Color(255, 255, 255, 100));
                }
                this.animation[l].draw(spriteX, spriteY, this.map.getTileWidth(), this.map.getTileHeight() - depth, this.colorOut[l]);
            }
            ++l;
        }
    }

    public void renderMapWriter(float spriteX, float spriteY, int depth, Color[] colorLayers, float alpha, boolean isCold, boolean isHot, boolean isPoisoned, boolean isBlighted) {
        int l = 0;
        while (l < this.layers) {
            this.colorOut[l].r = colorLayers[l].r;
            this.colorOut[l].g = colorLayers[l].g;
            this.colorOut[l].b = colorLayers[l].b;
            this.colorOut[l].a = alpha;
            if (isCold) {
                this.colorOut[l].b = (float)((double)this.colorOut[l].b + 0.5);
                this.colorOut[l].g = (float)((double)this.colorOut[l].g + 0.5);
            }
            if (isHot) {
                this.colorOut[l].r = (float)((double)this.colorOut[l].r + 0.5);
            }
            if (isPoisoned) {
                this.colorOut[l].g = (float)((double)this.colorOut[l].g + 0.5);
            }
            if (isBlighted) {
                this.colorOut[l] = this.colorOut[l].darker(0.7f);
            }
            if (depth > 0) {
                this.animation[l].draw(spriteX, spriteY, this.map.getTileWidth(), this.map.getTileHeight() - depth + 1, new Color(255, 255, 255, 100));
            }
            this.animation[l].draw(spriteX, spriteY, this.map.getTileWidth(), this.map.getTileHeight() - depth, this.colorOut[l]);
            ++l;
        }
    }

    public void update() throws SlickException {
        if (this.randomFrames && Utilities.randomInt(this.randomFramesChance) == 0) {
            this.randomFrame();
        }
        int l = 0;
        while (l < this.layers) {
            this.animation[l].update(8L);
            ++l;
        }
    }

    public void playAnimation(MobAnimationFrames a) {
        this.animation = this.animationMap[a.getID()];
        int l = 0;
        while (l < this.layers) {
            this.animationMap[a.getID()][l].restart();
            ++l;
        }
        this.playingAnimation = true;
    }

    public void setPosition(MobAnimationFrames position) {
        if (this.animation != this.animationMap[position.getID()]) {
            this.animation = this.animationMap[position.getID()];
            int l = 0;
            while (l < this.layers) {
                this.animation[l].restart();
                ++l;
            }
            if (this.animationRandom.get((Object)position) != null) {
                this.randomFrames = true;
                this.randomFramesChance = this.animationRandom.get((Object)position);
            } else {
                this.randomFrames = false;
                this.randomFramesChance = 1000;
            }
        }
    }

    public void randomFrame() {
        int randomFrame = Utilities.randomInt(this.animation[0].getFrameCount());
        int l = 0;
        while (l < this.layers) {
            this.animation[l].setCurrentFrame(randomFrame);
            ++l;
        }
    }

    public void setFrame(int i) {
        int l = 0;
        while (l < this.layers) {
            this.animation[l].setCurrentFrame(i);
            ++l;
        }
    }

    public void nextFrame() {
        if (this.animation[0].getFrame() + 1 < this.animation[0].getFrameCount()) {
            int l = 0;
            while (l < this.layers) {
                this.animation[l].setCurrentFrame(this.animation[l].getFrame() + 1);
                ++l;
            }
        }
    }

    public int getSpriteWidth() {
        return this.animation[0].getImage(0).getWidth();
    }

    public int getSpriteHeight() {
        return this.animation[0].getImage(0).getHeight();
    }

    public static enum MobAnimationFrames {
        WALK_NORTH(0, MobSpriteTemplateBase.MobAnimationConfig.WALK),
        WALK_EAST(1, MobSpriteTemplateBase.MobAnimationConfig.WALK),
        WALK_SOUTH(2, MobSpriteTemplateBase.MobAnimationConfig.WALK),
        WALK_WEST(3, MobSpriteTemplateBase.MobAnimationConfig.WALK),
        FACE_NORTH(4, MobSpriteTemplateBase.MobAnimationConfig.FACE),
        FACE_EAST(5, MobSpriteTemplateBase.MobAnimationConfig.FACE),
        FACE_SOUTH(6, MobSpriteTemplateBase.MobAnimationConfig.FACE),
        FACE_WEST(7, MobSpriteTemplateBase.MobAnimationConfig.FACE),
        DEATH_NORTH(8, MobSpriteTemplateBase.MobAnimationConfig.DEATH),
        DEATH_EAST(9, MobSpriteTemplateBase.MobAnimationConfig.DEATH),
        DEATH_SOUTH(10, MobSpriteTemplateBase.MobAnimationConfig.DEATH),
        DEATH_WEST(11, MobSpriteTemplateBase.MobAnimationConfig.DEATH),
        DECAY_NORTH(12, MobSpriteTemplateBase.MobAnimationConfig.DECAY),
        DECAY_EAST(13, MobSpriteTemplateBase.MobAnimationConfig.DECAY),
        DECAY_SOUTH(14, MobSpriteTemplateBase.MobAnimationConfig.DECAY),
        DECAY_WEST(15, MobSpriteTemplateBase.MobAnimationConfig.DECAY),
        ATTACK_NORTH(16, MobSpriteTemplateBase.MobAnimationConfig.ATTACK),
        ATTACK_EAST(17, MobSpriteTemplateBase.MobAnimationConfig.ATTACK),
        ATTACK_SOUTH(18, MobSpriteTemplateBase.MobAnimationConfig.ATTACK),
        ATTACK_WEST(19, MobSpriteTemplateBase.MobAnimationConfig.ATTACK),
        CARRY_NORTH(20, MobSpriteTemplateBase.MobAnimationConfig.CARRY),
        CARRY_EAST(21, MobSpriteTemplateBase.MobAnimationConfig.CARRY),
        CARRY_SOUTH(22, MobSpriteTemplateBase.MobAnimationConfig.CARRY),
        CARRY_WEST(23, MobSpriteTemplateBase.MobAnimationConfig.CARRY),
        HOLD_NORTH(24, MobSpriteTemplateBase.MobAnimationConfig.HOLD),
        HOLD_EAST(25, MobSpriteTemplateBase.MobAnimationConfig.HOLD),
        HOLD_SOUTH(26, MobSpriteTemplateBase.MobAnimationConfig.HOLD),
        HOLD_WEST(27, MobSpriteTemplateBase.MobAnimationConfig.HOLD),
        INTERACT_TOOL_NORTH(28, MobSpriteTemplateBase.MobAnimationConfig.INTERACT_TOOL),
        INTERACT_TOOL_EAST(29, MobSpriteTemplateBase.MobAnimationConfig.INTERACT_TOOL),
        INTERACT_TOOL_SOUTH(30, MobSpriteTemplateBase.MobAnimationConfig.INTERACT_TOOL),
        INTERACT_TOOL_WEST(31, MobSpriteTemplateBase.MobAnimationConfig.INTERACT_TOOL),
        INTERACT_NORTH(32, MobSpriteTemplateBase.MobAnimationConfig.INTERACT),
        INTERACT_EAST(33, MobSpriteTemplateBase.MobAnimationConfig.INTERACT),
        INTERACT_SOUTH(34, MobSpriteTemplateBase.MobAnimationConfig.INTERACT),
        INTERACT_WEST(35, MobSpriteTemplateBase.MobAnimationConfig.INTERACT),
        HIT_NORTH(36, MobSpriteTemplateBase.MobAnimationConfig.HIT),
        HIT_EAST(37, MobSpriteTemplateBase.MobAnimationConfig.HIT),
        HIT_SOUTH(38, MobSpriteTemplateBase.MobAnimationConfig.HIT),
        HIT_WEST(39, MobSpriteTemplateBase.MobAnimationConfig.HIT),
        SLEEP_NORTH(40, MobSpriteTemplateBase.MobAnimationConfig.SLEEP),
        SLEEP_EAST(41, MobSpriteTemplateBase.MobAnimationConfig.SLEEP),
        SLEEP_SOUTH(42, MobSpriteTemplateBase.MobAnimationConfig.SLEEP),
        SLEEP_WEST(43, MobSpriteTemplateBase.MobAnimationConfig.SLEEP),
        FLEE_NORTH(44, MobSpriteTemplateBase.MobAnimationConfig.FLEE),
        FLEE_EAST(45, MobSpriteTemplateBase.MobAnimationConfig.FLEE),
        FLEE_SOUTH(46, MobSpriteTemplateBase.MobAnimationConfig.FLEE),
        FLEE_WEST(47, MobSpriteTemplateBase.MobAnimationConfig.FLEE),
        EAT_NORTH(48, MobSpriteTemplateBase.MobAnimationConfig.EAT),
        EAT_EAST(49, MobSpriteTemplateBase.MobAnimationConfig.EAT),
        EAT_SOUTH(50, MobSpriteTemplateBase.MobAnimationConfig.EAT),
        EAT_WEST(51, MobSpriteTemplateBase.MobAnimationConfig.EAT),
        DRINK_NORTH(52, MobSpriteTemplateBase.MobAnimationConfig.DRINK),
        DRINK_EAST(53, MobSpriteTemplateBase.MobAnimationConfig.DRINK),
        DRINK_SOUTH(54, MobSpriteTemplateBase.MobAnimationConfig.DRINK),
        DRINK_WEST(55, MobSpriteTemplateBase.MobAnimationConfig.DRINK),
        DRINK_BOTTLE_NORTH(56, MobSpriteTemplateBase.MobAnimationConfig.DRINK_BOTTLE),
        DRINK_BOTTLE_EAST(57, MobSpriteTemplateBase.MobAnimationConfig.DRINK_BOTTLE),
        DRINK_BOTTLE_SOUTH(58, MobSpriteTemplateBase.MobAnimationConfig.DRINK_BOTTLE),
        DRINK_BOTTLE_WEST(59, MobSpriteTemplateBase.MobAnimationConfig.DRINK_BOTTLE);

        private final int mobAnimID;
        private final MobSpriteTemplateBase.MobAnimationConfig mobAnimConfig;

        private MobAnimationFrames(int mobAnimID, MobSpriteTemplateBase.MobAnimationConfig mobAnimConfig) {
            this.mobAnimID = mobAnimID;
            this.mobAnimConfig = mobAnimConfig;
        }

        public int getID() {
            return this.mobAnimID;
        }

        public MobSpriteTemplateBase.MobAnimationConfig getConfig() {
            return this.mobAnimConfig;
        }
    }
}

