/*
 * Decompiled with CFR 0.152.
 */
package rtr.mobs.pathfinder;

import java.util.Comparator;
import rtr.map.MapModule;
import rtr.states.StateBase;

public class SearchNode
implements Comparable<SearchNode>,
Comparator<SearchNode> {
    MapModule map = StateBase.getMapModule();
    int gValue;
    int mValue;
    int nodeX;
    int nodeY;
    boolean open;
    boolean closed;
    boolean resettable;
    SearchNode parent;

    public SearchNode(int x, int y) {
        this.nodeX = x;
        this.nodeY = y;
        this.mValue = 100;
    }

    public void flagResettable() {
        this.resettable = true;
    }

    public boolean isResettable() {
        return this.resettable;
    }

    public void resetNode() {
        this.mValue = 100;
        this.gValue = 0;
        this.open = false;
        this.closed = false;
        this.parent = null;
        this.resettable = false;
    }

    public int getG() {
        return this.gValue;
    }

    public void setG(int g) {
        this.gValue = g;
    }

    public int getM() {
        return this.mValue;
    }

    public void setM(int m) {
        this.mValue = m;
    }

    public int getX() {
        return this.nodeX;
    }

    public int getY() {
        return this.nodeY;
    }

    public void openNode() {
        this.open = true;
        this.closed = false;
    }

    public void closeNode() {
        this.open = false;
        this.closed = true;
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public SearchNode getParent() {
        return this.parent;
    }

    public void setParent(SearchNode node) {
        this.parent = node;
    }

    @Override
    public int compareTo(SearchNode n) {
        return this.gValue - n.getG();
    }

    @Override
    public int compare(SearchNode n1, SearchNode n2) {
        if (n1.getG() == n2.getG()) {
            return n1.getG();
        }
        return n1.getG() - n2.getG();
    }
}

