/*
 * Decompiled with CFR 0.152.
 */
package rtr.mobs.pathfinder;

import java.util.ArrayList;
import java.util.PriorityQueue;
import org.newdawn.slick.SlickException;
import rtr.map.MapModule;
import rtr.mobs.MobBase;
import rtr.mobs.MobModule;
import rtr.mobs.pathfinder.PathNode;
import rtr.mobs.pathfinder.SearchNode;
import rtr.object.ObjectModule;
import rtr.states.StateBase;
import rtr.utilities.OrderedPair;
import rtr.utilities.Utilities;

public class PathFinder {
    private MapModule map = StateBase.getMapModule();
    private MobModule mob = StateBase.getMobModule();
    private ObjectModule object = StateBase.getObjectModule();
    private PriorityQueue<PathNode> openPathNodes = new PriorityQueue();
    private ArrayList<PathNode> resettablePathNodes = new ArrayList();
    private PriorityQueue<SearchNode> openSearchNodes = new PriorityQueue();
    private ArrayList<SearchNode> resettableSearchNodes = new ArrayList();
    private PathNode basePathNode;
    private SearchNode baseSearchNode;
    private int mapWidth = this.map.getMapWidth();
    private int mapHeight = this.map.getMapHeight();
    private PathNode[][] pathNodes;
    private SearchNode[][] searchNodes;
    byte[][] searchMap = new byte[this.mapWidth][this.mapHeight];

    public PathFinder() throws SlickException {
        this.pathNodes = new PathNode[this.mapWidth][this.mapHeight];
        this.searchNodes = new SearchNode[this.mapWidth][this.mapHeight];
        int x = 0;
        while (x < this.pathNodes.length) {
            int y = 0;
            while (y < this.pathNodes[x].length) {
                this.pathNodes[x][y] = new PathNode(x, y);
                this.searchNodes[x][y] = new SearchNode(x, y);
                ++y;
            }
            ++x;
        }
    }

    public ArrayList<OrderedPair> findPath(int startX, int startY, int goalX, int goalY) {
        if (goalX < 0 || goalX > this.map.getMapWidth() - 1 || goalY < 0 || goalY > this.map.getMapHeight() - 1) {
            return null;
        }
        if (startX == goalX && startY == goalY) {
            ArrayList<OrderedPair> returnedPath = new ArrayList<OrderedPair>();
            returnedPath.add(OrderedPair.getOrderedPair(goalX, goalY));
            return returnedPath;
        }
        boolean running = true;
        int pathVariance = Utilities.randomInt(100) + 1;
        while (running) {
            this.resetOldPathNodes();
            this.openPathNodes.clear();
            this.basePathNode = this.pathNodes[startX][startY];
            this.openPathNodes.add(this.pathNodes[startX][startY]);
            this.pathNodes[startX][startY].openNode();
            this.pathNodes[startX][startY].resetNode(goalX, goalY, pathVariance);
            this.resettablePathNodes.add(this.pathNodes[startX][startY]);
            boolean foundPath = false;
            while (!foundPath) {
                this.basePathNode = this.openPathNodes.poll();
                int thisX = this.basePathNode.getX();
                int thisY = this.basePathNode.getY();
                int x = -1;
                while (x < 2) {
                    int y = -1;
                    while (y < 2) {
                        if (!(x == 0 && y == 0 || x == 1 && y == 1 || x == 1 && y == -1 || x == -1 && y == -1 || x == -1 && y == 1)) {
                            int checkX = thisX + x;
                            int checkY = thisY + y;
                            if (checkX <= this.map.getMapWidth() - 2 && checkX >= 2 && checkY <= this.map.getMapHeight() - 2 && checkY >= 2) {
                                if (this.pathNodes[checkX][checkY].isResettable()) {
                                    this.pathNodes[checkX][checkY].resetNode(goalX, goalY, pathVariance);
                                }
                                if (!this.pathNodes[checkX][checkY].isClosed()) {
                                    this.resettablePathNodes.add(this.pathNodes[checkX][checkY]);
                                    if (!(this.map.getBlockMap()[checkX][checkY] > 0 || this.object.getObject(checkX, checkY) != null && this.object.getObject(checkX, checkY).blocksMovement())) {
                                        PathNode checkNode = this.pathNodes[checkX][checkY];
                                        int movementCost = checkNode.getM();
                                        if (this.mob.getMobAt(checkX, checkY) != null || this.object.getObject(checkX, checkY) != null) {
                                            movementCost *= 10;
                                        }
                                        if (checkNode.isOpen()) {
                                            int gValueCheck = this.basePathNode.getG() + movementCost;
                                            if (gValueCheck < checkNode.getG()) {
                                                checkNode.setParent(this.basePathNode);
                                            }
                                        } else {
                                            checkNode.openNode();
                                            checkNode.setParent(this.basePathNode);
                                            checkNode.setG(this.basePathNode.getG() + movementCost);
                                            checkNode.calcF();
                                            this.openPathNodes.add(checkNode);
                                            if (checkX == goalX && checkY == goalY) {
                                                return this.buildPath(checkNode);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        ++y;
                    }
                    ++x;
                }
                this.basePathNode.closeNode();
                if (this.openPathNodes.size() <= 0) break;
            }
            running = false;
        }
        return null;
    }

    public ArrayList<OrderedPair> getCoordinatesInRange(int startX, int startY, int range) {
        this.resetOldSearchNodes();
        int movementCostMax = range * 100;
        ArrayList<OrderedPair> list = new ArrayList<OrderedPair>();
        this.openSearchNodes.clear();
        this.baseSearchNode = this.searchNodes[startX][startY];
        this.openSearchNodes.add(this.searchNodes[startX][startY]);
        this.searchNodes[startX][startY].openNode();
        this.searchNodes[startX][startY].resetNode();
        this.resettableSearchNodes.add(this.searchNodes[startX][startY]);
        boolean foundPath = false;
        while (!foundPath) {
            this.baseSearchNode = this.openSearchNodes.poll();
            int thisX = this.baseSearchNode.getX();
            int thisY = this.baseSearchNode.getY();
            int x = -1;
            while (x < 2) {
                int y = -1;
                while (y < 2) {
                    if (!(x == 0 && y == 0 || x == 1 && y == 1 || x == 1 && y == -1 || x == -1 && y == -1 || x == -1 && y == 1)) {
                        int checkX = thisX + x;
                        int checkY = thisY + y;
                        if (checkX <= this.map.getMapWidth() - 2 && checkX >= 2 && checkY <= this.map.getMapHeight() - 2 && checkY >= 2) {
                            if (this.searchNodes[checkX][checkY].isResettable()) {
                                this.searchNodes[checkX][checkY].resetNode();
                            }
                            if (!this.searchNodes[checkX][checkY].isClosed()) {
                                this.resettableSearchNodes.add(this.searchNodes[checkX][checkY]);
                                if (!(this.map.getBlockMap()[checkX][checkY] > 0 || this.object.getObject(checkX, checkY) != null && this.object.getObject(checkX, checkY).blocksMovement())) {
                                    SearchNode checkNode = this.searchNodes[checkX][checkY];
                                    int movementCost = checkNode.getM();
                                    if (checkNode.isOpen()) {
                                        int n = this.baseSearchNode.getG() + movementCost;
                                    } else {
                                        checkNode.openNode();
                                        if (this.baseSearchNode.getG() + movementCost <= movementCostMax) {
                                            checkNode.setG(this.baseSearchNode.getG() + movementCost);
                                            this.openSearchNodes.add(checkNode);
                                            list.add(OrderedPair.getOrderedPair(checkX, checkY));
                                        }
                                    }
                                }
                            }
                        }
                    }
                    ++y;
                }
                ++x;
            }
            this.baseSearchNode.closeNode();
            if (this.openSearchNodes.size() <= 0) break;
        }
        return list;
    }

    public ArrayList<OrderedPair> buildPath(PathNode node) {
        ArrayList<OrderedPair> returnedPath = new ArrayList<OrderedPair>();
        PathNode nextNode = node;
        OrderedPair nextPair = OrderedPair.getOrderedPair(node.getX(), node.getY());
        returnedPath.add(nextPair);
        while (nextNode.getParent() != null) {
            nextNode = nextNode.getParent();
            nextPair = OrderedPair.getOrderedPair(nextNode.getX(), nextNode.getY());
            returnedPath.add(nextPair);
        }
        return returnedPath;
    }

    public ArrayList<OrderedPair> buildPath(SearchNode node) {
        ArrayList<OrderedPair> returnedPath = new ArrayList<OrderedPair>();
        SearchNode nextNode = node;
        OrderedPair nextPair = OrderedPair.getOrderedPair(node.getX(), node.getY());
        returnedPath.add(nextPair);
        while (nextNode.getParent() != null) {
            nextNode = nextNode.getParent();
            nextPair = OrderedPair.getOrderedPair(nextNode.getX(), nextNode.getY());
            returnedPath.add(nextPair);
        }
        return returnedPath;
    }

    private void resetOldSearchNodes() {
        for (SearchNode s : this.resettableSearchNodes) {
            this.searchMap[s.getX()][s.getY()] = 0;
            s.flagResettable();
        }
        this.resettableSearchNodes.clear();
    }

    private void resetOldPathNodes() {
        for (PathNode p : this.resettablePathNodes) {
            p.flagResettable();
        }
        this.resettablePathNodes.clear();
    }

    public MobBase mobFetch(ArrayList<MobBase> mobList, int x, int y) throws SlickException {
        int i = 0;
        while (i < mobList.size()) {
            MobBase mob = mobList.get(i);
            if (mob.getTileX() == x && mob.getTileY() == y) {
                return mob;
            }
            ++i;
        }
        return null;
    }
}

