/*
 * Decompiled with CFR 0.152.
 */
package rtr.mobs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Properties;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;
import rtr.ModuleBase;
import rtr.mobs.MobBase;
import rtr.mobs.MobHero;
import rtr.mobs.MobZombie;
import rtr.mobs.pathfinder.PathFinder;
import rtr.mobs.spritesheet.MobSprite;
import rtr.mobs.spritesheet.MobSpriteLoader;
import rtr.states.StateBase;
import rtr.system.ScaleControl;
import rtr.utilities.OrderedPair;
import rtr.utilities.Utilities;

public class MobModule
extends ModuleBase {
    private MobSpriteLoader mobSpriteLoader;
    private ArrayList<MobBase> mobArrayUpdate = new ArrayList();
    private ArrayList<MobBase> mobArrayRender = new ArrayList();
    private HashMap<Integer, MobBase> mobMaster = new HashMap();
    private MobBase hero;
    private ArrayList<MobBase> mobRemove = new ArrayList();
    private ArrayList<MobBase> mobAdd = new ArrayList();
    private int mobID;
    private MobBase[][] mobLocationMap;
    private MobBase[][] futureMobLocationMap;
    private MobBase[][] pastMobLocationMap;
    private PathFinder pathFinder;
    private int noiseLevel;
    private int noiseLevelMax = 30;
    private int noiseReductionTick;

    @Override
    public void initModule(StateBase cS) throws SlickException {
        super.initModule(cS);
        if (this.pathFinder == null) {
            this.pathFinder = new PathFinder();
        }
        if (this.mobSpriteLoader == null) {
            this.mobSpriteLoader = new MobSpriteLoader();
        }
        if (this.mobLocationMap == null) {
            this.mobLocationMap = new MobBase[this.map.getMapWidth()][this.map.getMapHeight()];
        }
        if (this.futureMobLocationMap == null) {
            this.futureMobLocationMap = new MobBase[this.map.getMapWidth()][this.map.getMapHeight()];
        }
        if (this.pastMobLocationMap == null) {
            this.pastMobLocationMap = new MobBase[this.map.getMapWidth()][this.map.getMapHeight()];
        }
        this.initLoad();
    }

    @Override
    public void resetModule() throws SlickException {
        super.resetModule();
        this.mobArrayUpdate.clear();
        this.mobMaster.clear();
        this.mobRemove.clear();
        this.mobAdd.clear();
        this.mobID = 0;
        this.mobLocationMap = null;
        this.futureMobLocationMap = null;
        this.pastMobLocationMap = null;
        this.noiseLevel = 0;
        this.noiseLevelMax = 30;
        this.noiseReductionTick = 0;
    }

    @Override
    protected void loadPlay() throws SlickException {
        int randomX = 32 + Utilities.randomInt(this.map.getMapWidth() - 64);
        int randomY = 32 + Utilities.randomInt(this.map.getMapHeight() - 64);
        while (this.map.getBlockMap()[randomX][randomY] == 1) {
            randomX = 32 + Utilities.randomInt(this.map.getMapWidth() - 64);
            randomY = 32 + Utilities.randomInt(this.map.getMapHeight() - 64);
        }
        this.hero = this.newMob(randomX, randomY, MobBase.MobType.HERO);
        this.hero.makeHero();
        int x = 0;
        while (x < 128) {
            randomX = 32 + Utilities.randomInt(this.map.getMapWidth() - 64);
            randomY = 32 + Utilities.randomInt(this.map.getMapHeight() - 64);
            while (this.map.getBlockMap()[randomX][randomY] == 1 || !this.canMoveTo(randomX, randomY)) {
                randomX = 32 + Utilities.randomInt(this.map.getMapWidth() - 64);
                randomY = 32 + Utilities.randomInt(this.map.getMapHeight() - 64);
            }
            this.newMob(randomX, randomY, MobBase.MobType.ZOMBIE);
            ++x;
        }
    }

    @Override
    protected void newPlay() throws SlickException {
    }

    public void initLoadSync() throws SlickException {
        this.synced = true;
    }

    public Properties getPlayProperties() {
        Properties properties = new Properties();
        return properties;
    }

    public void render(Graphics g) throws SlickException {
        int displayWidth = ScaleControl.getWidth();
        int displayHeight = ScaleControl.getHeight();
        float mapX = this.map.getMapX();
        float mapY = this.map.getMapY();
        this.mobArrayRender.clear();
        for (MobBase m : this.mobArrayUpdate) {
            float mobX = m.getMobX();
            float mobY = m.getMobY();
            if (!(mobX + mapX > -10.0f) || !(mobX + mapX < (float)(displayWidth + 10)) || !(mobY + mapY > -10.0f) || !(mobY + mapY < (float)(displayHeight + 10))) continue;
            this.mobArrayRender.add(m);
        }
        Collections.sort(this.mobArrayRender, new Comparator<MobBase>(){

            @Override
            public int compare(MobBase m1, MobBase m2) {
                if (m1 == m2) {
                    return 0;
                }
                return (int)m1.getMobY() - (int)m2.getMobY();
            }
        });
        if (this.mobArrayRender.size() > 0) {
            this.mobSpriteLoader.getBaseSpriteSheet().startUse();
            for (MobBase m : this.mobArrayRender) {
                m.render();
            }
            this.mobSpriteLoader.getBaseSpriteSheet().endUse();
            for (MobBase m : this.mobArrayRender) {
                m.renderOverlay();
            }
        }
    }

    public void update() throws SlickException {
        this.updateMobArrays();
        for (MobBase m : this.mobArrayUpdate) {
            m.updateConstant();
        }
    }

    public boolean updateTurnProcess() {
        for (MobBase m : this.mobArrayUpdate) {
            if (m == this.hero) continue;
            m.processTurn();
        }
        Collections.sort(this.mobArrayUpdate, new Comparator<MobBase>(){

            @Override
            public int compare(MobBase m1, MobBase m2) {
                if (m1 == m2) {
                    return 0;
                }
                return m1.getCommandState().ordinal() - m2.getCommandState().ordinal();
            }
        });
        System.out.println("0-0-0-0-0-0-0-");
        for (MobBase m : this.mobArrayUpdate) {
            if (m == this.hero) {
                System.out.println((Object)((Object)m.getCommandState()) + " (HERO!!)");
                continue;
            }
            System.out.println((Object)m.getCommandState());
        }
        return true;
    }

    public boolean updateTurnExecute() {
        for (MobBase m : this.mobArrayUpdate) {
            m.executeTurn();
        }
        for (MobBase m : this.mobArrayUpdate) {
            if (m.getCommandState() == MobBase.MobCommand.COMPLETE || m.getCommandState() == MobBase.MobCommand.DEAD) continue;
            return false;
        }
        return true;
    }

    public boolean updateTurnCleanup() {
        int i = 0;
        while (i < this.mobLocationMap.length) {
            Arrays.fill(this.mobLocationMap[i], null);
            ++i;
        }
        i = 0;
        while (i < this.mobLocationMap.length) {
            Arrays.fill(this.futureMobLocationMap[i], null);
            ++i;
        }
        i = 0;
        while (i < this.mobLocationMap.length) {
            Arrays.fill(this.pastMobLocationMap[i], null);
            ++i;
        }
        for (MobBase m : this.mobArrayUpdate) {
            if (m.getCommandState() == MobBase.MobCommand.DEAD) continue;
            this.mobLocationMap[m.getTileX()][m.getTileY()] = m;
        }
        this.noiseReductionTick = this.noiseLevel > 20 ? (this.noiseReductionTick += 5) : (this.noiseLevel > 15 ? (this.noiseReductionTick += 4) : (this.noiseLevel > 10 ? (this.noiseReductionTick += 3) : (this.noiseLevel > 5 ? (this.noiseReductionTick += 2) : ++this.noiseReductionTick)));
        if (this.noiseReductionTick >= 5) {
            this.decreaseNoiseLevel(1);
            this.noiseReductionTick = 0;
        }
        return true;
    }

    public void increaseNoiseLevel(int i) {
        this.noiseLevel += i;
        if (this.noiseLevel > this.noiseLevelMax) {
            this.noiseLevel = this.noiseLevelMax;
        }
        this.noiseReductionTick = 0;
    }

    public void decreaseNoiseLevel(int i) {
        this.noiseLevel -= i;
        if (this.noiseLevel < 0) {
            this.noiseLevel = 0;
        }
    }

    public int getNoiseLevel() {
        return this.noiseLevel;
    }

    public int getNoiseLevelMax() {
        return this.noiseLevelMax;
    }

    private void updateMobArrays() {
        int e;
        if (this.mobRemove.size() > 0) {
            e = 0;
            while (e < this.mobRemove.size()) {
                this.mobArrayUpdate.remove(this.mobRemove.get(e));
                this.mobMaster.remove(this.mobRemove.get(e).getID());
                ++e;
            }
            this.mobRemove.clear();
        }
        if (this.mobAdd.size() > 0) {
            e = 0;
            while (e < this.mobAdd.size()) {
                this.mobArrayUpdate.add(this.mobAdd.get(e));
                this.mobMaster.put(this.mobAdd.get(e).getID(), this.mobAdd.get(e));
                ++e;
            }
            this.mobAdd.clear();
        }
    }

    public MobBase newMob(int x, int y, MobBase.MobType type) throws SlickException {
        int nextID = this.getNextID();
        MobBase out = null;
        switch (type) {
            case HERO: {
                out = new MobHero(nextID, x, y);
                break;
            }
            case ZOMBIE: {
                out = new MobZombie(nextID, x, y);
            }
        }
        this.mobAdd.add(out);
        this.mobLocationMap[x][y] = out;
        return out;
    }

    public void removeMob(MobBase m) {
        this.mobRemove.add(m);
    }

    public MobSprite createMobSpriteSheet(MobBase.MobType mobType, MobBase.MobGender mobGender) throws SlickException {
        return this.mobSpriteLoader.createNewMobSprite(mobType, mobGender);
    }

    public MobBase[][] getMobLocationMap() {
        return this.mobLocationMap;
    }

    public int getNextID() {
        int ID = this.mobID++;
        return ID;
    }

    public ArrayList<MobBase> getMobArray() {
        return this.mobArrayUpdate;
    }

    public HashMap<Integer, MobBase> getMobHashMap() {
        return this.mobMaster;
    }

    public MobBase getHero() {
        return this.hero;
    }

    public PathFinder getPathfinder() {
        return this.pathFinder;
    }

    public boolean canMoveTo(int x, int y, boolean ignoreHero) {
        return this.map.getBlockMap()[x][y] == 0 && (this.mobLocationMap[x][y] == null || this.pastMobLocationMap[x][y] != null || ignoreHero && this.mobLocationMap[x][y] == this.hero) && (this.futureMobLocationMap[x][y] == null || ignoreHero && this.futureMobLocationMap[x][y] == this.hero) && (this.object.getObject(x, y) == null || this.object.getObject(x, y) != null && !this.object.getObject(x, y).blocksMovement());
    }

    public boolean canMoveTo(int x, int y) {
        return this.map.getBlockMap()[x][y] == 0 && (this.mobLocationMap[x][y] == null || this.pastMobLocationMap[x][y] != null) && this.futureMobLocationMap[x][y] == null && (this.object.getObject(x, y) == null || this.object.getObject(x, y) != null && !this.object.getObject(x, y).blocksMovement());
    }

    public void addFuturePositionData(int x, int y, MobBase m) {
        this.futureMobLocationMap[x][y] = m;
    }

    public void addPastPositionData(int x, int y, MobBase m) {
        this.pastMobLocationMap[x][y] = m;
    }

    public MobBase getMobAt(int x, int y) {
        return this.mobLocationMap[x][y];
    }

    public ArrayList<MobBase> getMobsNearby(int tileX, int tileY, int distance) {
        ArrayList<MobBase> list = new ArrayList<MobBase>();
        for (MobBase m : this.mobArrayUpdate) {
            int dy;
            int dx = tileX - m.getTileX();
            int hValue = (int)Math.sqrt(dx * dx + (dy = tileY - m.getTileY()) * dy);
            if (hValue >= distance) continue;
            list.add(m);
        }
        return list;
    }

    public boolean canReachHero(int tileX, int tileY) {
        int x = -1;
        while (x < 2) {
            int y = -1;
            while (y < 2) {
                if (!(x == 0 && y == 0 || x == 1 && y == 1 || x == 1 && y == -1 || x == -1 && y == -1 || x == -1 && y == 1 || this.mobLocationMap[x + tileX][y + tileY] != this.hero)) {
                    return true;
                }
                ++y;
            }
            ++x;
        }
        return false;
    }

    public boolean isHeroNearby(int tileX, int tileY, int distance) {
        ArrayList<OrderedPair> nearbyCoordinates = this.pathFinder.getCoordinatesInRange(tileX, tileY, distance);
        return nearbyCoordinates.contains(OrderedPair.getOrderedPair(this.hero.getTileX(), this.hero.getTileY()));
    }
}

