/*
 * Decompiled with CFR 0.152.
 */
package rtr.mobs;

import java.util.ArrayList;
import org.newdawn.slick.Color;
import org.newdawn.slick.SlickException;
import rtr.console.Console;
import rtr.font.FontModule;
import rtr.item.ItemBase;
import rtr.item.ItemModule;
import rtr.lighting.Light;
import rtr.map.MapModule;
import rtr.mobs.MobModule;
import rtr.mobs.spritesheet.MobSprite;
import rtr.object.ObjectBase;
import rtr.object.ObjectModule;
import rtr.particles.ParticleModule;
import rtr.particles.projectiles.ProjectileModule;
import rtr.states.PlayState;
import rtr.states.StateBase;
import rtr.system.Game;
import rtr.system.ScaleControl;
import rtr.utilities.OrderedPair;
import rtr.utilities.Utilities;

public class MobBase {
    protected MapModule map = StateBase.getMapModule();
    protected MobModule mob = StateBase.getMobModule();
    protected ItemModule item = StateBase.getItemModule();
    protected FontModule font = StateBase.getFontModule();
    protected ObjectModule object = StateBase.getObjectModule();
    protected ParticleModule particle = StateBase.getParticleModule();
    protected ProjectileModule projectile = StateBase.getProjectileModule();
    protected static final int EQUIP_SLOT_RING_ONE = 0;
    protected static final int EQUIP_SLOT_HEAD = 1;
    protected static final int EQUIP_SLOT_RING_TWO = 2;
    protected static final int EQUIP_SLOT_WEAPON = 3;
    protected static final int EQUIP_SLOT_CHEST = 4;
    protected static final int EQUIP_SLOT_SHIELD = 5;
    protected static final int INVENTORY_START = 6;
    protected int mobID;
    protected int tileX;
    protected int tileY;
    protected float mobX;
    protected float mobY;
    protected float renderX;
    protected float renderY;
    protected int renderOffsetX;
    protected int renderOffsetY;
    protected MobType mobType;
    protected MobGroup mobGroup;
    protected MobGender mobGender;
    protected MobCommand mobCommand;
    protected MobDirection mobCommandDirection;
    protected ItemBase mobCommandItem;
    protected MobSprite sprite;
    protected int level;
    protected int experience;
    protected int experienceMultiplier;
    protected int hitPoints;
    protected int hitPointsMax;
    protected int hunger;
    protected int hungerMax;
    protected int hungerDecreaseRate;
    protected int hungerDecreaseRateTick;
    protected int energy;
    protected int energyMax;
    protected int energyDecreaseRate;
    protected int energyDecreaseRateTick;
    protected int coins;
    protected ItemBase[] inventory;
    protected int randomWanderChance;
    protected int baseAggroDistance;
    protected int actionTime;
    protected ParticleModule.ParticleSet bloodType;
    protected boolean stunned;
    protected boolean hero;
    protected byte lightRadius;
    protected byte lightIntensity;
    protected Light light;
    protected Color[] colorLayers = new Color[6];

    public byte getLightRadius() {
        return this.lightRadius;
    }

    public byte getLightIntensity() {
        return this.lightIntensity;
    }

    public Light getLight() {
        return this.light;
    }

    public Color[] getColorLayers() {
        return this.colorLayers;
    }

    public MobBase(int id, int x, int y) throws SlickException {
        this.mobID = id;
        this.tileX = x;
        this.tileY = y;
        this.mobX = x * this.map.getTileWidth();
        this.mobY = y * this.map.getTileHeight();
        this.renderX = this.mobX;
        this.renderY = this.mobY - 6.0f;
        this.renderOffsetX = Utilities.randomInt(-2, 2);
        this.renderOffsetY = Utilities.randomInt(-2, 2);
        int c = 0;
        while (c < this.colorLayers.length) {
            this.colorLayers[c] = new Color(-1);
            ++c;
        }
        this.mobCommand = MobCommand.IDLE;
    }

    public void render() throws SlickException {
        int displayWidth = ScaleControl.getWidth();
        int displayHeight = ScaleControl.getHeight();
        float mapX = this.map.getMapX();
        float mapY = this.map.getMapY();
        if (this.mobX + mapX > -10.0f && this.mobX + mapX < (float)(displayWidth + 10) && this.mobY + mapY > -10.0f && this.mobY + mapY < (float)(displayHeight + 10)) {
            this.sprite.render(this.renderX + (float)this.renderOffsetX + mapX, this.renderY + (float)this.renderOffsetY + mapY, 0, this.colorLayers, 1.0f, false, false, false, false, true);
        }
    }

    public void renderSprite(int x, int y) throws SlickException {
        this.sprite.render(x, y, 0, this.colorLayers, 1.0f, false, false, false, false, false);
    }

    public void renderOverlay() throws SlickException {
        if (this.mobCommand == MobCommand.DEAD || this.hero) {
            return;
        }
        int displayWidth = ScaleControl.getWidth();
        int displayHeight = ScaleControl.getHeight();
        float mapX = this.map.getMapX();
        float mapY = this.map.getMapY();
        if (this.mobX + mapX > -10.0f && this.mobX + mapX < (float)(displayWidth + 10) && this.mobY + mapY > -10.0f && this.mobY + mapY < (float)(displayHeight + 10)) {
            this.font.drawString(this.renderX + (float)this.renderOffsetX + mapX, this.renderY + (float)this.renderOffsetY + mapY + 8.0f, String.valueOf(this.hitPoints), 0);
        }
    }

    public void updateConstant() throws SlickException {
        this.renderX = this.mobX;
        this.renderY = this.mobY - 6.0f;
        this.sprite.update();
        if (this.stunned && Utilities.randomInt(10) == 0) {
            this.particle.newParticle(this.getCenterPixelX(true) + Utilities.randomInt(-1, 1), this.getCenterPixelY(true) - 7, ParticleModule.ParticleType.FIRE, ParticleModule.ParticleSet.FIRE_YELLOW);
            this.projectile.newEnergyRing(this.getCenterPixelX(true) + Utilities.randomInt(-1, 1), this.getCenterPixelY(true) - 7, 2, ParticleModule.ParticleSet.FIRE_YELLOW);
        }
        if (this.hitPoints == 1 && Utilities.randomInt(6) == 1) {
            this.particle.newParticle((float)(this.getCenterPixelX(true) + Utilities.randomInt(-2, 2)), (float)(this.getCenterPixelY(true) + 6 + Utilities.randomInt(-2, 2)), 90.0f, ParticleModule.ParticleType.BLOOD_POOL, this.bloodType);
        }
    }

    public void processTurn() {
        if (this.mobCommand == MobCommand.DEAD) {
            return;
        }
        if (this.stunned) {
            this.mobCommand = MobCommand.IDLE;
            this.stunned = false;
        } else if (this.mob.canReachHero(this.tileX, this.tileY)) {
            MobBase hero = this.mob.getHero();
            ArrayList<OrderedPair> path = this.mob.getPathfinder().findPath(this.tileX, this.tileY, hero.getTileX(), hero.getTileY());
            if (path != null) {
                OrderedPair o = path.get(path.size() - 2);
                if (hero.getTileY() < this.tileY) {
                    this.commandAttack(MobDirection.NORTH);
                } else if (hero.getTileY() > this.tileY) {
                    this.commandAttack(MobDirection.SOUTH);
                } else if (hero.getTileX() > this.tileX) {
                    this.commandAttack(MobDirection.EAST);
                } else if (hero.getTileX() < this.tileX) {
                    this.commandAttack(MobDirection.WEST);
                }
            }
        } else if (this.mob.isHeroNearby(this.tileX, this.tileY, this.baseAggroDistance + this.mob.getNoiseLevel())) {
            MobBase hero = this.mob.getHero();
            ArrayList<OrderedPair> path = this.mob.getPathfinder().findPath(this.tileX, this.tileY, hero.getTileX(), hero.getTileY());
            if (path != null) {
                OrderedPair o = path.get(path.size() - 2);
                if (o.getY() < this.tileY) {
                    if (this.object.getObject(o.getX(), o.getY()) != null && this.object.getObject(o.getX(), o.getY()).isDoor()) {
                        this.commandOpenDoor(MobDirection.NORTH);
                    } else {
                        this.commandMove(MobDirection.NORTH);
                    }
                } else if (o.getY() > this.tileY) {
                    if (this.object.getObject(o.getX(), o.getY()) != null && this.object.getObject(o.getX(), o.getY()).isDoor()) {
                        this.commandOpenDoor(MobDirection.SOUTH);
                    } else {
                        this.commandMove(MobDirection.SOUTH);
                    }
                } else if (o.getX() > this.tileX) {
                    if (this.object.getObject(o.getX(), o.getY()) != null && this.object.getObject(o.getX(), o.getY()).isDoor()) {
                        this.commandOpenDoor(MobDirection.EAST);
                    } else {
                        this.commandMove(MobDirection.EAST);
                    }
                } else if (o.getX() < this.tileX) {
                    if (this.object.getObject(o.getX(), o.getY()) != null && this.object.getObject(o.getX(), o.getY()).isDoor()) {
                        this.commandOpenDoor(MobDirection.WEST);
                    } else {
                        this.commandMove(MobDirection.WEST);
                    }
                }
            }
        } else if (Utilities.randomInt(this.randomWanderChance) == 0) {
            switch (Utilities.randomInt(4)) {
                case 0: {
                    if (!this.mob.canMoveTo(this.tileX, this.tileY - 1)) break;
                    this.commandMove(MobDirection.NORTH);
                    break;
                }
                case 1: {
                    if (!this.mob.canMoveTo(this.tileX, this.tileY + 1)) break;
                    this.commandMove(MobDirection.SOUTH);
                    break;
                }
                case 2: {
                    if (!this.mob.canMoveTo(this.tileX + 1, this.tileY)) break;
                    this.commandMove(MobDirection.EAST);
                    break;
                }
                case 3: {
                    if (!this.mob.canMoveTo(this.tileX - 1, this.tileY)) break;
                    this.commandMove(MobDirection.WEST);
                }
            }
        }
    }

    public boolean commandOpenDoor(MobDirection p) {
        switch (p) {
            case NORTH: {
                if (this.object.getObject(this.tileX, this.tileY - 1) == null || !this.object.getObject(this.tileX, this.tileY - 1).isDoor()) break;
                this.mobCommandDirection = p;
                this.mobCommand = MobCommand.OPEN_DOOR;
                return true;
            }
            case SOUTH: {
                if (this.object.getObject(this.tileX, this.tileY + 1) == null || !this.object.getObject(this.tileX, this.tileY + 1).isDoor()) break;
                this.mobCommandDirection = p;
                this.mobCommand = MobCommand.OPEN_DOOR;
                return true;
            }
            case EAST: {
                if (this.object.getObject(this.tileX + 1, this.tileY) == null || !this.object.getObject(this.tileX + 1, this.tileY).isDoor()) break;
                this.mobCommandDirection = p;
                this.mobCommand = MobCommand.OPEN_DOOR;
                return true;
            }
            case WEST: {
                if (this.object.getObject(this.tileX - 1, this.tileY) == null || !this.object.getObject(this.tileX - 1, this.tileY).isDoor()) break;
                this.mobCommandDirection = p;
                this.mobCommand = MobCommand.OPEN_DOOR;
                return true;
            }
        }
        return false;
    }

    public boolean commandOpenContainer(MobDirection p) {
        switch (p) {
            case NORTH: {
                if (this.object.getObject(this.tileX, this.tileY - 1) == null || !this.object.getObject(this.tileX, this.tileY - 1).isContainer()) break;
                this.mobCommandDirection = p;
                this.mobCommand = MobCommand.OPEN_CONTAINER;
                return true;
            }
            case SOUTH: {
                if (this.object.getObject(this.tileX, this.tileY + 1) == null || !this.object.getObject(this.tileX, this.tileY + 1).isContainer()) break;
                this.mobCommandDirection = p;
                this.mobCommand = MobCommand.OPEN_CONTAINER;
                return true;
            }
            case EAST: {
                if (this.object.getObject(this.tileX + 1, this.tileY) == null || !this.object.getObject(this.tileX + 1, this.tileY).isContainer()) break;
                this.mobCommandDirection = p;
                this.mobCommand = MobCommand.OPEN_CONTAINER;
                return true;
            }
            case WEST: {
                if (this.object.getObject(this.tileX - 1, this.tileY) == null || !this.object.getObject(this.tileX - 1, this.tileY).isContainer()) break;
                this.mobCommandDirection = p;
                this.mobCommand = MobCommand.OPEN_CONTAINER;
                return true;
            }
        }
        return false;
    }

    public boolean commandAttack(MobDirection p) {
        switch (p) {
            case NORTH: {
                if (this.mob.getMobAt(this.tileX, this.tileY - 1) == null) break;
                this.mobCommandDirection = p;
                this.mobCommand = MobCommand.ATTACK;
                return true;
            }
            case SOUTH: {
                if (this.mob.getMobAt(this.tileX, this.tileY + 1) == null) break;
                this.mobCommandDirection = p;
                this.mobCommand = MobCommand.ATTACK;
                return true;
            }
            case EAST: {
                if (this.mob.getMobAt(this.tileX + 1, this.tileY) == null) break;
                this.mobCommandDirection = p;
                this.mobCommand = MobCommand.ATTACK;
                return true;
            }
            case WEST: {
                if (this.mob.getMobAt(this.tileX - 1, this.tileY) == null) break;
                this.mobCommandDirection = p;
                this.mobCommand = MobCommand.ATTACK;
                return true;
            }
        }
        return false;
    }

    public boolean commandMove(MobDirection p) {
        switch (p) {
            case NORTH: {
                if (!this.mob.canMoveTo(this.tileX, this.tileY - 1)) break;
                this.mobCommandDirection = p;
                this.mobCommand = MobCommand.MOVE;
                this.mob.addFuturePositionData(this.tileX, this.tileY - 1, this);
                return true;
            }
            case SOUTH: {
                if (!this.mob.canMoveTo(this.tileX, this.tileY + 1)) break;
                this.mobCommandDirection = p;
                this.mobCommand = MobCommand.MOVE;
                this.mob.addFuturePositionData(this.tileX, this.tileY + 1, this);
                return true;
            }
            case EAST: {
                if (!this.mob.canMoveTo(this.tileX + 1, this.tileY)) break;
                this.mobCommandDirection = p;
                this.mobCommand = MobCommand.MOVE;
                this.mob.addFuturePositionData(this.tileX + 1, this.tileY, this);
                return true;
            }
            case WEST: {
                if (!this.mob.canMoveTo(this.tileX - 1, this.tileY)) break;
                this.mobCommandDirection = p;
                this.mobCommand = MobCommand.MOVE;
                this.mob.addFuturePositionData(this.tileX - 1, this.tileY, this);
                return true;
            }
        }
        return false;
    }

    public boolean commandEat(ItemBase i) {
        if (this.hunger >= this.hungerMax || i == null || i.getFoodValue() <= 0) {
            return false;
        }
        this.mobCommandItem = i;
        this.mobCommand = MobCommand.EAT;
        return true;
    }

    public boolean commandDrop(ItemBase i) {
        if (i == null) {
            return false;
        }
        this.mobCommandItem = i;
        this.mobCommand = MobCommand.DROP;
        return true;
    }

    public boolean commandPickup(ItemBase i) {
        if (i == null) {
            return false;
        }
        this.mobCommandItem = i;
        this.mobCommand = MobCommand.PICKUP;
        return true;
    }

    public void executeTurn() {
        boolean completed = false;
        if (this.mobCommand == MobCommand.DEAD) {
            completed = true;
            return;
        }
        if (this.stunned) {
            this.mobCommand = MobCommand.IDLE;
        }
        switch (this.mobCommand) {
            case ATTACK: {
                completed = this.executeAttack(this.mobCommandDirection);
                break;
            }
            case EAT: {
                completed = this.executeEat(this.mobCommandDirection);
                break;
            }
            case DROP: {
                completed = this.executeDrop(this.mobCommandDirection);
                break;
            }
            case PICKUP: {
                completed = this.executePickup(this.mobCommandDirection);
                break;
            }
            case OPEN_DOOR: {
                completed = this.executeOpenDoor(this.mobCommandDirection);
                break;
            }
            case OPEN_CONTAINER: {
                completed = this.executeOpenContainer(this.mobCommandDirection);
                break;
            }
            case MOVE: {
                completed = this.executeMove(this.mobCommandDirection);
                break;
            }
            case IDLE: {
                completed = true;
            }
        }
        if (completed) {
            this.completeTurn();
        }
    }

    private boolean executeAttack(MobDirection p) {
        if (this.actionTime == 0) {
            switch (p) {
                case NORTH: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.ATTACK_NORTH);
                    break;
                }
                case SOUTH: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.ATTACK_SOUTH);
                    break;
                }
                case WEST: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.ATTACK_WEST);
                    break;
                }
                case EAST: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.ATTACK_EAST);
                }
            }
        } else if (this.actionTime == 16) {
            switch (p) {
                case NORTH: {
                    this.mob.getMobAt(this.tileX, this.tileY - 1).takeDamage(this.getCenterPixelX(true), this.getCenterPixelY(true), 1);
                    if (this.mob.getMobAt(this.tileX, this.tileY - 1).getCommandState() != MobCommand.DEAD) break;
                    this.increaseExperience(5);
                    break;
                }
                case SOUTH: {
                    this.mob.getMobAt(this.tileX, this.tileY + 1).takeDamage(this.getCenterPixelX(true), this.getCenterPixelY(true), 1);
                    if (this.mob.getMobAt(this.tileX, this.tileY + 1).getCommandState() != MobCommand.DEAD) break;
                    this.increaseExperience(5);
                    break;
                }
                case WEST: {
                    this.mob.getMobAt(this.tileX - 1, this.tileY).takeDamage(this.getCenterPixelX(true), this.getCenterPixelY(true), 1);
                    if (this.mob.getMobAt(this.tileX - 1, this.tileY).getCommandState() != MobCommand.DEAD) break;
                    this.increaseExperience(5);
                    break;
                }
                case EAST: {
                    this.mob.getMobAt(this.tileX + 1, this.tileY).takeDamage(this.getCenterPixelX(true), this.getCenterPixelY(true), 1);
                    if (this.mob.getMobAt(this.tileX + 1, this.tileY).getCommandState() != MobCommand.DEAD) break;
                    this.increaseExperience(5);
                }
            }
            if (this.hero) {
                this.mob.increaseNoiseLevel(2);
            }
        }
        ++this.actionTime;
        if (this.actionTime > 32) {
            switch (p) {
                case NORTH: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.FACE_NORTH);
                    break;
                }
                case SOUTH: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.FACE_SOUTH);
                    break;
                }
                case WEST: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.FACE_WEST);
                    break;
                }
                case EAST: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.FACE_EAST);
                }
            }
            return true;
        }
        return false;
    }

    private boolean executeOpenDoor(MobDirection p) {
        if (this.actionTime == 0) {
            switch (p) {
                case NORTH: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.ATTACK_NORTH);
                    break;
                }
                case SOUTH: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.ATTACK_SOUTH);
                    break;
                }
                case WEST: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.ATTACK_WEST);
                    break;
                }
                case EAST: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.ATTACK_EAST);
                }
            }
        } else if (this.actionTime == 16) {
            switch (p) {
                case NORTH: {
                    this.object.getObject(this.tileX, this.tileY - 1).open();
                    break;
                }
                case SOUTH: {
                    this.object.getObject(this.tileX, this.tileY + 1).open();
                    break;
                }
                case WEST: {
                    this.object.getObject(this.tileX - 1, this.tileY).open();
                    break;
                }
                case EAST: {
                    this.object.getObject(this.tileX + 1, this.tileY).open();
                }
            }
            if (this.hero) {
                this.mob.increaseNoiseLevel(1);
            }
        }
        ++this.actionTime;
        if (this.actionTime > 32) {
            switch (p) {
                case NORTH: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.FACE_NORTH);
                    break;
                }
                case SOUTH: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.FACE_SOUTH);
                    break;
                }
                case WEST: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.FACE_WEST);
                    break;
                }
                case EAST: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.FACE_EAST);
                }
            }
            return true;
        }
        return false;
    }

    private boolean executeOpenContainer(MobDirection p) {
        if (this.actionTime == 0) {
            switch (p) {
                case NORTH: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.ATTACK_NORTH);
                    break;
                }
                case SOUTH: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.ATTACK_SOUTH);
                    break;
                }
                case WEST: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.ATTACK_WEST);
                    break;
                }
                case EAST: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.ATTACK_EAST);
                }
            }
        } else if (this.actionTime == 20) {
            switch (p) {
                case NORTH: {
                    this.object.getObject(this.tileX, this.tileY - 1).open();
                    ((PlayState)Game.getCS()).getGUI().openContainer(this.object.getObject(this.tileX, this.tileY - 1));
                    break;
                }
                case SOUTH: {
                    this.object.getObject(this.tileX, this.tileY + 1).open();
                    ((PlayState)Game.getCS()).getGUI().openContainer(this.object.getObject(this.tileX, this.tileY + 1));
                    break;
                }
                case WEST: {
                    this.object.getObject(this.tileX - 1, this.tileY).open();
                    ((PlayState)Game.getCS()).getGUI().openContainer(this.object.getObject(this.tileX - 1, this.tileY));
                    break;
                }
                case EAST: {
                    this.object.getObject(this.tileX + 1, this.tileY).open();
                    ((PlayState)Game.getCS()).getGUI().openContainer(this.object.getObject(this.tileX + 1, this.tileY));
                }
            }
            if (this.hero) {
                this.mob.increaseNoiseLevel(1);
            }
        }
        ++this.actionTime;
        if (this.actionTime > 32) {
            switch (p) {
                case NORTH: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.FACE_NORTH);
                    break;
                }
                case SOUTH: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.FACE_SOUTH);
                    break;
                }
                case WEST: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.FACE_WEST);
                    break;
                }
                case EAST: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.FACE_EAST);
                }
            }
            return true;
        }
        return false;
    }

    private boolean executeMove(MobDirection p) {
        float speed = 1.0f;
        switch (p) {
            case NORTH: {
                this.sprite.setPosition(MobSprite.MobAnimationFrames.WALK_NORTH);
                this.mobY -= speed;
                break;
            }
            case SOUTH: {
                this.sprite.setPosition(MobSprite.MobAnimationFrames.WALK_SOUTH);
                this.mobY += speed;
                break;
            }
            case WEST: {
                this.sprite.setPosition(MobSprite.MobAnimationFrames.WALK_WEST);
                this.mobX -= speed;
                break;
            }
            case EAST: {
                this.sprite.setPosition(MobSprite.MobAnimationFrames.WALK_EAST);
                this.mobX += speed;
            }
        }
        if (Math.abs(this.mobX - (float)(this.tileX * this.map.getTileWidth())) >= 16.0f || Math.abs(this.mobY - (float)(this.tileY * this.map.getTileHeight())) >= 16.0f) {
            switch (p) {
                case NORTH: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.FACE_NORTH);
                    break;
                }
                case SOUTH: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.FACE_SOUTH);
                    break;
                }
                case WEST: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.FACE_WEST);
                    break;
                }
                case EAST: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.FACE_EAST);
                }
            }
            this.tileUpdate();
            return true;
        }
        return false;
    }

    private boolean executeEat(MobDirection p) {
        if (this.actionTime == 0) {
            switch (p) {
                case NORTH: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.EAT_NORTH);
                    break;
                }
                case SOUTH: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.EAT_SOUTH);
                    break;
                }
                case WEST: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.EAT_WEST);
                    break;
                }
                case EAST: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.EAT_EAST);
                }
            }
        } else if (this.actionTime == 16) {
            this.increaseHunger(this.mobCommandItem.getFoodValue());
            if (this.isInInventory(this.mobCommandItem)) {
                this.consumeItem(this.mobCommandItem);
            } else {
                this.item.removeItem(this.mobCommandItem);
            }
        }
        ++this.actionTime;
        if (this.actionTime > 32) {
            switch (p) {
                case NORTH: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.FACE_NORTH);
                    break;
                }
                case SOUTH: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.FACE_SOUTH);
                    break;
                }
                case WEST: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.FACE_WEST);
                    break;
                }
                case EAST: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.FACE_EAST);
                }
            }
            if (this.hero && Utilities.randomInt(3) == 0) {
                this.mob.increaseNoiseLevel(1);
            }
            return true;
        }
        return false;
    }

    private boolean executeDrop(MobDirection p) {
        if (this.actionTime == 0) {
            switch (p) {
                case NORTH: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.DRINK_NORTH);
                    break;
                }
                case SOUTH: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.DRINK_SOUTH);
                    break;
                }
                case WEST: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.DRINK_WEST);
                    break;
                }
                case EAST: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.DRINK_EAST);
                }
            }
        } else if (this.actionTime == 16) {
            this.dropItem(this.mobCommandItem);
        }
        ++this.actionTime;
        if (this.actionTime > 32) {
            switch (p) {
                case NORTH: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.FACE_NORTH);
                    break;
                }
                case SOUTH: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.FACE_SOUTH);
                    break;
                }
                case WEST: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.FACE_WEST);
                    break;
                }
                case EAST: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.FACE_EAST);
                }
            }
            if (this.hero && Utilities.randomInt(2) == 0) {
                this.mob.increaseNoiseLevel(1);
            }
            return true;
        }
        return false;
    }

    private boolean executePickup(MobDirection p) {
        if (this.actionTime == 0) {
            switch (p) {
                case NORTH: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.DRINK_NORTH);
                    break;
                }
                case SOUTH: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.DRINK_SOUTH);
                    break;
                }
                case WEST: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.DRINK_WEST);
                    break;
                }
                case EAST: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.DRINK_EAST);
                }
            }
        } else if (this.actionTime == 16) {
            this.pickupItem(this.mobCommandItem);
        }
        ++this.actionTime;
        if (this.actionTime > 32) {
            switch (p) {
                case NORTH: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.FACE_NORTH);
                    break;
                }
                case SOUTH: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.FACE_SOUTH);
                    break;
                }
                case WEST: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.FACE_WEST);
                    break;
                }
                case EAST: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.FACE_EAST);
                }
            }
            if (this.hero && Utilities.randomInt(2) == 0) {
                this.mob.increaseNoiseLevel(1);
            }
            return true;
        }
        return false;
    }

    private void consumeItem(ItemBase consumedItem) {
        if (consumedItem == null) {
            return;
        }
        int i = 0;
        while (i < this.inventory.length) {
            if (this.inventory[i] == consumedItem) {
                this.inventory[i] = null;
            }
            ++i;
        }
    }

    private void completeTurn() {
        if (this.hungerMax > 0) {
            ++this.hungerDecreaseRateTick;
            if (this.hungerDecreaseRateTick >= this.hungerDecreaseRate) {
                if (this.hunger > 0) {
                    this.decreaseHunger(1);
                } else {
                    this.takeDamage(1);
                }
                this.hungerDecreaseRateTick = 0;
            }
        }
        if (this.energyMax > 0) {
            ++this.energyDecreaseRateTick;
            if (this.energyDecreaseRateTick >= this.energyDecreaseRate) {
                this.decreaseEnergy(1);
                this.energyDecreaseRateTick = 0;
            }
        }
        if (this.mobCommand != MobCommand.DEAD) {
            this.mobCommand = MobCommand.COMPLETE;
        }
        this.actionTime = 0;
    }

    public MobCommand getCommandState() {
        return this.mobCommand;
    }

    public float getMobX() {
        return this.mobX;
    }

    public float getMobY() {
        return this.mobY;
    }

    public void setMobX(float x) {
        this.mobX = x > (float)(this.map.getMapFullWidth() - this.map.getTileWidth() * 2) ? (float)(this.map.getMapFullWidth() - this.map.getTileWidth() * 2) : (x <= 1.0f ? (float)this.map.getTileWidth() : x);
    }

    public void setMobY(float y) {
        this.mobY = y > (float)(this.map.getMapFullHeight() - this.map.getTileHeight() * 2) ? (float)(this.map.getMapFullHeight() - this.map.getTileHeight() * 2) : (y <= 1.0f ? (float)this.map.getTileHeight() : y);
    }

    public int getTileX() {
        return this.tileX;
    }

    public int getTileY() {
        return this.tileY;
    }

    public int getID() {
        return this.mobID;
    }

    public MobType getMobType() {
        return this.mobType;
    }

    public MobGroup getMobGroup() {
        return this.mobGroup;
    }

    private boolean isInInventory(ItemBase searchItem) {
        if (searchItem == null) {
            return false;
        }
        int i = 0;
        while (i < this.inventory.length) {
            if (this.inventory[i] == searchItem) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void takeDamage(int i) {
        this.takeDamage(-1.0f, -1.0f, i);
    }

    private void takeDamage(float x, float y, int i) {
        if (this.mobCommand == MobCommand.DEAD) {
            return;
        }
        this.decreaseHitPoints(i);
        if (x != -1.0f && y != -1.0f) {
            int bloodAmount = this.hitPoints <= 0 ? 100 : 10;
            double xDiff = (float)this.getCenterPixelX(true) - x;
            double yDiff = (float)this.getCenterPixelY(true) - y;
            float angle = (float)Math.toDegrees(Math.atan2(yDiff, xDiff));
            int p = 0;
            while (p < bloodAmount) {
                this.particle.newParticle((float)this.getCenterPixelX(true), (float)this.getCenterPixelY(true), angle, ParticleModule.ParticleType.BLOOD, this.bloodType);
                ++p;
            }
            if (!this.hero) {
                this.stunned = true;
            }
        }
        if (this.hitPoints <= 0) {
            this.mobCommand = MobCommand.DEAD;
            this.stunned = false;
            if (this.hero) {
                Console.newBanner("$RED1You died!", "Git gud.");
            }
            switch (this.mobCommandDirection) {
                case NORTH: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.DEATH_NORTH);
                    break;
                }
                case SOUTH: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.DEATH_SOUTH);
                    break;
                }
                case WEST: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.DEATH_WEST);
                    break;
                }
                case EAST: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.DEATH_EAST);
                }
            }
        } else {
            switch (this.mobCommandDirection) {
                case NORTH: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.HIT_NORTH);
                    break;
                }
                case SOUTH: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.HIT_SOUTH);
                    break;
                }
                case WEST: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.HIT_WEST);
                    break;
                }
                case EAST: {
                    this.sprite.setPosition(MobSprite.MobAnimationFrames.HIT_EAST);
                }
            }
        }
    }

    private void tileUpdate() {
        this.mobX = (int)this.mobX;
        this.mobY = (int)this.mobY;
        this.tileX = (int)this.mobX / this.map.getTileWidth();
        this.tileY = (int)(this.mobY + (float)(this.map.getTileWidth() / 2)) / this.map.getTileHeight();
        this.light.setLightX(this.tileX);
        this.light.setLightY(this.tileY);
    }

    public int getCenterPixelX(boolean useMap) {
        if (useMap) {
            return (int)(this.renderX + (float)this.renderOffsetX + (float)(this.sprite.getSpriteWidth() / 2));
        }
        return this.sprite.getSpriteWidth() / 2;
    }

    public int getCenterPixelY(boolean useMap) {
        if (useMap) {
            return (int)(this.renderY + (float)this.renderOffsetY + (float)(this.sprite.getSpriteHeight() / 2));
        }
        return this.sprite.getSpriteHeight() / 2;
    }

    public int getLevel() {
        return this.level;
    }

    public void increaseLevel(int i) {
        this.level += i;
    }

    public int getExperience() {
        return this.experience;
    }

    public void increaseExperience(int i) {
        this.experience += i;
        if (this.experience > this.level * this.experienceMultiplier) {
            this.experience -= this.level * this.experienceMultiplier;
            this.increaseLevel(1);
        }
    }

    public int getExperienceMultiplier() {
        return this.experienceMultiplier;
    }

    public int getHitPoints() {
        return this.hitPoints;
    }

    public void increaseHitPoints(int i) {
        this.hitPoints += i;
        if (this.hitPoints > this.hitPointsMax) {
            this.hitPoints = this.hitPointsMax;
        }
    }

    public void decreaseHitPoints(int i) {
        this.hitPoints -= i;
        if (this.hitPoints < 0) {
            this.hitPoints = 0;
        }
    }

    public int getHitPointsMax() {
        return this.hitPointsMax;
    }

    public int getHunger() {
        return this.hunger;
    }

    public void increaseHunger(int i) {
        this.hunger += i;
        if (this.hunger > this.hungerMax) {
            this.hunger = this.hungerMax;
        }
    }

    public void decreaseHunger(int i) {
        this.hunger -= i;
        if (this.hunger < 0) {
            this.hunger = 0;
        }
    }

    public int getHungerMax() {
        return this.hungerMax;
    }

    public int getEnergy() {
        return this.energy;
    }

    public void increaseEnergy(int i) {
        this.energy += i;
        if (this.energy > this.energyMax) {
            this.energy = this.energyMax;
        }
    }

    public void decreaseEnergy(int i) {
        this.energy -= i;
        if (this.energy < 0) {
            this.energy = 0;
        }
    }

    public int getEnergyMax() {
        return this.energyMax;
    }

    public int getCoins() {
        return this.coins;
    }

    public void increaseCoins(int i) {
        this.coins += i;
    }

    public void makeHero() {
        this.hero = true;
    }

    public ItemBase getEquipSlotRingOne() {
        return this.inventory[0];
    }

    public ItemBase getEquipSlotHead() {
        return this.inventory[1];
    }

    public ItemBase getEquipSlotRingTwo() {
        return this.inventory[2];
    }

    public ItemBase getEquipSlotChest() {
        return this.inventory[3];
    }

    public ItemBase getEquipSlotWeapon() {
        return this.inventory[4];
    }

    public ItemBase getEquipSlotShield() {
        return this.inventory[5];
    }

    public int getEquipSlotRingOneNumber() {
        return 0;
    }

    public int getEquipSlotHeadNumber() {
        return 1;
    }

    public int getEquipSlotRingTwoNumber() {
        return 2;
    }

    public int getEquipSlotChestNumber() {
        return 3;
    }

    public int getEquipSlotWeaponNumber() {
        return 4;
    }

    public int getEquipSlotShieldNumber() {
        return 5;
    }

    public int getInventoryStartNumber() {
        return 6;
    }

    public void autoEquipItem(ItemBase equipItem) {
        ItemBase.ItemEquipSlot s = equipItem.getEquipSlot();
        if (s == ItemBase.ItemEquipSlot.HEAD) {
            if (this.inventory[1] == null) {
                this.inventory[1] = equipItem;
            }
        } else if (s == ItemBase.ItemEquipSlot.CHEST) {
            if (this.inventory[4] == null) {
                this.inventory[4] = equipItem;
            }
        } else if (s == ItemBase.ItemEquipSlot.WEAPON) {
            if (this.inventory[3] == null) {
                this.inventory[3] = equipItem;
            }
        } else if (s == ItemBase.ItemEquipSlot.SHIELD) {
            if (this.inventory[5] == null) {
                this.inventory[5] = equipItem;
            }
        } else if (s == ItemBase.ItemEquipSlot.RING) {
            if (this.inventory[0] == null) {
                this.inventory[0] = equipItem;
            } else if (this.inventory[2] == null) {
                this.inventory[2] = equipItem;
            }
        }
    }

    private boolean canEquip(ItemBase i) {
        ItemBase.ItemEquipSlot s = i.getEquipSlot();
        if (s == null) {
            return false;
        }
        return s == ItemBase.ItemEquipSlot.HEAD ? this.inventory[1] == null : (s == ItemBase.ItemEquipSlot.CHEST ? this.inventory[4] == null : (s == ItemBase.ItemEquipSlot.WEAPON ? this.inventory[3] == null : (s == ItemBase.ItemEquipSlot.SHIELD ? this.inventory[5] == null : s == ItemBase.ItemEquipSlot.RING && this.inventory[0] == null && this.inventory[2] == null)));
    }

    public void dropItem(int slot) {
        OrderedPair o = this.item.findOpenSpot(this.tileX, this.tileY);
        if (o == null) {
            return;
        }
        int dropX = o.getX();
        int dropY = o.getY();
        this.item.dropItem(this.inventory[slot], dropX, dropY);
        this.inventory[slot] = null;
    }

    public void dropItem(ItemBase droppedItem) {
        if (!this.isInInventory(droppedItem)) {
            return;
        }
        OrderedPair o = this.item.findOpenSpot(this.tileX, this.tileY);
        if (o == null) {
            return;
        }
        int i = 0;
        while (i < this.inventory.length) {
            if (this.inventory[i] == droppedItem) {
                this.inventory[i] = null;
            }
            ++i;
        }
        this.item.dropItem(droppedItem, o.getX(), o.getY());
    }

    public ItemBase[] getInventory() {
        return this.inventory;
    }

    public void pickupItem(ItemBase pickup) {
        if (pickup == null) {
            return;
        }
        if (pickup.getType() == ItemModule.ItemType.COINS) {
            this.increaseCoins(pickup.getCoinValue());
            this.item.removeItem(pickup);
        } else if (pickup.getEquipSlot() != null && this.canEquip(pickup)) {
            this.autoEquipItem(pickup);
            this.item.removeItem(pickup);
        } else if (this.canPickupItem()) {
            int slot = this.getOpenInventorySlot();
            this.inventory[slot] = pickup;
            this.item.removeItem(pickup);
        }
    }

    public void takeFromContainer(ObjectBase container, ItemBase pickup) {
        if (pickup == null) {
            return;
        }
        if (pickup.getType() == ItemModule.ItemType.COINS) {
            this.increaseCoins(pickup.getCoinValue());
            container.removeItemInInventory(pickup);
        } else if (pickup.getEquipSlot() != null && this.canEquip(pickup)) {
            this.autoEquipItem(pickup);
            container.removeItemInInventory(pickup);
        } else if (this.canPickupItem()) {
            int slot = this.getOpenInventorySlot();
            this.inventory[slot] = pickup;
            container.removeItemInInventory(pickup);
        }
    }

    public void placeInContainer(ObjectBase container, ItemBase movedItem) {
        if (movedItem == null) {
            return;
        }
        if (this.canPlaceItemInContainer(container)) {
            int slot = this.getOpenContainerSlot(container);
            container.getInventory()[slot] = movedItem;
            int i = 0;
            while (i < this.inventory.length) {
                if (this.inventory[i] == movedItem) {
                    this.inventory[i] = null;
                }
                ++i;
            }
        }
    }

    public boolean canPickupItem() {
        int i = 6;
        while (i < this.inventory.length) {
            if (this.inventory[i] == null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getOpenInventorySlot() {
        if (this.canPickupItem()) {
            int i = 6;
            while (i < this.inventory.length) {
                if (this.inventory[i] == null) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public boolean canPlaceItemInContainer(ObjectBase container) {
        int i = 0;
        while (i < container.getInventory().length) {
            if (container.getInventory()[i] == null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getOpenContainerSlot(ObjectBase container) {
        if (this.canPickupItem()) {
            int i = 0;
            while (i < container.getInventory().length) {
                if (container.getInventory()[i] == null) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public void swapItemsInInventory(int itemSlotOne, int itemSlotTwo) {
        ItemBase itemOne = this.inventory[itemSlotOne];
        if (itemOne != null && itemSlotTwo < 6 && (itemOne.getEquipSlot() == ItemBase.ItemEquipSlot.RING && (itemSlotTwo != 0 || itemSlotTwo != 2) || itemOne.getEquipSlot() == ItemBase.ItemEquipSlot.HEAD && itemSlotTwo != 1 || itemOne.getEquipSlot() == ItemBase.ItemEquipSlot.WEAPON && itemSlotTwo != 3 || itemOne.getEquipSlot() == ItemBase.ItemEquipSlot.CHEST && itemSlotTwo != 4 || itemOne.getEquipSlot() == ItemBase.ItemEquipSlot.SHIELD && itemSlotTwo != 5)) {
            return;
        }
        ItemBase itemTwo = this.inventory[itemSlotTwo];
        if (itemTwo != null && itemSlotOne < 6 && (itemTwo.getEquipSlot() == ItemBase.ItemEquipSlot.RING && (itemSlotOne != 0 || itemSlotOne != 2) || itemTwo.getEquipSlot() == ItemBase.ItemEquipSlot.HEAD && itemSlotOne != 1 || itemTwo.getEquipSlot() == ItemBase.ItemEquipSlot.WEAPON && itemSlotOne != 3 || itemTwo.getEquipSlot() == ItemBase.ItemEquipSlot.CHEST && itemSlotOne != 4 || itemTwo.getEquipSlot() == ItemBase.ItemEquipSlot.SHIELD && itemSlotOne != 5)) {
            return;
        }
        this.inventory[itemSlotOne] = itemTwo;
        this.inventory[itemSlotTwo] = itemOne;
    }

    public static enum MobCommand {
        ATTACK,
        EAT,
        DROP,
        PICKUP,
        OPEN_DOOR,
        OPEN_CONTAINER,
        MOVE,
        DEAD,
        IDLE,
        COMPLETE;

    }

    public static enum MobDirection {
        NORTH,
        EAST,
        SOUTH,
        WEST;

    }

    public static enum MobGender {
        MALE("$CYA1"),
        FEMALE("$PIN1"),
        NONE("$WHI0");

        private final String mobGenderColor;

        private MobGender(String mobGenderColor) {
            this.mobGenderColor = mobGenderColor;
        }

        public String getGenderColor() {
            return this.mobGenderColor;
        }
    }

    public static enum MobGroup {
        FRIENDLY,
        HOSTILE;

    }

    public static enum MobType {
        HERO("Hero", "Heroes"),
        ZOMBIE("Zombie", "Zombies");

        private final String mobTypeText;
        private final String mobTypeTextPlural;

        private MobType(String mobTypeText, String mobTypeTextPlural) {
            this.mobTypeText = mobTypeText;
            this.mobTypeTextPlural = mobTypeTextPlural;
        }

        private MobType(String mobTypeText) {
            this.mobTypeText = mobTypeText;
            this.mobTypeTextPlural = mobTypeText;
        }

        public String getText() {
            return this.mobTypeText;
        }

        public String getTextPlural() {
            return this.mobTypeTextPlural;
        }
    }
}

