/*
 * Decompiled with CFR 0.152.
 */
package rtr.map.generator;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import rtr.ImageLoader;
import rtr.utilities.Utilities;

public class RoomBuilder {
    private ArrayList<Image> rooms = new ArrayList();
    private ArrayList<RawRoomData[][]> roomsList = new ArrayList();

    public RoomBuilder() throws SlickException {
        int count = 1;
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("res/rooms/1.png");
        while (in != null) {
            this.rooms.add(ImageLoader.getImage("res/rooms/" + count + ".png"));
            ++count;
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream("res/rooms/" + count + ".png");
        }
        for (Image room : this.rooms) {
            RawRoomData[][] rawData = new RawRoomData[room.getWidth()][room.getHeight()];
            int x = 0;
            while (x < room.getWidth()) {
                int y = 0;
                while (y < room.getHeight()) {
                    Color pixel = room.getColor(x, y);
                    RawRoomData[] rawRoomDataArray = RawRoomData.values();
                    int n = rawRoomDataArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        RawRoomData t = rawRoomDataArray[n2];
                        if (pixel.equals(t.getColor())) {
                            rawData[x][y] = t;
                            break;
                        }
                        ++n2;
                    }
                    ++y;
                }
                ++x;
            }
            room.flushPixelData();
            RawRoomData[][] processedRoom = null;
            switch (Utilities.randomInt(8)) {
                case 0: {
                    processedRoom = new RawRoomData[room.getWidth()][room.getHeight()];
                    int x2 = 0;
                    while (x2 < room.getWidth()) {
                        processedRoom[x2] = rawData[room.getWidth() - 1 - x2];
                        ++x2;
                    }
                    break;
                }
                case 1: {
                    processedRoom = new RawRoomData[room.getWidth()][room.getHeight()];
                    int x2 = 0;
                    while (x2 < room.getWidth()) {
                        int y = 0;
                        while (y < room.getHeight()) {
                            processedRoom[x2][y] = rawData[room.getWidth() - 1 - x2][room.getHeight() - 1 - y];
                            ++y;
                        }
                        ++x2;
                    }
                    break;
                }
                case 2: {
                    processedRoom = new RawRoomData[room.getWidth()][room.getHeight()];
                    int x2 = 0;
                    while (x2 < room.getWidth()) {
                        int y = 0;
                        while (y < room.getHeight()) {
                            processedRoom[x2][y] = rawData[x2][room.getHeight() - 1 - y];
                            ++y;
                        }
                        ++x2;
                    }
                    break;
                }
                case 3: {
                    processedRoom = new RawRoomData[room.getHeight()][room.getWidth()];
                    int x2 = 0;
                    while (x2 < room.getWidth()) {
                        int y = 0;
                        while (y < room.getHeight()) {
                            processedRoom[y][x2] = rawData[x2][y];
                            ++y;
                        }
                        ++x2;
                    }
                    break;
                }
                case 4: {
                    processedRoom = new RawRoomData[room.getHeight()][room.getWidth()];
                    int x2 = 0;
                    while (x2 < room.getWidth()) {
                        int y = 0;
                        while (y < room.getHeight()) {
                            processedRoom[y][x2] = rawData[x2][room.getHeight() - 1 - y];
                            ++y;
                        }
                        ++x2;
                    }
                    break;
                }
                case 5: {
                    processedRoom = new RawRoomData[room.getHeight()][room.getWidth()];
                    int x2 = 0;
                    while (x2 < room.getWidth()) {
                        int y = 0;
                        while (y < room.getHeight()) {
                            processedRoom[y][x2] = rawData[room.getWidth() - 1 - x2][y];
                            ++y;
                        }
                        ++x2;
                    }
                    break;
                }
                case 6: {
                    processedRoom = new RawRoomData[room.getHeight()][room.getWidth()];
                    int x2 = 0;
                    while (x2 < room.getWidth()) {
                        int y = 0;
                        while (y < room.getHeight()) {
                            processedRoom[y][x2] = rawData[room.getWidth() - 1 - x2][room.getHeight() - 1 - y];
                            ++y;
                        }
                        ++x2;
                    }
                    break;
                }
                case 7: {
                    processedRoom = rawData;
                }
            }
            this.roomsList.add(processedRoom);
        }
    }

    public RawRoomData[][] getRandomRoom() {
        return this.roomsList.get(Utilities.randomInt(this.roomsList.size()));
    }

    public static enum RawRoomData {
        IGNORE(new Color(100, 0, 100)),
        OPEN(new Color(0, 0, 0)),
        FOOD_ALWAYS_HIGH(new Color(0, 250, 0)),
        FOOD_UP_TO_HIGH(new Color(0, 200, 0)),
        FOOD_UP_TO_MEDIUM(new Color(0, 150, 0)),
        FOOD_UP_TO_LOW(new Color(0, 100, 0)),
        TREASURE_ALWAYS_HIGH(new Color(250, 250, 0)),
        TREASURE_UP_TO_HIGH(new Color(200, 200, 0)),
        TREASURE_UP_TO_MEDIUM(new Color(150, 150, 0)),
        TREASURE_UP_TO_LOW(new Color(100, 100, 0)),
        ITEM_ALWAYS_HIGH(new Color(0, 0, 250)),
        ITEM_UP_TO_HIGH(new Color(0, 0, 200)),
        ITEM_UP_TO_MEDIUM(new Color(0, 0, 150)),
        ITEM_UP_TO_LOW(new Color(0, 0, 100)),
        WALL(new Color(250, 250, 250)),
        DOOR(new Color(0, 150, 150)),
        WAYPOINT(new Color(250, 0, 250)),
        CONNECTION(new Color(0, 250, 250));

        private final Color color;

        private RawRoomData(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }
    }
}

