/*
 * Decompiled with CFR 0.152.
 */
package rtr.map.generator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.PriorityQueue;
import org.newdawn.slick.SlickException;
import rtr.item.ItemModule;
import rtr.map.MapModule;
import rtr.map.MapTilesLoader;
import rtr.map.generator.PathNode;
import rtr.map.generator.RoomBuilder;
import rtr.object.ObjectModule;
import rtr.states.StateBase;
import rtr.utilities.OrderedPair;
import rtr.utilities.Utilities;

public class MapGenerator {
    private MapModule map = StateBase.getMapModule();
    private ItemModule item = StateBase.getItemModule();
    private ObjectModule object = StateBase.getObjectModule();
    private static final int BASE_MOVEMENT_COST = 1000;
    private PriorityQueue<PathNode> openPathNodes = new PriorityQueue();
    private ArrayList<PathNode> resettablePathNodes = new ArrayList();
    private ArrayList<OrderedPair> pathWaypoint = new ArrayList();
    private MapTilesLoader mtl;
    private RoomBuilder roomBuilder;
    private PathNode basePathNode;
    private int mapWidth;
    private int mapHeight;
    private int[][][] mapOut;
    private int[][] roomsPlaced = new int[this.map.getMapWidth()][this.map.getMapHeight()];
    ArrayList<OrderedPair> roomConnectionPoints = new ArrayList();
    private PathNode[][] pathNodes;

    public MapGenerator() throws SlickException {
        this.mapWidth = this.map.getMapWidth();
        this.mapHeight = this.map.getMapHeight();
        this.pathNodes = new PathNode[this.mapWidth][this.mapHeight];
        int x = 0;
        while (x < this.pathNodes.length) {
            int y = 0;
            while (y < this.pathNodes[x].length) {
                this.pathNodes[x][y] = new PathNode(x, y);
                ++y;
            }
            ++x;
        }
        this.mtl = this.map.getMapTileLoader();
        this.roomBuilder = new RoomBuilder();
    }

    public int[][][] generateMap() throws SlickException {
        this.mapOut = new int[this.map.getMapWidth()][this.map.getMapHeight()][this.map.getMapLayers()];
        this.item.eraseMap();
        this.generateFillTerrain();
        this.generateRandomCaves();
        this.generateRooms();
        this.generateRoomCavePaths();
        this.generateTerrain();
        this.generateRandomDeco();
        this.generateRandomItems();
        this.cleanup();
        return this.mapOut;
    }

    private void generateFillTerrain() throws SlickException {
        int x = 1;
        while (x < this.mapOut.length - 1) {
            int y = 1;
            while (y < this.mapOut[x].length - 1) {
                this.addTile(x, y, MapTilesLoader.TileSet.DIRT);
                this.addTile(x, y, MapTilesLoader.TileSet.ROCKS);
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < this.map.getMapWidth()) {
            this.addTile(x, 0, MapTilesLoader.TileSet.WALL_STONE);
            this.addTile(x, this.map.getMapHeight() - 1, MapTilesLoader.TileSet.WALL_STONE);
            this.createPatch(x, 0, 500 + Utilities.randomInt(5000), 6, -1, false, MapTilesLoader.TileSet.ROCKS);
            this.createPatch(x, this.map.getMapHeight() - 1, 500 + Utilities.randomInt(5000), 6, -1, false, MapTilesLoader.TileSet.ROCKS);
            ++x;
        }
        int y = 0;
        while (y < this.map.getMapHeight()) {
            this.addTile(0, y, MapTilesLoader.TileSet.WALL_STONE);
            this.addTile(this.map.getMapWidth() - 1, y, MapTilesLoader.TileSet.WALL_STONE);
            this.createPatch(0, y, 500 + Utilities.randomInt(5000), 6, -1, false, MapTilesLoader.TileSet.ROCKS);
            this.createPatch(this.map.getMapWidth() - 1, y, 500 + Utilities.randomInt(5000), 6, -1, false, MapTilesLoader.TileSet.ROCKS);
            ++y;
        }
    }

    private void generateRooms() throws SlickException {
        this.pathWaypoint.clear();
        this.roomsPlaced = new int[this.map.getMapWidth()][this.map.getMapHeight()];
        this.roomConnectionPoints = new ArrayList();
        int i = 0;
        while (i < 32) {
            RoomBuilder.RawRoomData[][] roomData = this.roomBuilder.getRandomRoom();
            boolean safeSpot = false;
            boolean connection = false;
            int placeX = 0;
            int placeY = 0;
            int attempts = 0;
            int attemptsMax = 10000;
            block1: while (!safeSpot && attempts < attemptsMax) {
                ++attempts;
                if (Utilities.randomInt(1000) != 0 && this.roomConnectionPoints.size() > 0) {
                    ArrayList<OrderedPair> thisRoomConnectionPoints = new ArrayList<OrderedPair>();
                    int x = 0;
                    while (x < roomData.length) {
                        int y = 0;
                        while (y < roomData[x].length) {
                            if (roomData[x][y] == RoomBuilder.RawRoomData.CONNECTION) {
                                thisRoomConnectionPoints.add(OrderedPair.getOrderedPair(x, y));
                            }
                            ++y;
                        }
                        ++x;
                    }
                    if (thisRoomConnectionPoints.size() <= 0) continue;
                    Collections.shuffle(thisRoomConnectionPoints);
                    Collections.shuffle(this.roomConnectionPoints);
                    for (OrderedPair r : thisRoomConnectionPoints) {
                        for (OrderedPair m : this.roomConnectionPoints) {
                            int y;
                            int x2;
                            if (!Utilities.isOutOfBounds(this.map.getMapHeight(), this.map.getMapWidth(), m.getX() + 1, m.getY()) && r.getX() - 1 < 0 && this.roomsPlaced[m.getX() + 1][m.getY()] == 0) {
                                placeX = m.getX() + 1;
                                placeY = m.getY() - r.getY();
                                x2 = 0;
                                while (x2 < roomData.length) {
                                    y = 0;
                                    while (y < roomData[x2].length) {
                                        if ((Utilities.isOutOfBounds(this.map.getMapHeight(), this.map.getMapWidth(), x2 + placeX, y + placeY) || this.roomsPlaced[x2 + placeX][y + placeY] == 1) && roomData[x2][y] != RoomBuilder.RawRoomData.IGNORE) continue block1;
                                        ++y;
                                    }
                                    ++x2;
                                }
                                safeSpot = true;
                                connection = true;
                                break block1;
                            }
                            if (!Utilities.isOutOfBounds(this.map.getMapHeight(), this.map.getMapWidth(), m.getX() - 1, m.getY()) && r.getX() + 1 < this.map.getMapWidth() && this.roomsPlaced[m.getX() - 1][m.getY()] == 0) {
                                placeX = m.getX() - 1;
                                placeY = m.getY() - r.getY();
                                x2 = 0;
                                while (x2 < roomData.length) {
                                    y = 0;
                                    while (y < roomData[x2].length) {
                                        if ((Utilities.isOutOfBounds(this.map.getMapHeight(), this.map.getMapWidth(), x2 + placeX, y + placeY) || this.roomsPlaced[x2 + placeX][y + placeY] == 1) && roomData[x2][y] != RoomBuilder.RawRoomData.IGNORE) continue block1;
                                        ++y;
                                    }
                                    ++x2;
                                }
                                safeSpot = true;
                                connection = true;
                                break block1;
                            }
                            if (!Utilities.isOutOfBounds(this.map.getMapHeight(), this.map.getMapWidth(), m.getX(), m.getY() + 1) && r.getY() - 1 < 0 && this.roomsPlaced[m.getX()][m.getY() + 1] == 0) {
                                placeX = m.getX() - r.getX();
                                placeY = m.getY() + 1;
                                x2 = 0;
                                while (x2 < roomData.length) {
                                    y = 0;
                                    while (y < roomData[x2].length) {
                                        if ((Utilities.isOutOfBounds(this.map.getMapHeight(), this.map.getMapWidth(), x2 + placeX, y + placeY) || this.roomsPlaced[x2 + placeX][y + placeY] == 1) && roomData[x2][y] != RoomBuilder.RawRoomData.IGNORE) continue block1;
                                        ++y;
                                    }
                                    ++x2;
                                }
                                safeSpot = true;
                                connection = true;
                                break block1;
                            }
                            if (Utilities.isOutOfBounds(this.map.getMapHeight(), this.map.getMapWidth(), m.getX(), m.getY() - 1) || r.getY() + 1 >= this.map.getMapHeight() || this.roomsPlaced[m.getX()][m.getY() - 1] != 0) continue;
                            placeX = m.getX() - r.getY();
                            placeY = m.getY() - 1;
                            x2 = 0;
                            while (x2 < roomData.length) {
                                y = 0;
                                while (y < roomData[x2].length) {
                                    if ((Utilities.isOutOfBounds(this.map.getMapHeight(), this.map.getMapWidth(), x2 + placeX, y + placeY) || this.roomsPlaced[x2 + placeX][y + placeY] == 1) && roomData[x2][y] != RoomBuilder.RawRoomData.IGNORE) continue block1;
                                    ++y;
                                }
                                ++x2;
                            }
                            safeSpot = true;
                            connection = true;
                            break block1;
                        }
                    }
                    continue;
                }
                placeX = Utilities.randomInt(this.map.getMapWidth() - roomData.length);
                placeY = Utilities.randomInt(this.map.getMapHeight() - roomData[0].length);
                int x = 0;
                while (x < roomData.length) {
                    int y = 0;
                    while (y < roomData[x].length) {
                        if (this.roomsPlaced[x + placeX][y + placeY] == 1 && roomData[x][y] != RoomBuilder.RawRoomData.IGNORE) {
                            placeX = Utilities.randomInt(this.map.getMapWidth() - roomData.length);
                            placeY = Utilities.randomInt(this.map.getMapHeight() - roomData[0].length);
                            continue block1;
                        }
                        ++y;
                    }
                    ++x;
                }
                safeSpot = true;
            }
            if (attempts < attemptsMax) {
                int x = 0;
                while (x < roomData.length) {
                    int y = 0;
                    while (y < roomData[x].length) {
                        if (roomData[x][y] != RoomBuilder.RawRoomData.IGNORE) {
                            this.eraseTopography(x + placeX, y + placeY);
                            this.item.removeItem(x + placeX, y + placeY);
                            this.roomsPlaced[x + placeX][y + placeY] = 1;
                        }
                        ++y;
                    }
                    ++x;
                }
                x = 0;
                while (x < roomData.length) {
                    int y = 0;
                    while (y < roomData[x].length) {
                        if (roomData[x][y] == RoomBuilder.RawRoomData.WALL) {
                            this.addTile(x + placeX, y + placeY, MapTilesLoader.TileSet.WALL_STONE);
                        } else if (roomData[x][y] == RoomBuilder.RawRoomData.WAYPOINT && !connection) {
                            this.pathWaypoint.add(OrderedPair.getOrderedPair(x + placeX, y + placeY));
                        } else if (roomData[x][y] == RoomBuilder.RawRoomData.CONNECTION) {
                            this.roomConnectionPoints.add(OrderedPair.getOrderedPair(x + placeX, y + placeY));
                        } else if (roomData[x][y] == RoomBuilder.RawRoomData.DOOR) {
                            int x2 = -1;
                            while (x2 <= 1) {
                                if (!Utilities.isOutOfBounds(this.map.getMapWidth(), this.map.getMapHeight(), x + x2, y) && roomData[x + x2][y] == RoomBuilder.RawRoomData.WALL) {
                                    this.object.addObject(x + placeX, y + placeY, ObjectModule.ObjectType.DOOR_NS);
                                    break;
                                }
                                ++x2;
                            }
                            int y2 = -1;
                            while (y2 <= 1) {
                                if (!Utilities.isOutOfBounds(this.map.getMapWidth(), this.map.getMapHeight(), x, y + y2) && roomData[x][y + y2] == RoomBuilder.RawRoomData.WALL) {
                                    this.object.addObject(x + placeX, y + placeY, ObjectModule.ObjectType.DOOR_WE);
                                    break;
                                }
                                ++y2;
                            }
                        }
                        ++y;
                    }
                    ++x;
                }
            } else {
                System.out.println("Failed to place something.");
            }
            ++i;
        }
    }

    private void generateRoomCavePaths() throws SlickException {
        while (this.pathWaypoint.size() > 0) {
            OrderedPair pathOne = this.pathWaypoint.get(Utilities.randomInt(this.pathWaypoint.size()));
            OrderedPair pathTwo = this.pathWaypoint.get(Utilities.randomInt(this.pathWaypoint.size()));
            ArrayList<OrderedPair> path = this.createPath(pathOne.getX(), pathOne.getY(), pathTwo.getX(), pathTwo.getY(), 200);
            if (path == null) continue;
            for (OrderedPair o : path) {
                this.createPatch(o.getX(), o.getY(), 1, Utilities.randomInt(2) + 2, 1, true, null, null);
            }
            this.pathWaypoint.remove(pathOne);
            this.pathWaypoint.remove(pathTwo);
        }
    }

    private void generateRandomCaves() throws SlickException {
        int i = 0;
        while (i < 10) {
            ArrayList<OrderedPair> path = this.createPath(Utilities.randomInt(this.map.getMapWidth()), Utilities.randomInt(this.map.getMapHeight()), Utilities.randomInt(this.map.getMapWidth()), Utilities.randomInt(this.map.getMapHeight()), 200);
            if (path != null) {
                int x = 0;
                while (x < path.size()) {
                    OrderedPair o = path.get(x);
                    if (x == 0 || x == path.size() - 1) {
                        this.createPatch(o.getX(), o.getY(), 1, Utilities.randomInt(32) + 8, 1, true, null, null);
                    } else {
                        this.createPatch(o.getX(), o.getY(), 1, Utilities.randomInt(2) + 2, 1, true, null, null);
                    }
                    ++x;
                }
            }
            ++i;
        }
    }

    private void generateTerrain() throws SlickException {
        int i = 0;
        while (i < 32) {
            this.createPatch(Utilities.randomInt(this.map.getMapWidth()), Utilities.randomInt(this.map.getMapHeight()), 32, 16, 1, true, MapTilesLoader.TileSet.SAND);
            ++i;
        }
        i = 0;
        while (i < 32) {
            this.createPatch(Utilities.randomInt(this.map.getMapWidth()), Utilities.randomInt(this.map.getMapHeight()), 32, 16, 1, true, MapTilesLoader.TileSet.GRASS);
            ++i;
        }
        i = 0;
        while (i < 64) {
            this.createPatch(Utilities.randomInt(this.map.getMapWidth()), Utilities.randomInt(this.map.getMapHeight()), 32, 32, 1, true, MapTilesLoader.TileSet.GRAVEL);
            ++i;
        }
        i = 0;
        while (i < 64) {
            this.createPatch(Utilities.randomInt(this.map.getMapWidth()), Utilities.randomInt(this.map.getMapHeight()), 32, 16, 1, true, MapTilesLoader.TileSet.BRICKS);
            ++i;
        }
        i = 0;
        while (i < 64) {
            this.createPatch(Utilities.randomInt(this.map.getMapWidth()), Utilities.randomInt(this.map.getMapHeight()), 32, 16, 1, true, MapTilesLoader.TileSet.TILES);
            ++i;
        }
    }

    private void generateRandomDeco() throws SlickException {
    }

    private void generateRandomItems() throws SlickException {
        int tileY;
        int i = 0;
        while (i < 64) {
            this.createPatch(Utilities.randomInt(this.map.getMapWidth()), Utilities.randomInt(this.map.getMapHeight()), 128, 2, 2, false, ItemModule.ItemType.COINS);
            ++i;
        }
        int tileX = 1;
        while (tileX < this.mapOut.length - 1) {
            tileY = 1;
            while (tileY < this.mapOut[tileX].length - 1) {
                if (this.mapOut[tileX][tileY][this.map.getLayerTopographyBottom()] == 0 && Utilities.randomInt(1024) == 0) {
                    this.item.addItem(tileX, tileY, ItemModule.ItemType.COINS, ItemModule.ItemQuality.VERY_LOW, ItemModule.ItemQuality.VERY_HIGH);
                }
                ++tileY;
            }
            ++tileX;
        }
        tileX = 1;
        while (tileX < this.mapOut.length - 1) {
            tileY = 1;
            while (tileY < this.mapOut[tileX].length - 1) {
                if (this.mapOut[tileX][tileY][this.map.getLayerTopographyBottom()] == 0 && Utilities.randomInt(128) == 0) {
                    this.object.addObject(tileX, tileY, ObjectModule.ObjectType.CHEST);
                }
                ++tileY;
            }
            ++tileX;
        }
        tileX = 1;
        while (tileX < this.mapOut.length - 1) {
            tileY = 1;
            while (tileY < this.mapOut[tileX].length - 1) {
                if (this.mapOut[tileX][tileY][this.map.getLayerTopographyBottom()] == 0 && Utilities.randomInt(128) == 0) {
                    switch (Utilities.randomInt(1)) {
                        case 0: {
                            this.item.addItem(tileX, tileY, ItemModule.ItemType.FOOD, ItemModule.ItemQuality.VERY_LOW, ItemModule.ItemQuality.MEDIUM);
                        }
                    }
                }
                ++tileY;
            }
            ++tileX;
        }
    }

    private void randomizeTerrain() {
        int tileX = 1;
        while (tileX < this.mapOut.length - 1) {
            int tileY = 1;
            while (tileY < this.mapOut[tileX].length - 1) {
                int layer = 0;
                while (layer < this.map.getMapLayers()) {
                    if (this.mapOut[tileX][tileY][layer] != 0 && this.map.getMapTileLoader().getTileType(this.mapOut[tileX][tileY][layer]) == MapTilesLoader.TileType.TERRAIN) {
                        int tileRange = this.mtl.getTileSetGID(this.mapOut[tileX][tileY][layer]);
                        int tileCheck = 2;
                        int tileSetSize = 200;
                        tileCheck = this.mapOut[tileX - 1][tileY - 1][layer] < tileRange || this.mapOut[tileX - 1][tileY - 1][layer] > tileRange + tileSetSize ? (tileCheck *= 10) : tileCheck * 10 + 1;
                        tileCheck = this.mapOut[tileX][tileY - 1][layer] < tileRange || this.mapOut[tileX][tileY - 1][layer] > tileRange + tileSetSize ? (tileCheck *= 10) : tileCheck * 10 + 1;
                        tileCheck = this.mapOut[tileX + 1][tileY - 1][layer] < tileRange || this.mapOut[tileX + 1][tileY - 1][layer] > tileRange + tileSetSize ? (tileCheck *= 10) : tileCheck * 10 + 1;
                        tileCheck = this.mapOut[tileX - 1][tileY][layer] < tileRange || this.mapOut[tileX - 1][tileY][layer] > tileRange + tileSetSize ? (tileCheck *= 10) : tileCheck * 10 + 1;
                        tileCheck = tileCheck * 10 + 1;
                        tileCheck = this.mapOut[tileX + 1][tileY][layer] < tileRange || this.mapOut[tileX + 1][tileY][layer] > tileRange + tileSetSize ? (tileCheck *= 10) : tileCheck * 10 + 1;
                        tileCheck = this.mapOut[tileX - 1][tileY + 1][layer] < tileRange || this.mapOut[tileX - 1][tileY + 1][layer] > tileRange + tileSetSize ? (tileCheck *= 10) : tileCheck * 10 + 1;
                        tileCheck = this.mapOut[tileX][tileY + 1][layer] < tileRange || this.mapOut[tileX][tileY + 1][layer] > tileRange + tileSetSize ? (tileCheck *= 10) : tileCheck * 10 + 1;
                        tileCheck = this.mapOut[tileX + 1][tileY + 1][layer] < tileRange || this.mapOut[tileX + 1][tileY + 1][layer] > tileRange + tileSetSize ? (tileCheck *= 10) : tileCheck * 10 + 1;
                        this.mapOut[tileX][tileY][layer] = tileCheck == 2111111111 ? Utilities.randomInt(25) + tileRange : (tileCheck == 2000111111 || tileCheck == 2100111111 || tileCheck == 2001111111 || tileCheck == 2101111111 || tileCheck == 2010111111 ? Utilities.randomInt(5) + (tileRange - 1) + 26 : (tileCheck == 2111111000 || tileCheck == 2111111101 || tileCheck == 2111111100 || tileCheck == 2111111001 || tileCheck == 2111111010 ? Utilities.randomInt(5) + (tileRange - 1) + 31 : (tileCheck == 2011011011 || tileCheck == 2111011011 || tileCheck == 2011011111 || tileCheck == 2111011111 || tileCheck == 2011111011 ? Utilities.randomInt(5) + (tileRange - 1) + 36 : (tileCheck == 2110110110 || tileCheck == 2110110111 || tileCheck == 2111110110 || tileCheck == 2111110111 || tileCheck == 2110111110 ? Utilities.randomInt(5) + (tileRange - 1) + 41 : (tileCheck == 2000011011 || tileCheck == 2001011111 || tileCheck == 2001011011 || tileCheck == 2000011111 || tileCheck == 2101011111 || tileCheck == 2101011011 || tileCheck == 2100011111 || tileCheck == 2100011011 || tileCheck == 2100111011 || tileCheck == 2110011011 || tileCheck == 2000111011 || tileCheck == 2010011011 || tileCheck == 2001111011 || tileCheck == 2010011111 || tileCheck == 2110011111 || tileCheck == 2101111011 || tileCheck == 2010111011 ? Utilities.randomInt(5) + (tileRange - 1) + 46 : (tileCheck == 2011011000 || tileCheck == 2111011001 || tileCheck == 2111011000 || tileCheck == 2011011001 || tileCheck == 2111011101 || tileCheck == 2111011100 || tileCheck == 2011011101 || tileCheck == 2011011100 || tileCheck == 2011111100 || tileCheck == 2011011110 || tileCheck == 2011111000 || tileCheck == 2011011010 || tileCheck == 2111011010 || tileCheck == 2011111001 || tileCheck == 2011111101 || tileCheck == 2111011110 || tileCheck == 2011111010 ? Utilities.randomInt(5) + (tileRange - 1) + 51 : (tileCheck == 2000110110 || tileCheck == 2100110111 || tileCheck == 2100110110 || tileCheck == 2000110111 || tileCheck == 2101110111 || tileCheck == 2101110110 || tileCheck == 2001110111 || tileCheck == 2001110110 || tileCheck == 2011110110 || tileCheck == 2001111110 || tileCheck == 2010110110 || tileCheck == 2000111110 || tileCheck == 2010110111 || tileCheck == 2100111110 || tileCheck == 2101111110 || tileCheck == 2011110111 || tileCheck == 2010111110 ? Utilities.randomInt(5) + (tileRange - 1) + 56 : (tileCheck == 2110110000 || tileCheck == 2111110100 || tileCheck == 2111110000 || tileCheck == 2110110100 || tileCheck == 2111110101 || tileCheck == 2111110001 || tileCheck == 2110110101 || tileCheck == 2110110001 || tileCheck == 2110111001 || tileCheck == 2110110011 || tileCheck == 2110111000 || tileCheck == 2110110010 || tileCheck == 2111110010 || tileCheck == 2110111100 || tileCheck == 2110111101 || tileCheck == 2111110011 || tileCheck == 2110111010 ? Utilities.randomInt(5) + (tileRange - 1) + 61 : (tileCheck == 2111111110 ? Utilities.randomInt(5) + (tileRange - 1) + 66 : (tileCheck == 2110111111 ? Utilities.randomInt(5) + (tileRange - 1) + 71 : (tileCheck == 2111111011 ? Utilities.randomInt(5) + (tileRange - 1) + 76 : (tileCheck == 2011111111 ? Utilities.randomInt(5) + (tileRange - 1) + 81 : (tileCheck == 2011111110 ? Utilities.randomInt(5) + (tileRange - 1) + 86 : (tileCheck == 2110111011 ? Utilities.randomInt(5) + (tileRange - 1) + 91 : 0))))))))))))));
                    }
                    ++layer;
                }
                ++tileY;
            }
            ++tileX;
        }
    }

    private void randomizeWalls() {
        int tileX = 1;
        while (tileX < this.mapOut.length - 1) {
            int tileY = 1;
            while (tileY < this.mapOut[tileX].length - 1) {
                int layer = 0;
                while (layer < this.map.getMapLayers()) {
                    if (this.mapOut[tileX][tileY][layer] != 0 && this.map.getMapTileLoader().getTileType(this.mapOut[tileX][tileY][layer]) == MapTilesLoader.TileType.WALL) {
                        int tileRange = this.mtl.getTileSetGID(this.mapOut[tileX][tileY][layer]);
                        this.mapOut[tileX][tileY][layer] = this.mtl.getTileSetGID(this.mapOut[tileX - 1][tileY][layer]) == tileRange && this.mtl.getTileSetGID(this.mapOut[tileX + 1][tileY][layer]) == tileRange && this.mtl.getTileSetGID(this.mapOut[tileX][tileY + 1][layer]) != tileRange ? Utilities.randomInt(25) + tileRange + 25 : (this.mtl.getTileSetGID(this.mapOut[tileX - 1][tileY][layer]) != tileRange && this.mtl.getTileSetGID(this.mapOut[tileX + 1][tileY][layer]) == tileRange && this.mtl.getTileSetGID(this.mapOut[tileX][tileY + 1][layer]) != tileRange ? Utilities.randomInt(5) + tileRange + 50 : (this.mtl.getTileSetGID(this.mapOut[tileX - 1][tileY][layer]) == tileRange && this.mtl.getTileSetGID(this.mapOut[tileX + 1][tileY][layer]) != tileRange && this.mtl.getTileSetGID(this.mapOut[tileX][tileY + 1][layer]) != tileRange ? Utilities.randomInt(5) + tileRange + 55 : (this.mtl.getTileSetGID(this.mapOut[tileX][tileY - 1][layer]) != tileRange && this.mtl.getTileSetGID(this.mapOut[tileX - 1][tileY][layer]) != tileRange && this.mtl.getTileSetGID(this.mapOut[tileX + 1][tileY][layer]) == tileRange && this.mtl.getTileSetGID(this.mapOut[tileX][tileY + 1][layer]) == tileRange ? Utilities.randomInt(5) + tileRange + 60 : (this.mtl.getTileSetGID(this.mapOut[tileX][tileY - 1][layer]) != tileRange && this.mtl.getTileSetGID(this.mapOut[tileX - 1][tileY][layer]) == tileRange && this.mtl.getTileSetGID(this.mapOut[tileX + 1][tileY][layer]) != tileRange && this.mtl.getTileSetGID(this.mapOut[tileX][tileY + 1][layer]) == tileRange ? Utilities.randomInt(5) + tileRange + 65 : (this.mtl.getTileSetGID(this.mapOut[tileX][tileY - 1][layer]) != tileRange && this.mtl.getTileSetGID(this.mapOut[tileX - 1][tileY][layer]) != tileRange && this.mtl.getTileSetGID(this.mapOut[tileX + 1][tileY][layer]) != tileRange && this.mtl.getTileSetGID(this.mapOut[tileX][tileY + 1][layer]) == tileRange ? Utilities.randomInt(5) + tileRange + 70 : (this.mtl.getTileSetGID(this.mapOut[tileX - 1][tileY][layer]) != tileRange && this.mtl.getTileSetGID(this.mapOut[tileX + 1][tileY][layer]) != tileRange && this.mtl.getTileSetGID(this.mapOut[tileX][tileY + 1][layer]) != tileRange ? Utilities.randomInt(5) + tileRange + 75 : Utilities.randomInt(25) + tileRange))))));
                    }
                    ++layer;
                }
                ++tileY;
            }
            ++tileX;
        }
    }

    private void cleanup() throws SlickException {
        this.cleanupRooms();
        this.cleanupItems();
        this.randomizeTerrain();
        this.randomizeWalls();
    }

    private void cleanupRooms() throws SlickException {
        for (OrderedPair m : this.roomConnectionPoints) {
            boolean addWall = true;
            int x = -1;
            while (x <= 1) {
                if (!Utilities.isOutOfBounds(this.map.getMapWidth(), this.map.getMapHeight(), x + m.getX(), m.getY()) && this.mapOut[x + m.getX()][m.getY()][this.map.getLayerTopographyBottom()] == 0 && this.roomsPlaced[x + m.getX()][m.getY()] == 0) {
                    addWall = false;
                    this.object.addObject(m.getX(), m.getY(), ObjectModule.ObjectType.DOOR_WE);
                }
                ++x;
            }
            int y = -1;
            while (y <= 1) {
                if (!Utilities.isOutOfBounds(this.map.getMapWidth(), this.map.getMapHeight(), m.getX(), y + m.getY()) && this.mapOut[m.getX()][y + m.getY()][this.map.getLayerTopographyBottom()] == 0 && this.roomsPlaced[m.getX()][y + m.getY()] == 0) {
                    addWall = false;
                    this.object.addObject(m.getX(), m.getY(), ObjectModule.ObjectType.DOOR_NS);
                }
                ++y;
            }
            if (!addWall) continue;
            this.addTile(m.getX(), m.getY(), MapTilesLoader.TileSet.WALL_STONE);
        }
        for (OrderedPair m : this.roomConnectionPoints) {
            boolean removeWall = false;
            ObjectModule.ObjectType doorDirection = null;
            int x = -1;
            while (x <= 1) {
                if (x != 0 && !Utilities.isOutOfBounds(this.map.getMapWidth(), this.map.getMapHeight(), x + m.getX(), m.getY()) && this.roomConnectionPoints.contains(OrderedPair.getOrderedPair(x + m.getX(), m.getY()))) {
                    removeWall = true;
                    doorDirection = ObjectModule.ObjectType.DOOR_WE;
                }
                ++x;
            }
            int y = -1;
            while (y <= 1) {
                if (y != 0 && !Utilities.isOutOfBounds(this.map.getMapWidth(), this.map.getMapHeight(), m.getX(), y + m.getY()) && this.roomConnectionPoints.contains(OrderedPair.getOrderedPair(m.getX(), y + m.getY()))) {
                    removeWall = true;
                    doorDirection = ObjectModule.ObjectType.DOOR_NS;
                }
                ++y;
            }
            if (!removeWall) continue;
            this.eraseWall(m.getX(), m.getY());
            this.object.addObject(m.getX(), m.getY(), doorDirection);
        }
    }

    private void cleanupItems() {
        int x = 1;
        while (x < this.mapOut.length - 1) {
            int y = 1;
            while (y < this.mapOut[x].length - 1) {
                if (this.object.getObject(x, y) != null && (this.object.getObject(x, y).getType() == ObjectModule.ObjectType.DOOR_NS || this.object.getObject(x, y).getType() == ObjectModule.ObjectType.DOOR_WE)) {
                    int x2 = -1;
                    while (x2 <= 1) {
                        if (!(x2 == 0 || Utilities.isOutOfBounds(this.map.getMapWidth(), this.map.getMapHeight(), x2 + x, y) || this.object.getObject(x2 + x, y) == null || this.object.getObject(x2 + x, y).getType() != ObjectModule.ObjectType.DOOR_NS && this.object.getObject(x2 + x, y).getType() != ObjectModule.ObjectType.DOOR_WE)) {
                            this.object.removeObject(x, y);
                            break;
                        }
                        ++x2;
                    }
                    int y2 = -1;
                    while (y2 <= 1) {
                        if (!(y2 == 0 || Utilities.isOutOfBounds(this.map.getMapWidth(), this.map.getMapHeight(), x, y2 + y) || this.object.getObject(x, y2 + y) == null || this.object.getObject(x, y2 + y).getType() != ObjectModule.ObjectType.DOOR_NS && this.object.getObject(x, y2 + y).getType() != ObjectModule.ObjectType.DOOR_WE)) {
                            this.object.removeObject(x, y);
                            break;
                        }
                        ++y2;
                    }
                }
                ++y;
            }
            ++x;
        }
    }

    private ArrayList<OrderedPair> createPath(int startX, int startY, int goalX, int goalY, int randomVariance) {
        if (goalX < 0 || goalX > this.map.getMapWidth() - 1 || goalY < 0 || goalY > this.map.getMapHeight() - 1) {
            return null;
        }
        if (startX == goalX && startY == goalY) {
            ArrayList<OrderedPair> returnedPath = new ArrayList<OrderedPair>();
            returnedPath.add(OrderedPair.getOrderedPair(goalX, goalY));
            return returnedPath;
        }
        boolean running = true;
        while (running) {
            this.resetOldPathNodes();
            this.openPathNodes.clear();
            this.basePathNode = this.pathNodes[startX][startY];
            this.openPathNodes.add(this.pathNodes[startX][startY]);
            this.pathNodes[startX][startY].openNode();
            this.pathNodes[startX][startY].resetNode(goalX, goalY);
            this.resettablePathNodes.add(this.pathNodes[startX][startY]);
            boolean foundPath = false;
            while (!foundPath) {
                this.basePathNode = this.openPathNodes.poll();
                int thisX = this.basePathNode.getX();
                int thisY = this.basePathNode.getY();
                int x = -1;
                while (x < 2) {
                    int y = -1;
                    while (y < 2) {
                        if (x != 0 || y != 0) {
                            int checkX = thisX + x;
                            int checkY = thisY + y;
                            if (checkX <= this.map.getMapWidth() - 2 && checkX >= 2 && checkY <= this.map.getMapHeight() - 2 && checkY >= 2) {
                                if (this.pathNodes[checkX][checkY].isResettable()) {
                                    this.pathNodes[checkX][checkY].resetNode(goalX, goalY);
                                }
                                if (!this.pathNodes[checkX][checkY].isClosed()) {
                                    this.resettablePathNodes.add(this.pathNodes[checkX][checkY]);
                                    if (this.map.getMapTileLoader().getTileType(this.mapOut[checkX][checkY][this.map.getLayerTopographyBottom()]) != MapTilesLoader.TileType.WALL && (checkX <= thisX || checkY <= thisY || this.map.getMapTileLoader().getTileType(this.mapOut[checkX - 1][checkY][this.map.getLayerTopographyBottom()]) != MapTilesLoader.TileType.WALL && this.map.getMapTileLoader().getTileType(this.mapOut[checkX][checkY - 1][this.map.getLayerTopographyBottom()]) != MapTilesLoader.TileType.WALL) && (checkX >= thisX || checkY >= thisY || this.map.getMapTileLoader().getTileType(this.mapOut[checkX + 1][checkY][this.map.getLayerTopographyBottom()]) != MapTilesLoader.TileType.WALL && this.map.getMapTileLoader().getTileType(this.mapOut[checkX][checkY + 1][this.map.getLayerTopographyBottom()]) != MapTilesLoader.TileType.WALL) && (checkX <= thisX || checkY >= thisY || this.map.getMapTileLoader().getTileType(this.mapOut[checkX - 1][checkY][this.map.getLayerTopographyBottom()]) != MapTilesLoader.TileType.WALL && this.map.getMapTileLoader().getTileType(this.mapOut[checkX][checkY + 1][this.map.getLayerTopographyBottom()]) != MapTilesLoader.TileType.WALL) && (checkX >= thisX || checkY <= thisY || this.map.getMapTileLoader().getTileType(this.mapOut[checkX + 1][checkY][this.map.getLayerTopographyBottom()]) != MapTilesLoader.TileType.WALL && this.map.getMapTileLoader().getTileType(this.mapOut[checkX][checkY - 1][this.map.getLayerTopographyBottom()]) != MapTilesLoader.TileType.WALL)) {
                                        PathNode checkNode = this.pathNodes[checkX][checkY];
                                        int movementCost = Utilities.randomInt(randomVariance);
                                        if (checkX > thisX && checkY > thisY || checkX < thisX && checkY < thisY || checkX > thisX && checkY < thisY || checkX < thisX && checkY > thisY) {
                                            movementCost = (int)((double)movementCost + (double)movementCost * 0.4);
                                        }
                                        if (checkNode.isOpen()) {
                                            int gValueCheck = this.basePathNode.getG() + movementCost;
                                            if (gValueCheck < checkNode.getG()) {
                                                checkNode.setParent(this.basePathNode);
                                            }
                                        } else {
                                            checkNode.openNode();
                                            checkNode.setParent(this.basePathNode);
                                            checkNode.setG(this.basePathNode.getG() + movementCost);
                                            checkNode.calcF();
                                            this.openPathNodes.add(checkNode);
                                            if (checkX == goalX && checkY == goalY) {
                                                return this.buildPath(checkNode);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        ++y;
                    }
                    ++x;
                }
                this.basePathNode.closeNode();
                if (this.openPathNodes.size() <= 0) break;
            }
            running = false;
        }
        return null;
    }

    public ArrayList<OrderedPair> buildPath(PathNode node) {
        ArrayList<OrderedPair> returnedPath = new ArrayList<OrderedPair>();
        PathNode nextNode = node;
        OrderedPair nextPair = OrderedPair.getOrderedPair(node.getX(), node.getY());
        returnedPath.add(nextPair);
        while (nextNode.getParent() != null) {
            nextNode = nextNode.getParent();
            nextPair = OrderedPair.getOrderedPair(nextNode.getX(), nextNode.getY());
            returnedPath.add(nextPair);
        }
        return returnedPath;
    }

    private void createPatch(int startX, int startY, int randomVariance, int distance, int sparsity, boolean allowOverwrite, MapTilesLoader.TileSet tileSet) throws SlickException {
        this.createPatch(startX, startY, randomVariance, distance, sparsity, allowOverwrite, tileSet, null);
    }

    private void createPatch(int startX, int startY, int randomVariance, int distance, int sparsity, boolean allowOverwrite, ItemModule.ItemType itemType) throws SlickException {
        this.createPatch(startX, startY, randomVariance, distance, sparsity, allowOverwrite, null, itemType);
    }

    private void createPatch(int startX, int startY, int randomVariance, int distance, int sparsity, boolean allowOverwrite, MapTilesLoader.TileSet tileSet, ItemModule.ItemType itemType) throws SlickException {
        if (Utilities.isOutOfBounds(this.map.getMapWidth(), this.map.getMapHeight(), startX, startY)) {
            return;
        }
        this.resetOldPathNodes();
        this.openPathNodes.clear();
        this.basePathNode = this.pathNodes[startX][startY];
        this.openPathNodes.add(this.pathNodes[startX][startY]);
        this.pathNodes[startX][startY].openNode();
        this.pathNodes[startX][startY].resetNode(startX, startY);
        this.resettablePathNodes.add(this.pathNodes[startX][startY]);
        int movementCostMax = distance * 1000;
        int layer = 0;
        if (tileSet != null) {
            int tileRange = this.mtl.getTileSetGID(tileSet);
            this.mtl.checkAndloadTileset(this.mtl.getTileSetGID(tileSet));
            layer = this.mtl.getTileLayer(tileRange);
        } else if (itemType != null) {
            layer = this.map.getLayerTopographyBottom();
        }
        if (tileSet == null && itemType == null) {
            this.eraseAll(startX, startY);
        }
        if (tileSet != null && (allowOverwrite || this.mapOut[startX][startY][layer] == 0)) {
            this.addTile(startX, startY, tileSet);
        }
        if (itemType != null && (allowOverwrite || this.mapOut[startX][startY][layer] == 0)) {
            this.item.addItem(startX, startY, itemType);
        }
        while (this.openPathNodes.size() > 0) {
            this.basePathNode = this.openPathNodes.poll();
            int thisX = this.basePathNode.getX();
            int thisY = this.basePathNode.getY();
            int x = -1;
            while (x < 2) {
                int y = -1;
                while (y < 2) {
                    if (x != 0 || y != 0) {
                        int checkX = thisX + x;
                        int checkY = thisY + y;
                        if (checkX <= this.map.getMapWidth() - 1 && checkX >= 1 && checkY <= this.map.getMapHeight() - 1 && checkY >= 1) {
                            if (this.pathNodes[checkX][checkY].isResettable()) {
                                this.pathNodes[checkX][checkY].resetNode(startX, startY);
                            }
                            if (!this.pathNodes[checkX][checkY].isClosed()) {
                                this.resettablePathNodes.add(this.pathNodes[checkX][checkY]);
                                if (allowOverwrite || this.mapOut[checkX][checkY][layer] <= 0) {
                                    PathNode checkNode = this.pathNodes[checkX][checkY];
                                    int movementCost = Utilities.randomInt(randomVariance) + 1000;
                                    if (checkX > thisX && checkY > thisY || checkX < thisX && checkY < thisY || checkX > thisX && checkY < thisY || checkX < thisX && checkY > thisY) {
                                        movementCost = (int)((double)movementCost + (double)movementCost * 0.4);
                                    }
                                    if (!checkNode.isOpen()) {
                                        checkNode.setG(this.basePathNode.getG() + movementCost);
                                        if (checkNode.getG() < movementCostMax) {
                                            checkNode.openNode();
                                            this.openPathNodes.add(checkNode);
                                            if (sparsity == -1 || Utilities.randomInt(sparsity) == 0) {
                                                if (tileSet == null && itemType == null) {
                                                    this.eraseAll(checkX, checkY);
                                                    this.item.removeItem(checkX, checkY);
                                                } else {
                                                    if (tileSet != null && (allowOverwrite || this.mapOut[checkX][checkY][layer] == 0)) {
                                                        this.addTile(checkX, checkY, tileSet);
                                                    }
                                                    if (itemType != null && (allowOverwrite || this.mapOut[checkX][checkY][layer] == 0)) {
                                                        this.item.addItem(checkX, checkY, itemType);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    ++y;
                }
                ++x;
            }
            this.basePathNode.closeNode();
        }
    }

    private void resetOldPathNodes() {
        for (PathNode p : this.resettablePathNodes) {
            p.flagResettable();
        }
        this.resettablePathNodes.clear();
    }

    public void eraseAll(int tileX, int tileY) throws SlickException {
        int l = this.map.getLayerTerrainBottom();
        while (l < this.map.getMapLayers()) {
            if (this.map.getMapTileLoader().getTileType(this.mapOut[tileX][tileY][l]) != MapTilesLoader.TileType.WALL) {
                this.mapOut[tileX][tileY][l] = 0;
            }
            ++l;
        }
    }

    public void eraseTerrain(int tileX, int tileY) throws SlickException {
        this.mapOut[tileX][tileY][this.map.getLayerTerrainBottom()] = 0;
        this.mapOut[tileX][tileY][this.map.getLayerTerrainTop()] = 0;
    }

    public void eraseTopography(int tileX, int tileY) throws SlickException {
        if (this.map.getMapTileLoader().getTileType(this.mapOut[tileX][tileY][this.map.getLayerTopographyBottom()]) != MapTilesLoader.TileType.WALL) {
            this.mapOut[tileX][tileY][this.map.getLayerTopographyBottom()] = 0;
        }
        this.mapOut[tileX][tileY][this.map.getLayerTopographyTop()] = 0;
    }

    public void eraseWall(int tileX, int tileY) throws SlickException {
        if (this.map.getMapTileLoader().getTileType(this.mapOut[tileX][tileY][this.map.getLayerTopographyBottom()]) == MapTilesLoader.TileType.WALL) {
            this.mapOut[tileX][tileY][this.map.getLayerTopographyBottom()] = 0;
        }
    }

    public void addTile(int tileX, int tileY, MapTilesLoader.TileSet tileSet) throws SlickException {
        int tileGID = this.mtl.getTileSetGID(tileSet);
        this.mtl.checkAndloadTileset(this.mtl.getTileSetGID(tileSet));
        byte layer = this.mtl.getTileLayer(tileGID);
        this.mapOut[tileX][tileY][layer] = tileGID;
    }
}

