/*
 * Decompiled with CFR 0.152.
 */
package rtr.map;

import java.util.ArrayList;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.ImageBuffer;
import org.newdawn.slick.SlickException;
import rtr.ModuleBase;
import rtr.item.ItemBase;
import rtr.map.MapTilesLoader;
import rtr.mobs.MobBase;
import rtr.object.ObjectBase;
import rtr.states.StateBase;
import rtr.system.ScaleControl;
import rtr.utilities.ArrayFillUtil;
import rtr.utilities.Utilities;

public class MiniMapModule
extends ModuleBase {
    private byte[][] refreshMap;
    private ImageBuffer miniMapBufferBottom;
    private ImageBuffer miniMapBufferTop;
    private Image miniMapBottom;
    private Image miniMapTop;
    private Image miniMapFull;
    private int mapHeight;
    private int mapWidth;
    private int mapLayers;
    private int mapRefresh = 11;

    @Override
    public void initModule(StateBase cS) throws SlickException {
        super.initModule(cS);
        this.buildMap();
    }

    @Override
    public void resetModule() throws SlickException {
        super.resetModule();
        ArrayFillUtil.fill(this.refreshMap, (byte)0);
        this.miniMapBufferBottom = null;
        this.miniMapBufferTop = null;
        this.miniMapBottom = null;
        this.miniMapTop = null;
        this.miniMapFull = null;
        this.mapHeight = 0;
        this.mapWidth = 0;
        this.mapLayers = 0;
        this.mapRefresh = 11;
    }

    public Image getMiniMapFull() throws SlickException {
        return this.miniMapFull;
    }

    public void render(float x, float y, int size, Graphics g) {
        int tileY;
        int tileX;
        g.setWorldClip(x, y, size, size);
        x = x - (float)this.mob.getHero().getTileX() + (float)(size / 2);
        y = y - (float)this.mob.getHero().getTileY() + (float)(size / 2);
        this.miniMapBottom.draw(x, y);
        this.miniMapTop.draw(x, y);
        g.glBeginPoints(1 * ScaleControl.getScale());
        g.setColor(Color.green);
        if (this.item != null) {
            tileX = 0;
            while (tileX < this.mapWidth) {
                tileY = 0;
                while (tileY < this.mapHeight) {
                    ItemBase i = this.item.getItem(tileX, tileY);
                    if (i != null) {
                        g.pointEmbedded(x + (float)i.getTileX(), y + (float)i.getTileY());
                    }
                    ++tileY;
                }
                ++tileX;
            }
        }
        g.setColor(Color.white);
        if (this.object != null) {
            tileX = 0;
            while (tileX < this.mapWidth) {
                tileY = 0;
                while (tileY < this.mapHeight) {
                    ObjectBase o = this.object.getObject(tileX, tileY);
                    if (o != null) {
                        g.pointEmbedded(x + (float)o.getTileX(), y + (float)o.getTileY());
                    }
                    ++tileY;
                }
                ++tileX;
            }
        }
        if (this.mob != null) {
            ArrayList<MobBase> mobArray = this.mob.getMobArray();
            for (MobBase e : mobArray) {
                float mobX = x + (float)e.getTileX() - 1.0f;
                float mobY = y + (float)e.getTileY() - 1.0f;
                if (e.getCommandState() == MobBase.MobCommand.DEAD) continue;
                if (e.getMobGroup() == MobBase.MobGroup.HOSTILE) {
                    g.setColor(Color.red);
                    g.pointEmbedded(mobX, mobY);
                    continue;
                }
                if (e.getMobGroup() != MobBase.MobGroup.FRIENDLY) continue;
                g.setColor(Color.green);
                g.pointEmbedded(mobX, mobY);
            }
        }
        g.glEnd();
        g.clearWorldClip();
    }

    public void update() throws SlickException {
        ++this.mapRefresh;
    }

    private void buildMap() throws SlickException {
        this.mapHeight = this.map.getMapHeight();
        this.mapWidth = this.map.getMapWidth();
        this.mapLayers = this.map.getMapLayers();
        this.refreshMap = new byte[this.mapWidth][this.mapHeight];
        this.miniMapBufferBottom = new ImageBuffer(this.mapWidth, this.mapHeight);
        this.miniMapBufferTop = new ImageBuffer(this.mapWidth, this.mapHeight);
        this.miniMapFull = new Image(this.mapWidth, this.mapHeight);
        int x = 0;
        while (x < this.mapWidth) {
            int y = 0;
            while (y < this.mapHeight) {
                this.setColor(x, y);
                ++y;
            }
            ++x;
        }
        this.miniMapBottom = this.miniMapBufferBottom.getImage(9728);
        this.miniMapTop = this.miniMapBufferTop.getImage(9728);
    }

    private void updateMap() throws SlickException {
        this.miniMapBottom.destroy();
        this.miniMapTop.destroy();
        int x = 0;
        while (x < this.mapWidth) {
            int y = 0;
            while (y < this.mapHeight) {
                if (this.refreshMap[x][y] != 0) {
                    this.setColor(x, y);
                }
                ++y;
            }
            ++x;
        }
        this.miniMapBottom = this.miniMapBufferBottom.getImage(9728);
        this.miniMapTop = this.miniMapBufferTop.getImage(9728);
        this.refreshMap = new byte[this.mapWidth][this.mapHeight];
    }

    private void setColor(int x, int y) {
        this.miniMapBufferBottom.setRGBA(x, y, 0, 0, 0, 0);
        this.miniMapBufferTop.setRGBA(x, y, 0, 0, 0, 0);
        int l = this.mapLayers - 1;
        while (l >= 0) {
            int tileID = this.map.getTileId(x, y, l);
            if (tileID != 0) {
                int random = Utilities.randomInt(25);
                if (l == this.map.getLayerBaseTerrainBottom() || l == this.map.getLayerBaseTerrainTop()) {
                    this.miniMapBufferBottom.setRGBA(x, y, 0 + random, 0 + random, 0 + random, 255);
                    break;
                }
                if (l == this.map.getLayerTerrainBottom() || l == this.map.getLayerTerrainTop()) {
                    this.miniMapBufferBottom.setRGBA(x, y, 25 + random, 25 + random, 25 + random, 255);
                    break;
                }
                if (l == this.map.getLayerTopographyBottom()) {
                    if (this.map.getMapTileLoader().getTileType(tileID) == MapTilesLoader.TileType.WALL) {
                        this.miniMapBufferTop.setRGBA(x, y, 25 + random, 125 + random, 225 + random, 255);
                        break;
                    }
                    this.miniMapBufferTop.setRGBA(x, y, 125 + random, 125 + random, 125 + random, 255);
                    break;
                }
                if (l == this.map.getLayerTopographyTop()) {
                    this.miniMapBufferTop.setRGBA(x, y, 155 + random, 155 + random, 155 + random, 255);
                    break;
                }
            }
            --l;
        }
    }

    public void flagForUpdate(int tileX, int tileY) {
        this.refreshMap[tileX][tileY] = 1;
        this.mapRefresh = 0;
    }
}

