/*
 * Decompiled with CFR 0.152.
 */
package rtr.map;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;
import rtr.ImageLoader;
import rtr.map.MapModule;
import rtr.map.tileSets.Bricks;
import rtr.map.tileSets.BricksAccent;
import rtr.map.tileSets.Dirt;
import rtr.map.tileSets.DirtAccent;
import rtr.map.tileSets.Grass;
import rtr.map.tileSets.GrassAccent;
import rtr.map.tileSets.Gravel;
import rtr.map.tileSets.GravelAccent;
import rtr.map.tileSets.Rocks;
import rtr.map.tileSets.RocksAccent;
import rtr.map.tileSets.Sand;
import rtr.map.tileSets.SandAccent;
import rtr.map.tileSets.TileSetBase;
import rtr.map.tileSets.Tiles;
import rtr.map.tileSets.TilesAccent;
import rtr.map.tileSets.WallStoneTerrain;
import rtr.states.StateBase;

public class MapTilesLoader {
    private MapModule map = StateBase.getMapModule();
    InputStream input;
    private HashMap<Integer, Image> tiles = new HashMap();
    private HashMap<Integer, byte[][]> collisionTiles = new HashMap();
    private HashMap<Integer, byte[][]> particleTiles = new HashMap();
    private HashMap<Integer, byte[][]> shadowTiles = new HashMap();
    private HashMap<Integer, Image> objects = new HashMap();
    private HashMap<TileSet, Integer> tileSetToGID = new HashMap();
    private HashMap<Integer, TileSet> GIDToTileSet = new HashMap();
    private HashMap<Integer, Boolean> isLoaded = new HashMap();
    private Properties properties = new Properties();
    private HashMap<Integer, String> tileName = new HashMap();
    private HashMap<Integer, Byte> tileBlocked = new HashMap();
    private HashMap<Integer, Byte> tileBlockLight = new HashMap();
    private HashMap<Integer, Byte> tileParticles = new HashMap();
    private HashMap<Integer, Byte> tileShadow = new HashMap();
    private HashMap<Integer, Byte> tileLight = new HashMap();
    private HashMap<Integer, Byte> tileLayer = new HashMap();
    private HashMap<Integer, TileType> tileType = new HashMap();
    private HashMap<Integer, Byte> tileCollision = new HashMap();
    private HashMap<Integer, Byte> tileInvulnerable = new HashMap();
    private HashMap<Integer, Color> tileMiniMapColor = new HashMap();
    private HashMap<Integer, Byte> tilePropHeight = new HashMap();
    private HashMap<Integer, Byte> tilePropWidth = new HashMap();
    private Color[] colorNorth;
    private Color[] colorEast;
    private Color[] colorSouth;
    private Color[] colorWest;
    private Color[] colorAll;
    private static final byte COLLISION_NONE = 0;
    private static final byte COLLISION_NORTH_LOW = 1;
    private static final byte COLLISION_NORTH_MEDIUM = 2;
    private static final byte COLLISION_NORTH_HIGH = 3;
    private static final byte COLLISION_EAST_LOW = 4;
    private static final byte COLLISION_EAST_MEDIUM = 5;
    private static final byte COLLISION_EAST_HIGH = 6;
    private static final byte COLLISION_SOUTH_LOW = 7;
    private static final byte COLLISION_SOUTH_MEDIUM = 8;
    private static final byte COLLISION_SOUTH_HIGH = 9;
    private static final byte COLLISION_WEST_LOW = 10;
    private static final byte COLLISION_WEST_MEDIUM = 11;
    private static final byte COLLISION_WEST_HIGH = 12;
    private static final byte COLLISION_ALL_LOW = 13;
    private static final byte COLLISION_ALL_MEDIUM = 14;
    private static final byte COLLISION_ALL_HIGH = 15;
    private static final Color fireRedVeryLow = new Color(100, 50, 50);
    private static final Color fireRedLow = new Color(150, 50, 50);
    private static final Color fireRedMedium = new Color(200, 50, 50);
    private static final Color fireRedHigh = new Color(250, 50, 50);
    private static final Color fireYellowVeryLow = new Color(100, 100, 50);
    private static final Color fireYellowLow = new Color(150, 150, 50);
    private static final Color fireYellowMedium = new Color(200, 200, 50);
    private static final Color fireYellowHigh = new Color(250, 250, 50);
    private static final Color fireGreenVeryLow = new Color(50, 100, 50);
    private static final Color fireGreenLow = new Color(50, 150, 50);
    private static final Color fireGreenMedium = new Color(50, 200, 50);
    private static final Color fireGreenHigh = new Color(50, 250, 50);
    private static final Color fireBlueVeryLow = new Color(50, 50, 100);
    private static final Color fireBlueLow = new Color(50, 50, 150);
    private static final Color fireBlueMedium = new Color(50, 50, 200);
    private static final Color fireBlueHigh = new Color(50, 50, 250);
    private static final Color firePurpleVeryLow = new Color(100, 50, 100);
    private static final Color firePurpleLow = new Color(150, 50, 150);
    private static final Color firePurpleMedium = new Color(200, 50, 200);
    private static final Color firePurpleHigh = new Color(250, 50, 250);
    private static final Color magicRedLow = new Color(250, 100, 100);
    private static final Color magicRedMedium = new Color(250, 150, 150);
    private static final Color magicRedHigh = new Color(250, 200, 200);
    private static final Color magicYellowLow = new Color(250, 250, 100);
    private static final Color magicYellowMedium = new Color(250, 250, 150);
    private static final Color magicYellowHigh = new Color(250, 250, 200);
    private static final Color magicGreenLow = new Color(100, 250, 100);
    private static final Color magicGreenMedium = new Color(150, 250, 150);
    private static final Color magicGreenHigh = new Color(200, 250, 200);
    private static final Color magicBlueLow = new Color(100, 100, 250);
    private static final Color magicBlueMedium = new Color(150, 150, 250);
    private static final Color magicBlueHigh = new Color(200, 200, 250);
    private static final Color magicPurpleLow = new Color(250, 100, 250);
    private static final Color magicPurpleMedium = new Color(250, 150, 250);
    private static final Color magicPurpleHigh = new Color(250, 200, 250);
    private static final Color smokeLow = new Color(150, 150, 150);
    private static final Color smokeMedium = new Color(200, 200, 200);
    private static final Color smokeHigh = new Color(250, 250, 250);
    private static final Color redSparklesVeryLow = new Color(100, 0, 0);
    private static final Color redSparklesLow = new Color(150, 0, 0);
    private static final Color redSparklesMedium = new Color(200, 0, 0);
    private static final Color redSparklesHigh = new Color(250, 0, 0);
    private static final Color greenSparklesVeryLow = new Color(0, 100, 0);
    private static final Color greenSparklesLow = new Color(0, 150, 0);
    private static final Color greenSparklesMedium = new Color(0, 200, 0);
    private static final Color greenSparklesHigh = new Color(0, 250, 0);
    private static final Color blueSparklesVeryLow = new Color(0, 0, 100);
    private static final Color blueSparklesLow = new Color(0, 0, 150);
    private static final Color blueSparklesMedium = new Color(0, 0, 200);
    private static final Color blueSparklesHigh = new Color(0, 0, 250);
    private static final Color purpleSparklesVeryLow = new Color(100, 0, 100);
    private static final Color purpleSparklesLow = new Color(150, 0, 150);
    private static final Color purpleSparklesMedium = new Color(200, 0, 200);
    private static final Color purpleSparklesHigh = new Color(250, 0, 250);

    MapTilesLoader() throws SlickException {
        if (this.colorNorth == null) {
            this.colorNorth = new Color[3];
            this.colorNorth[0] = new Color(50, 0, 0, 255);
            this.colorNorth[1] = new Color(150, 0, 0, 255);
            this.colorNorth[2] = new Color(250, 0, 0, 255);
        }
        if (this.colorEast == null) {
            this.colorEast = new Color[3];
            this.colorEast[0] = new Color(50, 50, 0, 255);
            this.colorEast[1] = new Color(150, 150, 0, 255);
            this.colorEast[2] = new Color(250, 250, 0, 255);
        }
        if (this.colorSouth == null) {
            this.colorSouth = new Color[3];
            this.colorSouth[0] = new Color(0, 50, 0, 255);
            this.colorSouth[1] = new Color(0, 150, 0, 255);
            this.colorSouth[2] = new Color(0, 250, 0, 255);
        }
        if (this.colorWest == null) {
            this.colorWest = new Color[3];
            this.colorWest[0] = new Color(0, 0, 50, 255);
            this.colorWest[1] = new Color(0, 0, 150, 255);
            this.colorWest[2] = new Color(0, 0, 250, 255);
        }
        if (this.colorAll == null) {
            this.colorAll = new Color[3];
            this.colorAll[0] = new Color(50, 50, 50, 255);
            this.colorAll[1] = new Color(150, 150, 150, 255);
            this.colorAll[2] = new Color(250, 250, 250, 255);
        }
        TileSet[] tileSetArray = TileSet.values();
        int n = tileSetArray.length;
        int n2 = 0;
        while (n2 < n) {
            TileSet t = tileSetArray[n2];
            this.addTileSetToDatabase(t, t.getTileSetTemplate().getTileGID());
            ++n2;
        }
    }

    private void addTileSetToDatabase(TileSet t, int i) {
        this.tileSetToGID.put(t, i);
        this.GIDToTileSet.put(i, t);
    }

    public void checkAndloadTileset(int tileID) throws SlickException {
        int globalID = this.getTileSetGID(tileID);
        if (this.isLoaded.get(globalID) == null || !this.isLoaded.get(globalID).booleanValue()) {
            TileSet t = this.getTileSetByGID(globalID);
            TileSetBase template = t.getTileSetTemplate();
            template.initialize();
            this.loadTerrain(template);
            System.out.println("Loaded Tileset: " + (Object)((Object)t) + " (" + globalID + ")");
        }
    }

    private void loadTerrain(TileSetBase tileSetBase) throws SlickException {
        int tileID;
        int x;
        int y;
        this.properties.clear();
        Image baseImage = ImageLoader.getImage("res/maps/base/" + tileSetBase.getFileName() + ".png");
        SpriteSheet baseSheet = new SpriteSheet(baseImage, this.map.getTileWidth(), this.map.getTileHeight());
        int startGID = tileSetBase.getTileGID();
        int tileSheetH = baseSheet.getHorizontalCount();
        int tileSheetV = baseSheet.getVerticalCount();
        this.isLoaded.put(startGID, true);
        int y2 = 0;
        while (y2 < tileSheetV) {
            int x2 = 0;
            while (x2 < tileSheetH) {
                int tileID2 = y2 * tileSheetH + x2;
                this.tiles.put(startGID + tileID2, baseSheet.getSprite(x2, y2));
                this.tileName.put(startGID + tileID2, tileSetBase.getName());
                this.tileLayer.put(startGID + tileID2, tileSetBase.getLayer());
                this.tileType.put(startGID + tileID2, tileSetBase.getType());
                this.tileMiniMapColor.put(startGID + tileID2, tileSetBase.getMiniMapColor());
                ++x2;
            }
            ++y2;
        }
        InputStream in = MapTilesLoader.class.getResourceAsStream("/res/maps/data/" + tileSetBase.getFileName() + ".png");
        if (in != null) {
            Image dataImage = ImageLoader.getImage("res/maps/data/" + tileSetBase.getFileName() + ".png");
            SpriteSheet dataSheet = new SpriteSheet(dataImage, this.map.getTileWidth(), this.map.getTileHeight());
            y = 0;
            while (y < tileSheetV) {
                x = 0;
                while (x < tileSheetH) {
                    tileID = y * tileSheetH + x;
                    this.generateBasicTileData(tileSetBase, x, y, startGID, tileID, dataSheet);
                    ++x;
                }
                ++y;
            }
            dataSheet.flushPixelData();
            ImageLoader.unloadImage("res/maps/data/" + tileSetBase.getFileName() + ".png");
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if ((in = MapTilesLoader.class.getResourceAsStream("/res/maps/collision/" + tileSetBase.getFileName() + ".png")) != null) {
            Image collisionImage = ImageLoader.getImage("res/maps/collision/" + tileSetBase.getFileName() + ".png");
            SpriteSheet collisionSheet = new SpriteSheet(collisionImage, this.map.getTileWidth(), this.map.getTileHeight());
            y = 0;
            while (y < tileSheetV) {
                x = 0;
                while (x < tileSheetH) {
                    tileID = y * tileSheetH + x;
                    this.generateCollisionData(tileSetBase, x, y, startGID, tileID, collisionSheet);
                    ++x;
                }
                ++y;
            }
            collisionSheet.flushPixelData();
            ImageLoader.unloadImage("res/maps/collision/" + tileSetBase.getFileName() + ".png");
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if ((in = MapTilesLoader.class.getResourceAsStream("/res/maps/particle/" + tileSetBase.getFileName() + ".png")) != null) {
            Image particleImage = ImageLoader.getImage("res/maps/particle/" + tileSetBase.getFileName() + ".png");
            SpriteSheet particleSheet = new SpriteSheet(particleImage, this.map.getTileWidth(), this.map.getTileHeight());
            y = 0;
            while (y < tileSheetV) {
                x = 0;
                while (x < tileSheetH) {
                    tileID = y * tileSheetH + x;
                    this.generateParticleData(tileSetBase, x, y, startGID, tileID, particleSheet);
                    ++x;
                }
                ++y;
            }
            particleSheet.flushPixelData();
            ImageLoader.unloadImage("res/maps/particle/" + tileSetBase.getFileName() + ".png");
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if ((in = MapTilesLoader.class.getResourceAsStream("/res/maps/shadow/" + tileSetBase.getFileName() + ".png")) != null) {
            Image shadowImage = ImageLoader.getImage("res/maps/shadow/" + tileSetBase.getFileName() + ".png");
            SpriteSheet shadowSheet = new SpriteSheet(shadowImage, this.map.getTileWidth(), this.map.getTileHeight());
            y = 0;
            while (y < tileSheetV) {
                x = 0;
                while (x < tileSheetH) {
                    tileID = y * tileSheetH + x;
                    this.generateShadowData(tileSetBase, x, y, startGID, tileID, shadowSheet);
                    ++x;
                }
                ++y;
            }
            shadowSheet.flushPixelData();
            ImageLoader.unloadImage("res/maps/shadow/" + tileSetBase.getFileName() + ".png");
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void generateBasicTileData(TileSetBase tileSetBase, int x, int y, int startGID, int tileID, SpriteSheet dataSheet) {
        Color colorCheck = dataSheet.getColor(x * this.map.getTileWidth(), y * this.map.getTileHeight());
        if (colorCheck.getAlphaByte() > 0) {
            this.tileBlocked.put(startGID + tileID, (byte)1);
        }
        if ((colorCheck = dataSheet.getColor(x * this.map.getTileWidth() + 1, y * this.map.getTileHeight())).getAlphaByte() > 0) {
            this.tileBlockLight.put(startGID + tileID, (byte)1);
        }
        if ((colorCheck = dataSheet.getColor(x * this.map.getTileWidth() + 3, y * this.map.getTileHeight())).getAlphaByte() > 0) {
            this.tileLight.put(startGID + tileID, (byte)(colorCheck.getRedByte() / 10));
        }
        if ((colorCheck = dataSheet.getColor(x * this.map.getTileWidth() + 4, y * this.map.getTileHeight())).getAlphaByte() > 0) {
            this.tileInvulnerable.put(startGID + tileID, (byte)1);
        }
    }

    private void generateCollisionData(TileSetBase tileSetBase, int x, int y, int startGID, int tileID, SpriteSheet collisionSheet) {
        byte[][] tileOut = new byte[this.map.getTileWidth()][this.map.getTileHeight()];
        int startX = x * this.map.getTileWidth();
        int startY = y * this.map.getTileHeight();
        boolean foundCollision = false;
        int w = 0;
        while (w < this.map.getTileWidth()) {
            int h = 0;
            while (h < this.map.getTileHeight()) {
                Color colorCheck = collisionSheet.getColor(startX + w, startY + h);
                if (colorCheck.getAlpha() != 0) {
                    foundCollision = true;
                    tileOut[w][h] = colorCheck.equals(this.colorNorth[0]) ? 1 : (colorCheck.equals(this.colorNorth[1]) ? 2 : (colorCheck.equals(this.colorNorth[2]) ? 3 : (colorCheck.equals(this.colorEast[0]) ? 4 : (colorCheck.equals(this.colorEast[1]) ? 5 : (colorCheck.equals(this.colorEast[2]) ? 6 : (colorCheck.equals(this.colorSouth[0]) ? 7 : (colorCheck.equals(this.colorSouth[1]) ? 8 : (colorCheck.equals(this.colorSouth[2]) ? 9 : (colorCheck.equals(this.colorWest[0]) ? 10 : (colorCheck.equals(this.colorWest[1]) ? 11 : (colorCheck.equals(this.colorWest[2]) ? 12 : (colorCheck.equals(this.colorAll[0]) ? 13 : (colorCheck.equals(this.colorAll[1]) ? 14 : (colorCheck.equals(this.colorAll[2]) ? 15 : 0))))))))))))));
                }
                ++h;
            }
            ++w;
        }
        if (foundCollision) {
            this.tileCollision.put(startGID + tileID, (byte)1);
            this.collisionTiles.put(startGID + tileID, tileOut);
        }
    }

    private void generateParticleData(TileSetBase tileSetBase, int x, int y, int startGID, int tileID, SpriteSheet particleSheet) {
        byte[][] tileOut = new byte[this.map.getTileWidth()][this.map.getTileHeight()];
        int startX = x * this.map.getTileWidth();
        int startY = y * this.map.getTileHeight();
        boolean foundParticle = false;
        int w = 0;
        while (w < this.map.getTileWidth()) {
            int h = 0;
            while (h < this.map.getTileHeight()) {
                Color colorCheck = particleSheet.getColor(startX + w, startY + h);
                if (colorCheck.getAlpha() != 0) {
                    foundParticle = true;
                    tileOut[w][h] = this.getParticleInt(colorCheck);
                }
                ++h;
            }
            if (foundParticle) {
                this.tileParticles.put(startGID + tileID, (byte)1);
                this.particleTiles.put(startGID + tileID, tileOut);
            }
            ++w;
        }
    }

    private byte getParticleInt(Color colorCheck) {
        if (colorCheck.equals(fireRedVeryLow)) {
            return 1;
        }
        if (colorCheck.equals(fireRedLow)) {
            return 2;
        }
        if (colorCheck.equals(fireRedMedium)) {
            return 3;
        }
        if (colorCheck.equals(fireRedHigh)) {
            return 4;
        }
        if (colorCheck.equals(fireYellowVeryLow)) {
            return 5;
        }
        if (colorCheck.equals(fireYellowLow)) {
            return 6;
        }
        if (colorCheck.equals(fireYellowMedium)) {
            return 7;
        }
        if (colorCheck.equals(fireYellowHigh)) {
            return 8;
        }
        if (colorCheck.equals(fireGreenVeryLow)) {
            return 9;
        }
        if (colorCheck.equals(fireGreenLow)) {
            return 10;
        }
        if (colorCheck.equals(fireGreenMedium)) {
            return 11;
        }
        if (colorCheck.equals(fireGreenHigh)) {
            return 12;
        }
        if (colorCheck.equals(fireBlueVeryLow)) {
            return 13;
        }
        if (colorCheck.equals(fireBlueLow)) {
            return 14;
        }
        if (colorCheck.equals(fireBlueMedium)) {
            return 15;
        }
        if (colorCheck.equals(fireBlueHigh)) {
            return 16;
        }
        if (colorCheck.equals(smokeLow)) {
            return 17;
        }
        if (colorCheck.equals(smokeMedium)) {
            return 18;
        }
        if (colorCheck.equals(smokeHigh)) {
            return 19;
        }
        if (colorCheck.equals(redSparklesVeryLow)) {
            return 20;
        }
        if (colorCheck.equals(redSparklesLow)) {
            return 21;
        }
        if (colorCheck.equals(redSparklesMedium)) {
            return 22;
        }
        if (colorCheck.equals(redSparklesHigh)) {
            return 23;
        }
        if (colorCheck.equals(greenSparklesVeryLow)) {
            return 24;
        }
        if (colorCheck.equals(greenSparklesLow)) {
            return 25;
        }
        if (colorCheck.equals(greenSparklesMedium)) {
            return 26;
        }
        if (colorCheck.equals(greenSparklesHigh)) {
            return 27;
        }
        if (colorCheck.equals(blueSparklesVeryLow)) {
            return 28;
        }
        if (colorCheck.equals(blueSparklesLow)) {
            return 29;
        }
        if (colorCheck.equals(blueSparklesMedium)) {
            return 30;
        }
        if (colorCheck.equals(blueSparklesHigh)) {
            return 31;
        }
        if (colorCheck.equals(magicRedLow)) {
            return 32;
        }
        if (colorCheck.equals(magicRedMedium)) {
            return 33;
        }
        if (colorCheck.equals(magicRedHigh)) {
            return 34;
        }
        if (colorCheck.equals(magicYellowLow)) {
            return 35;
        }
        if (colorCheck.equals(magicYellowMedium)) {
            return 36;
        }
        if (colorCheck.equals(magicYellowHigh)) {
            return 37;
        }
        if (colorCheck.equals(magicGreenLow)) {
            return 38;
        }
        if (colorCheck.equals(magicGreenMedium)) {
            return 39;
        }
        if (colorCheck.equals(magicGreenHigh)) {
            return 40;
        }
        if (colorCheck.equals(magicBlueLow)) {
            return 41;
        }
        if (colorCheck.equals(magicBlueMedium)) {
            return 42;
        }
        if (colorCheck.equals(magicBlueHigh)) {
            return 43;
        }
        if (colorCheck.equals(purpleSparklesVeryLow)) {
            return 44;
        }
        if (colorCheck.equals(purpleSparklesLow)) {
            return 45;
        }
        if (colorCheck.equals(purpleSparklesMedium)) {
            return 46;
        }
        if (colorCheck.equals(purpleSparklesHigh)) {
            return 47;
        }
        if (colorCheck.equals(firePurpleVeryLow)) {
            return 48;
        }
        if (colorCheck.equals(firePurpleLow)) {
            return 49;
        }
        if (colorCheck.equals(firePurpleMedium)) {
            return 50;
        }
        if (colorCheck.equals(firePurpleHigh)) {
            return 51;
        }
        if (colorCheck.equals(magicPurpleLow)) {
            return 52;
        }
        if (colorCheck.equals(magicPurpleMedium)) {
            return 53;
        }
        if (colorCheck.equals(magicPurpleHigh)) {
            return 54;
        }
        return 0;
    }

    private void generateShadowData(TileSetBase tileSetBase, int x, int y, int startGID, int tileID, SpriteSheet shadowSheet) {
        byte[][] tileOut = new byte[this.map.getTileWidth()][this.map.getTileHeight()];
        int startX = x * this.map.getTileWidth();
        int startY = y * this.map.getTileHeight();
        boolean foundShadow = false;
        int w = 0;
        while (w < this.map.getTileWidth()) {
            int h = 0;
            while (h < this.map.getTileHeight()) {
                if (shadowSheet.getColor(startX + w, startY + h).getAlpha() != 0) {
                    foundShadow = true;
                    int colorCheck = shadowSheet.getColor(startX + w, startY + h).getBlueByte();
                    tileOut[w][h] = (byte)(colorCheck / 10);
                }
                ++h;
            }
            ++w;
        }
        if (foundShadow) {
            this.tileShadow.put(startGID + tileID, (byte)1);
            this.shadowTiles.put(startGID + tileID, tileOut);
        }
    }

    public String getTileName(int tileID) {
        return this.tileName.get(tileID);
    }

    public boolean isTileBlock(int tileID) {
        return this.tileBlocked.get(tileID) != null;
    }

    public boolean isTileBlockLight(int tileID) {
        return this.tileBlockLight.get(tileID) != null;
    }

    public boolean isTileParticles(int tileID) {
        return this.tileParticles.get(tileID) != null;
    }

    public boolean isTileShadow(int tileID) {
        return this.tileShadow.get(tileID) != null;
    }

    public byte getTileLight(int tileID) {
        if (this.tileLight.get(tileID) != null) {
            return this.tileLight.get(tileID);
        }
        return 0;
    }

    public byte getTileLayer(int tileID) {
        return this.tileLayer.get(tileID);
    }

    public TileType getTileType(int tileID) {
        return this.tileType.get(tileID);
    }

    public boolean isTileCollision(int tileID) {
        return this.tileCollision.get(tileID) != null;
    }

    public boolean isTileInvulnerable(int tileID) {
        return this.tileInvulnerable.get(tileID) != null;
    }

    public Color getTileMiniMapColor(int tileID) {
        return this.tileMiniMapColor.get(tileID);
    }

    public byte getTileHeight(int tileID) {
        return this.tilePropHeight.get(tileID);
    }

    public byte getTileWidth(int tileID) {
        return this.tilePropWidth.get(tileID);
    }

    public int getTileSetGID(TileSet tileSet) {
        return this.tileSetToGID.get((Object)tileSet);
    }

    public int getTileSetGID(int tileId) {
        if (tileId == 0) {
            return 0;
        }
        return tileId / 200 * 200 + 1;
    }

    public HashMap<Integer, Image> getTiles() {
        return this.tiles;
    }

    public HashMap<Integer, byte[][]> getCollisionTiles() {
        return this.collisionTiles;
    }

    public HashMap<Integer, byte[][]> getParticleTiles() {
        return this.particleTiles;
    }

    public HashMap<Integer, byte[][]> getShadowTiles() {
        return this.shadowTiles;
    }

    public Image getObjectImage(int tileGID) throws SlickException {
        this.checkAndloadTileset(tileGID);
        return this.objects.get(tileGID);
    }

    public Image getWallImage(int tileGID) throws SlickException {
        this.checkAndloadTileset(tileGID);
        return this.tiles.get(tileGID + 79);
    }

    public TileSet getTileSetByGID(int tileId) {
        return this.GIDToTileSet.get(this.getTileSetGID(tileId));
    }

    public static enum TileSet {
        BRICKS_ACCENT(new BricksAccent(201)),
        BRICKS(new Bricks(1), BRICKS_ACCENT),
        DIRT_ACCENT(new DirtAccent(601)),
        DIRT(new Dirt(401), DIRT_ACCENT),
        GRASS_ACCENT(new GrassAccent(1001)),
        GRASS(new Grass(801), GRASS_ACCENT),
        GRAVEL_ACCENT(new GravelAccent(1401)),
        GRAVEL(new Gravel(1201), GRAVEL_ACCENT),
        ROCKS_ACCENT(new RocksAccent(1801)),
        ROCKS(new Rocks(1601), ROCKS_ACCENT),
        SAND_ACCENT(new SandAccent(2201)),
        SAND(new Sand(2001), SAND_ACCENT),
        TILES_ACCENT(new TilesAccent(2601)),
        TILES(new Tiles(2401), TILES_ACCENT),
        WALL_STONE(new WallStoneTerrain(10201));

        private TileSetBase tileSetTemplate;
        private TileSet accentTileSet;
        private TileSet collectedTileSet;
        private TileSet abandoned;
        private TileSet construction;
        private TileSet constructionPhase1;
        private TileSet constructionPhase2;
        private TileSet constructionPhase3;
        private TileSet constructionPhase4;
        private TileSet constructionPhase5;
        private TileSet fill1;
        private TileSet fill2;
        private TileSet fill3;
        private TileSet fill4;

        private TileSet(TileSetBase template) {
            this.tileSetTemplate = template;
        }

        private TileSet(TileSetBase template, TileSet accent, TileSet collected) {
            this.tileSetTemplate = template;
            this.accentTileSet = accent;
            this.collectedTileSet = collected;
        }

        private TileSet(TileSetBase template, TileSet accent) {
            this.tileSetTemplate = template;
            this.accentTileSet = accent;
        }

        private TileSet(TileSetBase template, TileSet c, TileSet cP1, TileSet cP2, TileSet cP3, TileSet cP4, TileSet cP5) {
            this.tileSetTemplate = template;
            this.construction = c;
            this.constructionPhase1 = cP1;
            this.constructionPhase2 = cP2;
            this.constructionPhase3 = cP3;
            this.constructionPhase4 = cP4;
            this.constructionPhase5 = cP5;
        }

        private TileSet(TileSetBase template, TileSet a, TileSet c, TileSet cP1, TileSet cP2, TileSet cP3, TileSet cP4, TileSet cP5) {
            this.tileSetTemplate = template;
            this.abandoned = a;
            this.construction = c;
            this.constructionPhase1 = cP1;
            this.constructionPhase2 = cP2;
            this.constructionPhase3 = cP3;
            this.constructionPhase4 = cP4;
            this.constructionPhase5 = cP5;
        }

        private TileSet(TileSetBase template, TileSet a, TileSet c, TileSet cP1, TileSet cP2, TileSet cP3, TileSet cP4, TileSet cP5, TileSet f1, TileSet f2, TileSet f3, TileSet f4) {
            this.tileSetTemplate = template;
            this.abandoned = a;
            this.construction = c;
            this.constructionPhase1 = cP1;
            this.constructionPhase2 = cP2;
            this.constructionPhase3 = cP3;
            this.constructionPhase4 = cP4;
            this.constructionPhase5 = cP5;
            this.fill1 = f1;
            this.fill2 = f2;
            this.fill3 = f3;
            this.fill4 = f4;
        }

        public TileSetBase getTileSetTemplate() {
            return this.tileSetTemplate;
        }

        public TileSet getAccent() {
            return this.accentTileSet;
        }

        public TileSet getCollected() {
            return this.collectedTileSet;
        }

        public TileSet getAbandoned() {
            return this.abandoned;
        }

        public TileSet getFill1() {
            return this.fill1;
        }

        public TileSet getFill2() {
            return this.fill2;
        }

        public TileSet getFill3() {
            return this.fill3;
        }

        public TileSet getFill4() {
            return this.fill4;
        }

        public TileSet getConstruction() {
            return this.construction;
        }

        public TileSet getConstructionPhase1() {
            return this.constructionPhase1;
        }

        public TileSet getConstructionPhase2() {
            return this.constructionPhase2;
        }

        public TileSet getConstructionPhase3() {
            return this.constructionPhase3;
        }

        public TileSet getConstructionPhase4() {
            return this.constructionPhase4;
        }

        public TileSet getConstructionPhase5() {
            return this.constructionPhase5;
        }
    }

    public static enum TileType {
        TERRAIN,
        OBJECT,
        WALL,
        ROAD;

    }
}

