/*
 * Decompiled with CFR 0.152.
 */
package rtr.map;

import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;
import rtr.ModuleBase;
import rtr.map.MapTilesLoader;
import rtr.map.generator.MapGenerator;
import rtr.mobs.MobBase;
import rtr.states.StateBase;
import rtr.system.ScaleControl;
import rtr.utilities.ArrayFillUtil;
import rtr.utilities.Utilities;

public class MapModule
extends ModuleBase {
    private static final int LAYER_BASE_TERRAIN_BOTTOM = 0;
    private static final int LAYER_BASE_TERRAIN_TOP = 1;
    private static final int LAYER_TERRAIN_BOTTOM = 2;
    private static final int LAYER_TERRAIN_TOP = 3;
    private static final int LAYER_TOPOGRAPHY_BOTTOM = 4;
    private static final int LAYER_TOPOGRAPHY_TOP = 5;
    private static final int MAP_HEIGHT = 256;
    private static final int MAP_WIDTH = 256;
    private static final int MAP_LAYERS = 6;
    private static final int MAP_TILE_WIDTH = 16;
    private static final int MAP_TILE_HEIGHT = 16;
    private static final int MAP_FULL_WIDTH = 4096;
    private static final int MAP_FULL_HEIGHT = 4096;
    private MapGenerator generator;
    private MapTilesLoader mtl;
    private int[][][] mapArray;
    private byte[][] blockMap;
    private byte[][] invulnerableMap;
    private byte[][] lightBlockMap;
    private float mapX = 0.0f;
    private float mapY = 0.0f;
    private boolean screenShaking;
    private boolean screenShakeFlip;
    private int screenShakeDirection;
    private float screenShakeAmount;

    @Override
    public void initModule(StateBase cS) throws SlickException {
        super.initModule(cS);
        if (this.mtl == null) {
            this.mtl = new MapTilesLoader();
        }
        if (this.generator == null) {
            this.generator = new MapGenerator();
        }
        if (this.blockMap == null) {
            this.blockMap = new byte[256][256];
        }
        if (this.invulnerableMap == null) {
            this.invulnerableMap = new byte[256][256];
        }
        if (this.lightBlockMap == null) {
            this.lightBlockMap = new byte[256][256];
        }
        this.initLoad();
    }

    @Override
    public void resetModule() throws SlickException {
        super.resetModule();
        ArrayFillUtil.fill(this.blockMap, (byte)0);
        ArrayFillUtil.fill(this.invulnerableMap, (byte)0);
        ArrayFillUtil.fill(this.lightBlockMap, (byte)0);
        this.mapX = 0.0f;
        this.mapY = 0.0f;
    }

    @Override
    protected void loadPlay() throws SlickException {
        this.mapArray = this.generator.generateMap();
        int x = 0;
        while (x < this.mapArray.length) {
            int y = 0;
            while (y < this.mapArray[x].length) {
                this.updateTileFlags(x, y);
                ++y;
            }
            ++x;
        }
    }

    public void renderBottom() throws SlickException {
        int startX = this.getMapRenderTileTopLeftX() - 1;
        int startY = this.getMapRenderTileTopLeftY() - 1;
        int endX = this.getMapRenderTileBottomRightX() + 1;
        int endY = this.getMapRenderTileBottomRightY() + 1;
        int x = startX;
        while (x < endX) {
            int y = startY;
            while (y < endY) {
                if (x >= 0 && x <= this.mapArray.length - 1 && y >= 0 && y <= this.mapArray[x].length - 1) {
                    int l = 0;
                    while (l < 3) {
                        if (this.mapArray[x][y][l] != 0) {
                            this.mtl.getTiles().get(this.mapArray[x][y][l]).draw(this.mapX + (float)(x * 16), this.mapY + (float)(y * 16));
                        }
                        ++l;
                    }
                }
                ++y;
            }
            ++x;
        }
    }

    public void renderTop() throws SlickException {
        int startX = this.getMapRenderTileTopLeftX() - 1;
        int startY = this.getMapRenderTileTopLeftY() - 1;
        int endX = this.getMapRenderTileBottomRightX() + 1;
        int endY = this.getMapRenderTileBottomRightY() + 1;
        int x = startX;
        while (x < endX) {
            int y = startY;
            while (y < endY) {
                if (x >= 0 && x <= this.mapArray.length - 1 && y >= 0 && y <= this.mapArray[x].length - 1) {
                    int l = 4;
                    while (l < 5) {
                        if (this.mapArray[x][y][l] != 0) {
                            this.mtl.getTiles().get(this.mapArray[x][y][l]).draw(this.mapX + (float)(x * 16), this.mapY + (float)(y * 16));
                        }
                        ++l;
                    }
                }
                ++y;
            }
            ++x;
        }
    }

    public void renderMapWriter(Graphics g) {
        int x = 0;
        while (x < 256) {
            int y = 0;
            while (y < 256) {
                int l = 0;
                while (l < 6) {
                    if (this.mapArray[x][y][l] != 0) {
                        this.mtl.getTiles().get(this.mapArray[x][y][l]).draw(x * 16, y * 16);
                    }
                    ++l;
                }
                ++y;
            }
            ++x;
        }
    }

    public void update() throws SlickException {
        int cameraCenterX = ScaleControl.getWidth() / 2;
        int cameraCenterY = ScaleControl.getHeight() / 2;
        MobBase hero = this.mob.getHero();
        float headX = hero.getMobX() * -1.0f + (float)cameraCenterX;
        float headY = hero.getMobY() * -1.0f + (float)cameraCenterY;
        double dx = (float)cameraCenterX - hero.getMobX() - this.mapX;
        double dy = (float)cameraCenterY - hero.getMobY() - this.mapY;
        double hValue = Math.sqrt(dx * dx + dy * dy);
        if (this.mapX - headX > 16.0f) {
            this.mapX = (float)((double)this.mapX - hValue / 40.0);
        } else if (this.mapX - headX < -16.0f) {
            this.mapX = (float)((double)this.mapX + hValue / 40.0);
        }
        if (this.mapY - headY > 16.0f) {
            this.mapY = (float)((double)this.mapY - hValue / 40.0);
        } else if (this.mapY - headY < -16.0f) {
            this.mapY = (float)((double)this.mapY + hValue / 40.0);
        }
        if (this.screenShaking) {
            this.screenShake();
        }
    }

    public void screenShake() {
        float amount = this.screenShakeAmount + (Utilities.randomFloat() - Utilities.randomFloat()) * 4.0f;
        if (this.screenShakeFlip) {
            this.screenShakeDirection = Utilities.randomInt(8);
            if (this.screenShakeDirection == 0) {
                this.mapX -= amount;
                this.mapY -= amount;
            } else if (this.screenShakeDirection == 1) {
                this.mapX += amount;
                this.mapY += amount;
            } else if (this.screenShakeDirection == 2) {
                this.mapX -= amount;
                this.mapY += amount;
            } else if (this.screenShakeDirection == 3) {
                this.mapX += amount;
                this.mapY -= amount;
            } else if (this.screenShakeDirection == 4) {
                this.mapX -= amount;
            } else if (this.screenShakeDirection == 5) {
                this.mapY -= amount;
            } else if (this.screenShakeDirection == 6) {
                this.mapX += amount;
            } else if (this.screenShakeDirection == 7) {
                this.mapY += amount;
            }
        } else {
            if (this.screenShakeDirection == 0) {
                this.mapX += amount;
                this.mapY += amount;
            } else if (this.screenShakeDirection == 1) {
                this.mapX -= amount;
                this.mapY -= amount;
            } else if (this.screenShakeDirection == 2) {
                this.mapX += amount;
                this.mapY -= amount;
            } else if (this.screenShakeDirection == 3) {
                this.mapX -= amount;
                this.mapY += amount;
            } else if (this.screenShakeDirection == 4) {
                this.mapX += amount;
            } else if (this.screenShakeDirection == 5) {
                this.mapY += amount;
            } else if (this.screenShakeDirection == 6) {
                this.mapX -= amount;
            } else if (this.screenShakeDirection == 7) {
                this.mapY -= amount;
            }
            this.screenShakeAmount -= 0.5f;
        }
        boolean bl = this.screenShakeFlip = !this.screenShakeFlip;
        if (this.screenShakeAmount <= 0.0f) {
            this.screenShakeAmount = 0.0f;
            this.screenShaking = false;
        }
    }

    public void initSreenShake(float i) {
        this.screenShaking = true;
        if (this.screenShakeAmount < 10.0f) {
            this.screenShakeAmount += i;
        }
        if (this.screenShakeAmount > 10.0f) {
            this.screenShakeAmount = 10.0f;
        }
    }

    private void updateTileFlags(int tileX, int tileY) throws SlickException {
        this.blockMap[tileX][tileY] = 0;
        this.invulnerableMap[tileX][tileY] = 0;
        this.lightBlockMap[tileX][tileY] = 0;
        int l = 0;
        while (l < 6) {
            if (this.mtl.isTileBlock(this.mapArray[tileX][tileY][l])) {
                this.blockMap[tileX][tileY] = 1;
            }
            if (this.mtl.isTileInvulnerable(this.mapArray[tileX][tileY][l])) {
                this.invulnerableMap[tileX][tileY] = 1;
            }
            if (this.mtl.isTileBlockLight(this.mapArray[tileX][tileY][l])) {
                this.lightBlockMap[tileX][tileY] = 1;
            }
            ++l;
        }
    }

    public int[][][] getMap() {
        return this.mapArray;
    }

    public float getMapX() {
        return this.mapX;
    }

    public float getMapY() {
        return this.mapY;
    }

    public int getMapHeight() {
        return 256;
    }

    public int getMapWidth() {
        return 256;
    }

    public int getMapLayers() {
        return 6;
    }

    public int getTileHeight() {
        return 16;
    }

    public int getTileWidth() {
        return 16;
    }

    public int getMapFullHeight() {
        return 4096;
    }

    public int getMapFullWidth() {
        return 4096;
    }

    public int getMapRenderTopLeftX() {
        return (int)(this.mapX * -1.0f);
    }

    public int getMapRenderTopLeftY() {
        return (int)(this.mapY * -1.0f);
    }

    public int getMapRenderTopRightX() {
        return (int)(this.mapX * -1.0f + (float)ScaleControl.getWidth());
    }

    public int getMapRenderTopRightY() {
        return (int)(this.mapY * -1.0f);
    }

    public int getMapRenderBottomLeftX() {
        return (int)(this.mapX * -1.0f);
    }

    public int getMapRenderBottomLeftY() {
        return (int)(this.mapY * -1.0f + (float)ScaleControl.getHeight());
    }

    public int getMapRenderBottomRightX() {
        return (int)(this.mapX * -1.0f + (float)ScaleControl.getWidth());
    }

    public int getMapRenderBottomRightY() {
        return (int)(this.mapY * -1.0f + (float)ScaleControl.getHeight());
    }

    public int getMapRenderTileTopLeftX() {
        return (int)(this.mapX * -1.0f) / 16;
    }

    public int getMapRenderTileTopLeftY() {
        return (int)(this.mapY * -1.0f) / 16;
    }

    public int getMapRenderTileTopRightX() {
        return (int)(this.mapX * -1.0f + (float)ScaleControl.getWidth()) / 16;
    }

    public int getMapRenderTileTopRightY() {
        return (int)(this.mapY * -1.0f) / 16;
    }

    public int getMapRenderTileBottomLeftX() {
        return (int)(this.mapX * -1.0f) / 16;
    }

    public int getMapRenderTileBottomLeftY() {
        return (int)(this.mapY * -1.0f + (float)ScaleControl.getHeight()) / 16;
    }

    public int getMapRenderTileBottomRightX() {
        return (int)(this.mapX * -1.0f + (float)ScaleControl.getWidth()) / 16;
    }

    public int getMapRenderTileBottomRightY() {
        return (int)(this.mapY * -1.0f + (float)ScaleControl.getHeight()) / 16;
    }

    public int getTileId(int tileX, int tileY, int layer) {
        return this.mapArray[tileX][tileY][layer];
    }

    public byte[][] getBlockMap() {
        return this.blockMap;
    }

    public byte[][] getInvulnerableMap() {
        return this.invulnerableMap;
    }

    public byte[][] getLightBlockMap() {
        return this.lightBlockMap;
    }

    public void realignMapPosition() {
        this.setMapPosition(this.mapX, this.mapY);
    }

    public void setMapPosition(float x, float y) {
        this.mapX = x > 256.0f ? 256.0f : (x < (float)(-4096 + ScaleControl.getWidth() - 256) ? (float)(-4096 + ScaleControl.getWidth() - 256) : x);
        this.mapY = y > 256.0f ? 256.0f : (y < (float)(-4096 + ScaleControl.getHeight() - 256) ? (float)(-4096 + ScaleControl.getHeight() - 256) : y);
    }

    public MapTilesLoader getMapTileLoader() {
        return this.mtl;
    }

    public int getLayerBaseTerrainBottom() {
        return 0;
    }

    public int getLayerBaseTerrainTop() {
        return 1;
    }

    public int getLayerTerrainBottom() {
        return 2;
    }

    public int getLayerTerrainTop() {
        return 3;
    }

    public int getLayerTopographyBottom() {
        return 4;
    }

    public int getLayerTopographyTop() {
        return 5;
    }

    public void generateMap() throws SlickException {
        this.mapArray = this.generator.generateMap();
    }
}

