/*
 * Decompiled with CFR 0.152.
 */
package rtr.map;

import java.util.HashMap;
import org.newdawn.slick.Color;
import org.newdawn.slick.SlickException;
import rtr.ModuleBase;
import rtr.states.StateBase;
import rtr.utilities.Utilities;

public class CollisionModule
extends ModuleBase {
    private static final byte COLLISION_NONE = 0;
    private static final byte COLLISION_NORTH_LOW = 1;
    private static final byte COLLISION_NORTH_MEDIUM = 2;
    private static final byte COLLISION_NORTH_HIGH = 3;
    private static final byte COLLISION_EAST_LOW = 4;
    private static final byte COLLISION_EAST_MEDIUM = 5;
    private static final byte COLLISION_EAST_HIGH = 6;
    private static final byte COLLISION_SOUTH_LOW = 7;
    private static final byte COLLISION_SOUTH_MEDIUM = 8;
    private static final byte COLLISION_SOUTH_HIGH = 9;
    private static final byte COLLISION_WEST_LOW = 10;
    private static final byte COLLISION_WEST_MEDIUM = 11;
    private static final byte COLLISION_WEST_HIGH = 12;
    private static final byte COLLISION_ALL_LOW = 13;
    private static final byte COLLISION_ALL_MEDIUM = 14;
    private static final byte COLLISION_ALL_HIGH = 15;
    private int tileGlobalX;
    private int tileGlobalY;
    private byte[][] collisionMap;
    private HashMap<Integer, byte[][]> collisionMasks;
    private Color[] colorNorth;
    private Color[] colorEast;
    private Color[] colorSouth;
    private Color[] colorWest;
    private Color[] colorAll;

    public byte getCollisionNone() {
        return 0;
    }

    public byte getCollisionNorthLow() {
        return 1;
    }

    public byte getCollisionNorthMedium() {
        return 2;
    }

    public byte getCollisionNorthHigh() {
        return 3;
    }

    public byte getCollisionEastLow() {
        return 4;
    }

    public byte getCollisionEastMedium() {
        return 5;
    }

    public byte getCollisionEastHigh() {
        return 6;
    }

    public byte getCollisionSouthLow() {
        return 7;
    }

    public byte getCollisionSouthMedium() {
        return 8;
    }

    public byte getCollisionSouthHigh() {
        return 9;
    }

    public byte getCollisionWestLow() {
        return 10;
    }

    public byte getCollisionWestMedium() {
        return 11;
    }

    public byte getCollisionWestHigh() {
        return 12;
    }

    public byte getCollisionAllLow() {
        return 13;
    }

    public byte getCollisionAllMedium() {
        return 14;
    }

    public byte getCollisionAllHigh() {
        return 15;
    }

    @Override
    public void initModule(StateBase cS) throws SlickException {
        super.initModule(cS);
        if (this.colorNorth == null) {
            this.colorNorth = new Color[3];
            this.colorNorth[0] = new Color(50, 0, 0, 255);
            this.colorNorth[1] = new Color(150, 0, 0, 255);
            this.colorNorth[2] = new Color(250, 0, 0, 255);
        }
        if (this.colorEast == null) {
            this.colorEast = new Color[3];
            this.colorEast[0] = new Color(50, 50, 0, 255);
            this.colorEast[1] = new Color(150, 150, 0, 255);
            this.colorEast[2] = new Color(250, 250, 0, 255);
        }
        if (this.colorSouth == null) {
            this.colorSouth = new Color[3];
            this.colorSouth[0] = new Color(0, 50, 0, 255);
            this.colorSouth[1] = new Color(0, 150, 0, 255);
            this.colorSouth[2] = new Color(0, 250, 0, 255);
        }
        if (this.colorWest == null) {
            this.colorWest = new Color[3];
            this.colorWest[0] = new Color(0, 0, 50, 255);
            this.colorWest[1] = new Color(0, 0, 150, 255);
            this.colorWest[2] = new Color(0, 0, 250, 255);
        }
        if (this.colorAll == null) {
            this.colorAll = new Color[3];
            this.colorAll[0] = new Color(50, 50, 50, 255);
            this.colorAll[1] = new Color(150, 150, 150, 255);
            this.colorAll[2] = new Color(250, 250, 250, 255);
        }
        if (this.collisionMap == null) {
            this.collisionMap = new byte[this.map.getMapFullWidth()][this.map.getMapFullHeight()];
        }
        if (this.collisionMasks == null) {
            this.collisionMasks = this.map.getMapTileLoader().getCollisionTiles();
        }
        this.buildMap();
    }

    @Override
    public void resetModule() throws SlickException {
        super.resetModule();
        this.tileGlobalX = 0;
        this.tileGlobalY = 0;
        int x = 0;
        while (x < this.collisionMap.length) {
            int y = 0;
            while (y < this.collisionMap[x].length) {
                this.collisionMap[x][y] = 0;
                ++y;
            }
            ++x;
        }
    }

    private void buildMap() throws SlickException {
        int[] tileID = new int[this.map.getMapLayers()];
        int mapWidth = this.map.getMapWidth();
        int mapHeight = this.map.getMapHeight();
        int x = 0;
        while (x < mapWidth) {
            int y = 0;
            while (y < mapHeight) {
                int l = 0;
                while (l < tileID.length) {
                    tileID[l] = this.map.getTileId(x, y, l);
                    if (tileID[l] != 0) {
                        this.builder(x, y, l, tileID[l]);
                    }
                    ++l;
                }
                ++y;
            }
            ++x;
        }
    }

    private void builder(int tX, int tY, int tL, int tileID) throws SlickException {
        if (!this.map.getMapTileLoader().isTileCollision(tileID)) {
            return;
        }
        this.tileGlobalX = tX * this.map.getTileWidth();
        this.tileGlobalY = tY * this.map.getTileHeight();
        byte[][] collisionArrayBuilder = this.collisionMasks.get(tileID);
        int x = 0;
        while (x < this.map.getTileWidth()) {
            int y = 0;
            while (y < this.map.getTileHeight()) {
                int pixelX = this.tileGlobalX + x;
                int pixelY = this.tileGlobalY + y;
                if (collisionArrayBuilder[x][y] != 0) {
                    this.collisionMap[pixelX][pixelY] = collisionArrayBuilder[x][y];
                }
                ++y;
            }
            ++x;
        }
        collisionArrayBuilder = null;
    }

    public void updateCollisionMap(int x, int y) throws SlickException {
        int[] tileID = new int[this.map.getMapLayers()];
        this.resetCollision(x, y);
        int l = 0;
        while (l < tileID.length) {
            tileID[l] = this.map.getTileId(x, y, l);
            if (tileID[l] != 0) {
                this.builder(x, y, l, tileID[l]);
            }
            ++l;
        }
    }

    private void resetCollision(int tX, int tY) throws SlickException {
        this.tileGlobalX = tX * this.map.getTileWidth();
        this.tileGlobalY = tY * this.map.getTileHeight();
        int x = 0;
        while (x < this.map.getTileWidth()) {
            int y = 0;
            while (y < this.map.getTileHeight()) {
                int pixelX = this.tileGlobalX + x;
                int pixelY = this.tileGlobalY + y;
                this.collisionMap[pixelX][pixelY] = 0;
                ++y;
            }
            ++x;
        }
    }

    public byte checkParticleCollision(int x, int y, CollisionHeight h) {
        if (Utilities.isOutOfBounds(this.map.getMapFullWidth() - 1, this.map.getMapFullHeight() - 1, x, y)) {
            return 0;
        }
        byte collisionType = this.collisionMap[x][y];
        if (h == CollisionHeight.ANY) {
            return collisionType;
        }
        if (h == CollisionHeight.HIGH && (collisionType == 3 || collisionType == 6 || collisionType == 9 || collisionType == 12 || collisionType == 15)) {
            return collisionType;
        }
        if (h == CollisionHeight.MEDIUM && (collisionType == 3 || collisionType == 6 || collisionType == 9 || collisionType == 12 || collisionType == 15 || collisionType == 2 || collisionType == 5 || collisionType == 8 || collisionType == 11 || collisionType == 14)) {
            return collisionType;
        }
        if (h == CollisionHeight.LOW && (collisionType == 3 || collisionType == 6 || collisionType == 9 || collisionType == 12 || collisionType == 15 || collisionType == 2 || collisionType == 5 || collisionType == 8 || collisionType == 11 || collisionType == 14 || collisionType == 1 || collisionType == 4 || collisionType == 7 || collisionType == 10 || collisionType == 13)) {
            return collisionType;
        }
        return 0;
    }

    public boolean checkParticleCollisionBetween(float startX, float startY, float endX, float endY, CollisionHeight h) {
        float angle = Utilities.calculateAngle(startX, startY, endX, endY);
        while (Math.abs(startX - endX) >= 2.0f || Math.abs(startY - endY) >= 2.0f) {
            if (this.checkParticleCollision((int)(startX = (float)((double)startX + Math.cos(angle))), (int)(startY = (float)((double)startY + Math.sin(angle))), h) == 0) continue;
            return true;
        }
        return false;
    }

    public byte[][] getCollisionMap() {
        return this.collisionMap;
    }

    public static enum CollisionHeight {
        ANY,
        LOW,
        MEDIUM,
        HIGH,
        NONE;

    }
}

