/*
 * Decompiled with CFR 0.152.
 */
package rtr.lighting;

import java.util.ArrayList;
import java.util.Arrays;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import rtr.ImageLoader;
import rtr.ModuleBase;
import rtr.lighting.Light;
import rtr.lighting.LightNode;
import rtr.map.MapTilesLoader;
import rtr.mobs.MobBase;
import rtr.states.StateBase;
import rtr.system.ScaleControl;
import rtr.utilities.ArrayFillUtil;

public class LightingModule
extends ModuleBase {
    private static final int colorRangeAmount = 75;
    private Color lightLevel;
    private Image light;
    private Image coloredLight;
    private float lightAlpha;
    private float lightAdjust;
    private Light[][] lightArray;
    private ArrayList<Light> shortTermLights = new ArrayList();
    private int[][] lightValueBase;
    private int[][] lightValueExtrasNew;
    private int[][] lightValueMapNew;
    private Color[] colorRange;
    private int mapWidth;
    private int mapHeight;
    private int mapLayers;
    private ArrayList<LightNode> resettableLightNodes = new ArrayList();
    private LightNode[][] lightNodes;
    private boolean debug = false;

    @Override
    public void initModule(StateBase cS) throws SlickException {
        super.initModule(cS);
        if (this.light == null) {
            this.light = ImageLoader.getImage("res/lightSources/light.png");
        }
        if (this.coloredLight == null) {
            this.coloredLight = ImageLoader.getImage("res/lightSources/coloredLight.png");
        }
        this.mapWidth = this.map.getMapWidth();
        this.mapHeight = this.map.getMapHeight();
        this.mapLayers = this.map.getMapLayers();
        this.lightNodes = new LightNode[this.mapWidth][this.mapHeight];
        int x = 0;
        while (x < this.lightNodes.length) {
            int y = 0;
            while (y < this.lightNodes[x].length) {
                this.lightNodes[x][y] = new LightNode(x, y);
                ++y;
            }
            ++x;
        }
        this.buildInitialMap();
        if (this.colorRange == null) {
            this.colorRange = new Color[75];
            x = 0;
            while (x < this.colorRange.length) {
                this.colorRange[x] = new Color(1.0f, 1.0f, 1.0f, (float)x * 0.005f);
                if (x <= 50) {
                    this.colorRange[x] = new Color(1.0f, 1.0f, 1.0f, (float)x * 0.02f);
                } else if (x <= 100) {
                    this.colorRange[x] = new Color(1.0f, 1.0f, 1.0f, (float)x * 0.03f);
                } else if (x <= 200) {
                    this.colorRange[x] = new Color(1.0f, 1.0f, 1.0f, (float)x * 0.04f);
                }
                ++x;
            }
        }
        this.lightAlpha = 160.0f;
        this.lightLevel = new Color(0.0f, 0.0f, 0.0f, this.lightAlpha);
        this.setLightLevel();
        this.forceLightAndColorLevels();
    }

    @Override
    public void resetModule() throws SlickException {
        super.resetModule();
        this.lightAlpha = 0.0f;
        this.lightAdjust = 0.0f;
        this.lightArray = null;
        this.shortTermLights.clear();
        ArrayFillUtil.fill(this.lightValueBase, 0);
        ArrayFillUtil.fill(this.lightValueExtrasNew, 0);
        ArrayFillUtil.fill(this.lightValueMapNew, 0);
        this.mapWidth = 0;
        this.mapHeight = 0;
        this.mapLayers = 0;
        int x = 0;
        while (x < this.lightNodes.length) {
            int y = 0;
            while (y < this.lightNodes[x].length) {
                this.lightNodes[x][y].flagResettable();
                ++y;
            }
            ++x;
        }
    }

    public void render(Graphics g) throws SlickException {
        int y;
        int displayWidth = ScaleControl.getWidth();
        int displayHeight = ScaleControl.getHeight();
        int startX = this.map.getMapRenderTileTopLeftX() - 4;
        int startY = this.map.getMapRenderTileTopLeftY() - 4;
        int endX = this.map.getMapRenderTileBottomRightX() + 4;
        int endY = this.map.getMapRenderTileBottomRightY() + 4;
        float mapX = this.map.getMapX();
        float mapY = this.map.getMapY();
        g.setColor(Color.black);
        GL11.glBlendFunc((int)774, (int)770);
        g.fillRect(0.0f, 0.0f, displayWidth + 16, displayHeight + 16);
        GL11.glBlendFunc((int)1, (int)769);
        g.fillRect(0.0f, 0.0f, displayWidth + 16, displayHeight + 16);
        g.clearAlphaMap();
        GL11.glBlendFunc((int)770, (int)1);
        g.setColor(this.lightLevel);
        g.fillRect(0.0f, 0.0f, displayWidth + 16, displayHeight + 16);
        this.light.startUse();
        int x = startX;
        while (x < endX) {
            y = startY;
            while (y < endY) {
                if (x >= 0 && x <= this.mapWidth - 1 && y >= 0 && y <= this.mapHeight - 1 && this.lightValueBase[x][y] > 0) {
                    if (this.lightValueBase[x][y] >= 75) {
                        this.light.drawEmbedded((float)(x * this.map.getTileWidth()) + mapX - (float)this.map.getTileWidth(), (float)(y * this.map.getTileHeight()) + mapY - (float)this.map.getTileHeight(), (float)(x * this.map.getTileWidth()) + mapX + 32.0f, (float)(y * this.map.getTileWidth()) + mapY + 32.0f, 0.0f, 0.0f, this.light.getWidth(), this.light.getHeight(), this.colorRange[74]);
                    } else {
                        this.light.drawEmbedded((float)(x * this.map.getTileWidth()) + mapX - (float)this.map.getTileWidth(), (float)(y * this.map.getTileHeight()) + mapY - (float)this.map.getTileHeight(), (float)(x * this.map.getTileWidth()) + mapX + 32.0f, (float)(y * this.map.getTileWidth()) + mapY + 32.0f, 0.0f, 0.0f, this.light.getWidth(), this.light.getHeight(), this.colorRange[this.lightValueBase[x][y]]);
                    }
                }
                ++y;
            }
            ++x;
        }
        this.light.endUse();
        GL11.glBlendFunc((int)1, (int)772);
        g.setColor(Color.black);
        g.fillRect(0.0f, 0.0f, displayWidth + 16, displayHeight + 16);
        g.setDrawMode(Graphics.MODE_NORMAL);
        if (this.debug) {
            x = 0;
            while (x < this.mapWidth) {
                y = 0;
                while (y < this.mapHeight) {
                    if ((float)(x * 8) + mapX > -10.0f && (float)(x * 8) + mapX < (float)(displayWidth + 10) && (float)(y * 8) + mapY > -10.0f && (float)(y * 8) + mapY < (float)(displayHeight + 10) && this.lightValueBase[x][y] != 0) {
                        this.font.drawString((float)(x * 8 + 1) + mapX, (float)(y * 8 + 1) + mapY, "" + this.lightValueBase[x][y], 1);
                    }
                    ++y;
                }
                ++x;
            }
        }
    }

    public void renderMapWriter(Graphics g) throws SlickException {
        int y;
        int displayWidth = this.map.getMapFullWidth();
        int displayHeight = this.map.getMapFullHeight();
        g.setColor(Color.white);
        GL11.glBlendFunc((int)774, (int)770);
        g.fillRect(0.0f, 0.0f, displayWidth + 16, displayHeight + 16);
        GL11.glBlendFunc((int)1, (int)769);
        g.fillRect(0.0f, 0.0f, displayWidth + 16, displayHeight + 16);
        g.clearAlphaMap();
        GL11.glBlendFunc((int)770, (int)1);
        g.setColor(this.lightLevel);
        g.fillRect(0.0f, 0.0f, displayWidth + 16, displayHeight + 16);
        this.light.startUse();
        int x = 0;
        while (x < this.mapWidth) {
            y = 0;
            while (y < this.mapHeight) {
                if (this.lightValueBase[x][y] > 0) {
                    if (this.lightValueBase[x][y] >= 75) {
                        this.light.drawEmbedded(x * this.map.getTileWidth() - this.map.getTileWidth(), y * this.map.getTileHeight() - this.map.getTileHeight(), x * this.map.getTileWidth() + 32, y * this.map.getTileWidth() + 32, 0.0f, 0.0f, this.light.getWidth(), this.light.getHeight(), this.colorRange[74]);
                    } else {
                        this.light.drawEmbedded(x * this.map.getTileWidth() - this.map.getTileWidth(), y * this.map.getTileHeight() - this.map.getTileHeight(), x * this.map.getTileWidth() + 32, y * this.map.getTileWidth() + 32, 0.0f, 0.0f, this.light.getWidth(), this.light.getHeight(), this.colorRange[this.lightValueBase[x][y]]);
                    }
                }
                ++y;
            }
            ++x;
        }
        this.light.endUse();
        GL11.glBlendFunc((int)1, (int)772);
        g.setColor(Color.black);
        g.fillRect(0.0f, 0.0f, displayWidth + 16, displayHeight + 16);
        g.setDrawMode(Graphics.MODE_NORMAL);
        if (this.debug) {
            x = 0;
            while (x < this.mapWidth) {
                y = 0;
                while (y < this.mapHeight) {
                    if (x * 8 > -10 && x * 8 < displayWidth + 10 && y * 8 > -10 && y * 8 < displayHeight + 10 && this.lightValueBase[x][y] != 0) {
                        this.font.drawString(x * 8 + 1, y * 8 + 1, "" + this.lightValueBase[x][y], 1);
                    }
                    ++y;
                }
                ++x;
            }
        }
    }

    public void update() throws SlickException {
        Object lightMap;
        this.setLightLevel();
        this.adjustLightLevel();
        int i = 0;
        while (i < this.lightValueExtrasNew.length) {
            Arrays.fill(this.lightValueExtrasNew[i], 0);
            ++i;
        }
        for (MobBase m : this.mob.getMobArray()) {
            Light l = m.getLight();
            if (l == null) continue;
            byte[][] lightMap2 = l.getLightMap();
            int x1 = 0;
            while (x1 < lightMap2.length) {
                int y1 = 0;
                while (y1 < lightMap2[x1].length) {
                    int lightAddX = x1 + (l.getLightX() - lightMap2.length / 2);
                    int lightAddY = y1 + (l.getLightY() - lightMap2[x1].length / 2);
                    if (lightAddX <= 250 && lightAddX >= 2 && lightAddY <= 250 && lightAddY >= 2) {
                        int[] nArray = this.lightValueExtrasNew[lightAddX];
                        int n = lightAddY;
                        nArray[n] = nArray[n] + lightMap2[x1][y1];
                    }
                    ++y1;
                }
                ++x1;
            }
        }
        for (Light l : this.shortTermLights) {
            lightMap = l.getLightMap();
            int x1 = 0;
            while (x1 < ((Object)lightMap).length) {
                int y1 = 0;
                while (y1 < ((Object)lightMap[x1]).length) {
                    int lightAddX = x1 + (l.getLightX() - ((Object)lightMap).length / 2);
                    int lightAddY = y1 + (l.getLightY() - ((Object)lightMap[x1]).length / 2);
                    if (lightAddX <= 250 && lightAddX >= 2 && lightAddY <= 250 && lightAddY >= 2) {
                        int[] nArray = this.lightValueExtrasNew[lightAddX];
                        int n = lightAddY;
                        nArray[n] = nArray[n] + lightMap[x1][y1];
                    }
                    ++y1;
                }
                ++x1;
            }
            l.update();
        }
        ArrayList<Light> shortTermLightsRemove = new ArrayList<Light>();
        lightMap = this.shortTermLights.iterator();
        while (lightMap.hasNext()) {
            Light l = (Light)lightMap.next();
            if (l.getLightDuration() > 0) continue;
            shortTermLightsRemove.add(l);
        }
        this.shortTermLights.removeAll(shortTermLightsRemove);
        int x = 0;
        while (x < this.mapWidth) {
            int y = 0;
            while (y < this.mapHeight) {
                if (this.lightValueBase[x][y] < this.lightValueExtrasNew[x][y] + this.lightValueMapNew[x][y]) {
                    int[] nArray = this.lightValueBase[x];
                    int n = y;
                    nArray[n] = nArray[n] + 1;
                } else if (this.lightValueBase[x][y] > this.lightValueExtrasNew[x][y] + this.lightValueMapNew[x][y]) {
                    int[] nArray = this.lightValueBase[x];
                    int n = y;
                    nArray[n] = nArray[n] - 1;
                }
                ++y;
            }
            ++x;
        }
        if (this.debug) {
            this.buildInitialMap();
            this.lightAlpha = 150.0f;
        }
    }

    private void setLightLevel() {
        this.lightAdjust = 120.0f;
    }

    private void forceLightAndColorLevels() {
        this.lightLevel = new Color(0, 0, 0, (int)this.lightAdjust);
    }

    private void adjustLightLevel() {
        if ((int)this.lightAlpha != (int)this.lightAdjust) {
            this.lightAlpha = this.lightAlpha > this.lightAdjust ? (this.lightAlpha -= 0.1f) : (this.lightAlpha += 0.1f);
        }
        this.lightLevel = new Color(0, 0, 0, (int)this.lightAlpha);
    }

    private void buildInitialMap() throws SlickException {
        int y;
        if (this.lightValueBase == null) {
            this.lightValueBase = new int[this.mapWidth][this.mapHeight];
        }
        if (this.lightValueExtrasNew == null) {
            this.lightValueExtrasNew = new int[this.mapWidth][this.mapHeight];
        }
        if (this.lightValueMapNew == null) {
            this.lightValueMapNew = new int[this.mapWidth][this.mapHeight];
        }
        if (this.lightArray == null) {
            this.lightArray = new Light[this.mapWidth][this.mapHeight];
        }
        int x = 0;
        while (x < this.mapWidth) {
            y = 0;
            while (y < this.mapHeight) {
                int l = 0;
                while (l < this.mapLayers) {
                    int tileID = this.map.getTileId(x, y, l);
                    if (tileID != 0 && this.map.getMapTileLoader().getTileLight(tileID) != 0) {
                        if (this.map.getMapTileLoader().getTileType(tileID) == MapTilesLoader.TileType.WALL) {
                            this.lightArray[x][y] = new Light(x, y + 1, this.map.getMapTileLoader().getTileLight(tileID));
                            break;
                        }
                        this.lightArray[x][y] = new Light(x, y, this.map.getMapTileLoader().getTileLight(tileID));
                        break;
                    }
                    ++l;
                }
                ++y;
            }
            ++x;
        }
        x = 0;
        while (x < this.mapWidth - 1) {
            y = 0;
            while (y < this.mapHeight - 1) {
                Light light = this.lightArray[x][y];
                if (light != null) {
                    byte[][] lightMap = light.getLightMap();
                    int x1 = 0;
                    while (x1 < lightMap.length) {
                        int y1 = 0;
                        while (y1 < lightMap[x1].length) {
                            int lightAddX = x1 + (light.getLightX() - lightMap.length / 2);
                            int lightAddY = y1 + (light.getLightY() - lightMap[x1].length / 2);
                            if (lightAddX <= 250 && lightAddX >= 2 && lightAddY <= 250 && lightAddY >= 2) {
                                int[] nArray = this.lightValueMapNew[lightAddX];
                                int n = lightAddY;
                                nArray[n] = nArray[n] + lightMap[x1][y1];
                            }
                            ++y1;
                        }
                        ++x1;
                    }
                }
                ++y;
            }
            ++x;
        }
    }

    public void updateLightMap(int tileX, int tileY, int area) throws SlickException {
        int y;
        int x = tileX - area / 2 - 11;
        while (x < tileX + area / 2 + 11) {
            int y2 = tileY - area / 2 - 11;
            while (y2 < tileY + area / 2 + 11) {
                if (x <= 250 && x >= 2 && y2 <= 250 && y2 >= 2 && this.lightArray[x][y2] != null) {
                    this.lightArray[x][y2].resetLight();
                }
                ++y2;
            }
            ++x;
        }
        boolean foundLight = false;
        int x2 = tileX - area / 2;
        while (x2 < tileX + area / 2) {
            y = tileY - area / 2;
            while (y < tileY + area / 2) {
                if (x2 <= 250 && x2 >= 2 && y <= 250 && y >= 2) {
                    foundLight = false;
                    int l = 0;
                    while (l < this.mapLayers) {
                        int tileID = this.map.getTileId(x2, y, l);
                        if (tileID != 0 && this.map.getMapTileLoader().getTileLight(tileID) != 0) {
                            foundLight = true;
                            if (this.lightArray[x2][y] != null && this.lightArray[x2][y].getLightAmount() == this.map.getMapTileLoader().getTileLight(tileID)) break;
                            this.lightArray[x2][y] = new Light(x2, y, this.map.getMapTileLoader().getTileLight(tileID));
                            break;
                        }
                        ++l;
                    }
                    if (!foundLight) {
                        this.lightArray[x2][y] = null;
                    }
                }
                ++y;
            }
            ++x2;
        }
        int i = 0;
        while (i < this.lightValueMapNew.length) {
            Arrays.fill(this.lightValueMapNew[i], 0);
            ++i;
        }
        x2 = 0;
        while (x2 < this.mapWidth - 1) {
            y = 0;
            while (y < this.mapHeight - 1) {
                Light light = this.lightArray[x2][y];
                if (light != null) {
                    byte[][] lightMap = light.getLightMap();
                    int x1 = 0;
                    while (x1 < lightMap.length) {
                        int y1 = 0;
                        while (y1 < lightMap[x1].length) {
                            int lightAddX = x1 + (light.getLightX() - lightMap.length / 2);
                            int lightAddY = y1 + (light.getLightY() - lightMap[x1].length / 2);
                            if (lightAddX <= 250 && lightAddX >= 2 && lightAddY <= 250 && lightAddY >= 2) {
                                int[] nArray = this.lightValueMapNew[lightAddX];
                                int n = lightAddY;
                                nArray[n] = nArray[n] + lightMap[x1][y1];
                            }
                            ++y1;
                        }
                        ++x1;
                    }
                }
                ++y;
            }
            ++x2;
        }
    }

    public void addShortTermLight(int x, int y, byte r, byte i, int d) {
        this.shortTermLights.add(new Light(x, y, r, i, d));
    }

    public float getLightLevel() {
        return this.lightAlpha;
    }

    public LightNode[][] getLightNodes() {
        return this.lightNodes;
    }

    public ArrayList<LightNode> getResettableLightNodes() {
        return this.resettableLightNodes;
    }

    public void resetOldLightNodes() {
        for (LightNode l : this.resettableLightNodes) {
            l.flagResettable();
        }
        this.resettableLightNodes.clear();
    }

    public int[][] getLightValueMap() {
        return this.lightValueBase;
    }
}

