/*
 * Decompiled with CFR 0.152.
 */
package rtr.lighting;

import java.util.Arrays;
import java.util.PriorityQueue;
import rtr.lighting.LightNode;
import rtr.lighting.LightingModule;
import rtr.map.MapModule;
import rtr.states.StateBase;
import rtr.utilities.Utilities;

public class Light {
    private MapModule map = StateBase.getMapModule();
    private LightingModule lighting = StateBase.getLightingModule();
    private byte[][] lightMap;
    private byte lightRadius;
    private byte lightIntensity;
    private int lightX;
    private int lightY;
    private int lightDuration;
    private PriorityQueue<LightNode> openLightNodes = new PriorityQueue();
    private LightNode baseLightNode;
    private LightNode[][] lightNodes = this.lighting.getLightNodes();

    public Light(int x, int y, byte r) {
        this(x, y, r, 1);
    }

    public Light(int x, int y, byte r, byte i) {
        this(x, y, r, i, -1);
    }

    public Light(int x, int y, byte r, byte i, int d) {
        this.lightMap = new byte[r * 2 + 1][r * 2 + 1];
        this.lightRadius = r;
        this.lightIntensity = i;
        this.lightX = x;
        this.lightY = y;
        this.lightDuration = d;
        this.generateLight();
    }

    public void resetLight() {
        int i = 0;
        while (i < this.lightMap.length) {
            Arrays.fill(this.lightMap[i], (byte)0);
            ++i;
        }
        this.generateLight();
    }

    private void generateLight() {
        if (Utilities.isOutOfBounds(250, 250, this.lightX, this.lightY)) {
            return;
        }
        this.lighting.resetOldLightNodes();
        this.openLightNodes.clear();
        this.baseLightNode = this.lightNodes[this.lightX][this.lightY];
        this.openLightNodes.add(this.lightNodes[this.lightX][this.lightY]);
        this.lightNodes[this.lightX][this.lightY].openNode();
        this.lightNodes[this.lightX][this.lightY].resetNode();
        this.lighting.getResettableLightNodes().add(this.lightNodes[this.lightX][this.lightY]);
        int movementCostMax = this.lightRadius * 10;
        while (this.openLightNodes.size() > 0) {
            this.baseLightNode = this.openLightNodes.poll();
            int thisX = this.baseLightNode.getX();
            int thisY = this.baseLightNode.getY();
            int x = -1;
            while (x < 2) {
                int y = -1;
                while (y < 2) {
                    if (x != 0 || y != 0) {
                        int checkX = thisX + x;
                        int checkY = thisY + y;
                        if (checkX <= 250 && checkX >= 2 && checkY <= 250 && checkY >= 2) {
                            if (this.lightNodes[checkX][checkY].isResettable()) {
                                this.lightNodes[checkX][checkY].resetNode();
                            }
                            if (!this.lightNodes[checkX][checkY].isClosed()) {
                                this.lighting.getResettableLightNodes().add(this.lightNodes[checkX][checkY]);
                                if ((checkX <= thisX || checkY <= thisY || this.map.getLightBlockMap()[checkX - 1][checkY] <= 0 && this.map.getLightBlockMap()[checkX][checkY - 1] <= 0) && (checkX >= thisX || checkY >= thisY || this.map.getLightBlockMap()[checkX + 1][checkY] <= 0 && this.map.getLightBlockMap()[checkX][checkY + 1] <= 0) && (checkX <= thisX || checkY >= thisY || this.map.getLightBlockMap()[checkX - 1][checkY] <= 0 && this.map.getLightBlockMap()[checkX][checkY + 1] <= 0) && (checkX >= thisX || checkY <= thisY || this.map.getLightBlockMap()[checkX + 1][checkY] <= 0 && this.map.getLightBlockMap()[checkX][checkY - 1] <= 0)) {
                                    LightNode checkNode = this.lightNodes[checkX][checkY];
                                    int movementCost = 0;
                                    if (this.map.getLightBlockMap()[checkX][checkY] > 0) {
                                        movementCost += 30;
                                    }
                                    movementCost = checkX > thisX && checkY > thisY || checkX < thisX && checkY < thisY || checkX > thisX && checkY < thisY || checkX < thisX && checkY > thisY ? (movementCost += 14) : (movementCost += 10);
                                    if (!checkNode.isOpen()) {
                                        checkNode.setG(this.baseLightNode.getG() + movementCost);
                                        if (checkNode.getG() < movementCostMax) {
                                            checkNode.openNode();
                                            this.openLightNodes.add(checkNode);
                                            this.lightMap[checkX - this.lightX + this.lightRadius][checkY - this.lightY + this.lightRadius] = (byte)(this.lightIntensity + this.lightRadius - checkNode.getG() / 10);
                                        }
                                    }
                                }
                            }
                        }
                    }
                    ++y;
                }
                ++x;
            }
            this.baseLightNode.closeNode();
        }
    }

    private void generateLight2() {
        if (Utilities.isOutOfBounds(250, 250, this.lightX, this.lightY)) {
            return;
        }
        int x = this.lightX - this.lightRadius;
        while (x < this.lightX + this.lightRadius) {
            int y = this.lightY - this.lightRadius;
            while (y < this.lightY + this.lightRadius) {
                if (x <= 250 && x >= 2 && y <= 250 && y >= 2) {
                    this.lightNodes[x][y].flagResettable();
                }
                ++y;
            }
            ++x;
        }
        this.openLightNodes.clear();
        this.baseLightNode = this.lightNodes[this.lightX][this.lightY];
        this.openLightNodes.add(this.lightNodes[this.lightX][this.lightY]);
        this.lightNodes[this.lightX][this.lightY].openNode();
        this.lightNodes[this.lightX][this.lightY].resetNode();
        int movementCostMax = this.lightRadius * 10;
        while (this.openLightNodes.size() > 0) {
            this.baseLightNode = this.openLightNodes.poll();
            int thisX = this.baseLightNode.getX();
            int thisY = this.baseLightNode.getY();
            int x2 = -1;
            while (x2 < 2) {
                int y = -1;
                while (y < 2) {
                    if (x2 != 0 || y != 0) {
                        int checkX = thisX + x2;
                        int checkY = thisY + y;
                        if (checkX <= 250 && checkX >= 2 && checkY <= 250 && checkY >= 2) {
                            if (this.lightNodes[checkX][checkY].isResettable()) {
                                this.lightNodes[checkX][checkY].resetNode();
                            }
                            if (!this.lightNodes[checkX][checkY].isClosed() && (checkX <= thisX || checkY <= thisY || this.map.getLightBlockMap()[checkX - 1][checkY] <= 0 && this.map.getLightBlockMap()[checkX][checkY - 1] <= 0) && (checkX >= thisX || checkY >= thisY || this.map.getLightBlockMap()[checkX + 1][checkY] <= 0 && this.map.getLightBlockMap()[checkX][checkY + 1] <= 0) && (checkX <= thisX || checkY >= thisY || this.map.getLightBlockMap()[checkX - 1][checkY] <= 0 && this.map.getLightBlockMap()[checkX][checkY + 1] <= 0) && (checkX >= thisX || checkY <= thisY || this.map.getLightBlockMap()[checkX + 1][checkY] <= 0 && this.map.getLightBlockMap()[checkX][checkY - 1] <= 0)) {
                                LightNode checkNode = this.lightNodes[checkX][checkY];
                                int movementCost = 0;
                                if (this.map.getLightBlockMap()[checkX][checkY] > 0) {
                                    movementCost += 30;
                                }
                                movementCost = checkX > thisX && checkY > thisY || checkX < thisX && checkY < thisY || checkX > thisX && checkY < thisY || checkX < thisX && checkY > thisY ? (movementCost += 14) : (movementCost += 10);
                                if (!checkNode.isOpen()) {
                                    checkNode.setG(this.baseLightNode.getG() + movementCost);
                                    if (checkNode.getG() < movementCostMax) {
                                        checkNode.openNode();
                                        this.openLightNodes.add(checkNode);
                                        this.lightMap[checkX - this.lightX + this.lightRadius][checkY - this.lightY + this.lightRadius] = (byte)(this.lightIntensity + this.lightRadius - checkNode.getG() / 10);
                                    }
                                }
                            }
                        }
                    }
                    ++y;
                }
                ++x2;
            }
            this.baseLightNode.closeNode();
        }
    }

    public void update() {
        --this.lightDuration;
    }

    public byte[][] getLightMap() {
        return this.lightMap;
    }

    public int getLightX() {
        return this.lightX;
    }

    public void setLightX(int x) {
        if (this.lightX != x) {
            this.lightX = x;
            this.resetLight();
            this.generateLight();
        }
    }

    public int getLightY() {
        return this.lightY;
    }

    public void setLightY(int y) {
        if (this.lightY != y) {
            this.lightY = y;
            this.resetLight();
            this.generateLight();
        }
    }

    public int getLightAmount() {
        return this.lightRadius;
    }

    public int getLightDuration() {
        return this.lightDuration;
    }
}

