/*
 * Decompiled with CFR 0.152.
 */
package rtr.item;

import java.util.ArrayList;
import java.util.HashMap;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;
import rtr.ImageLoader;
import rtr.ModuleBase;
import rtr.item.ItemBase;
import rtr.item.ItemCoins;
import rtr.item.ItemFood;
import rtr.states.StateBase;
import rtr.utilities.OrderedPair;
import rtr.utilities.Utilities;

public class ItemModule
extends ModuleBase {
    private SpriteSheet itemSheet;
    private HashMap<ItemSprite, ArrayList<Image>> itemSprites;
    private ItemBase[][] items;

    @Override
    public void initModule(StateBase cS) throws SlickException {
        super.initModule(cS);
        if (this.itemSheet == null) {
            this.itemSheet = new SpriteSheet(ImageLoader.getImage("res/itemSheet.png"), this.map.getTileWidth(), this.map.getTileHeight());
        }
        if (this.items == null) {
            this.items = new ItemBase[this.map.getMapWidth()][this.map.getMapHeight()];
        }
        if (this.itemSprites == null) {
            this.itemSprites = new HashMap();
            int row = 0;
            ItemSprite[] itemSpriteArray = ItemSprite.values();
            int n = itemSpriteArray.length;
            int n2 = 0;
            while (n2 < n) {
                ItemSprite s = itemSpriteArray[n2];
                this.itemSprites.put(s, new ArrayList());
                int i = 0;
                while (i < 5) {
                    this.itemSprites.get((Object)s).add(this.itemSheet.getSprite(i, row));
                    ++i;
                }
                ++row;
                ++n2;
            }
        }
    }

    @Override
    public void resetModule() throws SlickException {
        super.resetModule();
        this.items = new ItemBase[this.map.getMapWidth()][this.map.getMapHeight()];
    }

    public void render() {
        this.itemSheet.startUse();
        int startX = this.map.getMapRenderTileTopLeftX() - 1;
        int startY = this.map.getMapRenderTileTopLeftY() - 1;
        int endX = this.map.getMapRenderTileBottomRightX() + 1;
        int endY = this.map.getMapRenderTileBottomRightY() + 1;
        int x = startX;
        while (x < endX) {
            int y = startY;
            while (y < endY) {
                if (x >= 0 && x <= this.items.length - 1 && y >= 0 && y <= this.items[x].length - 1 && this.items[x][y] != null) {
                    this.items[x][y].render();
                }
                ++y;
            }
            ++x;
        }
        this.itemSheet.endUse();
    }

    public void update() throws SlickException {
        int startX = this.map.getMapRenderTileTopLeftX() - 1;
        int startY = this.map.getMapRenderTileTopLeftY() - 1;
        int endX = this.map.getMapRenderTileBottomRightX() + 1;
        int endY = this.map.getMapRenderTileBottomRightY() + 1;
        int x = startX;
        while (x < endX) {
            int y = startY;
            while (y < endY) {
                if (x >= 0 && x <= this.items.length - 1 && y >= 0 && y <= this.items[x].length - 1 && this.items[x][y] != null) {
                    this.items[x][y].update();
                }
                ++y;
            }
            ++x;
        }
    }

    public void addItem(int x, int y, ItemType t) {
        this.addItem(x, y, t, ItemQuality.VERY_LOW, ItemQuality.VERY_HIGH);
    }

    public void addItem(int x, int y, ItemType t, ItemQuality low, ItemQuality high) {
        if (t == ItemType.FOOD) {
            this.items[x][y] = new ItemFood(x, y, low, high);
        } else if (t == ItemType.COINS) {
            this.items[x][y] = new ItemCoins(x, y, low, high);
        } else if (t == ItemType.HERB) {
            this.items[x][y] = new ItemFood(x, y, low, high);
        } else if (t == ItemType.TREASURE) {
            this.items[x][y] = new ItemFood(x, y, low, high);
        } else if (t == ItemType.WEAPON) {
            this.items[x][y] = new ItemFood(x, y, low, high);
        } else if (t == ItemType.ARMOR) {
            this.items[x][y] = new ItemFood(x, y, low, high);
        } else if (t == ItemType.KEY_RED) {
            this.items[x][y] = new ItemFood(x, y, low, high);
        } else if (t == ItemType.KEY_GREEN) {
            this.items[x][y] = new ItemFood(x, y, low, high);
        } else if (t == ItemType.KEY_BLUE) {
            this.items[x][y] = new ItemFood(x, y, low, high);
        }
    }

    public void removeItem(int x, int y) {
        this.items[x][y] = null;
    }

    public void removeItem(ItemBase i) {
        this.items[i.getTileX()][i.getTileY()] = null;
    }

    public void dropItem(ItemBase i, int x, int y) {
        this.items[x][y] = i;
        i.setTileX(x);
        i.setTileY(y);
    }

    public ItemBase getItem(int x, int y) {
        return this.items[x][y];
    }

    public Image getSprite(ItemSprite s) {
        return this.itemSprites.get((Object)s).get(Utilities.randomInt(5));
    }

    public void eraseMap() {
        this.items = new ItemBase[this.map.getMapWidth()][this.map.getMapHeight()];
    }

    public OrderedPair findOpenSpot(int centerX, int centerY) {
        if (this.items[centerX][centerY] == null) {
            return OrderedPair.getOrderedPair(centerX, centerY);
        }
        int x = -1;
        while (x < 2) {
            int y = -1;
            while (y < 2) {
                if (this.items[centerX + x][centerY + y] == null) {
                    return OrderedPair.getOrderedPair(centerX + x, centerY + y);
                }
                ++y;
            }
            ++x;
        }
        return null;
    }

    public static enum ItemQuality {
        VERY_LOW,
        LOW,
        MEDIUM,
        HIGH,
        VERY_HIGH;

    }

    public static enum ItemSprite {
        FOOD,
        COINS_VERY_LOW,
        COINS_LOW,
        COINS_MEDIUM,
        COINS_HIGH,
        COINS_VERY_HIGH,
        HERB,
        TREASURE,
        WEAPON,
        ARMOR,
        KEY_RED,
        KEY_GREEN,
        KEY_BLUE;

    }

    public static enum ItemType {
        FOOD,
        COINS,
        HERB,
        TREASURE,
        WEAPON,
        ARMOR,
        KEY_RED,
        KEY_GREEN,
        KEY_BLUE;

    }
}

