/*
 * Decompiled with CFR 0.152.
 */
package rtr.item;

import org.newdawn.slick.Color;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import rtr.item.ItemModule;
import rtr.lighting.Light;
import rtr.map.MapModule;
import rtr.states.StateBase;

public class ItemBase {
    protected ItemModule item = StateBase.getItemModule();
    protected MapModule map = StateBase.getMapModule();
    protected Image sprite;
    protected Color itemColor;
    protected ItemModule.ItemType itemType;
    protected ItemModule.ItemQuality itemQuality;
    protected Light light;
    protected int tileX;
    protected int tileY;
    protected int randomOffsetAmountX;
    protected int randomOffsetAmountY;
    protected int foodValue;
    protected int herbValue;
    protected int scoreValue;
    protected int coinValue;
    protected ItemEquipSlot equipSlot;

    public ItemBase(int x, int y) {
        this.tileX = x;
        this.tileY = y;
    }

    public void render() {
        float drawX = this.map.getMapX() + (float)(this.tileX * this.map.getTileWidth());
        float drawY = this.map.getMapY() + (float)(this.tileY * this.map.getTileHeight());
        this.sprite.drawEmbedded(drawX + (float)this.randomOffsetAmountX, drawY + (float)this.randomOffsetAmountY, drawX + (float)this.randomOffsetAmountX + (float)this.sprite.getWidth(), drawY + (float)this.randomOffsetAmountY + (float)this.sprite.getHeight(), 0.0f, 0.0f, this.sprite.getWidth(), this.sprite.getHeight(), this.itemColor);
    }

    public void render(float drawX, float drawY) {
        this.sprite.draw(drawX, drawY, drawX + (float)this.sprite.getWidth(), drawY + (float)this.sprite.getHeight(), 0.0f, 0.0f, this.sprite.getWidth(), this.sprite.getHeight(), this.itemColor);
    }

    public void update() throws SlickException {
    }

    public int getFoodValue() {
        return this.foodValue;
    }

    public int getScoreValue() {
        return this.scoreValue;
    }

    public int getCoinValue() {
        return this.coinValue;
    }

    public ItemModule.ItemType getType() {
        return this.itemType;
    }

    public int getTileX() {
        return this.tileX;
    }

    public int getTileY() {
        return this.tileY;
    }

    public Light getLight() {
        return this.light;
    }

    public ItemEquipSlot getEquipSlot() {
        return this.equipSlot;
    }

    public void setTileX(int x) {
        this.tileX = x;
    }

    public void setTileY(int y) {
        this.tileY = y;
    }

    public static enum ItemEquipSlot {
        HEAD,
        CHEST,
        WEAPON,
        SHIELD,
        RING;

    }
}

