/*
 * Decompiled with CFR 0.152.
 */
package rtr.gui;

import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import rtr.ImageLoader;
import rtr.TurnControlModule;
import rtr.font.FontModule;
import rtr.item.ItemBase;
import rtr.item.ItemModule;
import rtr.map.MapModule;
import rtr.map.MiniMapModule;
import rtr.mobs.MobBase;
import rtr.mobs.MobModule;
import rtr.object.ObjectBase;
import rtr.states.StateBase;
import rtr.system.ScaleControl;

public class PlayStateGUI {
    private MapModule map = StateBase.getMapModule();
    private MiniMapModule miniMap = StateBase.getMiniMapModule();
    private MobModule mob = StateBase.getMobModule();
    private ItemModule item = StateBase.getItemModule();
    private FontModule font = StateBase.getFontModule();
    private TurnControlModule turnControl = StateBase.getTurnControlModule();
    private Image inventory9Slot = ImageLoader.getImage("res/GUI/inventory9Slot.png");
    private Image inventory12Slot = ImageLoader.getImage("res/GUI/inventory12Slot.png");
    private Image inventory15Slot = ImageLoader.getImage("res/GUI/inventory15Slot.png");
    private Image inventory18Slot = ImageLoader.getImage("res/GUI/inventory18Slot.png");
    private Image container1Slot = ImageLoader.getImage("res/GUI/container1Slot.png");
    private Image container3Slot = ImageLoader.getImage("res/GUI/container3Slot.png");
    private Image container6Slot = ImageLoader.getImage("res/GUI/container6Slot.png");
    private Image container9Slot = ImageLoader.getImage("res/GUI/container9Slot.png");
    private Image miniMapFrame = ImageLoader.getImage("res/GUI/miniMap.png");
    private Image miniMapLargeFrame = ImageLoader.getImage("res/GUI/miniMapLarge.png");
    private Image statusBar = ImageLoader.getImage("res/GUI/statusBar.png");
    private ObjectBase container;
    private Image inventoryHighlight = ImageLoader.getImage("res/GUI/inventoryHighlight.png");
    private Image inventorySelect = ImageLoader.getImage("res/GUI/inventorySelect.png");
    private Image inventoryRingSlot = ImageLoader.getImage("res/GUI/inventoryRingSlot.png");
    private Image inventoryHeadSlot = ImageLoader.getImage("res/GUI/inventoryHeadSlot.png");
    private Image inventoryWeaponSlot = ImageLoader.getImage("res/GUI/inventoryWeaponSlot.png");
    private Image inventoryChestSlot = ImageLoader.getImage("res/GUI/inventoryChestSlot.png");
    private Image inventoryShieldSlot = ImageLoader.getImage("res/GUI/inventoryShieldSlot.png");
    private Image heartFull = ImageLoader.getImage("res/GUI/heartFull.png");
    private Image heartHalf = ImageLoader.getImage("res/GUI/heartHalf.png");
    private Image heartEmpty = ImageLoader.getImage("res/GUI/heartEmpty.png");
    private Image hungerFull = ImageLoader.getImage("res/GUI/hungerFull.png");
    private Image hungerHalf = ImageLoader.getImage("res/GUI/hungerHalf.png");
    private Image hungerEmpty = ImageLoader.getImage("res/GUI/hungerEmpty.png");
    private Image energyFull = ImageLoader.getImage("res/GUI/energyFull.png");
    private Image energyHalf = ImageLoader.getImage("res/GUI/energyHalf.png");
    private Image energyEmpty = ImageLoader.getImage("res/GUI/energyEmpty.png");
    private MobBase hero = this.mob.getHero();
    private boolean inventoryOpen;
    private boolean miniMapOpen;
    private boolean usingContainer;
    private int inventorySlotHighlighted = 6;
    private int inventorySlotSelected = -1;
    private int containerSlotHighlighted = 0;
    private int containerSlotSelected = -1;

    public void render(Graphics g) throws SlickException {
        this.renderStatusBar(g);
        this.renderMiniMap(g);
        if (this.inventoryOpen) {
            this.renderInventory();
        }
    }

    private void renderInventory() throws SlickException {
        int displayWidth = ScaleControl.getWidth();
        int displayHeight = ScaleControl.getHeight();
        int x = (int)((float)((displayWidth - this.inventory9Slot.getWidth()) / 2) + this.hero.getMobX() + this.map.getMapX()) - 185;
        int y = (int)((float)((displayHeight - this.inventory9Slot.getHeight()) / 2) + this.hero.getMobY() + this.map.getMapY()) - 150;
        int renderOffsetChestY = 0;
        ItemBase[] heroInventory = this.hero.getInventory();
        int heroInventoryLengthFull = heroInventory.length;
        int heroInventoryLength = heroInventory.length - this.hero.getInventoryStartNumber();
        switch (heroInventoryLength) {
            case 9: {
                this.inventory9Slot.draw(x, y);
                break;
            }
            case 12: {
                this.inventory12Slot.draw(x, y);
                renderOffsetChestY = 16;
                break;
            }
            case 15: {
                this.inventory15Slot.draw(x, y);
                renderOffsetChestY = 32;
                break;
            }
            case 18: {
                this.inventory18Slot.draw(x, y);
                renderOffsetChestY = 48;
            }
        }
        this.font.drawString(x + 38, y + 46, "$YEL0A Carrot", 0, true);
        int drawX = x + 13;
        int drawY = y + 13;
        int alignX = 0;
        int alignY = 0;
        int i = 0;
        while (i < heroInventoryLengthFull) {
            if (heroInventory[i] != null) {
                heroInventory[i].render(drawX + alignX, drawY + alignY);
            } else if (i == this.hero.getEquipSlotRingOneNumber() || i == this.hero.getEquipSlotRingTwoNumber()) {
                this.inventoryRingSlot.draw(drawX + alignX, drawY + alignY);
            } else if (i == this.hero.getEquipSlotHeadNumber()) {
                this.inventoryHeadSlot.draw(drawX + alignX, drawY + alignY);
            } else if (i == this.hero.getEquipSlotWeaponNumber()) {
                this.inventoryWeaponSlot.draw(drawX + alignX, drawY + alignY);
            } else if (i == this.hero.getEquipSlotChestNumber()) {
                this.inventoryChestSlot.draw(drawX + alignX, drawY + alignY);
            } else if (i == this.hero.getEquipSlotShieldNumber()) {
                this.inventoryShieldSlot.draw(drawX + alignX, drawY + alignY);
            }
            if ((alignX += this.map.getTileWidth()) >= 3 * this.map.getTileWidth()) {
                alignX = 0;
                alignY = alignY == this.map.getTileWidth() ? (alignY += this.map.getTileWidth() + 11) : (alignY += this.map.getTileWidth());
            }
            ++i;
        }
        this.font.drawString(x + 25, y + 105 + renderOffsetChestY, "$GRE0" + this.hero.getCoins(), 0);
        if (this.container != null) {
            int renderOffsetContainerY = 0;
            ItemBase[] containerInventory = this.container.getInventory();
            int containerInventoryLength = containerInventory.length;
            switch (containerInventoryLength) {
                case 1: {
                    this.container1Slot.draw(x - 74, y + 43);
                    break;
                }
                case 3: {
                    this.container3Slot.draw(x - 74, y + 43);
                    renderOffsetContainerY = 16;
                    break;
                }
                case 6: {
                    this.container6Slot.draw(x - 74, y + 43);
                    renderOffsetContainerY = 32;
                    break;
                }
                case 9: {
                    this.container9Slot.draw(x - 74, y + 43);
                    renderOffsetContainerY = 48;
                }
            }
            drawX = x + 13 - 74;
            drawY = y + 13 + 43;
            alignX = 0;
            alignY = 0;
            int i2 = 0;
            while (i2 < containerInventoryLength) {
                if (containerInventory[i2] != null) {
                    containerInventory[i2].render(drawX + alignX, drawY + alignY);
                }
                if ((alignX += this.map.getTileWidth()) >= 3 * this.map.getTileWidth()) {
                    alignX = 0;
                    alignY += this.map.getTileWidth();
                }
                ++i2;
            }
        }
        if (this.usingContainer) {
            if (this.containerSlotSelected != -1) {
                this.inventorySelect.draw(x + 13 + this.containerSlotSelected % 3 * this.map.getTileHeight() - 74, y + 13 + this.containerSlotSelected / 3 * this.map.getTileHeight() + 43);
            }
            this.inventoryHighlight.draw(x + 13 + this.containerSlotHighlighted % 3 * this.map.getTileHeight() - 74, y + 13 + this.containerSlotHighlighted / 3 * this.map.getTileHeight() + 43);
        } else {
            if (this.inventorySlotSelected != -1) {
                if (this.inventorySlotSelected >= this.hero.getInventoryStartNumber()) {
                    this.inventorySelect.draw(x + 13 + this.inventorySlotSelected % 3 * this.map.getTileHeight(), y + 24 + this.inventorySlotSelected / 3 * this.map.getTileHeight());
                } else {
                    this.inventorySelect.draw(x + 13 + this.inventorySlotSelected % 3 * this.map.getTileHeight(), y + 13 + this.inventorySlotSelected / 3 * this.map.getTileHeight());
                }
            }
            if (this.inventorySlotHighlighted >= this.hero.getInventoryStartNumber()) {
                this.inventoryHighlight.draw(x + 13 + this.inventorySlotHighlighted % 3 * this.map.getTileHeight(), y + 24 + this.inventorySlotHighlighted / 3 * this.map.getTileHeight());
            } else {
                this.inventoryHighlight.draw(x + 13 + this.inventorySlotHighlighted % 3 * this.map.getTileHeight(), y + 13 + this.inventorySlotHighlighted / 3 * this.map.getTileHeight());
            }
        }
    }

    public void setInventorySlotHighlightedUp() {
        this.inventorySlotHighlighted = this.inventorySlotHighlighted == 0 ? this.hero.getInventory().length - 3 : (this.inventorySlotHighlighted == 1 ? this.hero.getInventory().length - 2 : (this.inventorySlotHighlighted == 2 ? this.hero.getInventory().length - 1 : (this.inventorySlotHighlighted -= 3)));
    }

    public void setInventorySlotHighlightedDown() {
        this.inventorySlotHighlighted = this.inventorySlotHighlighted == this.hero.getInventory().length - 3 ? 0 : (this.inventorySlotHighlighted == this.hero.getInventory().length - 2 ? 1 : (this.inventorySlotHighlighted == this.hero.getInventory().length - 1 ? 2 : (this.inventorySlotHighlighted += 3)));
    }

    public void setInventorySlotHighlightedLeft() {
        this.inventorySlotHighlighted = this.inventorySlotHighlighted % 3 == 0 ? (this.inventorySlotHighlighted += 2) : --this.inventorySlotHighlighted;
    }

    public void setInventorySlotHighlightedRight() {
        this.inventorySlotHighlighted = this.inventorySlotHighlighted % 3 == 2 ? (this.inventorySlotHighlighted -= 2) : ++this.inventorySlotHighlighted;
    }

    public int getInventorySlotHighlighted() {
        return this.inventorySlotHighlighted;
    }

    public ItemBase getInventorySlotHighlightedItem() {
        return this.hero.getInventory()[this.inventorySlotHighlighted];
    }

    public void selectInventoryItem() {
        if (this.inventorySlotSelected != -1 && this.inventorySlotSelected == this.inventorySlotHighlighted) {
            this.inventorySlotSelected = -1;
        } else if (this.inventorySlotSelected == -1) {
            this.inventorySlotSelected = this.inventorySlotHighlighted;
        } else {
            this.hero.swapItemsInInventory(this.inventorySlotSelected, this.inventorySlotHighlighted);
            this.inventorySlotSelected = -1;
        }
    }

    public void setContainerSlotHighlightedUp() {
        if (this.container.getInventory().length == 1) {
            return;
        }
        this.containerSlotHighlighted = this.containerSlotHighlighted == 0 ? this.container.getInventory().length - 3 : (this.containerSlotHighlighted == 1 ? this.container.getInventory().length - 2 : (this.containerSlotHighlighted == 2 ? this.container.getInventory().length - 1 : (this.containerSlotHighlighted -= 3)));
    }

    public void setContainerSlotHighlightedDown() {
        if (this.container.getInventory().length == 1) {
            return;
        }
        this.containerSlotHighlighted = this.containerSlotHighlighted == this.container.getInventory().length - 3 ? 0 : (this.containerSlotHighlighted == this.container.getInventory().length - 2 ? 1 : (this.containerSlotHighlighted == this.container.getInventory().length - 1 ? 2 : (this.containerSlotHighlighted += 3)));
    }

    public void setContainerSlotHighlightedLeft() {
        if (this.container.getInventory().length == 1) {
            return;
        }
        this.containerSlotHighlighted = this.containerSlotHighlighted % 3 == 0 ? (this.containerSlotHighlighted += 2) : --this.containerSlotHighlighted;
    }

    public void setContainerSlotHighlightedRight() {
        if (this.container.getInventory().length == 1) {
            return;
        }
        this.containerSlotHighlighted = this.containerSlotHighlighted % 3 == 2 ? (this.containerSlotHighlighted -= 2) : ++this.containerSlotHighlighted;
    }

    public int getContainerSlotHighlighted() {
        return this.containerSlotHighlighted;
    }

    public ItemBase getContainerSlotHighlightedItem() {
        return this.container.getInventory()[this.containerSlotHighlighted];
    }

    public void selectContainerItem() {
        if (this.containerSlotSelected != -1 && this.containerSlotSelected == this.containerSlotHighlighted) {
            this.containerSlotSelected = -1;
        } else if (this.containerSlotSelected == -1) {
            this.containerSlotSelected = this.containerSlotHighlighted;
        } else {
            this.container.swapItemsInInventory(this.containerSlotSelected, this.containerSlotHighlighted);
            this.containerSlotSelected = -1;
        }
    }

    private void renderMiniMap(Graphics g) {
        int displayHeight = ScaleControl.getHeight();
        int displayWidth = ScaleControl.getWidth();
        if (this.miniMapOpen) {
            int x = displayWidth - this.miniMapLargeFrame.getWidth();
            int y = displayHeight - this.miniMapLargeFrame.getHeight();
            this.miniMap.render(x + 11, y + 11, 128, g);
            this.miniMapLargeFrame.draw(x, y);
        } else {
            int x = displayWidth - this.miniMapFrame.getWidth();
            int y = displayHeight - this.miniMapFrame.getHeight();
            this.miniMap.render(x + 11, y + 11, 52, g);
            this.miniMapFrame.draw(x, y);
        }
    }

    private void renderStatusBar(Graphics g) {
        int displayHeight = ScaleControl.getHeight();
        int displayWidth = ScaleControl.getWidth();
        this.statusBar.draw(0.0f, displayHeight - this.statusBar.getHeight());
        int noiseLeft = (int)Math.ceil((float)this.mob.getNoiseLevel() / (float)this.mob.getNoiseLevelMax() * 63.0f);
        g.setColor(new Color(100 + noiseLeft, 255, 0, 150));
        g.fillRect(22.0f, displayHeight - 64, noiseLeft, 4.0f);
        g.setColor(new Color(0, 0, 0, 100));
        g.fillRect(22.0f, displayHeight - 61, noiseLeft, 1.0f);
        g.setColor(new Color(0, 0, 0, 100));
        g.fillRect(22.0f, displayHeight - 64, noiseLeft, 1.0f);
        int xpLeft = (int)Math.ceil((float)this.hero.getExperience() / (float)(this.hero.getExperienceMultiplier() * this.hero.getLevel()) * 63.0f);
        g.setColor(new Color(0, 255, 0, 150));
        g.fillRect(22.0f, displayHeight - 59, xpLeft, 8.0f);
        g.setColor(new Color(0, 0, 0, 100));
        g.fillRect(22.0f, displayHeight - 52, xpLeft, 1.0f);
        g.setColor(new Color(0, 0, 0, 100));
        g.fillRect(22.0f, displayHeight - 59, xpLeft, 1.0f);
        this.font.drawString(24.0f, displayHeight - 60, "$YEL0" + this.hero.getLevel(), 0);
        int hitPoints = this.hero.getHitPoints();
        int hitPointsMax = this.hero.getHitPointsMax();
        int fullHearts = hitPoints / 2;
        int halfHearts = hitPoints % 2;
        int emptyHearts = (hitPointsMax - hitPoints) / 2;
        int alignX = 0;
        int alignY = 0;
        int i = 0;
        while (i < fullHearts) {
            this.heartFull.draw(13 + alignX++ * 8, displayHeight - 43 + alignY * 8);
            if (alignX == 10) {
                alignX = 0;
                ++alignY;
            }
            ++i;
        }
        i = 0;
        while (i < halfHearts) {
            this.heartHalf.draw(13 + alignX++ * 8, displayHeight - 43 + alignY * 8);
            if (alignX == 10) {
                alignX = 0;
                ++alignY;
            }
            ++i;
        }
        i = 0;
        while (i < emptyHearts) {
            this.heartEmpty.draw(13 + alignX++ * 8, displayHeight - 43 + alignY * 8);
            if (alignX == 10) {
                alignX = 0;
                ++alignY;
            }
            ++i;
        }
        int hunger = this.hero.getHunger();
        int hungerMax = this.hero.getHungerMax();
        int fullHunger = hunger / 2;
        int halfHunger = hunger % 2;
        int emptyHunger = (hungerMax - hunger) / 2;
        alignX = 0;
        alignY = 2;
        int i2 = 0;
        while (i2 < fullHunger) {
            this.hungerFull.draw(13 + alignX++ * 8, displayHeight - 43 + alignY * 8);
            if (alignX == 10) {
                alignX = 0;
                ++alignY;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < halfHunger) {
            this.hungerHalf.draw(13 + alignX++ * 8, displayHeight - 43 + alignY * 8);
            if (alignX == 10) {
                alignX = 0;
                ++alignY;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < emptyHunger) {
            this.hungerEmpty.draw(13 + alignX++ * 8, displayHeight - 43 + alignY * 8);
            if (alignX == 10) {
                alignX = 0;
                ++alignY;
            }
            ++i2;
        }
        int energy = this.hero.getEnergy();
        int energyMax = this.hero.getEnergyMax();
        int fullEnergy = energy / 2;
        int halfEnergy = energy % 2;
        int emptyEnergy = (energyMax - energy) / 2;
        alignX = 0;
        alignY = 3;
        int i3 = 0;
        while (i3 < fullEnergy) {
            this.energyFull.draw(13 + alignX++ * 8, displayHeight - 43 + alignY * 8);
            if (alignX == 10) {
                alignX = 0;
                ++alignY;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < halfEnergy) {
            this.energyHalf.draw(13 + alignX++ * 8, displayHeight - 43 + alignY * 8);
            if (alignX == 10) {
                alignX = 0;
                ++alignY;
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < emptyEnergy) {
            this.energyEmpty.draw(13 + alignX++ * 8, displayHeight - 43 + alignY * 8);
            if (alignX == 10) {
                alignX = 0;
                ++alignY;
            }
            ++i3;
        }
    }

    public boolean isInventoryOpen() {
        return this.inventoryOpen;
    }

    public void toggleInventory() {
        if (this.inventoryOpen) {
            this.inventoryOpen = false;
            this.inventorySlotSelected = -1;
            this.containerSlotSelected = -1;
            this.containerSlotHighlighted = 0;
            this.usingContainer = false;
            this.container = null;
        } else {
            this.inventoryOpen = true;
        }
    }

    public boolean isUsingContainer() {
        return this.usingContainer;
    }

    public void toggleUsingContainer() {
        if (this.container != null) {
            this.usingContainer = !this.usingContainer;
        }
    }

    public void openContainer(ObjectBase o) {
        this.inventoryOpen = true;
        this.usingContainer = true;
        this.container = o;
    }

    public void closeContainer() {
        this.inventoryOpen = false;
        this.usingContainer = false;
        this.inventorySlotSelected = -1;
        this.containerSlotSelected = -1;
        this.containerSlotHighlighted = 0;
        this.container = null;
    }

    public ObjectBase getContainer() {
        return this.container;
    }

    public boolean isMiniMapOpen() {
        return this.miniMapOpen;
    }

    public void openMiniMap() {
        this.miniMapOpen = true;
    }

    public void closeMiniMap() {
        this.miniMapOpen = false;
    }
}

