/*
 * Decompiled with CFR 0.152.
 */
package rtr.font;

import java.util.ArrayList;
import java.util.HashMap;
import org.newdawn.slick.AngelCodeFont;
import org.newdawn.slick.Color;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import rtr.ImageLoader;
import rtr.ModuleBase;
import rtr.states.StateBase;

public class FontModule
extends ModuleBase {
    private HashMap<String, Color> fontColors = new HashMap();
    private boolean fontsLoaded;
    private ArrayList<AngelCodeFont> fonts = new ArrayList();
    private AngelCodeFont fontSmall;
    private AngelCodeFont fontMedium;
    private AngelCodeFont fontLarge;
    private AngelCodeFont fontHeader;
    private Image fontImageSmall;
    private Image fontImageMedium;
    private Image fontImageLarge;
    private Image fontImageHeader;
    private ArrayList<ArrayList<String>> outputTexts = new ArrayList();
    private ArrayList<ArrayList<Color>> outputColors = new ArrayList();

    @Override
    public void initModule(StateBase cS) throws SlickException {
        super.initModule(cS);
        if (!this.fontsLoaded) {
            this.fontColors.put("WHI0", new Color(250, 250, 250));
            this.fontColors.put("YEL0", new Color(250, 250, 200));
            this.fontColors.put("YEL1", new Color(250, 255, 100));
            this.fontColors.put("YEL2", new Color(150, 150, 0));
            this.fontColors.put("RED0", new Color(250, 200, 200));
            this.fontColors.put("RED1", new Color(250, 100, 100));
            this.fontColors.put("RED2", new Color(150, 0, 0));
            this.fontColors.put("GRE0", new Color(100, 250, 200));
            this.fontColors.put("GRE1", new Color(100, 250, 100));
            this.fontColors.put("GRE2", new Color(0, 150, 0));
            this.fontColors.put("BLU0", new Color(200, 200, 250));
            this.fontColors.put("BLU1", new Color(100, 100, 250));
            this.fontColors.put("BLU2", new Color(0, 0, 150));
            this.fontColors.put("BLA0", new Color(0, 0, 0));
            this.fontColors.put("BLA1", new Color(50, 50, 50));
            this.fontColors.put("BLA2", new Color(100, 100, 100));
            this.fontColors.put("CYA0", new Color(200, 250, 250));
            this.fontColors.put("CYA1", new Color(100, 250, 250));
            this.fontColors.put("CYA2", new Color(0, 150, 150));
            this.fontColors.put("PIN0", new Color(255, 170, 215));
            this.fontColors.put("PIN1", new Color(255, 115, 190));
            this.fontColors.put("PIN2", new Color(190, 70, 130));
            this.fontColors.put("ORA0", new Color(235, 170, 100));
            this.fontColors.put("ORA1", new Color(235, 135, 40));
            this.fontColors.put("ORA2", new Color(180, 105, 30));
            this.fontColors.put("MAG0", new Color(214, 141, 210));
            this.fontColors.put("MAG1", new Color(215, 80, 205));
            this.fontColors.put("MAG2", new Color(150, 55, 150));
            this.fontImageSmall = ImageLoader.getImage("res/font/fontSmall.png");
            this.fontImageMedium = ImageLoader.getImage("res/font/fontMedium.png");
            this.fontImageLarge = ImageLoader.getImage("res/font/fontLarge.png");
            this.fontImageHeader = ImageLoader.getImage("res/font/fontHeader.png");
            this.fontSmall = new AngelCodeFont("res/font/fontSmall.fnt", this.fontImageSmall);
            this.fonts.add(this.fontSmall);
            this.fontMedium = new AngelCodeFont("res/font/fontMedium.fnt", this.fontImageMedium);
            this.fonts.add(this.fontMedium);
            this.fontLarge = new AngelCodeFont("res/font/fontLarge.fnt", this.fontImageLarge);
            this.fonts.add(this.fontLarge);
            this.fontHeader = new AngelCodeFont("res/font/fontHeader.fnt", this.fontImageHeader);
            this.fonts.add(this.fontHeader);
            this.fontsLoaded = true;
        }
    }

    @Override
    public void resetModule() throws SlickException {
        super.resetModule();
    }

    public void render() {
    }

    public void update() {
    }

    public void drawString(float x, float y, String text, int size) {
        this.drawString(x, y, text, 255, size, false);
    }

    public void drawString(float x, float y, String text, int size, boolean centered) {
        this.drawString(x, y, text, 255, size, centered);
    }

    public void drawString(float x, float y, String text, int alpha, int size, boolean centered) {
        this.outputTexts.clear();
        this.outputColors.clear();
        Color outputColor = this.fontColors.get("WHI0");
        int start = 0;
        int stop = 0;
        String[] outputLines = text.split("~");
        int l = 0;
        while (l < outputLines.length) {
            this.outputTexts.add(new ArrayList());
            this.outputColors.add(new ArrayList());
            ++l;
        }
        l = 0;
        while (l < outputLines.length) {
            int t = start;
            while (t < text.length()) {
                if (text.charAt(t) == '$') {
                    stop = t;
                    if (start != stop) {
                        this.outputTexts.get(l).add(text.substring(start, stop));
                        this.outputColors.get(l).add(outputColor);
                    }
                    start = stop + 5;
                    for (String fC : this.fontColors.keySet()) {
                        if (!fC.equals(text.substring(t + 1, t + 5))) continue;
                        outputColor = this.fontColors.get(fC);
                    }
                }
                if (t == text.length() - 1) {
                    this.outputTexts.get(l).add(text.substring(start, text.length()));
                    this.outputColors.get(l).add(outputColor);
                } else if (text.charAt(t) == '~') {
                    stop = t;
                    this.outputTexts.get(l).add(text.substring(start, stop));
                    this.outputColors.get(l).add(outputColor);
                    start = t + 1;
                    break;
                }
                ++t;
            }
            ++l;
        }
        int stringHeight = 0;
        int l2 = 0;
        while (l2 < outputLines.length) {
            int stringLength = 0;
            int t = 0;
            while (t < this.outputTexts.get(l2).size()) {
                Color shadowColor;
                Color finalColor;
                if (alpha < 255) {
                    finalColor = new Color(this.outputColors.get(l2).get(t).getRed(), this.outputColors.get(l2).get(t).getGreen(), this.outputColors.get(l2).get(t).getBlue(), alpha);
                    shadowColor = new Color(this.fontColors.get("BLA0").getRed(), this.fontColors.get("BLA0").getGreen(), this.fontColors.get("BLA0").getBlue(), alpha);
                } else {
                    finalColor = this.outputColors.get(l2).get(t);
                    shadowColor = this.fontColors.get("BLA0");
                }
                if (centered) {
                    int stringLengthLeft = 0;
                    int stringLengthRight = 0;
                    int c = 0;
                    while (c < this.outputTexts.get(l2).size()) {
                        if (c < t) {
                            stringLengthLeft += this.fonts.get(size).getWidth(this.outputTexts.get(l2).get(c));
                        } else if (c > t) {
                            stringLengthRight += this.fonts.get(size).getWidth(this.outputTexts.get(l2).get(c));
                        }
                        ++c;
                    }
                    int stringAdjustmentFinal = (stringLengthLeft - stringLengthRight) / 2;
                    this.fonts.get(size).drawString(x + (float)stringAdjustmentFinal - (float)(this.fonts.get(size).getWidth(this.outputTexts.get(l2).get(t)) / 2) + 1.0f, y + (float)stringHeight + 1.0f, this.outputTexts.get(l2).get(t), shadowColor);
                    this.fonts.get(size).drawString(x + (float)stringAdjustmentFinal - (float)(this.fonts.get(size).getWidth(this.outputTexts.get(l2).get(t)) / 2), y + (float)stringHeight, this.outputTexts.get(l2).get(t), finalColor);
                } else {
                    this.fonts.get(size).drawString(x + 1.0f + (float)stringLength, y + 1.0f + (float)stringHeight, this.outputTexts.get(l2).get(t), shadowColor);
                    this.fonts.get(size).drawString(x + (float)stringLength, y + (float)stringHeight, this.outputTexts.get(l2).get(t), finalColor);
                    stringLength += this.fonts.get(size).getWidth(this.outputTexts.get(l2).get(t));
                }
                ++t;
            }
            stringHeight += this.fonts.get(size).getLineHeight();
            ++l2;
        }
    }

    public int getHeight(String text, int size) {
        return this.fonts.get(size).getHeight(text);
    }

    public int getWidth(String text, int size) {
        return this.fonts.get(size).getWidth(text);
    }

    public AngelCodeFont getFont(int size) {
        return this.fonts.get(size);
    }
}

