/*
 * Decompiled with CFR 0.152.
 */
package rtr.console;

import rtr.font.FontModule;
import rtr.states.StateBase;

public class ConsoleEntry {
    private FontModule font = StateBase.getFontModule();
    private float alphaCurrent = 0.0f;
    private float alphaMax = 255.0f;
    private String message;
    private boolean fadeIn = true;

    public ConsoleEntry(String m) {
        this.message = m;
    }

    public void render(int x, int y) {
        this.font.drawString(x, y, this.message, (int)this.alphaCurrent, 1, false);
    }

    public void update() {
        if (this.fadeIn) {
            this.alphaCurrent += 10.0f;
            if (this.alphaCurrent > this.alphaMax) {
                this.fadeIn = false;
            }
        }
    }

    public void decreaseAlpha(float a) {
        this.alphaMax -= a;
        this.alphaCurrent -= a;
    }
}

