/*
 * Decompiled with CFR 0.152.
 */
package rtr.console;

import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import rtr.font.FontModule;
import rtr.states.StateBase;
import rtr.system.ScaleControl;

public class ConsoleBanner {
    private FontModule font = StateBase.getFontModule();
    private float alpha = 0.0f;
    private String header;
    private String subtitle;
    private boolean fadeIn = true;
    private int decayTick;
    private int fadeTick;
    private float xShift = -30.0f;

    public ConsoleBanner(String h, String s) {
        this.header = h;
        this.subtitle = s;
    }

    public void render(float yOffset, Graphics g) {
        g.setColor(new Color(0.0f, 0.0f, 0.0f, this.alpha / 800.0f));
        g.fillRect(-10.0f, 90.0f + yOffset, ScaleControl.getWidth() + 20, 23.0f);
        g.setColor(new Color(0.0f, 0.0f, 0.2f, this.alpha / 800.0f));
        g.fillRect(-10.0f, 113.0f + yOffset, ScaleControl.getWidth() + 20, 16.0f);
        this.xShift += 0.1f;
        this.font.drawString((float)(ScaleControl.getWidth() / 2) + this.xShift, 92.0f + yOffset, this.header, (int)this.alpha * 2, 2, true);
        this.font.drawString((float)(ScaleControl.getWidth() / 2) - this.xShift, 113.0f + yOffset, this.subtitle, (int)this.alpha, 1, true);
    }

    public void update() {
        if (this.fadeIn) {
            this.alpha += 10.0f;
            if (this.alpha >= 255.0f) {
                ++this.fadeTick;
                this.alpha = 255.0f;
                if (this.fadeTick > 350) {
                    this.fadeIn = false;
                }
            }
        } else if (this.alpha > 0.0f) {
            this.alpha -= 5.0f;
        } else {
            ++this.decayTick;
        }
    }

    public int getDecayTick() {
        return this.decayTick;
    }
}

