/*
 * Decompiled with CFR 0.152.
 */
package rtr.console;

import java.util.ArrayList;
import org.newdawn.slick.Graphics;
import rtr.SettingsParser;
import rtr.console.ConsoleBanner;
import rtr.console.ConsoleEntry;

public class Console {
    private static ArrayList<ConsoleEntry> consoleDisplay = new ArrayList();
    private static ArrayList<ConsoleBanner> consoleBannerStorage = new ArrayList();
    private static int consoleMaxLength = 11;
    private static ConsoleBanner[] consoleSlots = new ConsoleBanner[4];

    public static void renderConsole(Graphics g, int x, int y, int length) {
        int i = length;
        while (i > 0) {
            if (consoleDisplay.size() > i) {
                consoleDisplay.get(consoleDisplay.size() - i).render(x + 6, y - i * 12 - 3);
            }
            --i;
        }
    }

    public static void renderBanner(Graphics g) {
        int offsetY = 0;
        int c = 0;
        while (c < consoleSlots.length) {
            ConsoleBanner b = consoleSlots[c];
            if (b != null) {
                b.render(offsetY, g);
            }
            offsetY += 70;
            ++c;
        }
    }

    public static void update() {
        ConsoleBanner b;
        int c;
        int i = 0;
        while (i < consoleDisplay.size()) {
            consoleDisplay.get(i).update();
            ++i;
        }
        if (consoleDisplay.size() > consoleMaxLength + 1) {
            consoleDisplay.remove(0);
        }
        if (consoleBannerStorage.size() > 0) {
            c = 0;
            while (c < consoleSlots.length) {
                if (consoleSlots[c] == null) {
                    Console.consoleSlots[c] = consoleBannerStorage.get(0);
                    consoleBannerStorage.remove(0);
                    if (consoleBannerStorage.size() == 0) break;
                }
                ++c;
            }
        }
        if (consoleBannerStorage.size() > 10) {
            c = 0;
            while (c < consoleSlots.length) {
                b = consoleSlots[c];
                if (b != null) {
                    b.update();
                    if (consoleBannerStorage.size() > 15) {
                        b.update();
                    }
                    if (consoleBannerStorage.size() > 20) {
                        b.update();
                    }
                    if (b.getDecayTick() > 20) {
                        Console.consoleSlots[c] = null;
                    }
                }
                ++c;
            }
        }
        c = 0;
        while (c < consoleSlots.length) {
            b = consoleSlots[c];
            if (b != null) {
                b.update();
                if (b.getDecayTick() > 20) {
                    Console.consoleSlots[c] = null;
                }
            }
            ++c;
        }
    }

    public static void out(int m, boolean v) {
        Console.out(Integer.toString(m), v);
    }

    public static void out(double m, boolean v) {
        Console.out(Double.toString(m), v);
    }

    public static void out(long m, boolean v) {
        Console.out(Long.toString(m), v);
    }

    public static void out(String text, boolean verbose) {
        StringBuilder sb = new StringBuilder(text);
        int t = sb.length() - 1;
        while (t >= 0) {
            if (sb.charAt(t) == '$') {
                sb.delete(t, t + 5);
            }
            --t;
        }
        System.out.println(sb.toString());
        if (verbose && !SettingsParser.getVerboseConsole()) {
            return;
        }
        for (ConsoleEntry e : consoleDisplay) {
            e.decreaseAlpha(20.0f);
        }
        consoleDisplay.add(new ConsoleEntry(text));
    }

    public static void newBanner(String header, String subtitle) {
        Console.out(String.valueOf(header) + " " + subtitle, true);
        int c = 0;
        while (c < consoleSlots.length) {
            if (consoleSlots[c] == null) {
                Console.consoleSlots[c] = new ConsoleBanner(header, subtitle);
                return;
            }
            ++c;
        }
        consoleBannerStorage.add(new ConsoleBanner(header, subtitle));
    }
}

