/*
 * Decompiled with CFR 0.152.
 */
package rtr;

import org.newdawn.slick.SlickException;
import rtr.ModuleBase;
import rtr.states.StateBase;

public class TurnControlModule
extends ModuleBase {
    private int turnCount;
    private TurnState currentTurnState = TurnState.IDLE;

    @Override
    public void initModule(StateBase cS) throws SlickException {
        super.initModule(cS);
        this.initLoad();
    }

    @Override
    public void resetModule() throws SlickException {
        super.resetModule();
        this.turnCount = 0;
    }

    @Override
    protected void loadPlay() throws SlickException {
    }

    @Override
    protected void newPlay() throws SlickException {
    }

    public void render() throws SlickException {
    }

    public void update() throws SlickException {
        switch (this.currentTurnState) {
            case IDLE: {
                break;
            }
            case PROCESS: {
                this.mob.updateTurnProcess();
                this.currentTurnState = TurnState.EXECUTE;
                break;
            }
            case EXECUTE: {
                boolean mobCompletedExecute = this.mob.updateTurnExecute();
                if (!mobCompletedExecute) break;
                this.currentTurnState = TurnState.CLEANUP;
            }
            case CLEANUP: {
                boolean mobCompletedCleanup = this.mob.updateTurnCleanup();
                if (mobCompletedCleanup) {
                    this.currentTurnState = TurnState.IDLE;
                }
                ++this.turnCount;
            }
        }
    }

    public void executeTurn() {
        this.currentTurnState = TurnState.PROCESS;
    }

    public TurnState getCurrentTurnState() {
        return this.currentTurnState;
    }

    public int getTurnCount() {
        return this.turnCount;
    }

    public static enum TurnState {
        PROCESS,
        EXECUTE,
        CLEANUP,
        IDLE;

    }
}

