/*
 * Decompiled with CFR 0.152.
 */
package rtr;

import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.Input;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.StateBasedGame;
import rtr.ImageLoader;
import rtr.ModuleBase;
import rtr.states.StateBase;
import rtr.system.Game;
import rtr.system.ScaleControl;
import rtr.system.ShutdownHook;

public class TransitionModule
extends ModuleBase {
    private static final int FADE_SPEED = 10;
    private GameContainer gc;
    private StateBasedGame sbg;
    private Color fade = new Color(0, 0, 0, 255);
    private boolean fadeIn = false;
    private boolean fadeOut = false;
    private boolean fadeOutComplete = false;
    private int fadeAmount = 0;
    private boolean controlLockout = false;
    private StateBase state;
    protected Image loadingLogo;
    protected Image loadingPillar;
    private Input input;

    public void initModule(StateBase cS, GameContainer gc, StateBasedGame sbg, Input i) throws SlickException {
        super.initModule(cS);
        this.loadingLogo = ImageLoader.getImage("res/logo.png");
        this.loadingPillar = ImageLoader.getImage("res/pillar.png");
        this.gc = gc;
        this.sbg = sbg;
        this.input = i;
    }

    @Override
    public void resetModule() throws SlickException {
        super.resetModule();
    }

    public void enter() {
        this.fadeAmount = 300;
        this.fadeIn = true;
    }

    public void startTransition(StateBase s) {
        this.fadeOut = true;
        this.state = s;
    }

    public void render(Graphics g) {
        Color imageFade;
        int displayWidth = ScaleControl.getWidth();
        int displayHeight = ScaleControl.getHeight();
        g.setColor(this.fade);
        g.fillRect(-16.0f, -16.0f, displayWidth + 32, displayHeight + 32);
        if (this.fadeOut) {
            this.controlLockout = true;
            this.fadeAmount += 10;
            this.fade = new Color(0, 0, 0, this.fadeAmount);
            imageFade = new Color(255, 255, 255, this.fadeAmount);
            if (this.state != null && this.state != Game.getSplashState()) {
                this.loadingLogo.drawCentered(ScaleControl.getWidth() / 2, ScaleControl.getHeight() / 2 - 110, imageFade);
                this.loadingPillar.draw(-96.0f, 0.0f, imageFade);
                this.loadingPillar.draw((float)(ScaleControl.getWidth() - this.loadingPillar.getWidth() + 96), 0.0f, imageFade);
            }
        }
        if (this.fadeOut && this.fadeAmount >= 300) {
            this.fadeOut = false;
            this.fadeOutComplete = true;
        }
        if (this.fadeIn) {
            this.controlLockout = true;
            this.fadeAmount -= 10;
            this.fade = new Color(0, 0, 0, this.fadeAmount);
            imageFade = new Color(255, 255, 255, this.fadeAmount);
            if (this.gameMode != Game.GameMode.SPLASH) {
                this.loadingLogo.drawCentered(ScaleControl.getWidth() / 2, ScaleControl.getHeight() / 2 - 110, imageFade);
                this.loadingPillar.draw(-96.0f, 0.0f, imageFade);
                this.loadingPillar.draw((float)(ScaleControl.getWidth() - this.loadingPillar.getWidth() + 96), 0.0f, imageFade);
            }
        }
        if (this.fadeIn && this.fadeAmount <= 0) {
            this.controlLockout = false;
            this.fadeIn = false;
            this.fadeAmount = 0;
        }
        if (this.fadeOutComplete) {
            this.fadeOutComplete = false;
            this.fadeAmount = 0;
            this.controlLockout = false;
            if (this.state == null) {
                ShutdownHook.setSafeShutdown(true);
                this.gc.exit();
            } else {
                this.input.clearControlPressedRecord();
                this.input.clearKeyPressedRecord();
                this.input.clearMousePressedRecord();
                Game.setCS(this.state);
                this.sbg.enterState(this.state.getID());
            }
        }
    }

    public boolean getControlLockout() {
        return this.controlLockout;
    }
}

