/*
 * Decompiled with CFR 0.152.
 */
package rtr;

import java.util.HashMap;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.SpriteSheet;
import rtr.ModuleBase;
import rtr.SettingsParser;
import rtr.states.StateBase;
import rtr.system.ScaleControl;
import rtr.utilities.Utilities;

public class ShadowModule
extends ModuleBase {
    private static final int shadowFBOTileWidth = 256;
    private static final int shadowFBOTileHeight = 256;
    private int mapHeight;
    private int mapWidth;
    private int mapFullHeight;
    private int mapFullWidth;
    private Color shadowColor = new Color(0.0f, 0.0f, 0.0f, 0.5f);
    private Image shadowFBOBottom;
    private Image shadowFBOTop;
    private HashMap<Integer, byte[][]> shadowMasks;
    private Image[][] bottomTiles;
    private Image[][] topTiles;
    private SpriteSheet bottomSheet;
    private SpriteSheet topSheet;

    @Override
    public void initModule(StateBase cS) throws SlickException {
        int y;
        int x;
        super.initModule(cS);
        this.mapHeight = this.map.getMapHeight();
        this.mapWidth = this.map.getMapWidth();
        this.mapFullHeight = this.map.getMapFullHeight();
        this.mapFullWidth = this.map.getMapFullWidth();
        if (this.shadowFBOBottom == null) {
            this.shadowFBOBottom = new Image(this.mapFullHeight, this.mapFullWidth);
            this.bottomSheet = new SpriteSheet(this.shadowFBOBottom, 256, 256);
            this.bottomTiles = new Image[this.bottomSheet.getHorizontalCount()][this.bottomSheet.getVerticalCount()];
            x = 0;
            while (x < this.bottomTiles.length) {
                y = 0;
                while (y < this.bottomTiles[x].length) {
                    this.bottomTiles[x][y] = this.bottomSheet.getSprite(x, y);
                    ++y;
                }
                ++x;
            }
        }
        if (this.shadowFBOTop == null) {
            this.shadowFBOTop = new Image(this.mapFullHeight, this.mapFullWidth);
            this.topSheet = new SpriteSheet(this.shadowFBOTop, 256, 256);
            this.topTiles = new Image[this.topSheet.getHorizontalCount()][this.topSheet.getVerticalCount()];
            x = 0;
            while (x < this.topTiles.length) {
                y = 0;
                while (y < this.topTiles[x].length) {
                    this.topTiles[x][y] = this.topSheet.getSprite(x, y);
                    ++y;
                }
                ++x;
            }
        }
        if (this.shadowMasks == null) {
            this.shadowMasks = this.map.getMapTileLoader().getShadowTiles();
        }
        this.buildShadowMap();
    }

    @Override
    public void resetModule() throws SlickException {
        super.resetModule();
        this.mapHeight = 0;
        this.mapWidth = 0;
        this.mapFullHeight = 0;
        this.mapFullWidth = 0;
        Graphics g = this.shadowFBOBottom.getGraphics();
        g.clearArea(0, 0, this.shadowFBOBottom.getWidth(), this.shadowFBOBottom.getHeight());
        g = this.shadowFBOTop.getGraphics();
        g.clearArea(0, 0, this.shadowFBOTop.getWidth(), this.shadowFBOTop.getHeight());
    }

    public void renderBottom() throws SlickException {
        if (!SettingsParser.getShadows()) {
            return;
        }
        int startX = this.getMapRenderSheetTopLeftX() - 1;
        int startY = this.getMapRenderSheetTopLeftY() - 1;
        int endX = this.getMapRenderSheetBottomRightX() + 1;
        int endY = this.getMapRenderSheetBottomRightY() + 1;
        this.shadowFBOBottom.startUse();
        int x = startX;
        while (x < endX) {
            int y = startY;
            while (y < endY) {
                if (x >= 0 && x <= this.bottomTiles.length - 1 && y >= 0 && y <= this.bottomTiles[x].length - 1) {
                    this.bottomTiles[x][y].drawEmbedded(this.map.getMapX() + (float)(x * 256), this.map.getMapY() + (float)(y * 256), this.map.getMapX() + (float)(x * 256) + 256.0f, this.map.getMapY() + (float)(y * 256) + 256.0f, 0.0f, 0.0f, 256.0f, 256.0f, this.shadowColor);
                }
                ++y;
            }
            ++x;
        }
        this.shadowFBOBottom.endUse();
    }

    public Image getBottom() throws SlickException {
        this.shadowFBOBottom.setAlpha(this.shadowColor.a);
        return this.shadowFBOBottom;
    }

    public void renderTop() throws SlickException {
        if (!SettingsParser.getShadows()) {
            return;
        }
        int startX = this.getMapRenderSheetTopLeftX() - 1;
        int startY = this.getMapRenderSheetTopLeftY() - 1;
        int endX = this.getMapRenderSheetBottomRightX() + 1;
        int endY = this.getMapRenderSheetBottomRightY() + 1;
        this.shadowFBOTop.startUse();
        int x = startX;
        while (x < endX) {
            int y = startY;
            while (y < endY) {
                if (x >= 0 && x <= this.topTiles.length - 1 && y >= 0 && y <= this.topTiles[x].length - 1) {
                    this.topTiles[x][y].drawEmbedded(this.map.getMapX() + (float)(x * 256), this.map.getMapY() + (float)(y * 256), this.map.getMapX() + (float)(x * 256) + 256.0f, this.map.getMapY() + (float)(y * 256) + 256.0f, 0.0f, 0.0f, 256.0f, 256.0f, this.shadowColor);
                }
                ++y;
            }
            ++x;
        }
        this.shadowFBOTop.endUse();
    }

    public Image getTop() throws SlickException {
        this.shadowFBOTop.setAlpha(this.shadowColor.a);
        return this.shadowFBOTop;
    }

    public void update() throws SlickException {
    }

    private void buildShadowMap() throws SlickException {
        int coordY;
        int coordX;
        int h;
        int w;
        byte[][] mask;
        int tileID;
        int y;
        Graphics g = null;
        g = this.shadowFBOTop.getGraphics();
        g.clearArea(0, 0, this.shadowFBOTop.getWidth(), this.shadowFBOTop.getHeight());
        g.setColor(Color.black);
        int x = 0;
        while (x < this.mapWidth) {
            y = 0;
            while (y < this.mapHeight) {
                tileID = this.map.getTileId(x, y, this.map.getLayerTopographyTop());
                if (this.map.getMapTileLoader().isTileShadow(tileID)) {
                    mask = this.shadowMasks.get(tileID);
                    w = 0;
                    while (w < this.map.getTileWidth()) {
                        h = 0;
                        while (h < this.map.getTileHeight()) {
                            if (mask[w][h] != 0) {
                                coordX = x * this.map.getTileWidth() + w;
                                coordY = y * this.map.getTileHeight() + h;
                                g.drawLine(coordX, coordY, coordX + mask[w][h], coordY + mask[w][h]);
                            }
                            ++h;
                        }
                        ++w;
                    }
                }
                ++y;
            }
            ++x;
        }
        g.flush();
        g = this.shadowFBOBottom.getGraphics();
        g.clearArea(0, 0, this.shadowFBOBottom.getWidth(), this.shadowFBOBottom.getHeight());
        g.setColor(Color.black);
        x = 0;
        while (x < this.mapWidth) {
            y = 0;
            while (y < this.mapHeight) {
                tileID = this.map.getTileId(x, y, this.map.getLayerTopographyBottom());
                if (this.map.getMapTileLoader().isTileShadow(tileID)) {
                    mask = this.shadowMasks.get(tileID);
                    w = 0;
                    while (w < this.map.getTileWidth()) {
                        h = 0;
                        while (h < this.map.getTileHeight()) {
                            if (mask[w][h] != 0) {
                                coordX = x * this.map.getTileWidth() + w;
                                coordY = y * this.map.getTileHeight() + h;
                                g.drawLine(coordX, coordY, coordX + mask[w][h], coordY + mask[w][h]);
                            }
                            ++h;
                        }
                        ++w;
                    }
                }
                ++y;
            }
            ++x;
        }
        g.flush();
    }

    public void refreshPartMap(int tileX, int tileY, int refreshArea) throws SlickException {
        int coordY;
        int coordX;
        int h;
        int w;
        byte[][] mask;
        int tileID;
        int y;
        refreshArea /= 2;
        int refreshStartX = tileX - (refreshArea += 3);
        int refreshStartY = tileY - refreshArea;
        int refreshEndX = tileX + refreshArea;
        int refreshEndY = tileY + refreshArea;
        Graphics g = this.shadowFBOBottom.getGraphics();
        g.clearArea(refreshStartX * this.map.getTileWidth(), refreshStartY * this.map.getTileHeight(), (1 + refreshArea * 2) * this.map.getTileWidth(), (1 + refreshArea * 2) * this.map.getTileHeight());
        int x = refreshStartX - 4;
        while (x <= refreshEndX + 4) {
            y = refreshStartY - 4;
            while (y <= refreshEndY + 4) {
                if (!Utilities.isOutOfBounds(this.map.getMapWidth(), this.map.getMapHeight(), x, y)) {
                    tileID = this.map.getTileId(x, y, this.map.getLayerTopographyBottom());
                    if (this.map.getMapTileLoader().isTileShadow(tileID)) {
                        mask = this.shadowMasks.get(tileID);
                        w = 0;
                        while (w < this.map.getTileWidth()) {
                            h = 0;
                            while (h < this.map.getTileHeight()) {
                                if (mask[w][h] != 0) {
                                    coordX = x * this.map.getTileWidth() + w;
                                    coordY = y * this.map.getTileHeight() + h;
                                    g.drawLine(coordX, coordY, coordX + mask[w][h], coordY + mask[w][h]);
                                }
                                ++h;
                            }
                            ++w;
                        }
                    }
                }
                ++y;
            }
            ++x;
        }
        g.flush();
        g = this.shadowFBOTop.getGraphics();
        g.clearArea(refreshStartX * this.map.getTileWidth(), refreshStartY * this.map.getTileHeight(), (1 + refreshArea * 2) * this.map.getTileWidth(), (1 + refreshArea * 2) * this.map.getTileHeight());
        x = refreshStartX - 4;
        while (x <= refreshEndX + 4) {
            y = refreshStartY - 4;
            while (y <= refreshEndY + 4) {
                if (!Utilities.isOutOfBounds(this.map.getMapWidth(), this.map.getMapHeight(), x, y)) {
                    tileID = this.map.getTileId(x, y, this.map.getLayerTopographyTop());
                    if (this.map.getMapTileLoader().isTileShadow(tileID)) {
                        mask = this.shadowMasks.get(tileID);
                        w = 0;
                        while (w < this.map.getTileWidth()) {
                            h = 0;
                            while (h < this.map.getTileHeight()) {
                                if (mask[w][h] != 0) {
                                    coordX = x * this.map.getTileWidth() + w;
                                    coordY = y * this.map.getTileHeight() + h;
                                    g.drawLine(coordX, coordY, coordX + mask[w][h], coordY + mask[w][h]);
                                }
                                ++h;
                            }
                            ++w;
                        }
                    }
                }
                ++y;
            }
            ++x;
        }
        g.flush();
    }

    public int getMapRenderSheetTopLeftX() {
        return (int)(this.map.getMapX() * -1.0f) / 256;
    }

    public int getMapRenderSheetTopLeftY() {
        return (int)(this.map.getMapY() * -1.0f) / 256;
    }

    public int getMapRenderSheetTopRightX() {
        return (int)(this.map.getMapX() * -1.0f + (float)ScaleControl.getWidth()) / 256;
    }

    public int getMapRenderSheetTopRightY() {
        return (int)(this.map.getMapY() * -1.0f) / 256;
    }

    public int getMapRenderSheetBottomLeftX() {
        return (int)(this.map.getMapX() * -1.0f) / 256;
    }

    public int getMapRenderSheetBottomLeftY() {
        return (int)(this.map.getMapY() * -1.0f + (float)ScaleControl.getHeight()) / 256;
    }

    public int getMapRenderSheetBottomRightX() {
        return (int)(this.map.getMapX() * -1.0f + (float)ScaleControl.getWidth()) / 256;
    }

    public int getMapRenderSheetBottomRightY() {
        return (int)(this.map.getMapY() * -1.0f + (float)ScaleControl.getHeight()) / 256;
    }
}

