/*
 * Decompiled with CFR 0.152.
 */
package rtr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.lwjgl.input.Keyboard;
import rtr.system.Game;

public class SettingsParser {
    private static int keyMapUp;
    private static int keyMapDown;
    private static int keyMapLeft;
    private static int keyMapRight;
    private static int keyZoomIn;
    private static int keyZoomOut;
    private static int keyMinimap;
    private static int keyCycleBrushType;
    private static int keyBrushSizeUp;
    private static int keyBrushSizeDown;
    private static int keyDebug;
    private static int keyScreenShot;
    private static int keyHideGUI;
    private static int keyGrid;
    private static int keyHideTopography;
    private static int keyFullScreen;
    private static int keyPopulationList;
    private static int keyMainMenu;
    private static int keyMapInformation;
    private static int keyDataViews;
    private static int keyProblemPanel;
    private static int keyBuildingList;
    private static int keyCancel;
    private static int keyAccentModeToggle;
    private static int keyEraseTool;
    private static int keyGrabTool;
    private static int keyPatchTool;
    private static int keyHoleTool;
    private static int keyPause;
    private static int keyGrabSpell;
    private static int keyPauseObjects;
    private static int keyDismantleObjects;
    private static int keyHarvestWood;
    private static int keyHarvestRock;
    private static int keyHarvestFoodAndWater;
    private static int keyHarvestCrystals;
    private static int keyNextTip;
    private static int keyDestroyTerrain;
    private static boolean fullScreen;
    private static boolean vSync;
    private static boolean smoothParticles;
    private static boolean tipsEnabled;
    private static boolean shadows;
    private static boolean clouds;
    private static boolean background;
    private static boolean debug;
    private static boolean allowOfficial;
    private static boolean verboseConsole;
    private static boolean mapScrollInverted;
    private static boolean edgeScrollingEnabled;
    private static boolean screenshakeEnabled;
    private static boolean hideDisclaimer;
    private static int edgeScrollSpeed;
    private static float forceInterfaceScale;
    private static ParticleAmount particleAmount;
    private static AutosaveFrequency autosaveFrequency;
    private static int musicVolume;
    private static int soundVolume;
    private static int lastProfile;
    private static String twitchChannel;
    private static Properties settingsProperties;
    private static Properties profileProperties;
    private static File profilesFolder;
    private static File baseSettings;
    private static File profileFolder;
    private static File profileSettings;
    private static InputStream in;
    private static FileOutputStream out;

    static {
        edgeScrollSpeed = 75;
        forceInterfaceScale = -1.0f;
        musicVolume = 5;
        soundVolume = 7;
        lastProfile = -1;
        twitchChannel = "";
        settingsProperties = new Properties();
        profileProperties = new Properties();
        profilesFolder = new File("profiles/");
        baseSettings = new File("profiles/settings.properties");
    }

    public static void loadBaseSettings() {
        smoothParticles = true;
        if (!profilesFolder.exists()) {
            profilesFolder.mkdir();
        }
        try {
            in = new FileInputStream(baseSettings);
            settingsProperties.load(in);
            SettingsParser.checkBaseSettings();
            in.close();
        }
        catch (IOException ioe) {
            SettingsParser.checkBaseSettings();
            System.out.println("Failed to load graphics properties file, resetting to default!");
        }
        SettingsParser.refreshBaseProperties();
    }

    public static void loadProfileSettings(int activeProfile) {
        Game.setActiveProfile(activeProfile);
        try {
            profileProperties.clear();
            profileFolder = new File("profiles/profile" + activeProfile + "/");
            if (!profileFolder.exists()) {
                profileFolder.mkdir();
            }
            profileSettings = new File("profiles/profile" + activeProfile + "/profileSettings.properties");
            in = new FileInputStream(profileSettings);
            profileProperties.load(in);
            SettingsParser.checkProfileSettings();
            in.close();
        }
        catch (IOException ioe) {
            SettingsParser.checkProfileSettings();
            System.out.println("Failed to load profile properties file, resetting to default!");
        }
        SettingsParser.refreshProfileProperties();
    }

    public static void createProfileSettings(int activeProfile, String twitchChannel, boolean tipsEnabled) {
        Game.setActiveProfile(activeProfile);
        try {
            profileProperties.clear();
            profileFolder = new File("profiles/profile" + activeProfile + "/");
            if (!profileFolder.exists()) {
                profileFolder.mkdir();
            }
            profileSettings = new File("profiles/profile" + activeProfile + "/profileSettings.properties");
            in = new FileInputStream(profileSettings);
            profileProperties.load(in);
            SettingsParser.checkProfileSettings(twitchChannel, tipsEnabled);
            in.close();
        }
        catch (IOException ioe) {
            SettingsParser.checkProfileSettings(twitchChannel, tipsEnabled);
            System.out.println("Failed to load profile properties file, resetting to default!");
        }
        SettingsParser.refreshProfileProperties();
    }

    public static void saveBaseSettings() {
        try {
            out = new FileOutputStream(baseSettings);
            settingsProperties.store(out, "settings");
            out.close();
        }
        catch (IOException ioe) {
            System.out.println("Failed to save graphics properties file!");
        }
    }

    public static void saveProfileSettings() {
        try {
            out = new FileOutputStream(profileSettings);
            profileProperties.store(out, "settings");
            out.close();
        }
        catch (IOException ioe) {
            System.out.println("Failed to save profile properties file!");
        }
    }

    public static void refreshBaseProperties() {
        fullScreen = Boolean.parseBoolean(settingsProperties.getProperty("fullScreen"));
        vSync = Boolean.parseBoolean(settingsProperties.getProperty("vSync"));
        debug = Boolean.parseBoolean(settingsProperties.getProperty("debug", "false"));
        allowOfficial = Boolean.parseBoolean(settingsProperties.getProperty("allowOfficial", "false"));
        verboseConsole = Boolean.parseBoolean(settingsProperties.getProperty("verboseConsole", "false"));
        musicVolume = Integer.parseInt(settingsProperties.getProperty("musicVolume"));
        soundVolume = Integer.parseInt(settingsProperties.getProperty("soundVolume"));
        lastProfile = Integer.parseInt(settingsProperties.getProperty("lastProfile"));
        forceInterfaceScale = Float.parseFloat(settingsProperties.getProperty("forceInterfaceScale"));
        int pAmount = Integer.parseInt(settingsProperties.getProperty("particleAmount"));
        if (pAmount == 0) {
            particleAmount = ParticleAmount.MINIMAL;
        } else if (pAmount == 1) {
            particleAmount = ParticleAmount.REDUCED;
        } else if (pAmount == 2) {
            particleAmount = ParticleAmount.FULL;
        }
        shadows = Boolean.parseBoolean(settingsProperties.getProperty("shadows"));
        int aFreq = Integer.parseInt(settingsProperties.getProperty("autosaveFrequency"));
        if (aFreq == 0) {
            autosaveFrequency = AutosaveFrequency.MINIMAL;
        } else if (aFreq == 1) {
            autosaveFrequency = AutosaveFrequency.REDUCED;
        } else if (aFreq == 2) {
            autosaveFrequency = AutosaveFrequency.FULL;
        }
        clouds = Boolean.parseBoolean(settingsProperties.getProperty("clouds"));
        background = Boolean.parseBoolean(settingsProperties.getProperty("background"));
        hideDisclaimer = Boolean.parseBoolean(settingsProperties.getProperty("hideDisclaimer"));
    }

    public static void refreshProfileProperties() {
        keyMapUp = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyMapUp").toUpperCase());
        keyMapDown = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyMapDown").toUpperCase());
        keyMapLeft = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyMapLeft").toUpperCase());
        keyMapRight = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyMapRight").toUpperCase());
        keyZoomIn = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyZoomIn").toUpperCase());
        keyZoomOut = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyZoomOut").toUpperCase());
        keyMinimap = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyMinimap").toUpperCase());
        keyCycleBrushType = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyCycleBrushType").toUpperCase());
        keyBrushSizeUp = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyBrushSizeUp").toUpperCase());
        keyBrushSizeDown = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyBrushSizeDown").toUpperCase());
        keyDebug = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyDebug").toUpperCase());
        keyScreenShot = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyScreenShot").toUpperCase());
        keyHideGUI = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyHideGUI").toUpperCase());
        keyGrid = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyGrid").toUpperCase());
        keyHideTopography = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyHideTopography").toUpperCase());
        keyFullScreen = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyFullScreen").toUpperCase());
        keyPopulationList = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyPopulationList").toUpperCase());
        keyMainMenu = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyMainMenu").toUpperCase());
        keyMapInformation = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyMapInformation").toUpperCase());
        keyDataViews = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyDataViews").toUpperCase());
        keyProblemPanel = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyProblemPanel").toUpperCase());
        keyBuildingList = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyBuildingList").toUpperCase());
        keyCancel = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyCancel").toUpperCase());
        keyAccentModeToggle = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyAccentModeToggle").toUpperCase());
        keyEraseTool = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyEraseTool").toUpperCase());
        keyGrabTool = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyGrabTool").toUpperCase());
        keyPatchTool = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyPatchTool").toUpperCase());
        keyHoleTool = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyHoleTool").toUpperCase());
        keyPause = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyPause").toUpperCase());
        keyGrabSpell = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyGrabSpell").toUpperCase());
        keyPauseObjects = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyPauseObjects").toUpperCase());
        keyDismantleObjects = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyDismantleObjects").toUpperCase());
        keyHarvestWood = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyHarvestWood").toUpperCase());
        keyHarvestRock = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyHarvestRock").toUpperCase());
        keyHarvestFoodAndWater = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyHarvestFoodAndWater").toUpperCase());
        keyHarvestCrystals = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyHarvestCrystals").toUpperCase());
        keyDestroyTerrain = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyDestroyTerrain").toUpperCase());
        smoothParticles = Boolean.parseBoolean(profileProperties.getProperty("smoothParticles"));
        tipsEnabled = Boolean.parseBoolean(profileProperties.getProperty("tipsEnabled"));
        screenshakeEnabled = Boolean.parseBoolean(profileProperties.getProperty("screenshakeEnabled"));
        mapScrollInverted = Boolean.parseBoolean(profileProperties.getProperty("mapScrollInverted", "false"));
        twitchChannel = profileProperties.getProperty("twitchChannel", "");
        edgeScrollingEnabled = Boolean.parseBoolean(profileProperties.getProperty("edgeScrollingEnabled", "false"));
        edgeScrollSpeed = Integer.parseInt(profileProperties.getProperty("edgeScrollSpeed", "80"));
        keyNextTip = Keyboard.getKeyIndex((String)profileProperties.getProperty("keyNextTip").toUpperCase());
    }

    private static void checkBaseSettings() {
        if (!settingsProperties.getProperty("version", "-1").equals(Game.getSettingsVersion())) {
            settingsProperties = new Properties();
            settingsProperties.setProperty("version", Game.getSettingsVersion());
        }
        if (!settingsProperties.containsKey("fullScreen")) {
            settingsProperties.setProperty("fullScreen", "false");
        }
        if (!settingsProperties.containsKey("vSync")) {
            settingsProperties.setProperty("vSync", "true");
        }
        if (!settingsProperties.containsKey("musicVolume")) {
            settingsProperties.setProperty("musicVolume", "5");
        }
        if (!settingsProperties.containsKey("soundVolume")) {
            settingsProperties.setProperty("soundVolume", "7");
        }
        if (!settingsProperties.containsKey("lastProfile")) {
            settingsProperties.setProperty("lastProfile", "-1");
        }
        if (!settingsProperties.containsKey("forceInterfaceScale")) {
            settingsProperties.setProperty("forceInterfaceScale", "-1");
        }
        if (!settingsProperties.containsKey("particleAmount")) {
            settingsProperties.setProperty("particleAmount", "2");
        }
        if (!settingsProperties.containsKey("shadows")) {
            settingsProperties.setProperty("shadows", "true");
        }
        if (!settingsProperties.containsKey("autosaveFrequency")) {
            settingsProperties.setProperty("autosaveFrequency", "2");
        }
        if (!settingsProperties.containsKey("clouds")) {
            settingsProperties.setProperty("clouds", "true");
        }
        if (!settingsProperties.containsKey("background")) {
            settingsProperties.setProperty("background", "true");
        }
        if (!settingsProperties.containsKey("mapScrollInverted")) {
            settingsProperties.setProperty("mapScrollInverted", "false");
        }
        if (!settingsProperties.containsKey("hideDisclaimer")) {
            settingsProperties.setProperty("hideDisclaimer", "false");
        }
        SettingsParser.saveBaseSettings();
    }

    private static void checkProfileSettings() {
        SettingsParser.checkProfileSettings("", true);
    }

    private static void checkProfileSettings(String twitchChannel, boolean tipsEnabled) {
        if (!profileProperties.getProperty("version", "-1").equals(Game.getSettingsVersion())) {
            profileProperties = new Properties();
            profileProperties.setProperty("version", Game.getSettingsVersion());
        }
        if (!profileProperties.containsKey("keyMapUp")) {
            profileProperties.setProperty("keyMapUp", "w");
        }
        if (!profileProperties.containsKey("keyMapDown")) {
            profileProperties.setProperty("keyMapDown", "s");
        }
        if (!profileProperties.containsKey("keyMapLeft")) {
            profileProperties.setProperty("keyMapLeft", "a");
        }
        if (!profileProperties.containsKey("keyMapRight")) {
            profileProperties.setProperty("keyMapRight", "d");
        }
        if (!profileProperties.containsKey("keyZoomIn")) {
            profileProperties.setProperty("keyZoomIn", "add");
        }
        if (!profileProperties.containsKey("keyZoomOut")) {
            profileProperties.setProperty("keyZoomOut", "subtract");
        }
        if (!profileProperties.containsKey("keyMinimap")) {
            profileProperties.setProperty("keyMinimap", "tab");
        }
        if (!profileProperties.containsKey("keyCycleBrushType")) {
            profileProperties.setProperty("keyCycleBrushType", "z");
        }
        if (!profileProperties.containsKey("keyBrushSizeUp")) {
            profileProperties.setProperty("keyBrushSizeUp", "period");
        }
        if (!profileProperties.containsKey("keyBrushSizeDown")) {
            profileProperties.setProperty("keyBrushSizeDown", "comma");
        }
        if (!profileProperties.containsKey("keyDebug")) {
            profileProperties.setProperty("keyDebug", "f3");
        }
        if (!profileProperties.containsKey("keyScreenShot")) {
            profileProperties.setProperty("keyScreenShot", "f2");
        }
        if (!profileProperties.containsKey("keyHideGUI")) {
            profileProperties.setProperty("keyHideGUI", "f4");
        }
        if (!profileProperties.containsKey("keyGrid")) {
            profileProperties.setProperty("keyGrid", "g");
        }
        if (!profileProperties.containsKey("keyHideTopography")) {
            profileProperties.setProperty("keyHideTopography", "t");
        }
        if (!profileProperties.containsKey("keyFullScreen")) {
            profileProperties.setProperty("keyFullScreen", "f10");
        }
        if (!profileProperties.containsKey("keyPopulationList")) {
            profileProperties.setProperty("keyPopulationList", "p");
        }
        if (!profileProperties.containsKey("keyMainMenu")) {
            profileProperties.setProperty("keyMainMenu", "m");
        }
        if (!profileProperties.containsKey("keyMapInformation")) {
            profileProperties.setProperty("keyMapInformation", "i");
        }
        if (!profileProperties.containsKey("keyDataViews")) {
            profileProperties.setProperty("keyDataViews", "v");
        }
        if (!profileProperties.containsKey("keyProblemPanel")) {
            profileProperties.setProperty("keyProblemPanel", "r");
        }
        if (!profileProperties.containsKey("keyBuildingList")) {
            profileProperties.setProperty("keyBuildingList", "l");
        }
        if (!profileProperties.containsKey("keyCancel")) {
            profileProperties.setProperty("keyCancel", "escape");
        }
        if (!profileProperties.containsKey("keyAccentModeToggle")) {
            profileProperties.setProperty("keyAccentModeToggle", "lshift");
        }
        if (!profileProperties.containsKey("keyEraseTool")) {
            profileProperties.setProperty("keyEraseTool", "e");
        }
        if (!profileProperties.containsKey("keyGrabTool")) {
            profileProperties.setProperty("keyGrabTool", "q");
        }
        if (!profileProperties.containsKey("keyPatchTool")) {
            profileProperties.setProperty("keyPatchTool", "p");
        }
        if (!profileProperties.containsKey("keyHoleTool")) {
            profileProperties.setProperty("keyHoleTool", "h");
        }
        if (!profileProperties.containsKey("keyPause")) {
            profileProperties.setProperty("keyPause", "space");
        }
        if (!profileProperties.containsKey("keyGrabSpell")) {
            profileProperties.setProperty("keyGrabSpell", "0");
        }
        if (!profileProperties.containsKey("keyPauseObjects")) {
            profileProperties.setProperty("keyPauseObjects", "o");
        }
        if (!profileProperties.containsKey("keyDismantleObjects")) {
            profileProperties.setProperty("keyDismantleObjects", "i");
        }
        if (!profileProperties.containsKey("keyHarvestWood")) {
            profileProperties.setProperty("keyHarvestWood", "1");
        }
        if (!profileProperties.containsKey("keyHarvestRock")) {
            profileProperties.setProperty("keyHarvestRock", "2");
        }
        if (!profileProperties.containsKey("keyHarvestFoodAndWater")) {
            profileProperties.setProperty("keyHarvestFoodAndWater", "3");
        }
        if (!profileProperties.containsKey("keyHarvestCrystals")) {
            profileProperties.setProperty("keyHarvestCrystals", "4");
        }
        if (!profileProperties.containsKey("keyDestroyTerrain")) {
            profileProperties.setProperty("keyDestroyTerrain", "5");
        }
        if (!profileProperties.containsKey("keyNextTip")) {
            profileProperties.setProperty("keyNextTip", "return");
        }
        if (!profileProperties.containsKey("smoothParticles")) {
            profileProperties.setProperty("smoothParticles", "true");
        }
        if (!profileProperties.containsKey("tipsEnabled")) {
            if (tipsEnabled) {
                profileProperties.setProperty("tipsEnabled", "true");
            } else {
                profileProperties.setProperty("tipsEnabled", "false");
            }
        }
        if (!profileProperties.containsKey("screenshakeEnabled")) {
            profileProperties.setProperty("screenshakeEnabled", "true");
        }
        if (!profileProperties.containsKey("mapScrollInverted")) {
            profileProperties.setProperty("mapScrollInverted", "false");
        }
        if (!profileProperties.containsKey("edgeScrollingEnabled")) {
            profileProperties.setProperty("edgeScrollingEnabled", "false");
        }
        if (!profileProperties.containsKey("edgeScrollSpeed")) {
            profileProperties.setProperty("edgeScrollSpeed", "75");
        }
        if (!profileProperties.containsKey("lastGameMode")) {
            profileProperties.setProperty("lastGameMode", "null");
        }
        if (!profileProperties.containsKey("twitchChannel")) {
            profileProperties.setProperty("twitchChannel", twitchChannel);
        }
        SettingsParser.saveProfileSettings();
    }

    public static void setFullScreen(boolean state) {
        settingsProperties.setProperty("fullScreen", Boolean.toString(state));
        fullScreen = Boolean.parseBoolean(settingsProperties.getProperty("fullScreen"));
        SettingsParser.saveBaseSettings();
    }

    public static void setLastProfile(int i) {
        settingsProperties.setProperty("lastProfile", Integer.toString(i));
        lastProfile = i;
        SettingsParser.saveBaseSettings();
    }

    public static void setTwitchChannel(String tC) {
        profileProperties.setProperty("twitchChannel", tC);
        twitchChannel = tC;
        SettingsParser.saveProfileSettings();
    }

    public static void setHideDisclaimer(boolean b) {
        settingsProperties.setProperty("hideDisclaimer", Boolean.toString(b));
        hideDisclaimer = b;
        SettingsParser.saveBaseSettings();
    }

    public static int getKeyUp() {
        return keyMapUp;
    }

    public static String getKeyUpName() {
        return profileProperties.getProperty("keyMapUp");
    }

    public static int getKeyDown() {
        return keyMapDown;
    }

    public static String getKeyDownName() {
        return profileProperties.getProperty("keyMapDown");
    }

    public static int getKeyLeft() {
        return keyMapLeft;
    }

    public static String getKeyLeftName() {
        return profileProperties.getProperty("keyMapLeft");
    }

    public static int getKeyRight() {
        return keyMapRight;
    }

    public static String getKeyRightName() {
        return profileProperties.getProperty("keyMapRight");
    }

    public static int getKeyZoomIn() {
        return keyZoomIn;
    }

    public static String getKeyZoomInName() {
        return profileProperties.getProperty("keyZoomIn");
    }

    public static int getKeyZoomOut() {
        return keyZoomOut;
    }

    public static String getKeyZoomOutName() {
        return profileProperties.getProperty("keyZoomOut");
    }

    public static int getKeyMinimap() {
        return keyMinimap;
    }

    public static String getKeyMinimapName() {
        return profileProperties.getProperty("keyMinimap");
    }

    public static int getKeyCycleBrushType() {
        return keyCycleBrushType;
    }

    public static String getKeyCycleBrushTypeName() {
        return profileProperties.getProperty("keyCycleBrushType");
    }

    public static int getKeyBrushSizeUp() {
        return keyBrushSizeUp;
    }

    public static String getBrushSizeUpName() {
        return profileProperties.getProperty("keyBrushSizeUp");
    }

    public static int getKeyBrushSizeDown() {
        return keyBrushSizeDown;
    }

    public static String getBrushSizeDownName() {
        return profileProperties.getProperty("keyBrushSizeDown");
    }

    public static int getKeyDebug() {
        return keyDebug;
    }

    public static String getKeyDebugName() {
        return profileProperties.getProperty("keyDebug");
    }

    public static int getKeyScreenShot() {
        return keyScreenShot;
    }

    public static String getKeyScreenShotName() {
        return profileProperties.getProperty("keyScreenShot");
    }

    public static int getKeyHideGUI() {
        return keyHideGUI;
    }

    public static String getKeyHudeGUIName() {
        return profileProperties.getProperty("keyHideGUI");
    }

    public static int getKeyGrid() {
        return keyGrid;
    }

    public static String getKeyGridName() {
        return profileProperties.getProperty("keyGrid");
    }

    public static int getKeyHideTopography() {
        return keyHideTopography;
    }

    public static String getKeyHideTopographyName() {
        return profileProperties.getProperty("keyHideTopography");
    }

    public static int getKeyFullScreen() {
        return keyFullScreen;
    }

    public static String getKeyFullScreenName() {
        return profileProperties.getProperty("keyFullScreen");
    }

    public static int getKeyPopulationList() {
        return keyPopulationList;
    }

    public static String getKeyPopulationName() {
        return profileProperties.getProperty("keyPopulationList");
    }

    public static int getKeyMainMenu() {
        return keyMainMenu;
    }

    public static String getKeyMainMenuName() {
        return profileProperties.getProperty("keyMainMenu");
    }

    public static int getKeyMapInformation() {
        return keyMapInformation;
    }

    public static String getKeyMapInformationName() {
        return profileProperties.getProperty("keyMapInformation");
    }

    public static int getKeyDataViews() {
        return keyDataViews;
    }

    public static String getKeyDataViewsName() {
        return profileProperties.getProperty("keyDataViews");
    }

    public static int getKeyProblemPanel() {
        return keyProblemPanel;
    }

    public static String getKeyProblemPanelName() {
        return profileProperties.getProperty("keyProblemPanel");
    }

    public static int getKeyBuildingList() {
        return keyBuildingList;
    }

    public static String getKeyBuildingListName() {
        return profileProperties.getProperty("keyBuildingList");
    }

    public static int getKeyCancel() {
        return keyCancel;
    }

    public static String getKeyCancelName() {
        return profileProperties.getProperty("keyCancel");
    }

    public static int getKeyAccentModeToggle() {
        return keyAccentModeToggle;
    }

    public static String getKeyAccentModeToggleName() {
        return profileProperties.getProperty("keyAccentModeToggle");
    }

    public static int getKeyEraseTool() {
        return keyEraseTool;
    }

    public static String getKeyEraseToolName() {
        return profileProperties.getProperty("keyEraseTool");
    }

    public static int getKeyGrabTool() {
        return keyGrabTool;
    }

    public static String getKeyGrabToolName() {
        return profileProperties.getProperty("keyGrabTool");
    }

    public static int getKeyPatchTool() {
        return keyPatchTool;
    }

    public static String getKeyPatchToolName() {
        return profileProperties.getProperty("keyPatchTool");
    }

    public static int getKeyHoleTool() {
        return keyHoleTool;
    }

    public static String getKeyHoleToolName() {
        return profileProperties.getProperty("keyHoleTool");
    }

    public static int getKeyPause() {
        return keyPause;
    }

    public static String getKeyPauseName() {
        return profileProperties.getProperty("keyPause");
    }

    public static int getKeyGrabSpell() {
        return keyGrabSpell;
    }

    public static String getKeyGrabSpellName() {
        return profileProperties.getProperty("keyGrabSpell");
    }

    public static int getKeyPauseObjects() {
        return keyPauseObjects;
    }

    public static String getKeyPauseObjectsName() {
        return profileProperties.getProperty("keyPauseObjects");
    }

    public static int getKeyDismantleObjects() {
        return keyDismantleObjects;
    }

    public static String getKeyDismantleObjectsName() {
        return profileProperties.getProperty("keyDismantleObjects");
    }

    public static int getKeyNextTip() {
        return keyNextTip;
    }

    public static String getKeyNextTipName() {
        return profileProperties.getProperty("keyNextTip");
    }

    public static int getKeyHarvestWood() {
        return keyHarvestWood;
    }

    public static String getKeyHarvestWoodName() {
        return profileProperties.getProperty("keyHarvestWood");
    }

    public static int getKeyHarvestRock() {
        return keyHarvestRock;
    }

    public static String getKeyHarvestRockName() {
        return profileProperties.getProperty("keyHarvestRock");
    }

    public static int getKeyHarvestFoodAndWater() {
        return keyHarvestFoodAndWater;
    }

    public static String getKeyHarvestFoodAndWaterName() {
        return profileProperties.getProperty("keyHarvestFoodAndWater");
    }

    public static int getKeyHarvestCrystals() {
        return keyHarvestCrystals;
    }

    public static String getKeyHarvestCrystalsName() {
        return profileProperties.getProperty("keyHarvestCrystals");
    }

    public static int getKeyDestroyTerrain() {
        return keyDestroyTerrain;
    }

    public static String getKeyDestroyTerrainName() {
        return profileProperties.getProperty("keyDestroyTerrain");
    }

    public static int getMusicVolume() {
        return musicVolume;
    }

    public static int getSoundVolume() {
        return soundVolume;
    }

    public static int getLastProfile() {
        return lastProfile;
    }

    public static boolean getFullScreen() {
        return fullScreen;
    }

    public static boolean getVSync() {
        return vSync;
    }

    public static boolean getSmoothParticles() {
        return smoothParticles;
    }

    public static boolean getTipsEnabled() {
        return tipsEnabled;
    }

    public static boolean getScreenshakeEnabled() {
        return screenshakeEnabled;
    }

    public static boolean getMapScrollInverted() {
        return mapScrollInverted;
    }

    public static boolean getEdgeScrollingEnabled() {
        return edgeScrollingEnabled;
    }

    public static int getEdgeScrollSpeed() {
        return edgeScrollSpeed;
    }

    public static String getTwitchChannel() {
        return twitchChannel;
    }

    public static boolean getDebug() {
        return debug;
    }

    public static boolean getAllowOfficial() {
        return allowOfficial;
    }

    public static ParticleAmount getParticleAmount() {
        return particleAmount;
    }

    public static boolean getShadows() {
        return shadows;
    }

    public static AutosaveFrequency getSaveFrequency() {
        return autosaveFrequency;
    }

    public static boolean getClouds() {
        return clouds;
    }

    public static boolean getBackground() {
        return background;
    }

    public static boolean getVerboseConsole() {
        return verboseConsole;
    }

    public static boolean getHideDisclaimer() {
        return hideDisclaimer;
    }

    public static float getForceInterfaceScale() {
        return forceInterfaceScale;
    }

    public static enum AutosaveFrequency {
        MINIMAL,
        REDUCED,
        FULL;

    }

    public static enum ParticleAmount {
        MINIMAL,
        REDUCED,
        FULL;

    }
}

