/*
 * Decompiled with CFR 0.152.
 */
package rtr;

import org.newdawn.slick.SlickException;
import rtr.ShadowModule;
import rtr.TransitionModule;
import rtr.TurnControlModule;
import rtr.font.FontModule;
import rtr.item.ItemModule;
import rtr.lighting.LightingModule;
import rtr.map.CollisionModule;
import rtr.map.MapModule;
import rtr.map.MiniMapModule;
import rtr.mobs.MobModule;
import rtr.object.ObjectModule;
import rtr.particles.ParticleModule;
import rtr.particles.projectiles.ProjectileModule;
import rtr.states.StateBase;
import rtr.system.Game;

public class ModuleBase {
    protected boolean initialized;
    protected boolean synced;
    protected StateBase currentState;
    protected Game.GameMode gameMode;
    protected FontModule font;
    protected MapModule map;
    protected MiniMapModule miniMap;
    protected ShadowModule shadow;
    protected MobModule mob;
    protected ItemModule item;
    protected ObjectModule object;
    protected LightingModule lighting;
    protected CollisionModule collision;
    protected ParticleModule particle;
    protected ProjectileModule projectile;
    protected TurnControlModule turnControl;
    protected TransitionModule transition;
    protected boolean debug = false;

    public void initModule(StateBase cS) throws SlickException {
        this.initialized = true;
        if (cS != null) {
            this.currentState = cS;
            this.gameMode = cS.getGameMode();
        }
        this.font = StateBase.getFontModule();
        this.map = StateBase.getMapModule();
        this.miniMap = StateBase.getMiniMapModule();
        this.shadow = StateBase.getShadowModule();
        this.mob = StateBase.getMobModule();
        this.item = StateBase.getItemModule();
        this.object = StateBase.getObjectModule();
        this.lighting = StateBase.getLightingModule();
        this.collision = StateBase.getCollisionModule();
        this.particle = StateBase.getParticleModule();
        this.projectile = StateBase.getProjectileModule();
        this.turnControl = StateBase.getTurnControlModule();
        this.transition = StateBase.getTransitionModule();
    }

    public void resetModule() throws SlickException {
        this.initialized = false;
        this.synced = false;
    }

    protected void initLoad() throws SlickException {
        if (this.gameMode == Game.GameMode.PLAY) {
            this.loadPlay();
        } else if (this.gameMode == Game.GameMode.MAIN_MENU) {
            this.loadMainMenu();
        }
    }

    protected void loadPlay() throws SlickException {
        this.newPlay();
    }

    protected void newPlay() throws SlickException {
    }

    protected void loadMainMenu() throws SlickException {
        this.newMainMenu();
    }

    protected void newMainMenu() throws SlickException {
        this.newPlay();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isSynced() {
        return this.synced;
    }
}

