/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.input.Cursor;
import org.lwjgl.input.Mouse;
import org.lwjgl.openal.AL;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.Drawable;
import org.lwjgl.opengl.PixelFormat;
import org.newdawn.slick.Game;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.openal.SoundStore;
import org.newdawn.slick.opengl.CursorLoader;
import org.newdawn.slick.opengl.ImageData;
import org.newdawn.slick.opengl.ImageIOImageData;
import org.newdawn.slick.opengl.InternalTextureLoader;
import org.newdawn.slick.opengl.TGAImageData;
import org.newdawn.slick.util.Log;
import org.newdawn.slick.util.ResourceLoader;

public class AppGameContainer
extends GameContainer {
    protected DisplayMode originalDisplayMode = Display.getDesktopDisplayMode();
    protected DisplayMode targetDisplayMode;
    protected boolean updateOnlyOnVisible = true;
    protected boolean alphaSupport = false;

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Display.getDisplayMode();
                }
                catch (Exception e) {
                    Log.error((Throwable)e);
                }
                return null;
            }
        });
    }

    public AppGameContainer(Game game) throws SlickException {
        this(game, 640, 480);
    }

    public AppGameContainer(Game game, boolean fullscreen) throws SlickException {
        super(game);
        this.setDisplayMode(this.originalDisplayMode.getWidth(), this.originalDisplayMode.getHeight(), fullscreen, true);
    }

    public AppGameContainer(Game game, int width, int height) throws SlickException {
        super(game);
        this.setDisplayMode(width, height, false, true);
    }

    public boolean supportsAlphaInBackBuffer() {
        return this.alphaSupport;
    }

    public void setTitle(String title) {
        Display.setTitle((String)title);
    }

    public void setDisplayMode(int width, int height, boolean fullscreen) throws SlickException {
        this.setDisplayMode(width, height, fullscreen, false);
    }

    public void setDisplayMode(int width, int height, boolean fullscreen, boolean reinit) throws SlickException {
        if (this.width == width && this.height == height && this.isFullscreen() == fullscreen) {
            return;
        }
        this.targetDisplayMode = fullscreen ? Display.getDesktopDisplayMode() : new DisplayMode(width, height);
        this.width = width;
        this.height = height;
        if (reinit) {
            try {
                Display.setDisplayMode((DisplayMode)this.targetDisplayMode);
                Display.setFullscreen((boolean)fullscreen);
            }
            catch (LWJGLException e) {
                e.printStackTrace();
            }
        }
        if (Display.isCreated()) {
            this.initGL();
            this.enterOrtho();
        }
        Display.setResizable((boolean)false);
        Display.setResizable((boolean)true);
        if (this.targetDisplayMode.getBitsPerPixel() == 16) {
            InternalTextureLoader.get().set16BitMode();
        }
        this.getDelta();
    }

    public boolean isFullscreen() {
        return Display.isFullscreen();
    }

    public void setFullscreen(boolean fullscreen) throws SlickException {
        if (this.isFullscreen() == fullscreen) {
            return;
        }
        if (!fullscreen) {
            try {
                Display.setFullscreen((boolean)fullscreen);
            }
            catch (LWJGLException e) {
                throw new SlickException("Unable to set fullscreen=" + fullscreen, (Throwable)e);
            }
        } else {
            this.setDisplayMode(this.width, this.height, fullscreen);
        }
        this.getDelta();
    }

    public void setMouseCursor(String ref, int hotSpotX, int hotSpotY) throws SlickException {
        try {
            Cursor cursor = CursorLoader.get().getCursor(ref, hotSpotX, hotSpotY);
            Mouse.setNativeCursor((Cursor)cursor);
        }
        catch (Throwable e) {
            Log.error((String)"Failed to load and apply cursor.", (Throwable)e);
            throw new SlickException("Failed to set mouse cursor", e);
        }
    }

    public void setMouseCursor(ImageData data, int hotSpotX, int hotSpotY) throws SlickException {
        try {
            Cursor cursor = CursorLoader.get().getCursor(data, hotSpotX, hotSpotY);
            Mouse.setNativeCursor((Cursor)cursor);
        }
        catch (Throwable e) {
            Log.error((String)"Failed to load and apply cursor.", (Throwable)e);
            throw new SlickException("Failed to set mouse cursor", e);
        }
    }

    public void setMouseCursor(Cursor cursor, int hotSpotX, int hotSpotY) throws SlickException {
        try {
            Mouse.setNativeCursor((Cursor)cursor);
        }
        catch (Throwable e) {
            Log.error((String)"Failed to load and apply cursor.", (Throwable)e);
            throw new SlickException("Failed to set mouse cursor", e);
        }
    }

    private int get2Fold(int fold) {
        int ret = 2;
        while (ret < fold) {
            ret *= 2;
        }
        return ret;
    }

    public void setMouseCursor(Image image, int hotSpotX, int hotSpotY) throws SlickException {
        try {
            Image temp = new Image(this.get2Fold(image.getWidth()), this.get2Fold(image.getHeight()));
            Graphics g = temp.getGraphics();
            ByteBuffer buffer = BufferUtils.createByteBuffer((int)(temp.getWidth() * temp.getHeight() * 4));
            g.drawImage(image.getFlippedCopy(false, true), 0.0f, 0.0f);
            g.flush();
            g.getArea(0, 0, temp.getWidth(), temp.getHeight(), buffer);
            Cursor cursor = CursorLoader.get().getCursor(buffer, hotSpotX, hotSpotY, temp.getWidth(), image.getHeight());
            Mouse.setNativeCursor((Cursor)cursor);
        }
        catch (Throwable e) {
            Log.error((String)"Failed to load and apply cursor.", (Throwable)e);
            throw new SlickException("Failed to set mouse cursor", e);
        }
    }

    public void reinit() throws SlickException {
        InternalTextureLoader.get().clear();
        SoundStore.get().clear();
        this.initSystem();
        this.enterOrtho();
        try {
            this.game.init((GameContainer)this);
        }
        catch (SlickException e) {
            Log.error((Throwable)e);
            this.running = false;
        }
    }

    private void tryCreateDisplay(PixelFormat format) throws LWJGLException {
        if (SHARED_DRAWABLE == null) {
            Display.create((PixelFormat)format);
        } else {
            Display.create((PixelFormat)format, (Drawable)SHARED_DRAWABLE);
        }
    }

    public void start() throws SlickException {
        try {
            this.setup();
            this.getDelta();
            while (this.running()) {
                this.gameLoop();
            }
        }
        finally {
            this.destroy();
        }
        if (this.forceExit) {
            System.exit(0);
        }
    }

    protected void setup() throws SlickException {
        if (this.targetDisplayMode == null) {
            this.setDisplayMode(640, 480, false);
        }
        Display.setTitle((String)this.game.getTitle());
        Log.info((String)("LWJGL Version: " + Sys.getVersion()));
        Log.info((String)("OriginalDisplayMode: " + this.originalDisplayMode));
        Log.info((String)("TargetDisplayMode: " + this.targetDisplayMode));
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    PixelFormat format = new PixelFormat(8, 8, stencil ? 8 : 0, AppGameContainer.this.samples);
                    AppGameContainer.this.tryCreateDisplay(format);
                    AppGameContainer.this.supportsMultiSample = true;
                }
                catch (Exception e) {
                    Display.destroy();
                    try {
                        PixelFormat format = new PixelFormat(8, 8, stencil ? 8 : 0);
                        AppGameContainer.this.tryCreateDisplay(format);
                        AppGameContainer.this.alphaSupport = false;
                    }
                    catch (Exception e2) {
                        Display.destroy();
                        try {
                            AppGameContainer.this.tryCreateDisplay(new PixelFormat());
                        }
                        catch (Exception e3) {
                            Log.error((Throwable)e3);
                        }
                    }
                }
                return null;
            }
        });
        if (!Display.isCreated()) {
            throw new SlickException("Failed to initialise the LWJGL display");
        }
        this.initSystem();
        this.enterOrtho();
        try {
            this.getInput().initControllers();
        }
        catch (SlickException e) {
            Log.info((String)"Controllers not available");
        }
        catch (Throwable e) {
            Log.info((String)"Controllers not available");
        }
        try {
            this.game.init((GameContainer)this);
        }
        catch (SlickException e) {
            Log.error((Throwable)e);
            this.running = false;
        }
    }

    protected void gameLoop() throws SlickException {
        int delta = this.getDelta();
        if (!Display.isVisible() && this.updateOnlyOnVisible) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        } else {
            try {
                this.updateAndRender(delta);
            }
            catch (SlickException e) {
                Log.error((Throwable)e);
                this.running = false;
                return;
            }
        }
        this.updateFPS();
        Display.update();
        if (Display.isCloseRequested() && this.game.closeRequested()) {
            this.running = false;
        }
    }

    public void setUpdateOnlyWhenVisible(boolean updateOnlyWhenVisible) {
        this.updateOnlyOnVisible = updateOnlyWhenVisible;
    }

    public boolean isUpdatingOnlyWhenVisible() {
        return this.updateOnlyOnVisible;
    }

    public void setIcon(String ref) throws SlickException {
        this.setIcons(new String[]{ref});
    }

    public void setMouseGrabbed(boolean grabbed) {
        Mouse.setGrabbed((boolean)grabbed);
    }

    public boolean isMouseGrabbed() {
        return Mouse.isGrabbed();
    }

    public boolean hasFocus() {
        return Display.isActive();
    }

    public int getScreenHeight() {
        return this.originalDisplayMode.getHeight();
    }

    public int getScreenWidth() {
        return this.originalDisplayMode.getWidth();
    }

    public void destroy() {
        Display.destroy();
        AL.destroy();
    }

    public void setIcons(String[] refs) throws SlickException {
        ByteBuffer[] bufs = new ByteBuffer[refs.length];
        int i = 0;
        while (i < refs.length) {
            TGAImageData data;
            boolean flip = true;
            if (refs[i].endsWith(".tga")) {
                data = new TGAImageData();
            } else {
                flip = false;
                data = new ImageIOImageData();
            }
            try {
                bufs[i] = data.loadImage(ResourceLoader.getResourceAsStream((String)refs[i]), flip, false, null);
            }
            catch (Exception e) {
                Log.error((Throwable)e);
                throw new SlickException("Failed to set the icon");
            }
            ++i;
        }
        Display.setIcon((ByteBuffer[])bufs);
    }

    public void setDefaultMouseCursor() {
        try {
            Mouse.setNativeCursor(null);
        }
        catch (LWJGLException e) {
            Log.error((String)"Failed to reset mouse cursor", (Throwable)e);
        }
    }

    private class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
        }
    }
}

