/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.CallSite;
import java.lang.invoke.DirectMethodHandle;
import java.lang.invoke.ForceInline;
import java.lang.invoke.InvokerBytecodeGenerator;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.Stable;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Array;
import java.util.Arrays;

class Invokers {
    private final MethodType targetType;
    @Stable
    private final MethodHandle[] invokers = new MethodHandle[3];
    static final int INV_EXACT = 0;
    static final int INV_GENERIC = 1;
    static final int INV_BASIC = 2;
    static final int INV_LIMIT = 3;
    private static final int MH_LINKER_ARG_APPENDED = 1;
    private static final LambdaForm.NamedFunction NF_checkExactType;
    private static final LambdaForm.NamedFunction NF_checkGenericType;
    private static final LambdaForm.NamedFunction NF_getCallSiteTarget;

    Invokers(MethodType methodType) {
        this.targetType = methodType;
    }

    MethodHandle exactInvoker() {
        MethodHandle methodHandle = this.cachedInvoker(0);
        if (methodHandle != null) {
            return methodHandle;
        }
        methodHandle = this.makeExactOrGeneralInvoker(true);
        return this.setCachedInvoker(0, methodHandle);
    }

    MethodHandle genericInvoker() {
        MethodHandle methodHandle = this.cachedInvoker(1);
        if (methodHandle != null) {
            return methodHandle;
        }
        methodHandle = this.makeExactOrGeneralInvoker(false);
        return this.setCachedInvoker(1, methodHandle);
    }

    MethodHandle basicInvoker() {
        MethodHandle methodHandle = this.cachedInvoker(2);
        if (methodHandle != null) {
            return methodHandle;
        }
        MethodType methodType = this.targetType.basicType();
        if (methodType != this.targetType) {
            return this.setCachedInvoker(2, methodType.invokers().basicInvoker());
        }
        methodHandle = methodType.form().cachedMethodHandle(0);
        if (methodHandle == null) {
            MemberName memberName = Invokers.invokeBasicMethod(methodType);
            methodHandle = DirectMethodHandle.make(memberName);
            assert (this.checkInvoker(methodHandle));
            methodHandle = methodType.form().setCachedMethodHandle(0, methodHandle);
        }
        return this.setCachedInvoker(2, methodHandle);
    }

    private MethodHandle cachedInvoker(int n) {
        return this.invokers[n];
    }

    private synchronized MethodHandle setCachedInvoker(int n, MethodHandle methodHandle) {
        MethodHandle methodHandle2 = this.invokers[n];
        if (methodHandle2 != null) {
            return methodHandle2;
        }
        this.invokers[n] = methodHandle;
        return this.invokers[n];
    }

    private MethodHandle makeExactOrGeneralInvoker(boolean bl) {
        MethodType methodType = this.targetType;
        MethodType methodType2 = methodType.invokerType();
        int n = bl ? 11 : 13;
        LambdaForm lambdaForm = Invokers.invokeHandleForm(methodType, false, n);
        MethodHandle methodHandle = BoundMethodHandle.bindSingle(methodType2, lambdaForm, methodType);
        String string = bl ? "invokeExact" : "invoke";
        methodHandle = methodHandle.withInternalMemberName(MemberName.makeMethodHandleInvoke(string, methodType), false);
        assert (this.checkInvoker(methodHandle));
        this.maybeCompileToBytecode(methodHandle);
        return methodHandle;
    }

    private void maybeCompileToBytecode(MethodHandle methodHandle) {
        if (this.targetType == this.targetType.erase() && this.targetType.parameterCount() < 10) {
            methodHandle.form.compileToBytecode();
        }
    }

    static MemberName invokeBasicMethod(MethodType methodType) {
        assert (methodType == methodType.basicType());
        try {
            return MethodHandles.Lookup.IMPL_LOOKUP.resolveOrFail((byte)5, MethodHandle.class, "invokeBasic", methodType);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw MethodHandleStatics.newInternalError("JVM cannot find invoker for " + methodType, reflectiveOperationException);
        }
    }

    private boolean checkInvoker(MethodHandle methodHandle) {
        assert (this.targetType.invokerType().equals((Object)methodHandle.type())) : Arrays.asList(this.targetType, this.targetType.invokerType(), methodHandle);
        assert (methodHandle.internalMemberName() == null || methodHandle.internalMemberName().getMethodType().equals((Object)this.targetType));
        assert (!methodHandle.isVarargsCollector());
        return true;
    }

    MethodHandle spreadInvoker(int n) {
        int n2 = this.targetType.parameterCount() - n;
        MethodType methodType = this.targetType;
        Class<?> clazz = Invokers.impliedRestargType(methodType, n);
        if (methodType.parameterSlotCount() <= 253) {
            return this.genericInvoker().asSpreader(clazz, n2);
        }
        MethodType methodType2 = methodType.replaceParameterTypes(n, methodType.parameterCount(), clazz);
        MethodHandle methodHandle = MethodHandles.invoker(methodType2);
        MethodHandle methodHandle2 = MethodHandles.insertArguments(Lazy.MH_asSpreader, 1, clazz, n2);
        return MethodHandles.filterArgument(methodHandle, 0, methodHandle2);
    }

    private static Class<?> impliedRestargType(MethodType methodType, int n) {
        if (methodType.isGeneric()) {
            return Object[].class;
        }
        int n2 = methodType.parameterCount();
        if (n >= n2) {
            return Object[].class;
        }
        Class<?> clazz = methodType.parameterType(n);
        for (int i = n + 1; i < n2; ++i) {
            if (clazz == methodType.parameterType(i)) continue;
            throw MethodHandleStatics.newIllegalArgumentException("need homogeneous rest arguments", methodType);
        }
        if (clazz == Object.class) {
            return Object[].class;
        }
        return Array.newInstance(clazz, 0).getClass();
    }

    public String toString() {
        return "Invokers" + this.targetType;
    }

    static MemberName methodHandleInvokeLinkerMethod(String string, MethodType methodType, Object[] objectArray) {
        Object object;
        int n;
        switch (string) {
            case "invokeExact": {
                n = 10;
                break;
            }
            case "invoke": {
                n = 12;
                break;
            }
            default: {
                throw new InternalError("not invoker: " + string);
            }
        }
        if (methodType.parameterSlotCount() <= 253) {
            object = Invokers.invokeHandleForm(methodType, false, n);
            objectArray[0] = methodType;
        } else {
            object = Invokers.invokeHandleForm(methodType, true, n);
        }
        return ((LambdaForm)object).vmentry;
    }

    private static LambdaForm invokeHandleForm(MethodType methodType, boolean bl, int n) {
        MethodType methodType2;
        Object[] objectArray;
        Object object;
        LambdaForm lambdaForm;
        String string;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        if (!bl) {
            methodType = methodType.basicType();
            bl4 = true;
        } else {
            bl4 = false;
        }
        switch (n) {
            case 10: {
                bl3 = true;
                bl2 = false;
                string = "invokeExact_MT";
                break;
            }
            case 11: {
                bl3 = false;
                bl2 = false;
                string = "exactInvoker";
                break;
            }
            case 12: {
                bl3 = true;
                bl2 = true;
                string = "invoke_MT";
                break;
            }
            case 13: {
                bl3 = false;
                bl2 = true;
                string = "invoker";
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        if (bl4 && (lambdaForm = methodType.form().cachedLambdaForm(n)) != null) {
            return lambdaForm;
        }
        int n2 = 0 + (bl3 ? 0 : 1);
        int n3 = n2 + 1;
        int n4 = n3 + methodType.parameterCount();
        int n5 = n4 + (bl3 && !bl ? 1 : 0);
        int n6 = n4;
        int n7 = bl ? -1 : n6++;
        int n8 = n6++;
        int n9 = n6++;
        MethodType methodType3 = methodType.invokerType();
        if (bl3) {
            if (!bl) {
                methodType3 = methodType3.appendParameterTypes(MemberName.class);
            }
        } else {
            methodType3 = methodType3.invokerType();
        }
        LambdaForm.Name[] nameArray = LambdaForm.arguments(n6 - n5, methodType3);
        assert (nameArray.length == n6) : Arrays.asList(methodType, bl, n, n6, nameArray.length);
        if (n7 >= n5) {
            assert (nameArray[n7] == null);
            object = BoundMethodHandle.speciesData_L();
            nameArray[0] = nameArray[0].withConstraint(object);
            objectArray = ((BoundMethodHandle.SpeciesData)object).getterFunction(0);
            nameArray[n7] = new LambdaForm.Name((LambdaForm.NamedFunction)objectArray, nameArray[0]);
        }
        object = methodType.basicType();
        objectArray = Arrays.copyOfRange(nameArray, n2, n4, Object[].class);
        MethodType methodType4 = methodType2 = bl ? methodType : nameArray[n7];
        if (!bl2) {
            nameArray[n8] = new LambdaForm.Name(NF_checkExactType, nameArray[n2], methodType2);
        } else {
            nameArray[n8] = new LambdaForm.Name(NF_checkGenericType, nameArray[n2], methodType2);
            objectArray[0] = nameArray[n8];
        }
        nameArray[n9] = new LambdaForm.Name((MethodType)object, objectArray);
        lambdaForm = new LambdaForm(string, n5, nameArray);
        if (bl3) {
            lambdaForm.compileToBytecode();
        }
        if (bl4) {
            lambdaForm = methodType.form().setCachedLambdaForm(n, lambdaForm);
        }
        return lambdaForm;
    }

    static WrongMethodTypeException newWrongMethodTypeException(MethodType methodType, MethodType methodType2) {
        return new WrongMethodTypeException("expected " + methodType2 + " but found " + methodType);
    }

    @ForceInline
    static void checkExactType(Object object, Object object2) {
        MethodHandle methodHandle = (MethodHandle)object;
        MethodType methodType = (MethodType)object2;
        MethodType methodType2 = methodHandle.type();
        if (methodType2 != methodType) {
            throw Invokers.newWrongMethodTypeException(methodType, methodType2);
        }
    }

    @ForceInline
    static Object checkGenericType(Object object, Object object2) {
        MethodHandle methodHandle = (MethodHandle)object;
        MethodType methodType = (MethodType)object2;
        return methodHandle.asType(methodType);
    }

    static MemberName linkToCallSiteMethod(MethodType methodType) {
        LambdaForm lambdaForm = Invokers.callSiteForm(methodType, false);
        return lambdaForm.vmentry;
    }

    static MemberName linkToTargetMethod(MethodType methodType) {
        LambdaForm lambdaForm = Invokers.callSiteForm(methodType, true);
        return lambdaForm.vmentry;
    }

    private static LambdaForm callSiteForm(MethodType methodType, boolean bl) {
        methodType = methodType.basicType();
        int n = bl ? 15 : 14;
        LambdaForm lambdaForm = methodType.form().cachedLambdaForm(n);
        if (lambdaForm != null) {
            return lambdaForm;
        }
        int n2 = 0 + methodType.parameterCount();
        int n3 = n2 + 1;
        int n4 = n2;
        int n5 = n4++;
        int n6 = bl ? -1 : n5;
        int n7 = bl ? n5 : n4++;
        int n8 = n4++;
        MethodType methodType2 = methodType.appendParameterTypes(bl ? MethodHandle.class : CallSite.class);
        LambdaForm.Name[] nameArray = LambdaForm.arguments(n4 - n3, methodType2);
        assert (nameArray.length == n4);
        assert (nameArray[n5] != null);
        if (!bl) {
            nameArray[n7] = new LambdaForm.Name(NF_getCallSiteTarget, nameArray[n6]);
        }
        Object[] objectArray = Arrays.copyOfRange(nameArray, 0, n2 + 1, Object[].class);
        System.arraycopy(objectArray, 0, objectArray, 1, objectArray.length - 1);
        objectArray[0] = nameArray[n7];
        nameArray[n8] = new LambdaForm.Name(methodType, objectArray);
        lambdaForm = new LambdaForm(bl ? "linkToTargetMethod" : "linkToCallSite", n3, nameArray);
        lambdaForm.compileToBytecode();
        lambdaForm = methodType.form().setCachedLambdaForm(n, lambdaForm);
        return lambdaForm;
    }

    @ForceInline
    static Object getCallSiteTarget(Object object) {
        return ((CallSite)object).getTarget();
    }

    static {
        try {
            LambdaForm.NamedFunction[] namedFunctionArray;
            NF_checkExactType = new LambdaForm.NamedFunction(Invokers.class.getDeclaredMethod("checkExactType", Object.class, Object.class));
            for (LambdaForm.NamedFunction namedFunction : namedFunctionArray = new LambdaForm.NamedFunction[]{NF_checkExactType, NF_checkGenericType = new LambdaForm.NamedFunction(Invokers.class.getDeclaredMethod("checkGenericType", Object.class, Object.class)), NF_getCallSiteTarget = new LambdaForm.NamedFunction(Invokers.class.getDeclaredMethod("getCallSiteTarget", Object.class))}) {
                assert (InvokerBytecodeGenerator.isStaticallyInvocable(namedFunction.member)) : namedFunction;
                namedFunction.resolve();
            }
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw MethodHandleStatics.newInternalError(reflectiveOperationException);
        }
    }

    private static class Lazy {
        private static final MethodHandle MH_asSpreader;

        private Lazy() {
        }

        static {
            try {
                MH_asSpreader = MethodHandles.Lookup.IMPL_LOOKUP.findVirtual(MethodHandle.class, "asSpreader", MethodType.methodType(MethodHandle.class, Class.class, Integer.TYPE));
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw MethodHandleStatics.newInternalError(reflectiveOperationException);
            }
        }
    }
}

